# Generated by Django 5.1.1 on 2024-10-18 01:55

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("artd_partner", "0007_position_partner"),
        ("artd_siigo", "0025_siigocustomerdocumenttype"),
    ]

    operations = [
        migrations.CreateModel(
            name="SiigoCustomer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "siigo_id",
                    models.CharField(
                        help_text="Siigo ID for the customer",
                        max_length=250,
                        verbose_name="Siigo ID",
                    ),
                ),
                (
                    "identification",
                    models.CharField(
                        help_text="Identification of the customer",
                        max_length=25,
                        verbose_name="Identification",
                    ),
                ),
                (
                    "check_digit",
                    models.CharField(
                        help_text="Check digit of the customer",
                        max_length=10,
                        verbose_name="Check Digit",
                    ),
                ),
                (
                    "name",
                    models.JSONField(
                        default=list,
                        help_text="Name of the customer",
                        verbose_name="Name",
                    ),
                ),
                (
                    "commercial_name",
                    models.CharField(
                        help_text="Commercial name of the customer",
                        max_length=250,
                        verbose_name="Commercial Name",
                    ),
                ),
                (
                    "branch_office",
                    models.PositiveIntegerField(
                        blank=True,
                        help_text="Branch office of the customer",
                        null=True,
                        verbose_name="Branch Office",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Active status of the customer",
                        verbose_name="Active",
                    ),
                ),
                (
                    "vat_responsible",
                    models.BooleanField(
                        default=True,
                        help_text="VAT responsible status of the customer",
                        verbose_name="VAT Responsible",
                    ),
                ),
                (
                    "fiscal_responsibilities",
                    models.JSONField(
                        default=list,
                        help_text="Fiscal responsibilities of the customer",
                        verbose_name="Fiscal Responsibilities",
                    ),
                ),
                (
                    "address",
                    models.JSONField(
                        default=dict,
                        help_text="Address of the customer",
                        verbose_name="Address",
                    ),
                ),
                (
                    "phones",
                    models.JSONField(
                        default=list,
                        help_text="Phones of the customer",
                        verbose_name="Phones",
                    ),
                ),
                (
                    "contacts",
                    models.JSONField(
                        default=list,
                        help_text="Contacts of the customer",
                        verbose_name="Contacts",
                    ),
                ),
                (
                    "comments",
                    models.TextField(
                        blank=True,
                        help_text="Comments of the customer",
                        null=True,
                        verbose_name="Comments",
                    ),
                ),
                (
                    "related_users",
                    models.JSONField(
                        default=list,
                        help_text="Related users of the customer",
                        verbose_name="Related Users",
                    ),
                ),
                (
                    "metadata",
                    models.JSONField(
                        default=dict,
                        help_text="Metadata of the customer",
                        verbose_name="Metadata",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="siigo_customers",
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
                (
                    "siigo_customer_document_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="siigo_customers",
                        to="artd_siigo.siigocustomerdocumenttype",
                        verbose_name="Siigo Customer Document Type",
                    ),
                ),
                (
                    "siigo_customer_person_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="siigo_customers",
                        to="artd_siigo.siigocustomerpersontype",
                        verbose_name="Siigo Customer Person Type",
                    ),
                ),
                (
                    "siigo_customer_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="siigo_customers",
                        to="artd_siigo.siigocustomertype",
                        verbose_name="Siigo Customer Type",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Customer",
                "verbose_name_plural": "Siigo Customers",
            },
        ),
    ]
