# Generated by Django 5.1.1 on 2024-10-20 14:29

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("artd_customer", "0019_alter_customer_customer_group"),
        ("artd_partner", "0007_position_partner"),
        ("artd_siigo", "0034_siigoconfig_contacts_siigoconfig_phones"),
    ]

    operations = [
        migrations.CreateModel(
            name="CustomerDocumentTypeMapping",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        blank=True,
                        help_text="Code",
                        max_length=100,
                        null=True,
                        verbose_name="Code",
                    ),
                ),
                (
                    "customer_document_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_customer.customerdocumenttype",
                        verbose_name="Customer Document Type",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="customer_document_type_mappings",
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mapping Customer Document Type",
                "verbose_name_plural": "Mapping Customer Document Type",
                "unique_together": {("partner", "customer_document_type")},
            },
        ),
        migrations.CreateModel(
            name="CustomerPersonTypeMapping",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        blank=True,
                        help_text="Code",
                        max_length=100,
                        null=True,
                        verbose_name="Code",
                    ),
                ),
                (
                    "customer_person_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_customer.customerpersontype",
                        verbose_name="Customer Person Type",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="customer_person_type_mappings",
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mapping Customer Person Type",
                "verbose_name_plural": "Mapping Customer Person Types",
                "unique_together": {("partner", "customer_person_type")},
            },
        ),
        migrations.CreateModel(
            name="CustomerTypeMapping",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        blank=True,
                        help_text="Code",
                        max_length=100,
                        null=True,
                        verbose_name="Code",
                    ),
                ),
                (
                    "customer_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_customer.customertype",
                        verbose_name="Customer Type",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="customer_type_mappings",
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mapping Customer Typ",
                "verbose_name_plural": "Mapping Customer Types",
                "unique_together": {("partner", "customer_type")},
            },
        ),
    ]
