# Generated by Django 5.1.1 on 2024-10-21 01:37

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("artd_partner", "0007_position_partner"),
        ("artd_siigo", "0039_siigoproducttype"),
    ]

    operations = [
        migrations.CreateModel(
            name="ProductTypeMapping",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "product_type",
                    models.CharField(
                        choices=[
                            ("service", "Service"),
                            ("physical", "Physical"),
                            ("virtual", "Virtual"),
                        ],
                        help_text="Product Type",
                        max_length=100,
                        verbose_name="Product Type",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="product_type_mappings",
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
                (
                    "siigo_product_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_siigo.siigoproducttype",
                        verbose_name="Siigo Product Type",
                    ),
                ),
            ],
            options={
                "verbose_name": "Mapping Product Type",
                "verbose_name_plural": "Mapping Product Types",
                "unique_together": {("partner", "siigo_product_type", "product_type")},
            },
        ),
    ]
