# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAlertsResult',
    'AwaitableGetAlertsResult',
    'get_alerts',
    'get_alerts_output',
]

@pulumi.output_type
class GetAlertsResult:
    """
    A collection of values returned by getAlerts.
    """
    def __init__(__self__, alerts=None, id=None, limit=None, offset=None):
        if alerts and not isinstance(alerts, list):
            raise TypeError("Expected argument 'alerts' to be a list")
        pulumi.set(__self__, "alerts", alerts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if limit and not isinstance(limit, int):
            raise TypeError("Expected argument 'limit' to be a int")
        pulumi.set(__self__, "limit", limit)
        if offset and not isinstance(offset, int):
            raise TypeError("Expected argument 'offset' to be a int")
        pulumi.set(__self__, "offset", offset)

    @_builtins.property
    @pulumi.getter
    def alerts(self) -> Sequence['outputs.GetAlertsAlertResult']:
        """
        List of all alerts in Wavefront. For each alert you will see a list of attributes.
        """
        return pulumi.get(self, "alerts")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "offset")


class AwaitableGetAlertsResult(GetAlertsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertsResult(
            alerts=self.alerts,
            id=self.id,
            limit=self.limit,
            offset=self.offset)


def get_alerts(limit: Optional[_builtins.int] = None,
               offset: Optional[_builtins.int] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertsResult:
    """
    Use this data source to get information about all Wavefront alerts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    # Get the information about all alerts.
    example = wavefront.get_alerts(limit=10,
        offset=0)
    ```


    :param _builtins.int limit: Limit is the maximum number of results to be returned. Defaults to 100.
    :param _builtins.int offset: Offset is the offset from the first result to be returned. Defaults to 0.
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['offset'] = offset
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('wavefront:index/getAlerts:getAlerts', __args__, opts=opts, typ=GetAlertsResult).value

    return AwaitableGetAlertsResult(
        alerts=pulumi.get(__ret__, 'alerts'),
        id=pulumi.get(__ret__, 'id'),
        limit=pulumi.get(__ret__, 'limit'),
        offset=pulumi.get(__ret__, 'offset'))
def get_alerts_output(limit: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      offset: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertsResult]:
    """
    Use this data source to get information about all Wavefront alerts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_wavefront as wavefront

    # Get the information about all alerts.
    example = wavefront.get_alerts(limit=10,
        offset=0)
    ```


    :param _builtins.int limit: Limit is the maximum number of results to be returned. Defaults to 100.
    :param _builtins.int offset: Offset is the offset from the first result to be returned. Defaults to 0.
    """
    __args__ = dict()
    __args__['limit'] = limit
    __args__['offset'] = offset
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('wavefront:index/getAlerts:getAlerts', __args__, opts=opts, typ=GetAlertsResult)
    return __ret__.apply(lambda __response__: GetAlertsResult(
        alerts=pulumi.get(__response__, 'alerts'),
        id=pulumi.get(__response__, 'id'),
        limit=pulumi.get(__response__, 'limit'),
        offset=pulumi.get(__response__, 'offset')))
