# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'AlertAlertTriageDashboard',
    'AlertAlertTriageDashboardParameters',
    'AlertTargetRoute',
    'CloudIntegrationNewRelicMetricFilter',
    'DashboardParameterDetail',
    'DashboardSection',
    'DashboardSectionRow',
    'DashboardSectionRowChart',
    'DashboardSectionRowChartChartSetting',
    'DashboardSectionRowChartSource',
    'IngestionPolicyTag',
    'MetricsPolicyPolicyRule',
    'MetricsPolicyPolicyRuleTag',
    'GetAlertAlertTriageDashboardResult',
    'GetAlertAlertTriageDashboardParametersResult',
    'GetAlertFailingHostLabelPairResult',
    'GetAlertInMaintenanceHostLabelPairResult',
    'GetAlertsAlertResult',
    'GetAlertsAlertAlertTriageDashboardResult',
    'GetAlertsAlertAlertTriageDashboardParametersResult',
    'GetAlertsAlertFailingHostLabelPairResult',
    'GetAlertsAlertInMaintenanceHostLabelPairResult',
    'GetDashboardParameterDetailResult',
    'GetDashboardSectionResult',
    'GetDashboardSectionRowResult',
    'GetDashboardSectionRowChartResult',
    'GetDashboardSectionRowChartChartSettingResult',
    'GetDashboardSectionRowChartSourceResult',
    'GetDashboardsDashboardResult',
    'GetDashboardsDashboardParameterDetailResult',
    'GetDashboardsDashboardSectionResult',
    'GetDashboardsDashboardSectionRowResult',
    'GetDashboardsDashboardSectionRowChartResult',
    'GetDashboardsDashboardSectionRowChartChartSettingResult',
    'GetDashboardsDashboardSectionRowChartSourceResult',
    'GetDerivedMetricsDerivedMetricResult',
    'GetEventsEventResult',
    'GetExternalLinksExternalLinkResult',
    'GetMaintenanceWindowAllMaintenanceWindowResult',
    'GetMetricsPolicyPolicyRuleResult',
    'GetMetricsPolicyPolicyRuleTagResult',
    'GetRolesRoleResult',
    'GetUserGroupsUserGroupResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class AlertAlertTriageDashboard(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dashboardId":
            suggest = "dashboard_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlertAlertTriageDashboard. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlertAlertTriageDashboard.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlertAlertTriageDashboard.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dashboard_id: _builtins.str,
                 description: _builtins.str,
                 parameters: Optional['outputs.AlertAlertTriageDashboardParameters'] = None):
        """
        :param _builtins.str dashboard_id: Dashboard ID
        :param _builtins.str description: Dashboard Description
        """
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> _builtins.str:
        """
        Dashboard ID
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Dashboard Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.AlertAlertTriageDashboardParameters']:
        return pulumi.get(self, "parameters")


@pulumi.output_type
class AlertAlertTriageDashboardParameters(dict):
    def __init__(__self__, *,
                 constants: Optional[Mapping[str, _builtins.str]] = None):
        if constants is not None:
            pulumi.set(__self__, "constants", constants)

    @_builtins.property
    @pulumi.getter
    def constants(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "constants")


@pulumi.output_type
class AlertTargetRoute(dict):
    def __init__(__self__, *,
                 method: _builtins.str,
                 target: _builtins.str,
                 filter: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str method: The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        :param _builtins.str target: (Required) The endpoint for the alert route. `EMAIL`: email address. `PAGERDUTY`: PagerDuty routing
               key. `WEBHOOK`: URL endpoint.
        :param Mapping[str, _builtins.str] filter: (Required) String that filters the route. Space delimited. Currently only allows a single key value pair.
               (e.g. `env prod`)
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "target", target)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        (Required) The endpoint for the alert route. `EMAIL`: email address. `PAGERDUTY`: PagerDuty routing
        key. `WEBHOOK`: URL endpoint.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Required) String that filters the route. Space delimited. Currently only allows a single key value pair.
        (e.g. `env prod`)
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class CloudIntegrationNewRelicMetricFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appName":
            suggest = "app_name"
        elif key == "metricFilterRegex":
            suggest = "metric_filter_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudIntegrationNewRelicMetricFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudIntegrationNewRelicMetricFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudIntegrationNewRelicMetricFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_name: _builtins.str,
                 metric_filter_regex: _builtins.str):
        """
        :param _builtins.str app_name: The name of a NewRelic App.
        :param _builtins.str metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested.
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> _builtins.str:
        """
        The name of a NewRelic App.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> _builtins.str:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested.
        """
        return pulumi.get(self, "metric_filter_regex")


@pulumi.output_type
class DashboardParameterDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "hideFromView":
            suggest = "hide_from_view"
        elif key == "parameterType":
            suggest = "parameter_type"
        elif key == "valuesToReadableStrings":
            suggest = "values_to_readable_strings"
        elif key == "dynamicFieldType":
            suggest = "dynamic_field_type"
        elif key == "queryValue":
            suggest = "query_value"
        elif key == "tagKey":
            suggest = "tag_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardParameterDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardParameterDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardParameterDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: _builtins.str,
                 hide_from_view: _builtins.bool,
                 label: _builtins.str,
                 name: _builtins.str,
                 parameter_type: _builtins.str,
                 values_to_readable_strings: Mapping[str, _builtins.str],
                 dynamic_field_type: Optional[_builtins.str] = None,
                 query_value: Optional[_builtins.str] = None,
                 tag_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str default_value: The default value of the parameter.
        :param _builtins.bool hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard.
        :param _builtins.str label: The label for the parameter.
        :param _builtins.str name: The name of the parameters.
        :param _builtins.str parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        :param Mapping[str, _builtins.str] values_to_readable_strings: A string->string map. At least one of the keys must match the value of
               `default_value`.
        :param _builtins.str dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        :param _builtins.str query_value: For `DYNAMIC` parameter types, the query to execute to return values.
        :param _builtins.str tag_key: for `TAG_KEY` dynamic field types, the tag key to return.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)
        if dynamic_field_type is not None:
            pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        if query_value is not None:
            pulumi.set(__self__, "query_value", query_value)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> _builtins.bool:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard.
        """
        return pulumi.get(self, "hide_from_view")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label for the parameter.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> _builtins.str:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        """
        return pulumi.get(self, "parameter_type")

    @_builtins.property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> Mapping[str, _builtins.str]:
        """
        A string->string map. At least one of the keys must match the value of
        `default_value`.
        """
        return pulumi.get(self, "values_to_readable_strings")

    @_builtins.property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> Optional[_builtins.str]:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        """
        return pulumi.get(self, "dynamic_field_type")

    @_builtins.property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> Optional[_builtins.str]:
        """
        For `DYNAMIC` parameter types, the query to execute to return values.
        """
        return pulumi.get(self, "query_value")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[_builtins.str]:
        """
        for `TAG_KEY` dynamic field types, the tag key to return.
        """
        return pulumi.get(self, "tag_key")


@pulumi.output_type
class DashboardSection(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 rows: Sequence['outputs.DashboardSectionRow']):
        """
        :param _builtins.str name: Name of this section.
        :param Sequence['DashboardSectionRowArgs'] rows: See dashboard section rows.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of this section.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.DashboardSectionRow']:
        """
        See dashboard section rows.
        """
        return pulumi.get(self, "rows")


@pulumi.output_type
class DashboardSectionRow(dict):
    def __init__(__self__, *,
                 charts: Sequence['outputs.DashboardSectionRowChart']):
        """
        :param Sequence['DashboardSectionRowChartArgs'] charts: Charts in this section. See dashboard chart.
        """
        pulumi.set(__self__, "charts", charts)

    @_builtins.property
    @pulumi.getter
    def charts(self) -> Sequence['outputs.DashboardSectionRowChart']:
        """
        Charts in this section. See dashboard chart.
        """
        return pulumi.get(self, "charts")


@pulumi.output_type
class DashboardSectionRowChart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartSetting":
            suggest = "chart_setting"
        elif key == "chartAttribute":
            suggest = "chart_attribute"
        elif key == "noDefaultEvents":
            suggest = "no_default_events"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_setting: 'outputs.DashboardSectionRowChartChartSetting',
                 name: _builtins.str,
                 sources: Sequence['outputs.DashboardSectionRowChartSource'],
                 summarization: _builtins.str,
                 units: _builtins.str,
                 base: Optional[_builtins.int] = None,
                 chart_attribute: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 no_default_events: Optional[_builtins.bool] = None):
        """
        :param 'DashboardSectionRowChartChartSettingArgs' chart_setting: Chart settings. See chart settings.
        :param _builtins.str name: Name of the source.
        :param Sequence['DashboardSectionRowChartSourceArgs'] sources: Query expression to plot on the chart. See chart source queries.
        :param _builtins.str summarization: Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`,
               `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`.
        :param _builtins.str units: String to label the units of the chart on the Y-Axis.
        :param _builtins.int base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param _builtins.str description: Description of the chart.
        :param _builtins.bool no_default_events: Show events related to the sources included in queries
        """
        pulumi.set(__self__, "chart_setting", chart_setting)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if chart_attribute is not None:
            pulumi.set(__self__, "chart_attribute", chart_attribute)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if no_default_events is not None:
            pulumi.set(__self__, "no_default_events", no_default_events)

    @_builtins.property
    @pulumi.getter(name="chartSetting")
    def chart_setting(self) -> 'outputs.DashboardSectionRowChartChartSetting':
        """
        Chart settings. See chart settings.
        """
        return pulumi.get(self, "chart_setting")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the source.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.DashboardSectionRowChartSource']:
        """
        Query expression to plot on the chart. See chart source queries.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def summarization(self) -> _builtins.str:
        """
        Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`,
        `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`.
        """
        return pulumi.get(self, "summarization")

    @_builtins.property
    @pulumi.getter
    def units(self) -> _builtins.str:
        """
        String to label the units of the chart on the Y-Axis.
        """
        return pulumi.get(self, "units")

    @_builtins.property
    @pulumi.getter
    def base(self) -> Optional[_builtins.int]:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @_builtins.property
    @pulumi.getter(name="chartAttribute")
    def chart_attribute(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "chart_attribute")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="noDefaultEvents")
    def no_default_events(self) -> Optional[_builtins.bool]:
        """
        Show events related to the sources included in queries
        """
        return pulumi.get(self, "no_default_events")


@pulumi.output_type
class DashboardSectionRowChartChartSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoColumnTags":
            suggest = "auto_column_tags"
        elif key == "columnTags":
            suggest = "column_tags"
        elif key == "customTags":
            suggest = "custom_tags"
        elif key == "expectedDataSpacing":
            suggest = "expected_data_spacing"
        elif key == "fixedLegendDisplayStats":
            suggest = "fixed_legend_display_stats"
        elif key == "fixedLegendEnabled":
            suggest = "fixed_legend_enabled"
        elif key == "fixedLegendFilterField":
            suggest = "fixed_legend_filter_field"
        elif key == "fixedLegendFilterLimit":
            suggest = "fixed_legend_filter_limit"
        elif key == "fixedLegendFilterSort":
            suggest = "fixed_legend_filter_sort"
        elif key == "fixedLegendHideLabel":
            suggest = "fixed_legend_hide_label"
        elif key == "fixedLegendPosition":
            suggest = "fixed_legend_position"
        elif key == "fixedLegendUseRawStats":
            suggest = "fixed_legend_use_raw_stats"
        elif key == "groupBySource":
            suggest = "group_by_source"
        elif key == "invertDynamicLegendHoverControl":
            suggest = "invert_dynamic_legend_hover_control"
        elif key == "lineType":
            suggest = "line_type"
        elif key == "numTags":
            suggest = "num_tags"
        elif key == "plainMarkdownContent":
            suggest = "plain_markdown_content"
        elif key == "showHosts":
            suggest = "show_hosts"
        elif key == "showLabels":
            suggest = "show_labels"
        elif key == "showRawValues":
            suggest = "show_raw_values"
        elif key == "sortValuesDescending":
            suggest = "sort_values_descending"
        elif key == "sparklineDecimalPrecision":
            suggest = "sparkline_decimal_precision"
        elif key == "sparklineDisplayColor":
            suggest = "sparkline_display_color"
        elif key == "sparklineDisplayFontSize":
            suggest = "sparkline_display_font_size"
        elif key == "sparklineDisplayHorizontalPosition":
            suggest = "sparkline_display_horizontal_position"
        elif key == "sparklineDisplayPostfix":
            suggest = "sparkline_display_postfix"
        elif key == "sparklineDisplayPrefix":
            suggest = "sparkline_display_prefix"
        elif key == "sparklineDisplayValueType":
            suggest = "sparkline_display_value_type"
        elif key == "sparklineDisplayVerticalPosition":
            suggest = "sparkline_display_vertical_position"
        elif key == "sparklineFillColor":
            suggest = "sparkline_fill_color"
        elif key == "sparklineLineColor":
            suggest = "sparkline_line_color"
        elif key == "sparklineSize":
            suggest = "sparkline_size"
        elif key == "sparklineValueColorMapApplyTo":
            suggest = "sparkline_value_color_map_apply_to"
        elif key == "sparklineValueColorMapColors":
            suggest = "sparkline_value_color_map_colors"
        elif key == "sparklineValueColorMapValues":
            suggest = "sparkline_value_color_map_values"
        elif key == "sparklineValueColorMapValuesV2s":
            suggest = "sparkline_value_color_map_values_v2s"
        elif key == "sparklineValueTextMapTexts":
            suggest = "sparkline_value_text_map_texts"
        elif key == "sparklineValueTextMapThresholds":
            suggest = "sparkline_value_text_map_thresholds"
        elif key == "stackType":
            suggest = "stack_type"
        elif key == "tagMode":
            suggest = "tag_mode"
        elif key == "timeBasedColoring":
            suggest = "time_based_coloring"
        elif key == "windowSize":
            suggest = "window_size"
        elif key == "y0ScaleSiBy1024":
            suggest = "y0_scale_si_by1024"
        elif key == "y0UnitAutoscaling":
            suggest = "y0_unit_autoscaling"
        elif key == "y1ScaleSiBy1024":
            suggest = "y1_scale_si_by1024"
        elif key == "y1UnitAutoscaling":
            suggest = "y1_unit_autoscaling"
        elif key == "y1Units":
            suggest = "y1_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChartChartSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChartChartSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChartChartSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 auto_column_tags: Optional[_builtins.bool] = None,
                 column_tags: Optional[_builtins.str] = None,
                 custom_tags: Optional[Sequence[_builtins.str]] = None,
                 expected_data_spacing: Optional[_builtins.int] = None,
                 fixed_legend_display_stats: Optional[Sequence[_builtins.str]] = None,
                 fixed_legend_enabled: Optional[_builtins.bool] = None,
                 fixed_legend_filter_field: Optional[_builtins.str] = None,
                 fixed_legend_filter_limit: Optional[_builtins.int] = None,
                 fixed_legend_filter_sort: Optional[_builtins.str] = None,
                 fixed_legend_hide_label: Optional[_builtins.bool] = None,
                 fixed_legend_position: Optional[_builtins.str] = None,
                 fixed_legend_use_raw_stats: Optional[_builtins.bool] = None,
                 group_by_source: Optional[_builtins.bool] = None,
                 invert_dynamic_legend_hover_control: Optional[_builtins.bool] = None,
                 line_type: Optional[_builtins.str] = None,
                 max: Optional[_builtins.float] = None,
                 min: Optional[_builtins.float] = None,
                 num_tags: Optional[_builtins.int] = None,
                 plain_markdown_content: Optional[_builtins.str] = None,
                 show_hosts: Optional[_builtins.bool] = None,
                 show_labels: Optional[_builtins.bool] = None,
                 show_raw_values: Optional[_builtins.bool] = None,
                 sort_values_descending: Optional[_builtins.bool] = None,
                 sparkline_decimal_precision: Optional[_builtins.int] = None,
                 sparkline_display_color: Optional[_builtins.str] = None,
                 sparkline_display_font_size: Optional[_builtins.str] = None,
                 sparkline_display_horizontal_position: Optional[_builtins.str] = None,
                 sparkline_display_postfix: Optional[_builtins.str] = None,
                 sparkline_display_prefix: Optional[_builtins.str] = None,
                 sparkline_display_value_type: Optional[_builtins.str] = None,
                 sparkline_display_vertical_position: Optional[_builtins.str] = None,
                 sparkline_fill_color: Optional[_builtins.str] = None,
                 sparkline_line_color: Optional[_builtins.str] = None,
                 sparkline_size: Optional[_builtins.str] = None,
                 sparkline_value_color_map_apply_to: Optional[_builtins.str] = None,
                 sparkline_value_color_map_colors: Optional[Sequence[_builtins.str]] = None,
                 sparkline_value_color_map_values: Optional[Sequence[_builtins.int]] = None,
                 sparkline_value_color_map_values_v2s: Optional[Sequence[_builtins.float]] = None,
                 sparkline_value_text_map_texts: Optional[Sequence[_builtins.str]] = None,
                 sparkline_value_text_map_thresholds: Optional[Sequence[_builtins.float]] = None,
                 stack_type: Optional[_builtins.str] = None,
                 tag_mode: Optional[_builtins.str] = None,
                 time_based_coloring: Optional[_builtins.bool] = None,
                 window_size: Optional[_builtins.int] = None,
                 windowing: Optional[_builtins.str] = None,
                 xmax: Optional[_builtins.float] = None,
                 xmin: Optional[_builtins.float] = None,
                 y0_scale_si_by1024: Optional[_builtins.bool] = None,
                 y0_unit_autoscaling: Optional[_builtins.bool] = None,
                 y1_scale_si_by1024: Optional[_builtins.bool] = None,
                 y1_unit_autoscaling: Optional[_builtins.bool] = None,
                 y1_units: Optional[_builtins.str] = None,
                 y1max: Optional[_builtins.float] = None,
                 y1min: Optional[_builtins.float] = None,
                 ymax: Optional[_builtins.float] = None,
                 ymin: Optional[_builtins.float] = None):
        """
        :param _builtins.str type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to
               the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the
               Markdown display, and `sparkline` to the Single Stat view. Valid options are`line`, `scatterplot`,
               `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
               `top-k`, `status-list`, and `histogram`.
        :param _builtins.bool auto_column_tags: This setting is deprecated.
        :param _builtins.str column_tags: This setting is deprecated.
        :param Sequence[_builtins.str] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        :param _builtins.int expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series
               above which a dotted line will replace a solid in in line plots. Default is 60.
        :param Sequence[_builtins.str] fixed_legend_display_stats: For a chart with a fixed legend, a list of statistics to display in the legend.
        :param _builtins.bool fixed_legend_enabled: Whether to enable a fixed tabular legend adjacent to the chart.
        :param _builtins.str fixed_legend_filter_field: Statistic to use for determining whether a series is displayed on the fixed legend.
               Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        :param _builtins.int fixed_legend_filter_limit: Number of series to include in the fixed legend.
        :param _builtins.str fixed_legend_filter_sort: Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
               are `TOP`, and `BOTTOM`.
        :param _builtins.bool fixed_legend_hide_label: This setting is deprecated.
        :param _builtins.str fixed_legend_position: Where the fixed legend should be displayed with respect to the chart.
               Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        :param _builtins.bool fixed_legend_use_raw_stats: If `true`, the legend uses non-summarized stats instead of summarized.
        :param _builtins.bool group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source.
               If `false`, each source is displayed in its own row. if `true`, multiple metrics for the same host are displayed as different
               columns in the same row.
        :param _builtins.bool invert_dynamic_legend_hover_control: Whether to disable the display of the floating legend (but
               reenable it when the ctrl-key is pressed).
        :param _builtins.str line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`,
               `step-after`, `basis`, `cardinal`, and `monotone`.
        :param _builtins.float max: Max value of the Y-axis. Set to null or leave blank for auto.
        :param _builtins.float min: Min value of the Y-axis. Set to null or leave blank for auto.
        :param _builtins.int num_tags: For the tabular view defines how many point tags to display.
        :param _builtins.str plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param _builtins.bool show_hosts: For the tabular view, whether to display sources. Default is `true`.
        :param _builtins.bool show_labels: For the tabular view, whether to display labels. Default is `true`.
        :param _builtins.bool show_raw_values: For the tabular view, whether to display raw values. Default is `false`.
        :param _builtins.bool sort_values_descending: For the tabular view, whether to display values in descending order. Default is `false`.
        :param _builtins.int sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number.
        :param _builtins.str sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined).
               Values should be in `rgba(,,,,)` format.
        :param _builtins.str sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent.
        :param _builtins.str sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text.
               Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        :param _builtins.str sparkline_display_postfix: For the single stat view, a string to append to the displayed text.
        :param _builtins.str sparkline_display_prefix: For the single stat view, a string to add before the displayed text.
        :param _builtins.str sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query.
               Valid options are `VALUE` or `LABEL`.
        :param _builtins.str sparkline_display_vertical_position: This setting is deprecated.
        :param _builtins.str sparkline_fill_color: For the single stat view, the color of the background fill. Values should be
               in `rgba(,,,,)`.
        :param _builtins.str sparkline_line_color: For the single stat view, the color of the line. Values should be in `rgba(,,,,)` format.
        :param _builtins.str sparkline_size: For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart.
               Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        :param _builtins.str sparkline_value_color_map_apply_to: For the single stat view, whether to apply dynamic color settings to
               the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        :param Sequence[_builtins.str] sparkline_value_color_map_colors: For the single stat view, A list of colors that differing query values map to.
               Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`.
        :param Sequence[_builtins.int] sparkline_value_color_map_values: This setting is deprecated.
        :param Sequence[_builtins.float] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different
               query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        :param Sequence[_builtins.str] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query
               values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        :param Sequence[_builtins.float] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for
               mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        :param _builtins.str stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
               stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
               center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        :param _builtins.str tag_mode: For the tabular view, which mode to use to determine which point tags to display.
               Valid options are `all`, `top`, or `custom`.
        :param _builtins.bool time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points.
        :param _builtins.int window_size: Width, in minutes, of the time window to use for `last` windowing.
        :param _builtins.str windowing: For the tabular view, whether to use the full time window for the query or the last X minutes.
               Valid options are `full` or `last`.
        :param _builtins.float xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto.
        :param _builtins.float xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto.
        :param _builtins.bool y0_scale_si_by1024: Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        :param _builtins.bool y0_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        :param _builtins.bool y1_scale_si_by1024: Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        :param _builtins.bool y1_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        :param _builtins.str y1_units: For plots with multiple Y-axes, units for right side Y-axis.
        :param _builtins.float y1max: For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto.
        :param _builtins.float y1min: For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto.
        :param _builtins.float ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        :param _builtins.float ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        pulumi.set(__self__, "type", type)
        if auto_column_tags is not None:
            pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        if column_tags is not None:
            pulumi.set(__self__, "column_tags", column_tags)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if expected_data_spacing is not None:
            pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        if fixed_legend_display_stats is not None:
            pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        if fixed_legend_enabled is not None:
            pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        if fixed_legend_filter_field is not None:
            pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        if fixed_legend_filter_limit is not None:
            pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        if fixed_legend_filter_sort is not None:
            pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        if fixed_legend_hide_label is not None:
            pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        if fixed_legend_position is not None:
            pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        if fixed_legend_use_raw_stats is not None:
            pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        if group_by_source is not None:
            pulumi.set(__self__, "group_by_source", group_by_source)
        if invert_dynamic_legend_hover_control is not None:
            pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        if line_type is not None:
            pulumi.set(__self__, "line_type", line_type)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if num_tags is not None:
            pulumi.set(__self__, "num_tags", num_tags)
        if plain_markdown_content is not None:
            pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        if show_hosts is not None:
            pulumi.set(__self__, "show_hosts", show_hosts)
        if show_labels is not None:
            pulumi.set(__self__, "show_labels", show_labels)
        if show_raw_values is not None:
            pulumi.set(__self__, "show_raw_values", show_raw_values)
        if sort_values_descending is not None:
            pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        if sparkline_decimal_precision is not None:
            pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        if sparkline_display_color is not None:
            pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        if sparkline_display_font_size is not None:
            pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        if sparkline_display_horizontal_position is not None:
            pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        if sparkline_display_postfix is not None:
            pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        if sparkline_display_prefix is not None:
            pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        if sparkline_display_value_type is not None:
            pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        if sparkline_display_vertical_position is not None:
            pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        if sparkline_fill_color is not None:
            pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        if sparkline_line_color is not None:
            pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        if sparkline_size is not None:
            pulumi.set(__self__, "sparkline_size", sparkline_size)
        if sparkline_value_color_map_apply_to is not None:
            pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        if sparkline_value_color_map_colors is not None:
            pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        if sparkline_value_color_map_values is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        if sparkline_value_color_map_values_v2s is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        if sparkline_value_text_map_texts is not None:
            pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        if sparkline_value_text_map_thresholds is not None:
            pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if tag_mode is not None:
            pulumi.set(__self__, "tag_mode", tag_mode)
        if time_based_coloring is not None:
            pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)
        if windowing is not None:
            pulumi.set(__self__, "windowing", windowing)
        if xmax is not None:
            pulumi.set(__self__, "xmax", xmax)
        if xmin is not None:
            pulumi.set(__self__, "xmin", xmin)
        if y0_scale_si_by1024 is not None:
            pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        if y0_unit_autoscaling is not None:
            pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        if y1_scale_si_by1024 is not None:
            pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        if y1_unit_autoscaling is not None:
            pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        if y1_units is not None:
            pulumi.set(__self__, "y1_units", y1_units)
        if y1max is not None:
            pulumi.set(__self__, "y1max", y1max)
        if y1min is not None:
            pulumi.set(__self__, "y1min", y1min)
        if ymax is not None:
            pulumi.set(__self__, "ymax", ymax)
        if ymin is not None:
            pulumi.set(__self__, "ymin", ymin)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to
        the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the
        Markdown display, and `sparkline` to the Single Stat view. Valid options are`line`, `scatterplot`,
        `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
        `top-k`, `status-list`, and `histogram`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> Optional[_builtins.bool]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "auto_column_tags")

    @_builtins.property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> Optional[_builtins.str]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "column_tags")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> Optional[_builtins.int]:
        """
        Threshold (in seconds) for time delta between consecutive points in a series
        above which a dotted line will replace a solid in in line plots. Default is 60.
        """
        return pulumi.get(self, "expected_data_spacing")

    @_builtins.property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Optional[Sequence[_builtins.str]]:
        """
        For a chart with a fixed legend, a list of statistics to display in the legend.
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @_builtins.property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable a fixed tabular legend adjacent to the chart.
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> Optional[_builtins.str]:
        """
        Statistic to use for determining whether a series is displayed on the fixed legend.
        Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> Optional[_builtins.int]:
        """
        Number of series to include in the fixed legend.
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> Optional[_builtins.str]:
        """
        Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
        are `TOP`, and `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @_builtins.property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> Optional[_builtins.bool]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @_builtins.property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> Optional[_builtins.str]:
        """
        Where the fixed legend should be displayed with respect to the chart.
        Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_position")

    @_builtins.property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> Optional[_builtins.bool]:
        """
        If `true`, the legend uses non-summarized stats instead of summarized.
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @_builtins.property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> Optional[_builtins.bool]:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source.
        If `false`, each source is displayed in its own row. if `true`, multiple metrics for the same host are displayed as different
        columns in the same row.
        """
        return pulumi.get(self, "group_by_source")

    @_builtins.property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> Optional[_builtins.bool]:
        """
        Whether to disable the display of the floating legend (but
        reenable it when the ctrl-key is pressed).
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @_builtins.property
    @pulumi.getter(name="lineType")
    def line_type(self) -> Optional[_builtins.str]:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`,
        `step-after`, `basis`, `cardinal`, and `monotone`.
        """
        return pulumi.get(self, "line_type")

    @_builtins.property
    @pulumi.getter
    def max(self) -> Optional[_builtins.float]:
        """
        Max value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> Optional[_builtins.float]:
        """
        Min value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> Optional[_builtins.int]:
        """
        For the tabular view defines how many point tags to display.
        """
        return pulumi.get(self, "num_tags")

    @_builtins.property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> Optional[_builtins.str]:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @_builtins.property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> Optional[_builtins.bool]:
        """
        For the tabular view, whether to display sources. Default is `true`.
        """
        return pulumi.get(self, "show_hosts")

    @_builtins.property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> Optional[_builtins.bool]:
        """
        For the tabular view, whether to display labels. Default is `true`.
        """
        return pulumi.get(self, "show_labels")

    @_builtins.property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> Optional[_builtins.bool]:
        """
        For the tabular view, whether to display raw values. Default is `false`.
        """
        return pulumi.get(self, "show_raw_values")

    @_builtins.property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> Optional[_builtins.bool]:
        """
        For the tabular view, whether to display values in descending order. Default is `false`.
        """
        return pulumi.get(self, "sort_values_descending")

    @_builtins.property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> Optional[_builtins.int]:
        """
        For the single stat view, the decimal precision of the displayed number.
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> Optional[_builtins.str]:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined).
        Values should be in `rgba(,,,,)` format.
        """
        return pulumi.get(self, "sparkline_display_color")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> Optional[_builtins.str]:
        """
        For the single stat view, the font size of the displayed text, in percent.
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> Optional[_builtins.str]:
        """
        For the single stat view, the horizontal position of the displayed text.
        Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> Optional[_builtins.str]:
        """
        For the single stat view, a string to append to the displayed text.
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> Optional[_builtins.str]:
        """
        For the single stat view, a string to add before the displayed text.
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> Optional[_builtins.str]:
        """
        For the single stat view, where to display the name of the query or the value of the query.
        Valid options are `VALUE` or `LABEL`.
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> Optional[_builtins.str]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @_builtins.property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> Optional[_builtins.str]:
        """
        For the single stat view, the color of the background fill. Values should be
        in `rgba(,,,,)`.
        """
        return pulumi.get(self, "sparkline_fill_color")

    @_builtins.property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> Optional[_builtins.str]:
        """
        For the single stat view, the color of the line. Values should be in `rgba(,,,,)` format.
        """
        return pulumi.get(self, "sparkline_line_color")

    @_builtins.property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> Optional[_builtins.str]:
        """
        For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart.
        Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        """
        return pulumi.get(self, "sparkline_size")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> Optional[_builtins.str]:
        """
        For the single stat view, whether to apply dynamic color settings to
        the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Optional[Sequence[_builtins.str]]:
        """
        For the single stat view, A list of colors that differing query values map to.
        Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`.
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Optional[Sequence[_builtins.int]]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Optional[Sequence[_builtins.float]]:
        """
        For the single stat view, a list of boundaries for mapping different
        query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @_builtins.property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Optional[Sequence[_builtins.str]]:
        """
        For the single stat view, a list of display text values that different query
        values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @_builtins.property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Optional[Sequence[_builtins.float]]:
        """
        For the single stat view, a list of threshold boundaries for
        mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[_builtins.str]:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
        stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
        center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        """
        return pulumi.get(self, "stack_type")

    @_builtins.property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> Optional[_builtins.str]:
        """
        For the tabular view, which mode to use to determine which point tags to display.
        Valid options are `all`, `top`, or `custom`.
        """
        return pulumi.get(self, "tag_mode")

    @_builtins.property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> Optional[_builtins.bool]:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points.
        """
        return pulumi.get(self, "time_based_coloring")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[_builtins.int]:
        """
        Width, in minutes, of the time window to use for `last` windowing.
        """
        return pulumi.get(self, "window_size")

    @_builtins.property
    @pulumi.getter
    def windowing(self) -> Optional[_builtins.str]:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes.
        Valid options are `full` or `last`.
        """
        return pulumi.get(self, "windowing")

    @_builtins.property
    @pulumi.getter
    def xmax(self) -> Optional[_builtins.float]:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmax")

    @_builtins.property
    @pulumi.getter
    def xmin(self) -> Optional[_builtins.float]:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmin")

    @_builtins.property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> Optional[_builtins.bool]:
        """
        Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        """
        return pulumi.get(self, "y0_scale_si_by1024")

    @_builtins.property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> Optional[_builtins.bool]:
        """
        Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @_builtins.property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> Optional[_builtins.bool]:
        """
        Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI).
        """
        return pulumi.get(self, "y1_scale_si_by1024")

    @_builtins.property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> Optional[_builtins.bool]:
        """
        Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @_builtins.property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> Optional[_builtins.str]:
        """
        For plots with multiple Y-axes, units for right side Y-axis.
        """
        return pulumi.get(self, "y1_units")

    @_builtins.property
    @pulumi.getter
    def y1max(self) -> Optional[_builtins.float]:
        """
        For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto.
        """
        return pulumi.get(self, "y1max")

    @_builtins.property
    @pulumi.getter
    def y1min(self) -> Optional[_builtins.float]:
        """
        For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto.
        """
        return pulumi.get(self, "y1min")

    @_builtins.property
    @pulumi.getter
    def ymax(self) -> Optional[_builtins.float]:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymax")

    @_builtins.property
    @pulumi.getter
    def ymin(self) -> Optional[_builtins.float]:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymin")


@pulumi.output_type
class DashboardSectionRowChartSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryBuilderEnabled":
            suggest = "query_builder_enabled"
        elif key == "scatterPlotSource":
            suggest = "scatter_plot_source"
        elif key == "sourceDescription":
            suggest = "source_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChartSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChartSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChartSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 query: _builtins.str,
                 disabled: Optional[_builtins.bool] = None,
                 query_builder_enabled: Optional[_builtins.bool] = None,
                 scatter_plot_source: Optional[_builtins.str] = None,
                 source_description: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the source.
        :param _builtins.str query: Query expression to plot on the chart.
        :param _builtins.bool disabled: Whether the source is disabled.
        :param _builtins.bool query_builder_enabled: Whether or not this source line should have the query builder enabled.
        :param _builtins.str scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param _builtins.str source_description: A description for the purpose of this source.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if query_builder_enabled is not None:
            pulumi.set(__self__, "query_builder_enabled", query_builder_enabled)
        if scatter_plot_source is not None:
            pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        if source_description is not None:
            pulumi.set(__self__, "source_description", source_description)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the source.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Query expression to plot on the chart.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[_builtins.bool]:
        """
        Whether the source is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter(name="queryBuilderEnabled")
    def query_builder_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether or not this source line should have the query builder enabled.
        """
        return pulumi.get(self, "query_builder_enabled")

    @_builtins.property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> Optional[_builtins.str]:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @_builtins.property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> Optional[_builtins.str]:
        """
        A description for the purpose of this source.
        """
        return pulumi.get(self, "source_description")


@pulumi.output_type
class IngestionPolicyTag(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class MetricsPolicyPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "tagsAnded":
            suggest = "tags_anded"
        elif key == "accountIds":
            suggest = "account_ids"
        elif key == "roleIds":
            suggest = "role_ids"
        elif key == "userGroupIds":
            suggest = "user_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricsPolicyPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricsPolicyPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricsPolicyPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: _builtins.str,
                 description: _builtins.str,
                 name: _builtins.str,
                 prefixes: Sequence[_builtins.str],
                 tags_anded: _builtins.bool,
                 account_ids: Optional[Sequence[_builtins.str]] = None,
                 role_ids: Optional[Sequence[_builtins.str]] = None,
                 tags: Optional[Sequence['outputs.MetricsPolicyPolicyRuleTag']] = None,
                 user_group_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str access_type: Valid options are `ALLOW` and `BLOCK`.
        :param _builtins.str description: A detailed description of the Metrics Policy. The description is visible only when you edit the rule.
        :param _builtins.str name: The unique name identifier for a Metrics Policy. The name is visible on the Metrics Security Policy page.
        :param Sequence[_builtins.str] prefixes: List of prefixes to match metrics on. You can specify the full metric name or use a wildcard character in metric names, sources, or point tags. The wildcard character alone (*) means all metrics.
        :param _builtins.bool tags_anded: Bool where `true` require all tags are met by selected metrics, else `false` select metrics that match any give tag.
        :param Sequence[_builtins.str] account_ids: List of account ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        :param Sequence[_builtins.str] role_ids: List of role ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        :param Sequence['MetricsPolicyPolicyRuleTagArgs'] tags: List of Key/Value tags to select target metrics for policy.
        :param Sequence[_builtins.str] user_group_ids: List of user group ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "prefixes", prefixes)
        pulumi.set(__self__, "tags_anded", tags_anded)
        if account_ids is not None:
            pulumi.set(__self__, "account_ids", account_ids)
        if role_ids is not None:
            pulumi.set(__self__, "role_ids", role_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> _builtins.str:
        """
        Valid options are `ALLOW` and `BLOCK`.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A detailed description of the Metrics Policy. The description is visible only when you edit the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The unique name identifier for a Metrics Policy. The name is visible on the Metrics Security Policy page.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Sequence[_builtins.str]:
        """
        List of prefixes to match metrics on. You can specify the full metric name or use a wildcard character in metric names, sources, or point tags. The wildcard character alone (*) means all metrics.
        """
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter(name="tagsAnded")
    def tags_anded(self) -> _builtins.bool:
        """
        Bool where `true` require all tags are met by selected metrics, else `false` select metrics that match any give tag.
        """
        return pulumi.get(self, "tags_anded")

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of account ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "account_ids")

    @_builtins.property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of role ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "role_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.MetricsPolicyPolicyRuleTag']]:
        """
        List of Key/Value tags to select target metrics for policy.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of user group ids to apply Metrics Policy to. Must have at least one associated account_id, user_group_id, or role_id.
        """
        return pulumi.get(self, "user_group_ids")


@pulumi.output_type
class MetricsPolicyPolicyRuleTag(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: The tag's key.
        :param _builtins.str value: The tag's value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The tag's key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The tag's value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAlertAlertTriageDashboardResult(dict):
    def __init__(__self__, *,
                 dashboard_id: _builtins.str,
                 description: _builtins.str,
                 parameters: Optional['outputs.GetAlertAlertTriageDashboardParametersResult'] = None):
        """
        :param _builtins.str dashboard_id: Dashboard ID
        :param _builtins.str description: Dashboard Description
        """
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> _builtins.str:
        """
        Dashboard ID
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Dashboard Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.GetAlertAlertTriageDashboardParametersResult']:
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GetAlertAlertTriageDashboardParametersResult(dict):
    def __init__(__self__, *,
                 constants: Optional[Mapping[str, _builtins.str]] = None):
        if constants is not None:
            pulumi.set(__self__, "constants", constants)

    @_builtins.property
    @pulumi.getter
    def constants(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "constants")


@pulumi.output_type
class GetAlertFailingHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: _builtins.int,
                 host: _builtins.str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter
    def firing(self) -> _builtins.int:
        return pulumi.get(self, "firing")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetAlertInMaintenanceHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: _builtins.int,
                 host: _builtins.str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter
    def firing(self) -> _builtins.int:
        return pulumi.get(self, "firing")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetAlertsAlertResult(dict):
    def __init__(__self__, *,
                 additional_information: _builtins.str,
                 alert_triage_dashboards: Sequence['outputs.GetAlertsAlertAlertTriageDashboardResult'],
                 alert_type: _builtins.str,
                 can_modifies: Sequence[_builtins.str],
                 can_views: Sequence[_builtins.str],
                 condition: _builtins.str,
                 conditions: Mapping[str, _builtins.str],
                 display_expression: _builtins.str,
                 evaluate_realtime_data: _builtins.bool,
                 failing_host_label_pairs: Sequence['outputs.GetAlertsAlertFailingHostLabelPairResult'],
                 id: _builtins.str,
                 in_maintenance_host_label_pairs: Sequence['outputs.GetAlertsAlertInMaintenanceHostLabelPairResult'],
                 include_obsolete_metrics: _builtins.bool,
                 minutes: _builtins.int,
                 name: _builtins.str,
                 notification_resend_frequency_minutes: _builtins.int,
                 process_rate_minutes: _builtins.int,
                 resolve_after_minutes: _builtins.int,
                 runbook_links: Sequence[_builtins.str],
                 severity: _builtins.str,
                 severity_lists: Sequence[_builtins.str],
                 statuses: Sequence[_builtins.str],
                 tags: Sequence[_builtins.str],
                 target: _builtins.str,
                 targets: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str additional_information: User-supplied additional explanatory information about this alert.
        :param Sequence['GetAlertsAlertAlertTriageDashboardArgs'] alert_triage_dashboards: A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        :param _builtins.str alert_type: The type of alert in Wavefront.
        :param Sequence[_builtins.str] can_modifies: A list of users or groups that can modify the alert.
        :param Sequence[_builtins.str] can_views: A list of users or groups that can view the alert.
        :param _builtins.str condition: A Wavefront query that is evaluated at regular intervals (default is 1 minute). The alert fires and notifications are triggered when a data series matching this query evaluates to a non-zero value for a set number of consecutive minutes.
        :param Mapping[str, _builtins.str] conditions: A map of severity to condition for which this alert will trigger.
        :param _builtins.str display_expression: A second query the results of which are displayed in the alert user interface instead of the condition query.
        :param _builtins.bool evaluate_realtime_data: A Boolean flag to enable real-time evaluation.
        :param Sequence['GetAlertsAlertFailingHostLabelPairArgs'] failing_host_label_pairs: A list of failing host label pairs.
        :param _builtins.str id: The ID of the alert in Wavefront.
        :param Sequence['GetAlertsAlertInMaintenanceHostLabelPairArgs'] in_maintenance_host_label_pairs: A list of in maintenance host label pairs.
        :param _builtins.bool include_obsolete_metrics: A Boolean flag indicating whether to include obsolete metrics or not.
        :param _builtins.int minutes: The number of consecutive minutes that a series matching the condition query must evaluate to "true" (non-zero value) before the alert fires.
        :param _builtins.str name: The name of the alert as it is displayed in Wavefront.
        :param _builtins.int notification_resend_frequency_minutes: How often to re-trigger a continually failing alert.
        :param _builtins.int process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes.
        :param _builtins.int resolve_after_minutes: The number of consecutive minutes that a firing series matching the condition query must evaluate to "false" (zero value) before the alert resolves.
        :param Sequence[_builtins.str] runbook_links: A list of user-supplied runbook links for this alert.
        :param _builtins.str severity: The severity of the alert.
        :param Sequence[_builtins.str] statuses: The status of the alert.
        :param Sequence[_builtins.str] tags: A set of tags assigned to the alert.
        :param _builtins.str target: An email address or integration endpoint (such as PagerDuty or webhook) to notify when the alert status changes.
        :param Mapping[str, _builtins.str] targets: A comma-separated list of the email addresses or integration endpoints (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        """
        pulumi.set(__self__, "additional_information", additional_information)
        pulumi.set(__self__, "alert_triage_dashboards", alert_triage_dashboards)
        pulumi.set(__self__, "alert_type", alert_type)
        pulumi.set(__self__, "can_modifies", can_modifies)
        pulumi.set(__self__, "can_views", can_views)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "display_expression", display_expression)
        pulumi.set(__self__, "evaluate_realtime_data", evaluate_realtime_data)
        pulumi.set(__self__, "failing_host_label_pairs", failing_host_label_pairs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_maintenance_host_label_pairs", in_maintenance_host_label_pairs)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notification_resend_frequency_minutes", notification_resend_frequency_minutes)
        pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        pulumi.set(__self__, "resolve_after_minutes", resolve_after_minutes)
        pulumi.set(__self__, "runbook_links", runbook_links)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "severity_lists", severity_lists)
        pulumi.set(__self__, "statuses", statuses)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "target", target)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> _builtins.str:
        """
        User-supplied additional explanatory information about this alert.
        """
        return pulumi.get(self, "additional_information")

    @_builtins.property
    @pulumi.getter(name="alertTriageDashboards")
    def alert_triage_dashboards(self) -> Sequence['outputs.GetAlertsAlertAlertTriageDashboardResult']:
        """
        A set of user-supplied dashboard and parameters to create dashboard links for triaging alerts.
        """
        return pulumi.get(self, "alert_triage_dashboards")

    @_builtins.property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> _builtins.str:
        """
        The type of alert in Wavefront.
        """
        return pulumi.get(self, "alert_type")

    @_builtins.property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> Sequence[_builtins.str]:
        """
        A list of users or groups that can modify the alert.
        """
        return pulumi.get(self, "can_modifies")

    @_builtins.property
    @pulumi.getter(name="canViews")
    def can_views(self) -> Sequence[_builtins.str]:
        """
        A list of users or groups that can view the alert.
        """
        return pulumi.get(self, "can_views")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> _builtins.str:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute). The alert fires and notifications are triggered when a data series matching this query evaluates to a non-zero value for a set number of consecutive minutes.
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Mapping[str, _builtins.str]:
        """
        A map of severity to condition for which this alert will trigger.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="displayExpression")
    def display_expression(self) -> _builtins.str:
        """
        A second query the results of which are displayed in the alert user interface instead of the condition query.
        """
        return pulumi.get(self, "display_expression")

    @_builtins.property
    @pulumi.getter(name="evaluateRealtimeData")
    def evaluate_realtime_data(self) -> _builtins.bool:
        """
        A Boolean flag to enable real-time evaluation.
        """
        return pulumi.get(self, "evaluate_realtime_data")

    @_builtins.property
    @pulumi.getter(name="failingHostLabelPairs")
    def failing_host_label_pairs(self) -> Sequence['outputs.GetAlertsAlertFailingHostLabelPairResult']:
        """
        A list of failing host label pairs.
        """
        return pulumi.get(self, "failing_host_label_pairs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the alert in Wavefront.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inMaintenanceHostLabelPairs")
    def in_maintenance_host_label_pairs(self) -> Sequence['outputs.GetAlertsAlertInMaintenanceHostLabelPairResult']:
        """
        A list of in maintenance host label pairs.
        """
        return pulumi.get(self, "in_maintenance_host_label_pairs")

    @_builtins.property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> _builtins.bool:
        """
        A Boolean flag indicating whether to include obsolete metrics or not.
        """
        return pulumi.get(self, "include_obsolete_metrics")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> _builtins.int:
        """
        The number of consecutive minutes that a series matching the condition query must evaluate to "true" (non-zero value) before the alert fires.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the alert as it is displayed in Wavefront.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationResendFrequencyMinutes")
    def notification_resend_frequency_minutes(self) -> _builtins.int:
        """
        How often to re-trigger a continually failing alert.
        """
        return pulumi.get(self, "notification_resend_frequency_minutes")

    @_builtins.property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> _builtins.int:
        """
        The specified query is executed every `process_rate_minutes` minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @_builtins.property
    @pulumi.getter(name="resolveAfterMinutes")
    def resolve_after_minutes(self) -> _builtins.int:
        """
        The number of consecutive minutes that a firing series matching the condition query must evaluate to "false" (zero value) before the alert resolves.
        """
        return pulumi.get(self, "resolve_after_minutes")

    @_builtins.property
    @pulumi.getter(name="runbookLinks")
    def runbook_links(self) -> Sequence[_builtins.str]:
        """
        A list of user-supplied runbook links for this alert.
        """
        return pulumi.get(self, "runbook_links")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        The severity of the alert.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="severityLists")
    def severity_lists(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "severity_lists")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Sequence[_builtins.str]:
        """
        The status of the alert.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A set of tags assigned to the alert.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        An email address or integration endpoint (such as PagerDuty or webhook) to notify when the alert status changes.
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A comma-separated list of the email addresses or integration endpoints (such as PagerDuty or webhook) to notify when the alert status changes. Multiple target types can be in the list.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetAlertsAlertAlertTriageDashboardResult(dict):
    def __init__(__self__, *,
                 dashboard_id: _builtins.str,
                 description: _builtins.str,
                 parameters: Optional['outputs.GetAlertsAlertAlertTriageDashboardParametersResult'] = None):
        """
        :param _builtins.str dashboard_id: Dashboard ID
        :param _builtins.str description: Dashboard Description
        """
        pulumi.set(__self__, "dashboard_id", dashboard_id)
        pulumi.set(__self__, "description", description)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> _builtins.str:
        """
        Dashboard ID
        """
        return pulumi.get(self, "dashboard_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Dashboard Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.GetAlertsAlertAlertTriageDashboardParametersResult']:
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GetAlertsAlertAlertTriageDashboardParametersResult(dict):
    def __init__(__self__, *,
                 constants: Optional[Mapping[str, _builtins.str]] = None):
        if constants is not None:
            pulumi.set(__self__, "constants", constants)

    @_builtins.property
    @pulumi.getter
    def constants(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "constants")


@pulumi.output_type
class GetAlertsAlertFailingHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: _builtins.int,
                 host: _builtins.str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter
    def firing(self) -> _builtins.int:
        return pulumi.get(self, "firing")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetAlertsAlertInMaintenanceHostLabelPairResult(dict):
    def __init__(__self__, *,
                 firing: _builtins.int,
                 host: _builtins.str):
        pulumi.set(__self__, "firing", firing)
        pulumi.set(__self__, "host", host)

    @_builtins.property
    @pulumi.getter
    def firing(self) -> _builtins.int:
        return pulumi.get(self, "firing")

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")


@pulumi.output_type
class GetDashboardParameterDetailResult(dict):
    def __init__(__self__, *,
                 default_value: _builtins.str,
                 dynamic_field_type: _builtins.str,
                 hide_from_view: _builtins.bool,
                 label: _builtins.str,
                 parameter_type: _builtins.str,
                 query_value: _builtins.str,
                 tag_key: _builtins.str,
                 values_to_readable_strings: Mapping[str, _builtins.str]):
        """
        :param _builtins.str default_value: The default value of the parameter.
        :param _builtins.str dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        :param _builtins.bool hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard.
        :param _builtins.str label: The label for the parameter.
        :param _builtins.str parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        :param _builtins.str query_value: For `DYNAMIC` parameter types, the query to execute to return values.
        :param _builtins.str tag_key: For `TAG_KEY` dynamic field types, the tag key to return.
        :param Mapping[str, _builtins.str] values_to_readable_strings: A string to string map. At least one of the keys must match the value of
               `default_value`.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "query_value", query_value)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> _builtins.str:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        """
        return pulumi.get(self, "dynamic_field_type")

    @_builtins.property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> _builtins.bool:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard.
        """
        return pulumi.get(self, "hide_from_view")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label for the parameter.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> _builtins.str:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        """
        return pulumi.get(self, "parameter_type")

    @_builtins.property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> _builtins.str:
        """
        For `DYNAMIC` parameter types, the query to execute to return values.
        """
        return pulumi.get(self, "query_value")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> _builtins.str:
        """
        For `TAG_KEY` dynamic field types, the tag key to return.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> Mapping[str, _builtins.str]:
        """
        A string to string map. At least one of the keys must match the value of
        `default_value`.
        """
        return pulumi.get(self, "values_to_readable_strings")


@pulumi.output_type
class GetDashboardSectionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 rows: Sequence['outputs.GetDashboardSectionRowResult']):
        """
        :param _builtins.str name: The name of the parameters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.GetDashboardSectionRowResult']:
        return pulumi.get(self, "rows")


@pulumi.output_type
class GetDashboardSectionRowResult(dict):
    def __init__(__self__, *,
                 charts: Sequence['outputs.GetDashboardSectionRowChartResult'],
                 height_factor: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the parameters.
        """
        pulumi.set(__self__, "charts", charts)
        pulumi.set(__self__, "height_factor", height_factor)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def charts(self) -> Sequence['outputs.GetDashboardSectionRowChartResult']:
        return pulumi.get(self, "charts")

    @_builtins.property
    @pulumi.getter(name="heightFactor")
    def height_factor(self) -> _builtins.int:
        return pulumi.get(self, "height_factor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDashboardSectionRowChartResult(dict):
    def __init__(__self__, *,
                 base: _builtins.int,
                 chart_attributes: _builtins.str,
                 chart_settings: Sequence['outputs.GetDashboardSectionRowChartChartSettingResult'],
                 description: _builtins.str,
                 include_obsolete_metrics: _builtins.bool,
                 interpolate_points_key: _builtins.bool,
                 name: _builtins.str,
                 no_default_events: _builtins.bool,
                 sources: Sequence['outputs.GetDashboardSectionRowChartSourceResult'],
                 summarization: _builtins.str,
                 units: _builtins.str):
        """
        :param _builtins.int base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param _builtins.str description: Description of the chart.
        :param _builtins.str name: The name of the parameters.
        :param _builtins.str summarization: Summarization strategy for the chart. MEAN is default.
        :param _builtins.str units: String to label the units of the chart on the Y-Axis.
        """
        pulumi.set(__self__, "base", base)
        pulumi.set(__self__, "chart_attributes", chart_attributes)
        pulumi.set(__self__, "chart_settings", chart_settings)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "interpolate_points_key", interpolate_points_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "no_default_events", no_default_events)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)

    @_builtins.property
    @pulumi.getter
    def base(self) -> _builtins.int:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @_builtins.property
    @pulumi.getter(name="chartAttributes")
    def chart_attributes(self) -> _builtins.str:
        return pulumi.get(self, "chart_attributes")

    @_builtins.property
    @pulumi.getter(name="chartSettings")
    def chart_settings(self) -> Sequence['outputs.GetDashboardSectionRowChartChartSettingResult']:
        return pulumi.get(self, "chart_settings")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> _builtins.bool:
        return pulumi.get(self, "include_obsolete_metrics")

    @_builtins.property
    @pulumi.getter(name="interpolatePointsKey")
    def interpolate_points_key(self) -> _builtins.bool:
        return pulumi.get(self, "interpolate_points_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noDefaultEvents")
    def no_default_events(self) -> _builtins.bool:
        return pulumi.get(self, "no_default_events")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetDashboardSectionRowChartSourceResult']:
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def summarization(self) -> _builtins.str:
        """
        Summarization strategy for the chart. MEAN is default.
        """
        return pulumi.get(self, "summarization")

    @_builtins.property
    @pulumi.getter
    def units(self) -> _builtins.str:
        """
        String to label the units of the chart on the Y-Axis.
        """
        return pulumi.get(self, "units")


@pulumi.output_type
class GetDashboardSectionRowChartChartSettingResult(dict):
    def __init__(__self__, *,
                 auto_column_tags: _builtins.bool,
                 column_tags: _builtins.str,
                 custom_tags: Sequence[_builtins.str],
                 expected_data_spacing: _builtins.int,
                 fixed_legend_display_stats: Sequence[_builtins.str],
                 fixed_legend_enabled: _builtins.bool,
                 fixed_legend_filter_field: _builtins.str,
                 fixed_legend_filter_limit: _builtins.int,
                 fixed_legend_filter_sort: _builtins.str,
                 fixed_legend_hide_label: _builtins.bool,
                 fixed_legend_position: _builtins.str,
                 fixed_legend_use_raw_stats: _builtins.bool,
                 group_by_source: _builtins.bool,
                 invert_dynamic_legend_hover_control: _builtins.bool,
                 line_type: _builtins.str,
                 max: _builtins.float,
                 min: _builtins.float,
                 num_tags: _builtins.int,
                 plain_markdown_content: _builtins.str,
                 show_hosts: _builtins.bool,
                 show_labels: _builtins.bool,
                 show_raw_values: _builtins.bool,
                 sort_values_descending: _builtins.bool,
                 sparkline_decimal_precision: _builtins.int,
                 sparkline_display_color: _builtins.str,
                 sparkline_display_font_size: _builtins.str,
                 sparkline_display_horizontal_position: _builtins.str,
                 sparkline_display_postfix: _builtins.str,
                 sparkline_display_prefix: _builtins.str,
                 sparkline_display_value_type: _builtins.str,
                 sparkline_display_vertical_position: _builtins.str,
                 sparkline_fill_color: _builtins.str,
                 sparkline_line_color: _builtins.str,
                 sparkline_size: _builtins.str,
                 sparkline_value_color_map_apply_to: _builtins.str,
                 sparkline_value_color_map_colors: Sequence[_builtins.str],
                 sparkline_value_color_map_values: Sequence[_builtins.int],
                 sparkline_value_color_map_values_v2s: Sequence[_builtins.float],
                 sparkline_value_text_map_texts: Sequence[_builtins.str],
                 sparkline_value_text_map_thresholds: Sequence[_builtins.float],
                 stack_type: _builtins.str,
                 tag_mode: _builtins.str,
                 time_based_coloring: _builtins.bool,
                 type: _builtins.str,
                 window_size: _builtins.int,
                 windowing: _builtins.str,
                 xmax: _builtins.float,
                 xmin: _builtins.float,
                 y0_scale_si_by1024: _builtins.bool,
                 y0_unit_autoscaling: _builtins.bool,
                 y1_max: _builtins.float,
                 y1_min: _builtins.float,
                 y1_scale_si_by1024: _builtins.bool,
                 y1_unit_autoscaling: _builtins.bool,
                 y1_units: _builtins.str,
                 ymax: _builtins.float,
                 ymin: _builtins.float):
        """
        :param _builtins.bool auto_column_tags: This setting is deprecated.
        :param _builtins.str column_tags: This setting is deprecated.
        :param Sequence[_builtins.str] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        :param _builtins.int expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        :param Sequence[_builtins.str] fixed_legend_display_stats: (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        :param _builtins.bool fixed_legend_enabled: (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        :param _builtins.str fixed_legend_filter_field: (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        :param _builtins.int fixed_legend_filter_limit: (Optional) Number of series to include in the fixed legend.
        :param _builtins.str fixed_legend_filter_sort: (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        :param _builtins.bool fixed_legend_hide_label: (Optional) This setting is deprecated.
        :param _builtins.str fixed_legend_position: (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        :param _builtins.bool fixed_legend_use_raw_stats: (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        :param _builtins.bool group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        :param _builtins.bool invert_dynamic_legend_hover_control: (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        :param _builtins.str line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        :param _builtins.float max: Max value of the Y-axis. Set to null or leave blank for auto.
        :param _builtins.float min: Min value of the Y-axis. Set to null or leave blank for auto.
        :param _builtins.int num_tags: For the tabular view defines how many point tags to display.
        :param _builtins.str plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param _builtins.bool show_hosts: For the tabular view, whether to display sources. Default is `true`.
        :param _builtins.bool show_labels: For the tabular view, whether to display labels. Default is `true`.
        :param _builtins.bool show_raw_values: For the tabular view, whether to display raw values. Default is `false`.
        :param _builtins.bool sort_values_descending: For the tabular view, whether to display values in descending order. Default is `false`.
        :param _builtins.int sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number.
        :param _builtins.str sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        :param _builtins.str sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent.
        :param _builtins.str sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        :param _builtins.str sparkline_display_postfix: For the single stat view, a string to append to the displayed text.
        :param _builtins.str sparkline_display_prefix: For the single stat view, a string to add before the displayed text.
        :param _builtins.str sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        :param _builtins.str sparkline_display_vertical_position: This setting is deprecated.
        :param _builtins.str sparkline_fill_color: For the single stat view, the color of the background fill. Values should be in RGBA format.
        :param _builtins.str sparkline_line_color: For the single stat view, the color of the line. Values should be in RGBA format.
        :param _builtins.str sparkline_size: For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        :param _builtins.str sparkline_value_color_map_apply_to: For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        :param Sequence[_builtins.str] sparkline_value_color_map_colors: For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        :param Sequence[_builtins.int] sparkline_value_color_map_values: This setting is deprecated.
        :param Sequence[_builtins.float] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        :param Sequence[_builtins.str] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        :param Sequence[_builtins.float] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        :param _builtins.str stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        :param _builtins.str tag_mode: For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        :param _builtins.bool time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points.
        :param _builtins.str type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are`line`, `scatterplot`,
               `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        :param _builtins.int window_size: Width, in minutes, of the time window to use for `last` windowing.
        :param _builtins.str windowing: For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        :param _builtins.float xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto.
        :param _builtins.float xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto.
        :param _builtins.bool y0_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        :param _builtins.bool y1_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        :param _builtins.str y1_units: For plots with multiple Y-axes, units for right side Y-axis.
        :param _builtins.float ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        :param _builtins.float ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        pulumi.set(__self__, "column_tags", column_tags)
        pulumi.set(__self__, "custom_tags", custom_tags)
        pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        pulumi.set(__self__, "group_by_source", group_by_source)
        pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        pulumi.set(__self__, "line_type", line_type)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "num_tags", num_tags)
        pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        pulumi.set(__self__, "show_hosts", show_hosts)
        pulumi.set(__self__, "show_labels", show_labels)
        pulumi.set(__self__, "show_raw_values", show_raw_values)
        pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        pulumi.set(__self__, "sparkline_size", sparkline_size)
        pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        pulumi.set(__self__, "stack_type", stack_type)
        pulumi.set(__self__, "tag_mode", tag_mode)
        pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "window_size", window_size)
        pulumi.set(__self__, "windowing", windowing)
        pulumi.set(__self__, "xmax", xmax)
        pulumi.set(__self__, "xmin", xmin)
        pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        pulumi.set(__self__, "y1_max", y1_max)
        pulumi.set(__self__, "y1_min", y1_min)
        pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        pulumi.set(__self__, "y1_units", y1_units)
        pulumi.set(__self__, "ymax", ymax)
        pulumi.set(__self__, "ymin", ymin)

    @_builtins.property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> _builtins.bool:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "auto_column_tags")

    @_builtins.property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> _builtins.str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "column_tags")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Sequence[_builtins.str]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> _builtins.int:
        """
        Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        """
        return pulumi.get(self, "expected_data_spacing")

    @_builtins.property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Sequence[_builtins.str]:
        """
        (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @_builtins.property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> _builtins.bool:
        """
        (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> _builtins.str:
        """
        (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> _builtins.int:
        """
        (Optional) Number of series to include in the fixed legend.
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> _builtins.str:
        """
        (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @_builtins.property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> _builtins.bool:
        """
        (Optional) This setting is deprecated.
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @_builtins.property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> _builtins.str:
        """
        (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_position")

    @_builtins.property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> _builtins.bool:
        """
        (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @_builtins.property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> _builtins.bool:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        """
        return pulumi.get(self, "group_by_source")

    @_builtins.property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> _builtins.bool:
        """
        (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @_builtins.property
    @pulumi.getter(name="lineType")
    def line_type(self) -> _builtins.str:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        """
        return pulumi.get(self, "line_type")

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.float:
        """
        Max value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.float:
        """
        Min value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> _builtins.int:
        """
        For the tabular view defines how many point tags to display.
        """
        return pulumi.get(self, "num_tags")

    @_builtins.property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> _builtins.str:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @_builtins.property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> _builtins.bool:
        """
        For the tabular view, whether to display sources. Default is `true`.
        """
        return pulumi.get(self, "show_hosts")

    @_builtins.property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> _builtins.bool:
        """
        For the tabular view, whether to display labels. Default is `true`.
        """
        return pulumi.get(self, "show_labels")

    @_builtins.property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> _builtins.bool:
        """
        For the tabular view, whether to display raw values. Default is `false`.
        """
        return pulumi.get(self, "show_raw_values")

    @_builtins.property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> _builtins.bool:
        """
        For the tabular view, whether to display values in descending order. Default is `false`.
        """
        return pulumi.get(self, "sort_values_descending")

    @_builtins.property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> _builtins.int:
        """
        For the single stat view, the decimal precision of the displayed number.
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> _builtins.str:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_display_color")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> _builtins.str:
        """
        For the single stat view, the font size of the displayed text, in percent.
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> _builtins.str:
        """
        For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> _builtins.str:
        """
        For the single stat view, a string to append to the displayed text.
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> _builtins.str:
        """
        For the single stat view, a string to add before the displayed text.
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> _builtins.str:
        """
        For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> _builtins.str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @_builtins.property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> _builtins.str:
        """
        For the single stat view, the color of the background fill. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_fill_color")

    @_builtins.property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> _builtins.str:
        """
        For the single stat view, the color of the line. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_line_color")

    @_builtins.property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> _builtins.str:
        """
        For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        """
        return pulumi.get(self, "sparkline_size")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> _builtins.str:
        """
        For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Sequence[_builtins.str]:
        """
        For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Sequence[_builtins.int]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Sequence[_builtins.float]:
        """
        For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @_builtins.property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Sequence[_builtins.str]:
        """
        For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @_builtins.property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Sequence[_builtins.float]:
        """
        For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> _builtins.str:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        """
        return pulumi.get(self, "stack_type")

    @_builtins.property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> _builtins.str:
        """
        For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        """
        return pulumi.get(self, "tag_mode")

    @_builtins.property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> _builtins.bool:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points.
        """
        return pulumi.get(self, "time_based_coloring")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are`line`, `scatterplot`,
        `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> _builtins.int:
        """
        Width, in minutes, of the time window to use for `last` windowing.
        """
        return pulumi.get(self, "window_size")

    @_builtins.property
    @pulumi.getter
    def windowing(self) -> _builtins.str:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        """
        return pulumi.get(self, "windowing")

    @_builtins.property
    @pulumi.getter
    def xmax(self) -> _builtins.float:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmax")

    @_builtins.property
    @pulumi.getter
    def xmin(self) -> _builtins.float:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmin")

    @_builtins.property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> _builtins.bool:
        return pulumi.get(self, "y0_scale_si_by1024")

    @_builtins.property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> _builtins.bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @_builtins.property
    @pulumi.getter(name="y1Max")
    def y1_max(self) -> _builtins.float:
        return pulumi.get(self, "y1_max")

    @_builtins.property
    @pulumi.getter(name="y1Min")
    def y1_min(self) -> _builtins.float:
        return pulumi.get(self, "y1_min")

    @_builtins.property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> _builtins.bool:
        return pulumi.get(self, "y1_scale_si_by1024")

    @_builtins.property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> _builtins.bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @_builtins.property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> _builtins.str:
        """
        For plots with multiple Y-axes, units for right side Y-axis.
        """
        return pulumi.get(self, "y1_units")

    @_builtins.property
    @pulumi.getter
    def ymax(self) -> _builtins.float:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymax")

    @_builtins.property
    @pulumi.getter
    def ymin(self) -> _builtins.float:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymin")


@pulumi.output_type
class GetDashboardSectionRowChartSourceResult(dict):
    def __init__(__self__, *,
                 disabled: _builtins.bool,
                 name: _builtins.str,
                 query: _builtins.str,
                 querybuilder_enabled: _builtins.bool,
                 scatter_plot_source: _builtins.str,
                 secondary_axis: _builtins.bool,
                 source_color: _builtins.str,
                 source_description: _builtins.str):
        """
        :param _builtins.bool disabled: Whether the source is disabled.
        :param _builtins.str name: The name of the parameters.
        :param _builtins.str query: Query expression to plot on the chart.
        :param _builtins.str scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param _builtins.str source_description: A description for the purpose of this source.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "querybuilder_enabled", querybuilder_enabled)
        pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        pulumi.set(__self__, "secondary_axis", secondary_axis)
        pulumi.set(__self__, "source_color", source_color)
        pulumi.set(__self__, "source_description", source_description)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether the source is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Query expression to plot on the chart.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="querybuilderEnabled")
    def querybuilder_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "querybuilder_enabled")

    @_builtins.property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> _builtins.str:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @_builtins.property
    @pulumi.getter(name="secondaryAxis")
    def secondary_axis(self) -> _builtins.bool:
        return pulumi.get(self, "secondary_axis")

    @_builtins.property
    @pulumi.getter(name="sourceColor")
    def source_color(self) -> _builtins.str:
        return pulumi.get(self, "source_color")

    @_builtins.property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> _builtins.str:
        """
        A description for the purpose of this source.
        """
        return pulumi.get(self, "source_description")


@pulumi.output_type
class GetDashboardsDashboardResult(dict):
    def __init__(__self__, *,
                 can_modifies: Sequence[_builtins.str],
                 can_views: Sequence[_builtins.str],
                 chart_title_bg_color: _builtins.str,
                 chart_title_color: _builtins.str,
                 chart_title_scalar: _builtins.int,
                 created_epoch_millis: _builtins.int,
                 creator_id: _builtins.str,
                 customer: _builtins.str,
                 default_end_time: _builtins.int,
                 default_start_time: _builtins.int,
                 default_time_window: _builtins.str,
                 deleted: _builtins.bool,
                 description: _builtins.str,
                 display_description: _builtins.bool,
                 display_query_parameters: _builtins.bool,
                 display_section_table_of_contents: _builtins.bool,
                 event_filter_type: _builtins.str,
                 event_query: _builtins.str,
                 favorite: _builtins.bool,
                 hidden: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 num_charts: _builtins.int,
                 num_favorites: _builtins.int,
                 parameter_details: Sequence['outputs.GetDashboardsDashboardParameterDetailResult'],
                 parameters: Mapping[str, _builtins.str],
                 sections: Sequence['outputs.GetDashboardsDashboardSectionResult'],
                 system_owned: _builtins.bool,
                 tags: Sequence[_builtins.str],
                 updated_epoch_millis: _builtins.int,
                 updater_id: _builtins.str,
                 url: _builtins.str,
                 views_last_day: _builtins.int,
                 views_last_month: _builtins.int,
                 views_last_week: _builtins.int):
        """
        :param Sequence[_builtins.str] can_modifies: A list of users that have modify ACL access to the dashboard.
        :param Sequence[_builtins.str] can_views: A list of users that have view ACL access to the dashboard.
        :param _builtins.str description: Description of the chart.
        :param _builtins.bool display_query_parameters: Whether the dashboard parameters section is opened by default when the dashboard is shown.
        :param _builtins.bool display_section_table_of_contents: Whether the "pills" quick-linked the sections of the dashboard are displayed by default when the dashboard is shown.
        :param _builtins.str event_filter_type: How charts belonging to this dashboard should display events. `BYCHART` is default if
               unspecified. Valid options are: `BYCHART`, `AUTOMATIC`, `ALL`, `NONE`, `BYDASHBOARD`, and `BYCHARTANDDASHBOARD`.
        :param _builtins.str name: The name of the parameters.
        :param Sequence['GetDashboardsDashboardParameterDetailArgs'] parameter_details: The current JSON representation of dashboard parameters. See parameter details.
        :param Sequence[_builtins.str] tags: A set of tags to assign to this resource.
        :param _builtins.str url: Unique identifier, also a URL slug of the dashboard.
        """
        pulumi.set(__self__, "can_modifies", can_modifies)
        pulumi.set(__self__, "can_views", can_views)
        pulumi.set(__self__, "chart_title_bg_color", chart_title_bg_color)
        pulumi.set(__self__, "chart_title_color", chart_title_color)
        pulumi.set(__self__, "chart_title_scalar", chart_title_scalar)
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "customer", customer)
        pulumi.set(__self__, "default_end_time", default_end_time)
        pulumi.set(__self__, "default_start_time", default_start_time)
        pulumi.set(__self__, "default_time_window", default_time_window)
        pulumi.set(__self__, "deleted", deleted)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_description", display_description)
        pulumi.set(__self__, "display_query_parameters", display_query_parameters)
        pulumi.set(__self__, "display_section_table_of_contents", display_section_table_of_contents)
        pulumi.set(__self__, "event_filter_type", event_filter_type)
        pulumi.set(__self__, "event_query", event_query)
        pulumi.set(__self__, "favorite", favorite)
        pulumi.set(__self__, "hidden", hidden)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "num_charts", num_charts)
        pulumi.set(__self__, "num_favorites", num_favorites)
        pulumi.set(__self__, "parameter_details", parameter_details)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "sections", sections)
        pulumi.set(__self__, "system_owned", system_owned)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)
        pulumi.set(__self__, "updater_id", updater_id)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "views_last_day", views_last_day)
        pulumi.set(__self__, "views_last_month", views_last_month)
        pulumi.set(__self__, "views_last_week", views_last_week)

    @_builtins.property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> Sequence[_builtins.str]:
        """
        A list of users that have modify ACL access to the dashboard.
        """
        return pulumi.get(self, "can_modifies")

    @_builtins.property
    @pulumi.getter(name="canViews")
    def can_views(self) -> Sequence[_builtins.str]:
        """
        A list of users that have view ACL access to the dashboard.
        """
        return pulumi.get(self, "can_views")

    @_builtins.property
    @pulumi.getter(name="chartTitleBgColor")
    def chart_title_bg_color(self) -> _builtins.str:
        return pulumi.get(self, "chart_title_bg_color")

    @_builtins.property
    @pulumi.getter(name="chartTitleColor")
    def chart_title_color(self) -> _builtins.str:
        return pulumi.get(self, "chart_title_color")

    @_builtins.property
    @pulumi.getter(name="chartTitleScalar")
    def chart_title_scalar(self) -> _builtins.int:
        return pulumi.get(self, "chart_title_scalar")

    @_builtins.property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> _builtins.int:
        return pulumi.get(self, "created_epoch_millis")

    @_builtins.property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> _builtins.str:
        return pulumi.get(self, "creator_id")

    @_builtins.property
    @pulumi.getter
    def customer(self) -> _builtins.str:
        return pulumi.get(self, "customer")

    @_builtins.property
    @pulumi.getter(name="defaultEndTime")
    def default_end_time(self) -> _builtins.int:
        return pulumi.get(self, "default_end_time")

    @_builtins.property
    @pulumi.getter(name="defaultStartTime")
    def default_start_time(self) -> _builtins.int:
        return pulumi.get(self, "default_start_time")

    @_builtins.property
    @pulumi.getter(name="defaultTimeWindow")
    def default_time_window(self) -> _builtins.str:
        return pulumi.get(self, "default_time_window")

    @_builtins.property
    @pulumi.getter
    def deleted(self) -> _builtins.bool:
        return pulumi.get(self, "deleted")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayDescription")
    def display_description(self) -> _builtins.bool:
        return pulumi.get(self, "display_description")

    @_builtins.property
    @pulumi.getter(name="displayQueryParameters")
    def display_query_parameters(self) -> _builtins.bool:
        """
        Whether the dashboard parameters section is opened by default when the dashboard is shown.
        """
        return pulumi.get(self, "display_query_parameters")

    @_builtins.property
    @pulumi.getter(name="displaySectionTableOfContents")
    def display_section_table_of_contents(self) -> _builtins.bool:
        """
        Whether the "pills" quick-linked the sections of the dashboard are displayed by default when the dashboard is shown.
        """
        return pulumi.get(self, "display_section_table_of_contents")

    @_builtins.property
    @pulumi.getter(name="eventFilterType")
    def event_filter_type(self) -> _builtins.str:
        """
        How charts belonging to this dashboard should display events. `BYCHART` is default if
        unspecified. Valid options are: `BYCHART`, `AUTOMATIC`, `ALL`, `NONE`, `BYDASHBOARD`, and `BYCHARTANDDASHBOARD`.
        """
        return pulumi.get(self, "event_filter_type")

    @_builtins.property
    @pulumi.getter(name="eventQuery")
    def event_query(self) -> _builtins.str:
        return pulumi.get(self, "event_query")

    @_builtins.property
    @pulumi.getter
    def favorite(self) -> _builtins.bool:
        return pulumi.get(self, "favorite")

    @_builtins.property
    @pulumi.getter
    def hidden(self) -> _builtins.bool:
        return pulumi.get(self, "hidden")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numCharts")
    def num_charts(self) -> _builtins.int:
        return pulumi.get(self, "num_charts")

    @_builtins.property
    @pulumi.getter(name="numFavorites")
    def num_favorites(self) -> _builtins.int:
        return pulumi.get(self, "num_favorites")

    @_builtins.property
    @pulumi.getter(name="parameterDetails")
    def parameter_details(self) -> Sequence['outputs.GetDashboardsDashboardParameterDetailResult']:
        """
        The current JSON representation of dashboard parameters. See parameter details.
        """
        return pulumi.get(self, "parameter_details")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def sections(self) -> Sequence['outputs.GetDashboardsDashboardSectionResult']:
        return pulumi.get(self, "sections")

    @_builtins.property
    @pulumi.getter(name="systemOwned")
    def system_owned(self) -> _builtins.bool:
        return pulumi.get(self, "system_owned")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A set of tags to assign to this resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> _builtins.int:
        return pulumi.get(self, "updated_epoch_millis")

    @_builtins.property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> _builtins.str:
        return pulumi.get(self, "updater_id")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        Unique identifier, also a URL slug of the dashboard.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="viewsLastDay")
    def views_last_day(self) -> _builtins.int:
        return pulumi.get(self, "views_last_day")

    @_builtins.property
    @pulumi.getter(name="viewsLastMonth")
    def views_last_month(self) -> _builtins.int:
        return pulumi.get(self, "views_last_month")

    @_builtins.property
    @pulumi.getter(name="viewsLastWeek")
    def views_last_week(self) -> _builtins.int:
        return pulumi.get(self, "views_last_week")


@pulumi.output_type
class GetDashboardsDashboardParameterDetailResult(dict):
    def __init__(__self__, *,
                 default_value: _builtins.str,
                 dynamic_field_type: _builtins.str,
                 hide_from_view: _builtins.bool,
                 label: _builtins.str,
                 parameter_type: _builtins.str,
                 query_value: _builtins.str,
                 tag_key: _builtins.str,
                 values_to_readable_strings: Mapping[str, _builtins.str]):
        """
        :param _builtins.str default_value: The default value of the parameter.
        :param _builtins.str dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        :param _builtins.bool hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard.
        :param _builtins.str label: The label for the parameter.
        :param _builtins.str parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        :param _builtins.str query_value: For `DYNAMIC` parameter types, the query to execute to return values.
        :param _builtins.str tag_key: For `TAG_KEY` dynamic field types, the tag key to return.
        :param Mapping[str, _builtins.str] values_to_readable_strings: A string to string map. At least one of the keys must match the value of
               `default_value`.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "query_value", query_value)
        pulumi.set(__self__, "tag_key", tag_key)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> _builtins.str:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> _builtins.str:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, and `MATCHING_SOURCE_TAG`.
        """
        return pulumi.get(self, "dynamic_field_type")

    @_builtins.property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> _builtins.bool:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard.
        """
        return pulumi.get(self, "hide_from_view")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The label for the parameter.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> _builtins.str:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`.
        """
        return pulumi.get(self, "parameter_type")

    @_builtins.property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> _builtins.str:
        """
        For `DYNAMIC` parameter types, the query to execute to return values.
        """
        return pulumi.get(self, "query_value")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> _builtins.str:
        """
        For `TAG_KEY` dynamic field types, the tag key to return.
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> Mapping[str, _builtins.str]:
        """
        A string to string map. At least one of the keys must match the value of
        `default_value`.
        """
        return pulumi.get(self, "values_to_readable_strings")


@pulumi.output_type
class GetDashboardsDashboardSectionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 rows: Sequence['outputs.GetDashboardsDashboardSectionRowResult']):
        """
        :param _builtins.str name: The name of the parameters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowResult']:
        return pulumi.get(self, "rows")


@pulumi.output_type
class GetDashboardsDashboardSectionRowResult(dict):
    def __init__(__self__, *,
                 charts: Sequence['outputs.GetDashboardsDashboardSectionRowChartResult'],
                 height_factor: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.str name: The name of the parameters.
        """
        pulumi.set(__self__, "charts", charts)
        pulumi.set(__self__, "height_factor", height_factor)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def charts(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowChartResult']:
        return pulumi.get(self, "charts")

    @_builtins.property
    @pulumi.getter(name="heightFactor")
    def height_factor(self) -> _builtins.int:
        return pulumi.get(self, "height_factor")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDashboardsDashboardSectionRowChartResult(dict):
    def __init__(__self__, *,
                 base: _builtins.int,
                 chart_attributes: _builtins.str,
                 chart_settings: Sequence['outputs.GetDashboardsDashboardSectionRowChartChartSettingResult'],
                 description: _builtins.str,
                 include_obsolete_metrics: _builtins.bool,
                 interpolate_points_key: _builtins.bool,
                 name: _builtins.str,
                 no_default_events: _builtins.bool,
                 sources: Sequence['outputs.GetDashboardsDashboardSectionRowChartSourceResult'],
                 summarization: _builtins.str,
                 units: _builtins.str):
        """
        :param _builtins.int base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param _builtins.str description: Description of the chart.
        :param _builtins.str name: The name of the parameters.
        :param _builtins.str summarization: Summarization strategy for the chart. MEAN is default.
        :param _builtins.str units: String to label the units of the chart on the Y-Axis.
        """
        pulumi.set(__self__, "base", base)
        pulumi.set(__self__, "chart_attributes", chart_attributes)
        pulumi.set(__self__, "chart_settings", chart_settings)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "interpolate_points_key", interpolate_points_key)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "no_default_events", no_default_events)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)

    @_builtins.property
    @pulumi.getter
    def base(self) -> _builtins.int:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @_builtins.property
    @pulumi.getter(name="chartAttributes")
    def chart_attributes(self) -> _builtins.str:
        return pulumi.get(self, "chart_attributes")

    @_builtins.property
    @pulumi.getter(name="chartSettings")
    def chart_settings(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowChartChartSettingResult']:
        return pulumi.get(self, "chart_settings")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the chart.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> _builtins.bool:
        return pulumi.get(self, "include_obsolete_metrics")

    @_builtins.property
    @pulumi.getter(name="interpolatePointsKey")
    def interpolate_points_key(self) -> _builtins.bool:
        return pulumi.get(self, "interpolate_points_key")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noDefaultEvents")
    def no_default_events(self) -> _builtins.bool:
        return pulumi.get(self, "no_default_events")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetDashboardsDashboardSectionRowChartSourceResult']:
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter
    def summarization(self) -> _builtins.str:
        """
        Summarization strategy for the chart. MEAN is default.
        """
        return pulumi.get(self, "summarization")

    @_builtins.property
    @pulumi.getter
    def units(self) -> _builtins.str:
        """
        String to label the units of the chart on the Y-Axis.
        """
        return pulumi.get(self, "units")


@pulumi.output_type
class GetDashboardsDashboardSectionRowChartChartSettingResult(dict):
    def __init__(__self__, *,
                 auto_column_tags: _builtins.bool,
                 column_tags: _builtins.str,
                 custom_tags: Sequence[_builtins.str],
                 expected_data_spacing: _builtins.int,
                 fixed_legend_display_stats: Sequence[_builtins.str],
                 fixed_legend_enabled: _builtins.bool,
                 fixed_legend_filter_field: _builtins.str,
                 fixed_legend_filter_limit: _builtins.int,
                 fixed_legend_filter_sort: _builtins.str,
                 fixed_legend_hide_label: _builtins.bool,
                 fixed_legend_position: _builtins.str,
                 fixed_legend_use_raw_stats: _builtins.bool,
                 group_by_source: _builtins.bool,
                 invert_dynamic_legend_hover_control: _builtins.bool,
                 line_type: _builtins.str,
                 max: _builtins.float,
                 min: _builtins.float,
                 num_tags: _builtins.int,
                 plain_markdown_content: _builtins.str,
                 show_hosts: _builtins.bool,
                 show_labels: _builtins.bool,
                 show_raw_values: _builtins.bool,
                 sort_values_descending: _builtins.bool,
                 sparkline_decimal_precision: _builtins.int,
                 sparkline_display_color: _builtins.str,
                 sparkline_display_font_size: _builtins.str,
                 sparkline_display_horizontal_position: _builtins.str,
                 sparkline_display_postfix: _builtins.str,
                 sparkline_display_prefix: _builtins.str,
                 sparkline_display_value_type: _builtins.str,
                 sparkline_display_vertical_position: _builtins.str,
                 sparkline_fill_color: _builtins.str,
                 sparkline_line_color: _builtins.str,
                 sparkline_size: _builtins.str,
                 sparkline_value_color_map_apply_to: _builtins.str,
                 sparkline_value_color_map_colors: Sequence[_builtins.str],
                 sparkline_value_color_map_values: Sequence[_builtins.int],
                 sparkline_value_color_map_values_v2s: Sequence[_builtins.float],
                 sparkline_value_text_map_texts: Sequence[_builtins.str],
                 sparkline_value_text_map_thresholds: Sequence[_builtins.float],
                 stack_type: _builtins.str,
                 tag_mode: _builtins.str,
                 time_based_coloring: _builtins.bool,
                 type: _builtins.str,
                 window_size: _builtins.int,
                 windowing: _builtins.str,
                 xmax: _builtins.float,
                 xmin: _builtins.float,
                 y0_scale_si_by1024: _builtins.bool,
                 y0_unit_autoscaling: _builtins.bool,
                 y1_max: _builtins.float,
                 y1_min: _builtins.float,
                 y1_scale_si_by1024: _builtins.bool,
                 y1_unit_autoscaling: _builtins.bool,
                 y1_units: _builtins.str,
                 ymax: _builtins.float,
                 ymin: _builtins.float):
        """
        :param _builtins.bool auto_column_tags: This setting is deprecated.
        :param _builtins.str column_tags: This setting is deprecated.
        :param Sequence[_builtins.str] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        :param _builtins.int expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        :param Sequence[_builtins.str] fixed_legend_display_stats: (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        :param _builtins.bool fixed_legend_enabled: (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        :param _builtins.str fixed_legend_filter_field: (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        :param _builtins.int fixed_legend_filter_limit: (Optional) Number of series to include in the fixed legend.
        :param _builtins.str fixed_legend_filter_sort: (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        :param _builtins.bool fixed_legend_hide_label: (Optional) This setting is deprecated.
        :param _builtins.str fixed_legend_position: (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        :param _builtins.bool fixed_legend_use_raw_stats: (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        :param _builtins.bool group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        :param _builtins.bool invert_dynamic_legend_hover_control: (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        :param _builtins.str line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        :param _builtins.float max: Max value of the Y-axis. Set to null or leave blank for auto.
        :param _builtins.float min: Min value of the Y-axis. Set to null or leave blank for auto.
        :param _builtins.int num_tags: For the tabular view defines how many point tags to display.
        :param _builtins.str plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param _builtins.bool show_hosts: For the tabular view, whether to display sources. Default is `true`.
        :param _builtins.bool show_labels: For the tabular view, whether to display labels. Default is `true`.
        :param _builtins.bool show_raw_values: For the tabular view, whether to display raw values. Default is `false`.
        :param _builtins.bool sort_values_descending: For the tabular view, whether to display values in descending order. Default is `false`.
        :param _builtins.int sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number.
        :param _builtins.str sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        :param _builtins.str sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent.
        :param _builtins.str sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        :param _builtins.str sparkline_display_postfix: For the single stat view, a string to append to the displayed text.
        :param _builtins.str sparkline_display_prefix: For the single stat view, a string to add before the displayed text.
        :param _builtins.str sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        :param _builtins.str sparkline_display_vertical_position: This setting is deprecated.
        :param _builtins.str sparkline_fill_color: For the single stat view, the color of the background fill. Values should be in RGBA format.
        :param _builtins.str sparkline_line_color: For the single stat view, the color of the line. Values should be in RGBA format.
        :param _builtins.str sparkline_size: For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        :param _builtins.str sparkline_value_color_map_apply_to: For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        :param Sequence[_builtins.str] sparkline_value_color_map_colors: For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        :param Sequence[_builtins.int] sparkline_value_color_map_values: This setting is deprecated.
        :param Sequence[_builtins.float] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        :param Sequence[_builtins.str] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        :param Sequence[_builtins.float] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        :param _builtins.str stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        :param _builtins.str tag_mode: For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        :param _builtins.bool time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points.
        :param _builtins.str type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are`line`, `scatterplot`, `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        :param _builtins.int window_size: Width, in minutes, of the time window to use for `last` windowing.
        :param _builtins.str windowing: For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        :param _builtins.float xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto.
        :param _builtins.float xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto.
        :param _builtins.bool y0_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        :param _builtins.bool y1_unit_autoscaling: (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        :param _builtins.str y1_units: For plots with multiple Y-axes, units for right side Y-axis.
        :param _builtins.float ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        :param _builtins.float ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        pulumi.set(__self__, "column_tags", column_tags)
        pulumi.set(__self__, "custom_tags", custom_tags)
        pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        pulumi.set(__self__, "group_by_source", group_by_source)
        pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        pulumi.set(__self__, "line_type", line_type)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "num_tags", num_tags)
        pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        pulumi.set(__self__, "show_hosts", show_hosts)
        pulumi.set(__self__, "show_labels", show_labels)
        pulumi.set(__self__, "show_raw_values", show_raw_values)
        pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        pulumi.set(__self__, "sparkline_size", sparkline_size)
        pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        pulumi.set(__self__, "stack_type", stack_type)
        pulumi.set(__self__, "tag_mode", tag_mode)
        pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "window_size", window_size)
        pulumi.set(__self__, "windowing", windowing)
        pulumi.set(__self__, "xmax", xmax)
        pulumi.set(__self__, "xmin", xmin)
        pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        pulumi.set(__self__, "y1_max", y1_max)
        pulumi.set(__self__, "y1_min", y1_min)
        pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        pulumi.set(__self__, "y1_units", y1_units)
        pulumi.set(__self__, "ymax", ymax)
        pulumi.set(__self__, "ymin", ymin)

    @_builtins.property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> _builtins.bool:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "auto_column_tags")

    @_builtins.property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> _builtins.str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "column_tags")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Sequence[_builtins.str]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode.
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> _builtins.int:
        """
        Threshold (in seconds) for time delta between consecutive points in a series above which a dotted line will replace a solid in line plots. Default is 60.
        """
        return pulumi.get(self, "expected_data_spacing")

    @_builtins.property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Sequence[_builtins.str]:
        """
        (Optional) For a chart with a fixed legend, a list of statistics to display in the legend.
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @_builtins.property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> _builtins.bool:
        """
        (Optional) Whether to enable a fixed tabular legend adjacent to the chart.
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> _builtins.str:
        """
        (Optional) Statistic to use for determining whether a series is displayed on the fixed legend. Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, and `COUNT`.
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> _builtins.int:
        """
        (Optional) Number of series to include in the fixed legend.
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @_builtins.property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> _builtins.str:
        """
        (Optional) Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options are `TOP`, and `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @_builtins.property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> _builtins.bool:
        """
        (Optional) This setting is deprecated.
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @_builtins.property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> _builtins.str:
        """
        (Optional)  Where the fixed legend should be displayed with respect to the chart. Valid options are `RIGHT`, `TOP`, `LEFT`, `BOTTOM`.
        """
        return pulumi.get(self, "fixed_legend_position")

    @_builtins.property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> _builtins.bool:
        """
        (Optional) If `true`, the legend uses non-summarized stats instead of summarized.
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @_builtins.property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> _builtins.bool:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source. If set to `false`, each source is displayed in its own row. If set to `true`, multiple metrics for the same host are displayed as different columns in the same row.
        """
        return pulumi.get(self, "group_by_source")

    @_builtins.property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> _builtins.bool:
        """
        (Optional) Whether to disable the display of the floating legend (but reenable it when the ctrl-key is pressed).
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @_builtins.property
    @pulumi.getter(name="lineType")
    def line_type(self) -> _builtins.str:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, `step-after`, `basis`, `cardinal`, and `monotone`.
        """
        return pulumi.get(self, "line_type")

    @_builtins.property
    @pulumi.getter
    def max(self) -> _builtins.float:
        """
        Max value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "max")

    @_builtins.property
    @pulumi.getter
    def min(self) -> _builtins.float:
        """
        Min value of the Y-axis. Set to null or leave blank for auto.
        """
        return pulumi.get(self, "min")

    @_builtins.property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> _builtins.int:
        """
        For the tabular view defines how many point tags to display.
        """
        return pulumi.get(self, "num_tags")

    @_builtins.property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> _builtins.str:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @_builtins.property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> _builtins.bool:
        """
        For the tabular view, whether to display sources. Default is `true`.
        """
        return pulumi.get(self, "show_hosts")

    @_builtins.property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> _builtins.bool:
        """
        For the tabular view, whether to display labels. Default is `true`.
        """
        return pulumi.get(self, "show_labels")

    @_builtins.property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> _builtins.bool:
        """
        For the tabular view, whether to display raw values. Default is `false`.
        """
        return pulumi.get(self, "show_raw_values")

    @_builtins.property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> _builtins.bool:
        """
        For the tabular view, whether to display values in descending order. Default is `false`.
        """
        return pulumi.get(self, "sort_values_descending")

    @_builtins.property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> _builtins.int:
        """
        For the single stat view, the decimal precision of the displayed number.
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> _builtins.str:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined). Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_display_color")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> _builtins.str:
        """
        For the single stat view, the font size of the displayed text, in percent.
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> _builtins.str:
        """
        For the single stat view, the horizontal position of the displayed text. Valid options are `MIDDLE`, `LEFT`, `RIGHT`.
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> _builtins.str:
        """
        For the single stat view, a string to append to the displayed text.
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> _builtins.str:
        """
        For the single stat view, a string to add before the displayed text.
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> _builtins.str:
        """
        For the single stat view, where to display the name of the query or the value of the query. Valid options are `VALUE` or `LABEL`.
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @_builtins.property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> _builtins.str:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @_builtins.property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> _builtins.str:
        """
        For the single stat view, the color of the background fill. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_fill_color")

    @_builtins.property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> _builtins.str:
        """
        For the single stat view, the color of the line. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_line_color")

    @_builtins.property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> _builtins.str:
        """
        For the single stat view, this determines whether the sparkline of the statistic is displayed in the chart. Valid options are `BACKGROUND`, `BOTTOM`, `NONE`.
        """
        return pulumi.get(self, "sparkline_size")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> _builtins.str:
        """
        For the single stat view, whether to apply dynamic color settings to the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`.
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Sequence[_builtins.str]:
        """
        For the single stat view, a list of colors that differing query values map to. Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in RGBA format.
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Sequence[_builtins.int]:
        """
        This setting is deprecated.
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @_builtins.property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Sequence[_builtins.float]:
        """
        For the single stat view, a list of boundaries for mapping different query values to colors. Must contain one element less than `sparkline_value_color_map_colors`.
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @_builtins.property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Sequence[_builtins.str]:
        """
        For the single stat view, a list of display text values that different query values map to. Must contain one more element than `sparkline_value_text_map_thresholds`.
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @_builtins.property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Sequence[_builtins.float]:
        """
        For the single stat view, a list of threshold boundaries for mapping different query values to display text. Must contain one element less than `sparkline_value_text_map_text`.
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @_builtins.property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> _builtins.str:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, and `bars`.
        """
        return pulumi.get(self, "stack_type")

    @_builtins.property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> _builtins.str:
        """
        For the tabular view, which mode to use to determine which point tags to display. Valid options are `all`, `top`, or `custom`.
        """
        return pulumi.get(self, "tag_mode")

    @_builtins.property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> _builtins.bool:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points.
        """
        return pulumi.get(self, "time_based_coloring")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to the Stacked Area plot, `table` to the Tabular View, `scatterplot-xy` to Scatter Plot, `markdown-widget` to the Markdown display, and `sparkline` to the Single Stat view. Valid options are`line`, `scatterplot`, `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`, `top-k`, `status-list`, and `histogram`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> _builtins.int:
        """
        Width, in minutes, of the time window to use for `last` windowing.
        """
        return pulumi.get(self, "window_size")

    @_builtins.property
    @pulumi.getter
    def windowing(self) -> _builtins.str:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes. Valid options are `full` or `last`.
        """
        return pulumi.get(self, "windowing")

    @_builtins.property
    @pulumi.getter
    def xmax(self) -> _builtins.float:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmax")

    @_builtins.property
    @pulumi.getter
    def xmin(self) -> _builtins.float:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto.
        """
        return pulumi.get(self, "xmin")

    @_builtins.property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> _builtins.bool:
        return pulumi.get(self, "y0_scale_si_by1024")

    @_builtins.property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> _builtins.bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @_builtins.property
    @pulumi.getter(name="y1Max")
    def y1_max(self) -> _builtins.float:
        return pulumi.get(self, "y1_max")

    @_builtins.property
    @pulumi.getter(name="y1Min")
    def y1_min(self) -> _builtins.float:
        return pulumi.get(self, "y1_min")

    @_builtins.property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> _builtins.bool:
        return pulumi.get(self, "y1_scale_si_by1024")

    @_builtins.property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> _builtins.bool:
        """
        (Optional) Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units.
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @_builtins.property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> _builtins.str:
        """
        For plots with multiple Y-axes, units for right side Y-axis.
        """
        return pulumi.get(self, "y1_units")

    @_builtins.property
    @pulumi.getter
    def ymax(self) -> _builtins.float:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymax")

    @_builtins.property
    @pulumi.getter
    def ymin(self) -> _builtins.float:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto.
        """
        return pulumi.get(self, "ymin")


@pulumi.output_type
class GetDashboardsDashboardSectionRowChartSourceResult(dict):
    def __init__(__self__, *,
                 disabled: _builtins.bool,
                 name: _builtins.str,
                 query: _builtins.str,
                 querybuilder_enabled: _builtins.bool,
                 scatter_plot_source: _builtins.str,
                 secondary_axis: _builtins.bool,
                 source_color: _builtins.str,
                 source_description: _builtins.str):
        """
        :param _builtins.bool disabled: Whether the source is disabled.
        :param _builtins.str name: The name of the parameters.
        :param _builtins.str query: Query expression to plot on the chart.
        :param _builtins.str scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param _builtins.str source_description: A description for the purpose of this source.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "querybuilder_enabled", querybuilder_enabled)
        pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        pulumi.set(__self__, "secondary_axis", secondary_axis)
        pulumi.set(__self__, "source_color", source_color)
        pulumi.set(__self__, "source_description", source_description)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> _builtins.bool:
        """
        Whether the source is disabled.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the parameters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        Query expression to plot on the chart.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="querybuilderEnabled")
    def querybuilder_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "querybuilder_enabled")

    @_builtins.property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> _builtins.str:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @_builtins.property
    @pulumi.getter(name="secondaryAxis")
    def secondary_axis(self) -> _builtins.bool:
        return pulumi.get(self, "secondary_axis")

    @_builtins.property
    @pulumi.getter(name="sourceColor")
    def source_color(self) -> _builtins.str:
        return pulumi.get(self, "source_color")

    @_builtins.property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> _builtins.str:
        """
        A description for the purpose of this source.
        """
        return pulumi.get(self, "source_description")


@pulumi.output_type
class GetDerivedMetricsDerivedMetricResult(dict):
    def __init__(__self__, *,
                 additional_information: _builtins.str,
                 create_user_id: _builtins.str,
                 created_epoch_millis: _builtins.int,
                 deleted: _builtins.bool,
                 hosts_useds: Sequence[_builtins.str],
                 id: _builtins.str,
                 in_trash: _builtins.bool,
                 include_obsolete_metrics: _builtins.bool,
                 last_error_message: _builtins.str,
                 last_failed_time: _builtins.int,
                 last_processed_millis: _builtins.int,
                 last_query_time: _builtins.int,
                 metrics_useds: Sequence[_builtins.str],
                 minutes: _builtins.int,
                 name: _builtins.str,
                 points_scanned_at_last_query: _builtins.int,
                 process_rate_minutes: _builtins.int,
                 query: _builtins.str,
                 query_failing: _builtins.bool,
                 query_qb_enabled: _builtins.bool,
                 statuses: Sequence[_builtins.str],
                 tags: Sequence[_builtins.str],
                 update_user_id: _builtins.str,
                 updated_epoch_millis: _builtins.int):
        """
        :param _builtins.str additional_information: User-supplied additional explanatory information about the derived metric.
        :param _builtins.str create_user_id: The ID of the user who created the derived metric.
        :param _builtins.int created_epoch_millis: The timestamp in epoch milliseconds indicating when the derived metric is created.
        :param _builtins.bool deleted: A Boolean flag indicating whether the derived metric is deleted or not.
        :param Sequence[_builtins.str] hosts_useds: A list of hosts used in the derived metric.
        :param _builtins.str id: The ID of the derived metric in Wavefront.
        :param _builtins.bool in_trash: A Boolean variable indicating trash status.
        :param _builtins.bool include_obsolete_metrics: A Boolean flag indicating whether to include obsolete metrics or not.
        :param _builtins.str last_error_message: Last error message occurred.
        :param _builtins.int last_failed_time: Timestamp of the last failed derived metric.
        :param _builtins.int last_processed_millis: The last processed timestamp.
        :param _builtins.int last_query_time: The timestamp indicating the last time the query was executed.
        :param Sequence[_builtins.str] metrics_useds: A list of metrics used in the derived metric.
        :param _builtins.int minutes: How frequently the query generating the derived metric is run.
        :param _builtins.str name: The name of the derived metric in Wavefront.
        :param _builtins.int points_scanned_at_last_query: The number of points scanned when the last query was executed.
        :param _builtins.int process_rate_minutes: The specified query is executed every `process_rate_minutes` minutes.
        :param _builtins.str query: A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        :param _builtins.bool query_failing: A Boolean variable indicating whether query is failing for the derived metric.
        :param _builtins.bool query_qb_enabled: A Boolean flag for enabling `query_qb`
        :param Sequence[_builtins.str] statuses: The status of the derived metric.
        :param Sequence[_builtins.str] tags: A set of tags assigned to the derived metric.
        :param _builtins.str update_user_id: The ID of the user who updated the derived metric.
        :param _builtins.int updated_epoch_millis: The timestamp in epoch milliseconds indicating when the derived metric is updated.
        """
        pulumi.set(__self__, "additional_information", additional_information)
        pulumi.set(__self__, "create_user_id", create_user_id)
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "deleted", deleted)
        pulumi.set(__self__, "hosts_useds", hosts_useds)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_trash", in_trash)
        pulumi.set(__self__, "include_obsolete_metrics", include_obsolete_metrics)
        pulumi.set(__self__, "last_error_message", last_error_message)
        pulumi.set(__self__, "last_failed_time", last_failed_time)
        pulumi.set(__self__, "last_processed_millis", last_processed_millis)
        pulumi.set(__self__, "last_query_time", last_query_time)
        pulumi.set(__self__, "metrics_useds", metrics_useds)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "points_scanned_at_last_query", points_scanned_at_last_query)
        pulumi.set(__self__, "process_rate_minutes", process_rate_minutes)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "query_failing", query_failing)
        pulumi.set(__self__, "query_qb_enabled", query_qb_enabled)
        pulumi.set(__self__, "statuses", statuses)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "update_user_id", update_user_id)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)

    @_builtins.property
    @pulumi.getter(name="additionalInformation")
    def additional_information(self) -> _builtins.str:
        """
        User-supplied additional explanatory information about the derived metric.
        """
        return pulumi.get(self, "additional_information")

    @_builtins.property
    @pulumi.getter(name="createUserId")
    def create_user_id(self) -> _builtins.str:
        """
        The ID of the user who created the derived metric.
        """
        return pulumi.get(self, "create_user_id")

    @_builtins.property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> _builtins.int:
        """
        The timestamp in epoch milliseconds indicating when the derived metric is created.
        """
        return pulumi.get(self, "created_epoch_millis")

    @_builtins.property
    @pulumi.getter
    def deleted(self) -> _builtins.bool:
        """
        A Boolean flag indicating whether the derived metric is deleted or not.
        """
        return pulumi.get(self, "deleted")

    @_builtins.property
    @pulumi.getter(name="hostsUseds")
    def hosts_useds(self) -> Sequence[_builtins.str]:
        """
        A list of hosts used in the derived metric.
        """
        return pulumi.get(self, "hosts_useds")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the derived metric in Wavefront.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inTrash")
    def in_trash(self) -> _builtins.bool:
        """
        A Boolean variable indicating trash status.
        """
        return pulumi.get(self, "in_trash")

    @_builtins.property
    @pulumi.getter(name="includeObsoleteMetrics")
    def include_obsolete_metrics(self) -> _builtins.bool:
        """
        A Boolean flag indicating whether to include obsolete metrics or not.
        """
        return pulumi.get(self, "include_obsolete_metrics")

    @_builtins.property
    @pulumi.getter(name="lastErrorMessage")
    def last_error_message(self) -> _builtins.str:
        """
        Last error message occurred.
        """
        return pulumi.get(self, "last_error_message")

    @_builtins.property
    @pulumi.getter(name="lastFailedTime")
    def last_failed_time(self) -> _builtins.int:
        """
        Timestamp of the last failed derived metric.
        """
        return pulumi.get(self, "last_failed_time")

    @_builtins.property
    @pulumi.getter(name="lastProcessedMillis")
    def last_processed_millis(self) -> _builtins.int:
        """
        The last processed timestamp.
        """
        return pulumi.get(self, "last_processed_millis")

    @_builtins.property
    @pulumi.getter(name="lastQueryTime")
    def last_query_time(self) -> _builtins.int:
        """
        The timestamp indicating the last time the query was executed.
        """
        return pulumi.get(self, "last_query_time")

    @_builtins.property
    @pulumi.getter(name="metricsUseds")
    def metrics_useds(self) -> Sequence[_builtins.str]:
        """
        A list of metrics used in the derived metric.
        """
        return pulumi.get(self, "metrics_useds")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> _builtins.int:
        """
        How frequently the query generating the derived metric is run.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the derived metric in Wavefront.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pointsScannedAtLastQuery")
    def points_scanned_at_last_query(self) -> _builtins.int:
        """
        The number of points scanned when the last query was executed.
        """
        return pulumi.get(self, "points_scanned_at_last_query")

    @_builtins.property
    @pulumi.getter(name="processRateMinutes")
    def process_rate_minutes(self) -> _builtins.int:
        """
        The specified query is executed every `process_rate_minutes` minutes.
        """
        return pulumi.get(self, "process_rate_minutes")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        """
        A Wavefront query that is evaluated at regular intervals (default is 1 minute).
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="queryFailing")
    def query_failing(self) -> _builtins.bool:
        """
        A Boolean variable indicating whether query is failing for the derived metric.
        """
        return pulumi.get(self, "query_failing")

    @_builtins.property
    @pulumi.getter(name="queryQbEnabled")
    def query_qb_enabled(self) -> _builtins.bool:
        """
        A Boolean flag for enabling `query_qb`
        """
        return pulumi.get(self, "query_qb_enabled")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Sequence[_builtins.str]:
        """
        The status of the derived metric.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A set of tags assigned to the derived metric.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updateUserId")
    def update_user_id(self) -> _builtins.str:
        """
        The ID of the user who updated the derived metric.
        """
        return pulumi.get(self, "update_user_id")

    @_builtins.property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> _builtins.int:
        """
        The timestamp in epoch milliseconds indicating when the derived metric is updated.
        """
        return pulumi.get(self, "updated_epoch_millis")


@pulumi.output_type
class GetEventsEventResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 details: _builtins.str,
                 endtime_key: _builtins.int,
                 id: _builtins.str,
                 is_ephemeral: _builtins.bool,
                 name: _builtins.str,
                 severity: _builtins.str,
                 start_time: _builtins.int,
                 tags: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Mapping[str, _builtins.str] annotations: Annotations associated with the event.
        :param _builtins.str details: The description of the event.
        :param _builtins.str id: The ID of the event in Wavefront.
        :param _builtins.bool is_ephemeral: A Boolean flag. If set to `true`, creates a point-in-time event (i.e. with no duration).
        :param _builtins.str name: The name of the event in Wavefront.
        :param _builtins.str severity: The severity category of the event.
        :param _builtins.int start_time: The start time of the event in epoch milliseconds.
        :param Sequence[_builtins.str] tags: A set of tags assigned to the event.
        :param _builtins.str type: The type of the event.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "endtime_key", endtime_key)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_ephemeral", is_ephemeral)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Annotations associated with the event.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def details(self) -> _builtins.str:
        """
        The description of the event.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter(name="endtimeKey")
    def endtime_key(self) -> _builtins.int:
        return pulumi.get(self, "endtime_key")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the event in Wavefront.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEphemeral")
    def is_ephemeral(self) -> _builtins.bool:
        """
        A Boolean flag. If set to `true`, creates a point-in-time event (i.e. with no duration).
        """
        return pulumi.get(self, "is_ephemeral")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the event in Wavefront.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        The severity category of the event.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.int:
        """
        The start time of the event in epoch milliseconds.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A set of tags assigned to the event.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the event.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetExternalLinksExternalLinkResult(dict):
    def __init__(__self__, *,
                 created_epoch_millis: _builtins.int,
                 creator_id: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 is_log_integration: _builtins.bool,
                 metric_filter_regex: _builtins.str,
                 name: _builtins.str,
                 point_tag_filter_regexes: Mapping[str, _builtins.str],
                 source_filter_regex: _builtins.str,
                 template: _builtins.str,
                 updated_epoch_millis: _builtins.int,
                 updater_id: _builtins.str):
        """
        :param _builtins.int created_epoch_millis: The timestamp in epoch milliseconds indicating when the external link is created.
        :param _builtins.str creator_id: The ID of the user who created the external link.
        :param _builtins.str description: Human-readable description of the link.
        :param _builtins.str id: The ID of the external link.
        :param _builtins.bool is_log_integration: Whether this is a "Log Integration" subType of external link.
        :param _builtins.str metric_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the metric name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param _builtins.str name: The name of the external link.
        :param Mapping[str, _builtins.str] point_tag_filter_regexes: (Optional) Controls whether a link is displayed in the context menu of a highlighted
               series. This is a map from string to regular expression. The highlighted series must contain point tags whose
               keys are present in the keys of this map and whose values match the regular expressions associated with those
               keys in order for the link to be displayed.
        :param _builtins.str source_filter_regex: Controls whether a link is displayed in the context menu of a highlighted series. If present, the source name of the highlighted series must match this regular expression in order for the link to be displayed.
        :param _builtins.str template: The mustache template for the link. The template must expand to a full URL, including scheme, origin, etc.
        :param _builtins.int updated_epoch_millis: The timestamp in epoch milliseconds indicating when the external link is updated.
        :param _builtins.str updater_id: The ID of the user who updated the external link.
        """
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_log_integration", is_log_integration)
        pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "point_tag_filter_regexes", point_tag_filter_regexes)
        pulumi.set(__self__, "source_filter_regex", source_filter_regex)
        pulumi.set(__self__, "template", template)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)
        pulumi.set(__self__, "updater_id", updater_id)

    @_builtins.property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> _builtins.int:
        """
        The timestamp in epoch milliseconds indicating when the external link is created.
        """
        return pulumi.get(self, "created_epoch_millis")

    @_builtins.property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> _builtins.str:
        """
        The ID of the user who created the external link.
        """
        return pulumi.get(self, "creator_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Human-readable description of the link.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the external link.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isLogIntegration")
    def is_log_integration(self) -> _builtins.bool:
        """
        Whether this is a "Log Integration" subType of external link.
        """
        return pulumi.get(self, "is_log_integration")

    @_builtins.property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> _builtins.str:
        """
        Controls whether a link is displayed in the context menu of a highlighted series. If present, the metric name of the highlighted series must match this regular expression in order for the link to be displayed.
        """
        return pulumi.get(self, "metric_filter_regex")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the external link.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pointTagFilterRegexes")
    def point_tag_filter_regexes(self) -> Mapping[str, _builtins.str]:
        """
        (Optional) Controls whether a link is displayed in the context menu of a highlighted
        series. This is a map from string to regular expression. The highlighted series must contain point tags whose
        keys are present in the keys of this map and whose values match the regular expressions associated with those
        keys in order for the link to be displayed.
        """
        return pulumi.get(self, "point_tag_filter_regexes")

    @_builtins.property
    @pulumi.getter(name="sourceFilterRegex")
    def source_filter_regex(self) -> _builtins.str:
        """
        Controls whether a link is displayed in the context menu of a highlighted series. If present, the source name of the highlighted series must match this regular expression in order for the link to be displayed.
        """
        return pulumi.get(self, "source_filter_regex")

    @_builtins.property
    @pulumi.getter
    def template(self) -> _builtins.str:
        """
        The mustache template for the link. The template must expand to a full URL, including scheme, origin, etc.
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> _builtins.int:
        """
        The timestamp in epoch milliseconds indicating when the external link is updated.
        """
        return pulumi.get(self, "updated_epoch_millis")

    @_builtins.property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> _builtins.str:
        """
        The ID of the user who updated the external link.
        """
        return pulumi.get(self, "updater_id")


@pulumi.output_type
class GetMaintenanceWindowAllMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 created_epoch_millis: _builtins.int,
                 creator_id: _builtins.str,
                 customer_id: _builtins.str,
                 end_time_in_seconds: _builtins.int,
                 event_name: _builtins.str,
                 host_tag_group_host_names_group_anded: _builtins.bool,
                 id: _builtins.str,
                 reason: _builtins.str,
                 relevant_customer_tags: Sequence[_builtins.str],
                 relevant_host_names: Sequence[_builtins.str],
                 relevant_host_tags: Sequence[_builtins.str],
                 relevant_host_tags_anded: _builtins.bool,
                 running_state: _builtins.str,
                 sort_attr: _builtins.int,
                 start_time_in_seconds: _builtins.int,
                 title: _builtins.str,
                 updated_epoch_millis: _builtins.int,
                 updater_id: _builtins.str):
        pulumi.set(__self__, "created_epoch_millis", created_epoch_millis)
        pulumi.set(__self__, "creator_id", creator_id)
        pulumi.set(__self__, "customer_id", customer_id)
        pulumi.set(__self__, "end_time_in_seconds", end_time_in_seconds)
        pulumi.set(__self__, "event_name", event_name)
        pulumi.set(__self__, "host_tag_group_host_names_group_anded", host_tag_group_host_names_group_anded)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "relevant_customer_tags", relevant_customer_tags)
        pulumi.set(__self__, "relevant_host_names", relevant_host_names)
        pulumi.set(__self__, "relevant_host_tags", relevant_host_tags)
        pulumi.set(__self__, "relevant_host_tags_anded", relevant_host_tags_anded)
        pulumi.set(__self__, "running_state", running_state)
        pulumi.set(__self__, "sort_attr", sort_attr)
        pulumi.set(__self__, "start_time_in_seconds", start_time_in_seconds)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "updated_epoch_millis", updated_epoch_millis)
        pulumi.set(__self__, "updater_id", updater_id)

    @_builtins.property
    @pulumi.getter(name="createdEpochMillis")
    def created_epoch_millis(self) -> _builtins.int:
        return pulumi.get(self, "created_epoch_millis")

    @_builtins.property
    @pulumi.getter(name="creatorId")
    def creator_id(self) -> _builtins.str:
        return pulumi.get(self, "creator_id")

    @_builtins.property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> _builtins.str:
        return pulumi.get(self, "customer_id")

    @_builtins.property
    @pulumi.getter(name="endTimeInSeconds")
    def end_time_in_seconds(self) -> _builtins.int:
        return pulumi.get(self, "end_time_in_seconds")

    @_builtins.property
    @pulumi.getter(name="eventName")
    def event_name(self) -> _builtins.str:
        return pulumi.get(self, "event_name")

    @_builtins.property
    @pulumi.getter(name="hostTagGroupHostNamesGroupAnded")
    def host_tag_group_host_names_group_anded(self) -> _builtins.bool:
        return pulumi.get(self, "host_tag_group_host_names_group_anded")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="relevantCustomerTags")
    def relevant_customer_tags(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "relevant_customer_tags")

    @_builtins.property
    @pulumi.getter(name="relevantHostNames")
    def relevant_host_names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "relevant_host_names")

    @_builtins.property
    @pulumi.getter(name="relevantHostTags")
    def relevant_host_tags(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "relevant_host_tags")

    @_builtins.property
    @pulumi.getter(name="relevantHostTagsAnded")
    def relevant_host_tags_anded(self) -> _builtins.bool:
        return pulumi.get(self, "relevant_host_tags_anded")

    @_builtins.property
    @pulumi.getter(name="runningState")
    def running_state(self) -> _builtins.str:
        return pulumi.get(self, "running_state")

    @_builtins.property
    @pulumi.getter(name="sortAttr")
    def sort_attr(self) -> _builtins.int:
        return pulumi.get(self, "sort_attr")

    @_builtins.property
    @pulumi.getter(name="startTimeInSeconds")
    def start_time_in_seconds(self) -> _builtins.int:
        return pulumi.get(self, "start_time_in_seconds")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter(name="updatedEpochMillis")
    def updated_epoch_millis(self) -> _builtins.int:
        return pulumi.get(self, "updated_epoch_millis")

    @_builtins.property
    @pulumi.getter(name="updaterId")
    def updater_id(self) -> _builtins.str:
        return pulumi.get(self, "updater_id")


@pulumi.output_type
class GetMetricsPolicyPolicyRuleResult(dict):
    def __init__(__self__, *,
                 access_type: _builtins.str,
                 account_ids: Sequence[_builtins.str],
                 description: _builtins.str,
                 name: _builtins.str,
                 prefixes: Sequence[_builtins.str],
                 role_ids: Sequence[_builtins.str],
                 tags: Sequence['outputs.GetMetricsPolicyPolicyRuleTagResult'],
                 tags_anded: _builtins.bool,
                 user_group_ids: Sequence[_builtins.str]):
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "account_ids", account_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "prefixes", prefixes)
        pulumi.set(__self__, "role_ids", role_ids)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "tags_anded", tags_anded)
        pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> _builtins.str:
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "account_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "role_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetMetricsPolicyPolicyRuleTagResult']:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAnded")
    def tags_anded(self) -> _builtins.bool:
        return pulumi.get(self, "tags_anded")

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "user_group_ids")


@pulumi.output_type
class GetMetricsPolicyPolicyRuleTagResult(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetRolesRoleResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 permissions: Sequence[_builtins.str]):
        """
        :param _builtins.str description: The Role's description.
        :param _builtins.str id: The Role ID.
        :param _builtins.str name: The Role Name.
        :param Sequence[_builtins.str] permissions: List of Permissions (Strings) associated with Role.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Role's description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The Role ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Role Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence[_builtins.str]:
        """
        List of Permissions (Strings) associated with Role.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GetUserGroupsUserGroupResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 roles: Sequence[_builtins.str],
                 users: Sequence[_builtins.str]):
        """
        :param _builtins.str description: The group description.
        :param _builtins.str id: The group ID.
        :param _builtins.str name: The group name.
        :param Sequence[_builtins.str] roles: List of roles associated with the group.
        :param Sequence[_builtins.str] users: List of users assigned to the group.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The group ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence[_builtins.str]:
        """
        List of roles associated with the group.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter
    def users(self) -> Sequence[_builtins.str]:
        """
        List of users assigned to the group.
        """
        return pulumi.get(self, "users")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 customer: _builtins.str,
                 email: _builtins.str,
                 last_successful_login: _builtins.int,
                 permissions: Sequence[_builtins.str],
                 user_group_ids: Sequence[_builtins.str]):
        """
        :param _builtins.str customer: The customer the user is associated with.
        :param _builtins.int last_successful_login: When the user last logged in to Wavefront.
        :param Sequence[_builtins.str] permissions: List of permissions granted to a user.
        :param Sequence[_builtins.str] user_group_ids: List of User Group Ids the user is a member of.
        """
        pulumi.set(__self__, "customer", customer)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "last_successful_login", last_successful_login)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "user_group_ids", user_group_ids)

    @_builtins.property
    @pulumi.getter
    def customer(self) -> _builtins.str:
        """
        The customer the user is associated with.
        """
        return pulumi.get(self, "customer")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="lastSuccessfulLogin")
    def last_successful_login(self) -> _builtins.int:
        """
        When the user last logged in to Wavefront.
        """
        return pulumi.get(self, "last_successful_login")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Sequence[_builtins.str]:
        """
        List of permissions granted to a user.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Sequence[_builtins.str]:
        """
        List of User Group Ids the user is a member of.
        """
        return pulumi.get(self, "user_group_ids")


