"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolResourceServer = exports.ResourceServerScope = void 0;
const core_1 = require("@aws-cdk/core");
const cognito_generated_1 = require("./cognito.generated");
/**
 * A scope for ResourceServer.
 */
class ResourceServerScope {
    /**
     *
     */
    constructor(props) {
        this.scopeName = props.scopeName;
        this.scopeDescription = props.scopeDescription;
    }
}
exports.ResourceServerScope = ResourceServerScope;
/**
 * Defines a User Pool OAuth2.0 Resource Server.
 */
class UserPoolResourceServer extends core_1.Resource {
    /**
     *
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            physicalName: props.identifier,
        });
        const resource = new cognito_generated_1.CfnUserPoolResourceServer(this, 'Resource', {
            identifier: this.physicalName,
            name: (_a = props.userPoolResourceServerName) !== null && _a !== void 0 ? _a : this.physicalName,
            scopes: props.scopes,
            userPoolId: props.userPool.userPoolId,
        });
        this.userPoolResourceServerId = resource.ref;
    }
    /**
     * Import a user pool resource client given its id.
     */
    static fromUserPoolResourceServerId(scope, id, userPoolResourceServerId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.userPoolResourceServerId = userPoolResourceServerId;
            }
        }
        return new Import(scope, id);
    }
}
exports.UserPoolResourceServer = UserPoolResourceServer;
//# sourceMappingURL=data:application/json;base64,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