# Adversarial Robustness Toolbox (ART) v1.3
<p align="center">
  <img src="docs/images/art_logo.png?raw=true" width="250" title="ART logo">
</p>
<br />

[![Build Status](https://travis-ci.org/IBM/adversarial-robustness-toolbox.svg?branch=master)](https://travis-ci.org/IBM/adversarial-robustness-toolbox)
[![Documentation Status](https://readthedocs.org/projects/adversarial-robustness-toolbox/badge/?version=latest)](http://adversarial-robustness-toolbox.readthedocs.io/en/latest/?badge=latest)
[![GitHub version](https://badge.fury.io/gh/IBM%2Fadversarial-robustness-toolbox.svg)](https://badge.fury.io/gh/IBM%2Fadversarial-robustness-toolbox)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/IBM/adversarial-robustness-toolbox.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/IBM/adversarial-robustness-toolbox/context:python)
[![Total alerts](https://img.shields.io/lgtm/alerts/g/IBM/adversarial-robustness-toolbox.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/IBM/adversarial-robustness-toolbox/alerts/)
[![codecov](https://codecov.io/gh/IBM/adversarial-robustness-toolbox/branch/master/graph/badge.svg)](https://codecov.io/gh/IBM/adversarial-robustness-toolbox)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/adversarial-robustness-toolbox)](https://pypi.org/project/adversarial-robustness-toolbox/)
[![slack-img](https://img.shields.io/badge/chat-on%20slack-yellow.svg)](https://ibm-art.slack.com/)

对抗性鲁棒性工具箱（ART）是用于机器学习安全性的Python库。 ART提供的工具使开发人员和研究人员可以针对以下方面评估，捍卫，认证和验证机器学习模型和应用程序：
逃避，中毒，提取和推断的对抗性威胁。 ART支持所有数据类型的所有流行的机器学习框架（TensorFlow，Keras，PyTorch，MXNet，scikit-learn，XGBoost，LightGBM，CatBoost，GPy等）
（图像，表格，音频，视频等）和机器学习任务（分类，对象检测，生成，认证等）。

<p align="center">
  <img src="docs/images/adversarial_threats_attacker.png?raw=true" width="400" title="ART logo">
  <img src="docs/images/adversarial_threats_art.png?raw=true" width="400" title="ART logo">
</p>
<br />

## 学到更多

| **[开始使用][get-started]**     | **[文献资料][documentation]**     | **[贡献][contributing]**           |
|-------------------------------------|-------------------------------|-----------------------------------|
| - [安装][installation]<br>- [例子](examples/README.md)<br>- [笔记本电脑](notebooks/README.md) | - [进攻][attacks]<br>- [防御][defences]<br>- [估算器][estimators]<br>- [指标][metrics]<br>- [技术文档](https://adversarial-robustness-toolbox.readthedocs.io) | - [Slack](https://ibm-art.slack.com), [邀请函](https://join.slack.com/t/ibm-art/shared_invite/enQtMzkyOTkyODE4NzM4LTA4NGQ1OTMxMzFmY2Q1MzE1NWI2MmEzN2FjNGNjOGVlODVkZDE0MjA1NTA4OGVkMjVkNmQ4MTY1NmMyOGM5YTg)<br>- [贡献](CONTRIBUTING.md)<br>- [路线图][roadmap]<br>- [引用][citing] |

[get-started]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/Get-Started
[attacks]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/ART-Attacks
[defences]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/ART-Defences
[estimators]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/ART-Estimators
[metrics]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/ART-Metrics
[contributing]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/Contributing
[documentation]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/Documentation
[installation]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/Get-Started#setup
[roadmap]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/Roadmap
[citing]: https://github.com/IBM/adversarial-robustness-toolbox/wiki/Contributing#citing-art

该图书馆正在不断发展中。 欢迎反馈，错误报告和贡献！