"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpOrigin = void 0;
const cloudfront = require("@aws-cdk/aws-cloudfront");
/**
 * (experimental) An Origin for an HTTP server or S3 bucket configured for website hosting.
 *
 * @experimental
 */
class HttpOrigin extends cloudfront.OriginBase {
    /**
     * @experimental
     */
    constructor(domainName, props = {}) {
        super(domainName, props);
        this.props = props;
        validateSecondsInRangeOrUndefined('readTimeout', 1, 60, props.readTimeout);
        validateSecondsInRangeOrUndefined('keepaliveTimeout', 1, 60, props.keepaliveTimeout);
    }
    /**
     * @experimental
     */
    renderCustomOriginConfig() {
        var _a, _b, _c;
        return {
            originProtocolPolicy: (_a = this.props.protocolPolicy) !== null && _a !== void 0 ? _a : cloudfront.OriginProtocolPolicy.HTTPS_ONLY,
            httpPort: this.props.httpPort,
            httpsPort: this.props.httpsPort,
            originReadTimeout: (_b = this.props.readTimeout) === null || _b === void 0 ? void 0 : _b.toSeconds(),
            originKeepaliveTimeout: (_c = this.props.keepaliveTimeout) === null || _c === void 0 ? void 0 : _c.toSeconds(),
        };
    }
}
exports.HttpOrigin = HttpOrigin;
/**
 * Throws an error if a duration is defined and not an integer number of seconds within a range.
 */
function validateSecondsInRangeOrUndefined(name, min, max, duration) {
    if (duration === undefined) {
        return;
    }
    const value = duration.toSeconds();
    if (!Number.isInteger(value) || value < min || value > max) {
        throw new Error(`${name}: Must be an int between ${min} and ${max} seconds (inclusive); received ${value}.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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