import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BeyondcorpAppConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of AppConnectors that are authorised to be associated with this AppConnection
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#connectors BeyondcorpAppConnection#connectors}
    */
    readonly connectors?: string[];
    /**
    * An arbitrary user-provided name for the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#display_name BeyondcorpAppConnection#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#id BeyondcorpAppConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#labels BeyondcorpAppConnection#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * ID of the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#name BeyondcorpAppConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#project BeyondcorpAppConnection#project}
    */
    readonly project?: string;
    /**
    * The region of the AppConnection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#region BeyondcorpAppConnection#region}
    */
    readonly region?: string;
    /**
    * The type of network connectivity used by the AppConnection. Refer to
  https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#type
  for a list of possible values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#type BeyondcorpAppConnection#type}
    */
    readonly type?: string;
    /**
    * application_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#application_endpoint BeyondcorpAppConnection#application_endpoint}
    */
    readonly applicationEndpoint: BeyondcorpAppConnectionApplicationEndpoint;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#gateway BeyondcorpAppConnection#gateway}
    */
    readonly gateway?: BeyondcorpAppConnectionGateway;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#timeouts BeyondcorpAppConnection#timeouts}
    */
    readonly timeouts?: BeyondcorpAppConnectionTimeouts;
}
export interface BeyondcorpAppConnectionApplicationEndpoint {
    /**
    * Hostname or IP address of the remote application endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#host BeyondcorpAppConnection#host}
    */
    readonly host: string;
    /**
    * Port of the remote application endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#port BeyondcorpAppConnection#port}
    */
    readonly port: number;
}
export declare function beyondcorpAppConnectionApplicationEndpointToTerraform(struct?: BeyondcorpAppConnectionApplicationEndpointOutputReference | BeyondcorpAppConnectionApplicationEndpoint): any;
export declare class BeyondcorpAppConnectionApplicationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BeyondcorpAppConnectionApplicationEndpoint | undefined;
    set internalValue(value: BeyondcorpAppConnectionApplicationEndpoint | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export interface BeyondcorpAppConnectionGateway {
    /**
    * AppGateway name in following format: projects/{project_id}/locations/{locationId}/appgateways/{gateway_id}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#app_gateway BeyondcorpAppConnection#app_gateway}
    */
    readonly appGateway: string;
    /**
    * The type of hosting used by the gateway. Refer to
  https://cloud.google.com/beyondcorp/docs/reference/rest/v1/projects.locations.appConnections#Type_1
  for a list of possible values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#type BeyondcorpAppConnection#type}
    */
    readonly type?: string;
}
export declare function beyondcorpAppConnectionGatewayToTerraform(struct?: BeyondcorpAppConnectionGatewayOutputReference | BeyondcorpAppConnectionGateway): any;
export declare class BeyondcorpAppConnectionGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BeyondcorpAppConnectionGateway | undefined;
    set internalValue(value: BeyondcorpAppConnectionGateway | undefined);
    private _appGateway?;
    get appGateway(): string;
    set appGateway(value: string);
    get appGatewayInput(): string | undefined;
    get ingressPort(): number;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get uri(): string;
}
export interface BeyondcorpAppConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#create BeyondcorpAppConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#delete BeyondcorpAppConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection#update BeyondcorpAppConnection#update}
    */
    readonly update?: string;
}
export declare function beyondcorpAppConnectionTimeoutsToTerraform(struct?: BeyondcorpAppConnectionTimeoutsOutputReference | BeyondcorpAppConnectionTimeouts | cdktf.IResolvable): any;
export declare class BeyondcorpAppConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BeyondcorpAppConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BeyondcorpAppConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection google_beyondcorp_app_connection}
*/
export declare class BeyondcorpAppConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_beyondcorp_app_connection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connection google_beyondcorp_app_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BeyondcorpAppConnectionConfig
    */
    constructor(scope: Construct, id: string, config: BeyondcorpAppConnectionConfig);
    private _connectors?;
    get connectors(): string[];
    set connectors(value: string[]);
    resetConnectors(): void;
    get connectorsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _applicationEndpoint;
    get applicationEndpoint(): BeyondcorpAppConnectionApplicationEndpointOutputReference;
    putApplicationEndpoint(value: BeyondcorpAppConnectionApplicationEndpoint): void;
    get applicationEndpointInput(): BeyondcorpAppConnectionApplicationEndpoint | undefined;
    private _gateway;
    get gateway(): BeyondcorpAppConnectionGatewayOutputReference;
    putGateway(value: BeyondcorpAppConnectionGateway): void;
    resetGateway(): void;
    get gatewayInput(): BeyondcorpAppConnectionGateway | undefined;
    private _timeouts;
    get timeouts(): BeyondcorpAppConnectionTimeoutsOutputReference;
    putTimeouts(value: BeyondcorpAppConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BeyondcorpAppConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
