import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BeyondcorpAppConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * An arbitrary user-provided name for the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#display_name BeyondcorpAppConnector#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#id BeyondcorpAppConnector#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#labels BeyondcorpAppConnector#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * ID of the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#name BeyondcorpAppConnector#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#project BeyondcorpAppConnector#project}
    */
    readonly project?: string;
    /**
    * The region of the AppConnector.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#region BeyondcorpAppConnector#region}
    */
    readonly region?: string;
    /**
    * principal_info block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#principal_info BeyondcorpAppConnector#principal_info}
    */
    readonly principalInfo: BeyondcorpAppConnectorPrincipalInfo;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#timeouts BeyondcorpAppConnector#timeouts}
    */
    readonly timeouts?: BeyondcorpAppConnectorTimeouts;
}
export interface BeyondcorpAppConnectorPrincipalInfoServiceAccount {
    /**
    * Email address of the service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#email BeyondcorpAppConnector#email}
    */
    readonly email: string;
}
export declare function beyondcorpAppConnectorPrincipalInfoServiceAccountToTerraform(struct?: BeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference | BeyondcorpAppConnectorPrincipalInfoServiceAccount): any;
export declare class BeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined;
    set internalValue(value: BeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
}
export interface BeyondcorpAppConnectorPrincipalInfo {
    /**
    * service_account block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#service_account BeyondcorpAppConnector#service_account}
    */
    readonly serviceAccount: BeyondcorpAppConnectorPrincipalInfoServiceAccount;
}
export declare function beyondcorpAppConnectorPrincipalInfoToTerraform(struct?: BeyondcorpAppConnectorPrincipalInfoOutputReference | BeyondcorpAppConnectorPrincipalInfo): any;
export declare class BeyondcorpAppConnectorPrincipalInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BeyondcorpAppConnectorPrincipalInfo | undefined;
    set internalValue(value: BeyondcorpAppConnectorPrincipalInfo | undefined);
    private _serviceAccount;
    get serviceAccount(): BeyondcorpAppConnectorPrincipalInfoServiceAccountOutputReference;
    putServiceAccount(value: BeyondcorpAppConnectorPrincipalInfoServiceAccount): void;
    get serviceAccountInput(): BeyondcorpAppConnectorPrincipalInfoServiceAccount | undefined;
}
export interface BeyondcorpAppConnectorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#create BeyondcorpAppConnector#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#delete BeyondcorpAppConnector#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector#update BeyondcorpAppConnector#update}
    */
    readonly update?: string;
}
export declare function beyondcorpAppConnectorTimeoutsToTerraform(struct?: BeyondcorpAppConnectorTimeoutsOutputReference | BeyondcorpAppConnectorTimeouts | cdktf.IResolvable): any;
export declare class BeyondcorpAppConnectorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BeyondcorpAppConnectorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BeyondcorpAppConnectorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector google_beyondcorp_app_connector}
*/
export declare class BeyondcorpAppConnector extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_beyondcorp_app_connector";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/beyondcorp_app_connector google_beyondcorp_app_connector} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BeyondcorpAppConnectorConfig
    */
    constructor(scope: Construct, id: string, config: BeyondcorpAppConnectorConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get state(): string;
    private _principalInfo;
    get principalInfo(): BeyondcorpAppConnectorPrincipalInfoOutputReference;
    putPrincipalInfo(value: BeyondcorpAppConnectorPrincipalInfo): void;
    get principalInfoInput(): BeyondcorpAppConnectorPrincipalInfo | undefined;
    private _timeouts;
    get timeouts(): BeyondcorpAppConnectorTimeoutsOutputReference;
    putTimeouts(value: BeyondcorpAppConnectorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BeyondcorpAppConnectorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
