import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryAnalyticsHubListingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Categories of the listing. Up to two categories are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#categories BigqueryAnalyticsHubListing#categories}
    */
    readonly categories?: string[];
    /**
    * The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#data_exchange_id BigqueryAnalyticsHubListing#data_exchange_id}
    */
    readonly dataExchangeId: string;
    /**
    * Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#description BigqueryAnalyticsHubListing#description}
    */
    readonly description?: string;
    /**
    * Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#display_name BigqueryAnalyticsHubListing#display_name}
    */
    readonly displayName: string;
    /**
    * Documentation describing the listing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#documentation BigqueryAnalyticsHubListing#documentation}
    */
    readonly documentation?: string;
    /**
    * Base64 encoded image representing the listing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#icon BigqueryAnalyticsHubListing#icon}
    */
    readonly icon?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#id BigqueryAnalyticsHubListing#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#listing_id BigqueryAnalyticsHubListing#listing_id}
    */
    readonly listingId: string;
    /**
    * The name of the location this data exchange listing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#location BigqueryAnalyticsHubListing#location}
    */
    readonly location: string;
    /**
    * Email or URL of the primary point of contact of the listing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#primary_contact BigqueryAnalyticsHubListing#primary_contact}
    */
    readonly primaryContact?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#project BigqueryAnalyticsHubListing#project}
    */
    readonly project?: string;
    /**
    * Email or URL of the request access of the listing. Subscribers can use this reference to request access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#request_access BigqueryAnalyticsHubListing#request_access}
    */
    readonly requestAccess?: string;
    /**
    * bigquery_dataset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#bigquery_dataset BigqueryAnalyticsHubListing#bigquery_dataset}
    */
    readonly bigqueryDataset: BigqueryAnalyticsHubListingBigqueryDataset;
    /**
    * data_provider block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#data_provider BigqueryAnalyticsHubListing#data_provider}
    */
    readonly dataProvider?: BigqueryAnalyticsHubListingDataProvider;
    /**
    * publisher block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#publisher BigqueryAnalyticsHubListing#publisher}
    */
    readonly publisher?: BigqueryAnalyticsHubListingPublisher;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#timeouts BigqueryAnalyticsHubListing#timeouts}
    */
    readonly timeouts?: BigqueryAnalyticsHubListingTimeouts;
}
export interface BigqueryAnalyticsHubListingBigqueryDataset {
    /**
    * Resource name of the dataset source for this listing. e.g. projects/myproject/datasets/123
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#dataset BigqueryAnalyticsHubListing#dataset}
    */
    readonly dataset: string;
}
export declare function bigqueryAnalyticsHubListingBigqueryDatasetToTerraform(struct?: BigqueryAnalyticsHubListingBigqueryDatasetOutputReference | BigqueryAnalyticsHubListingBigqueryDataset): any;
export declare class BigqueryAnalyticsHubListingBigqueryDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryAnalyticsHubListingBigqueryDataset | undefined;
    set internalValue(value: BigqueryAnalyticsHubListingBigqueryDataset | undefined);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
}
export interface BigqueryAnalyticsHubListingDataProvider {
    /**
    * Name of the data provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#name BigqueryAnalyticsHubListing#name}
    */
    readonly name: string;
    /**
    * Email or URL of the data provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#primary_contact BigqueryAnalyticsHubListing#primary_contact}
    */
    readonly primaryContact?: string;
}
export declare function bigqueryAnalyticsHubListingDataProviderToTerraform(struct?: BigqueryAnalyticsHubListingDataProviderOutputReference | BigqueryAnalyticsHubListingDataProvider): any;
export declare class BigqueryAnalyticsHubListingDataProviderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryAnalyticsHubListingDataProvider | undefined;
    set internalValue(value: BigqueryAnalyticsHubListingDataProvider | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryContact?;
    get primaryContact(): string;
    set primaryContact(value: string);
    resetPrimaryContact(): void;
    get primaryContactInput(): string | undefined;
}
export interface BigqueryAnalyticsHubListingPublisher {
    /**
    * Name of the listing publisher.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#name BigqueryAnalyticsHubListing#name}
    */
    readonly name: string;
    /**
    * Email or URL of the listing publisher.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#primary_contact BigqueryAnalyticsHubListing#primary_contact}
    */
    readonly primaryContact?: string;
}
export declare function bigqueryAnalyticsHubListingPublisherToTerraform(struct?: BigqueryAnalyticsHubListingPublisherOutputReference | BigqueryAnalyticsHubListingPublisher): any;
export declare class BigqueryAnalyticsHubListingPublisherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryAnalyticsHubListingPublisher | undefined;
    set internalValue(value: BigqueryAnalyticsHubListingPublisher | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryContact?;
    get primaryContact(): string;
    set primaryContact(value: string);
    resetPrimaryContact(): void;
    get primaryContactInput(): string | undefined;
}
export interface BigqueryAnalyticsHubListingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#create BigqueryAnalyticsHubListing#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#delete BigqueryAnalyticsHubListing#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing#update BigqueryAnalyticsHubListing#update}
    */
    readonly update?: string;
}
export declare function bigqueryAnalyticsHubListingTimeoutsToTerraform(struct?: BigqueryAnalyticsHubListingTimeoutsOutputReference | BigqueryAnalyticsHubListingTimeouts | cdktf.IResolvable): any;
export declare class BigqueryAnalyticsHubListingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryAnalyticsHubListingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BigqueryAnalyticsHubListingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing google_bigquery_analytics_hub_listing}
*/
export declare class BigqueryAnalyticsHubListing extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_analytics_hub_listing";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_analytics_hub_listing google_bigquery_analytics_hub_listing} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryAnalyticsHubListingConfig
    */
    constructor(scope: Construct, id: string, config: BigqueryAnalyticsHubListingConfig);
    private _categories?;
    get categories(): string[];
    set categories(value: string[]);
    resetCategories(): void;
    get categoriesInput(): string[] | undefined;
    private _dataExchangeId?;
    get dataExchangeId(): string;
    set dataExchangeId(value: string);
    get dataExchangeIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _documentation?;
    get documentation(): string;
    set documentation(value: string);
    resetDocumentation(): void;
    get documentationInput(): string | undefined;
    private _icon?;
    get icon(): string;
    set icon(value: string);
    resetIcon(): void;
    get iconInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listingId?;
    get listingId(): string;
    set listingId(value: string);
    get listingIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _primaryContact?;
    get primaryContact(): string;
    set primaryContact(value: string);
    resetPrimaryContact(): void;
    get primaryContactInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requestAccess?;
    get requestAccess(): string;
    set requestAccess(value: string);
    resetRequestAccess(): void;
    get requestAccessInput(): string | undefined;
    private _bigqueryDataset;
    get bigqueryDataset(): BigqueryAnalyticsHubListingBigqueryDatasetOutputReference;
    putBigqueryDataset(value: BigqueryAnalyticsHubListingBigqueryDataset): void;
    get bigqueryDatasetInput(): BigqueryAnalyticsHubListingBigqueryDataset | undefined;
    private _dataProvider;
    get dataProvider(): BigqueryAnalyticsHubListingDataProviderOutputReference;
    putDataProvider(value: BigqueryAnalyticsHubListingDataProvider): void;
    resetDataProvider(): void;
    get dataProviderInput(): BigqueryAnalyticsHubListingDataProvider | undefined;
    private _publisher;
    get publisher(): BigqueryAnalyticsHubListingPublisherOutputReference;
    putPublisher(value: BigqueryAnalyticsHubListingPublisher): void;
    resetPublisher(): void;
    get publisherInput(): BigqueryAnalyticsHubListingPublisher | undefined;
    private _timeouts;
    get timeouts(): BigqueryAnalyticsHubListingTimeoutsOutputReference;
    putTimeouts(value: BigqueryAnalyticsHubListingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BigqueryAnalyticsHubListingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
