import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryDatasetAccessAConfig extends cdktf.TerraformMetaArguments {
    /**
    * A unique ID for this dataset, without the project name. The ID
  must contain only letters (a-z, A-Z), numbers (0-9), or
  underscores (_). The maximum length is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#dataset_id BigqueryDatasetAccessA#dataset_id}
    */
    readonly datasetId: string;
    /**
    * A domain to grant access to. Any users signed in with the
  domain specified will be granted the specified access
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#domain BigqueryDatasetAccessA#domain}
    */
    readonly domain?: string;
    /**
    * An email address of a Google Group to grant access to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#group_by_email BigqueryDatasetAccessA#group_by_email}
    */
    readonly groupByEmail?: string;
    /**
    * Some other type of member that appears in the IAM Policy but isn't a user,
  group, domain, or special group. For example: 'allUsers'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#iam_member BigqueryDatasetAccessA#iam_member}
    */
    readonly iamMember?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#id BigqueryDatasetAccessA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#project BigqueryDatasetAccessA#project}
    */
    readonly project?: string;
    /**
    * Describes the rights granted to the user specified by the other
  member of the access object. Basic, predefined, and custom roles are
  supported. Predefined roles that have equivalent basic roles are
  swapped by the API to their basic counterparts, and will show a diff
  post-create. See
  [official docs](https://cloud.google.com/bigquery/docs/access-control).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#role BigqueryDatasetAccessA#role}
    */
    readonly role?: string;
    /**
    * A special group to grant access to. Possible values include:
  
  
  * 'projectOwners': Owners of the enclosing project.
  
  
  * 'projectReaders': Readers of the enclosing project.
  
  
  * 'projectWriters': Writers of the enclosing project.
  
  
  * 'allAuthenticatedUsers': All authenticated BigQuery users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#special_group BigqueryDatasetAccessA#special_group}
    */
    readonly specialGroup?: string;
    /**
    * An email address of a user to grant access to. For example:
  fred@example.com
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#user_by_email BigqueryDatasetAccessA#user_by_email}
    */
    readonly userByEmail?: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#dataset BigqueryDatasetAccessA#dataset}
    */
    readonly dataset?: BigqueryDatasetAccessDatasetA;
    /**
    * routine block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#routine BigqueryDatasetAccessA#routine}
    */
    readonly routine?: BigqueryDatasetAccessRoutineA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#timeouts BigqueryDatasetAccessA#timeouts}
    */
    readonly timeouts?: BigqueryDatasetAccessTimeouts;
    /**
    * view block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#view BigqueryDatasetAccessA#view}
    */
    readonly view?: BigqueryDatasetAccessViewA;
}
export interface BigqueryDatasetAccessDatasetDatasetA {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#dataset_id BigqueryDatasetAccessA#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#project_id BigqueryDatasetAccessA#project_id}
    */
    readonly projectId: string;
}
export declare function bigqueryDatasetAccessDatasetDatasetAToTerraform(struct?: BigqueryDatasetAccessDatasetDatasetAOutputReference | BigqueryDatasetAccessDatasetDatasetA): any;
export declare class BigqueryDatasetAccessDatasetDatasetAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryDatasetAccessDatasetDatasetA | undefined;
    set internalValue(value: BigqueryDatasetAccessDatasetDatasetA | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface BigqueryDatasetAccessDatasetA {
    /**
    * Which resources in the dataset this entry applies to. Currently, only views are supported,
  but additional target types may be added in the future. Possible values: VIEWS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#target_types BigqueryDatasetAccessA#target_types}
    */
    readonly targetTypes: string[];
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#dataset BigqueryDatasetAccessA#dataset}
    */
    readonly dataset: BigqueryDatasetAccessDatasetDatasetA;
}
export declare function bigqueryDatasetAccessDatasetAToTerraform(struct?: BigqueryDatasetAccessDatasetAOutputReference | BigqueryDatasetAccessDatasetA): any;
export declare class BigqueryDatasetAccessDatasetAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryDatasetAccessDatasetA | undefined;
    set internalValue(value: BigqueryDatasetAccessDatasetA | undefined);
    private _targetTypes?;
    get targetTypes(): string[];
    set targetTypes(value: string[]);
    get targetTypesInput(): string[] | undefined;
    private _dataset;
    get dataset(): BigqueryDatasetAccessDatasetDatasetAOutputReference;
    putDataset(value: BigqueryDatasetAccessDatasetDatasetA): void;
    get datasetInput(): BigqueryDatasetAccessDatasetDatasetA | undefined;
}
export interface BigqueryDatasetAccessRoutineA {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#dataset_id BigqueryDatasetAccessA#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#project_id BigqueryDatasetAccessA#project_id}
    */
    readonly projectId: string;
    /**
    * The ID of the routine. The ID must contain only letters (a-z,
  A-Z), numbers (0-9), or underscores (_). The maximum length
  is 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#routine_id BigqueryDatasetAccessA#routine_id}
    */
    readonly routineId: string;
}
export declare function bigqueryDatasetAccessRoutineAToTerraform(struct?: BigqueryDatasetAccessRoutineAOutputReference | BigqueryDatasetAccessRoutineA): any;
export declare class BigqueryDatasetAccessRoutineAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryDatasetAccessRoutineA | undefined;
    set internalValue(value: BigqueryDatasetAccessRoutineA | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _routineId?;
    get routineId(): string;
    set routineId(value: string);
    get routineIdInput(): string | undefined;
}
export interface BigqueryDatasetAccessTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#create BigqueryDatasetAccessA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#delete BigqueryDatasetAccessA#delete}
    */
    readonly delete?: string;
}
export declare function bigqueryDatasetAccessTimeoutsToTerraform(struct?: BigqueryDatasetAccessTimeoutsOutputReference | BigqueryDatasetAccessTimeouts | cdktf.IResolvable): any;
export declare class BigqueryDatasetAccessTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryDatasetAccessTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BigqueryDatasetAccessTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface BigqueryDatasetAccessViewA {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#dataset_id BigqueryDatasetAccessA#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#project_id BigqueryDatasetAccessA#project_id}
    */
    readonly projectId: string;
    /**
    * The ID of the table. The ID must contain only letters (a-z,
  A-Z), numbers (0-9), or underscores (_). The maximum length
  is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access#table_id BigqueryDatasetAccessA#table_id}
    */
    readonly tableId: string;
}
export declare function bigqueryDatasetAccessViewAToTerraform(struct?: BigqueryDatasetAccessViewAOutputReference | BigqueryDatasetAccessViewA): any;
export declare class BigqueryDatasetAccessViewAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryDatasetAccessViewA | undefined;
    set internalValue(value: BigqueryDatasetAccessViewA | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access google_bigquery_dataset_access}
*/
export declare class BigqueryDatasetAccessA extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_dataset_access";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_dataset_access google_bigquery_dataset_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryDatasetAccessAConfig
    */
    constructor(scope: Construct, id: string, config: BigqueryDatasetAccessAConfig);
    get apiUpdatedMember(): cdktf.IResolvable;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _groupByEmail?;
    get groupByEmail(): string;
    set groupByEmail(value: string);
    resetGroupByEmail(): void;
    get groupByEmailInput(): string | undefined;
    private _iamMember?;
    get iamMember(): string;
    set iamMember(value: string);
    resetIamMember(): void;
    get iamMemberInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _specialGroup?;
    get specialGroup(): string;
    set specialGroup(value: string);
    resetSpecialGroup(): void;
    get specialGroupInput(): string | undefined;
    private _userByEmail?;
    get userByEmail(): string;
    set userByEmail(value: string);
    resetUserByEmail(): void;
    get userByEmailInput(): string | undefined;
    private _dataset;
    get dataset(): BigqueryDatasetAccessDatasetAOutputReference;
    putDataset(value: BigqueryDatasetAccessDatasetA): void;
    resetDataset(): void;
    get datasetInput(): BigqueryDatasetAccessDatasetA | undefined;
    private _routine;
    get routine(): BigqueryDatasetAccessRoutineAOutputReference;
    putRoutine(value: BigqueryDatasetAccessRoutineA): void;
    resetRoutine(): void;
    get routineInput(): BigqueryDatasetAccessRoutineA | undefined;
    private _timeouts;
    get timeouts(): BigqueryDatasetAccessTimeoutsOutputReference;
    putTimeouts(value: BigqueryDatasetAccessTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BigqueryDatasetAccessTimeouts | undefined;
    private _view;
    get view(): BigqueryDatasetAccessViewAOutputReference;
    putView(value: BigqueryDatasetAccessViewA): void;
    resetView(): void;
    get viewInput(): BigqueryDatasetAccessViewA | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
