import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Maximum number of queries that are allowed to run concurrently in this reservation. This is a soft limit due to asynchronous nature of the system and various optimizations for small queries. Default value is 0 which means that concurrency will be automatically set based on the reservation size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#concurrency BigqueryReservation#concurrency}
    */
    readonly concurrency?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#id BigqueryReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If false, any query using this reservation will use idle slots from other reservations within
  the same admin project. If true, a query using this reservation will execute with the slot
  capacity specified above at most.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#ignore_idle_slots BigqueryReservation#ignore_idle_slots}
    */
    readonly ignoreIdleSlots?: boolean | cdktf.IResolvable;
    /**
    * The geographic location where the transfer config should reside.
  Examples: US, EU, asia-northeast1. The default value is US.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#location BigqueryReservation#location}
    */
    readonly location?: string;
    /**
    * Applicable only for reservations located within one of the BigQuery multi-regions (US or EU).
  If set to true, this reservation is placed in the organization's secondary region which is designated for disaster recovery purposes. If false, this reservation is placed in the organization's default region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#multi_region_auxiliary BigqueryReservation#multi_region_auxiliary}
    */
    readonly multiRegionAuxiliary?: boolean | cdktf.IResolvable;
    /**
    * The name of the reservation. This field must only contain alphanumeric characters or dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#name BigqueryReservation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#project BigqueryReservation#project}
    */
    readonly project?: string;
    /**
    * Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
  unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#slot_capacity BigqueryReservation#slot_capacity}
    */
    readonly slotCapacity: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#timeouts BigqueryReservation#timeouts}
    */
    readonly timeouts?: BigqueryReservationTimeouts;
}
export interface BigqueryReservationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#create BigqueryReservation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#delete BigqueryReservation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation#update BigqueryReservation#update}
    */
    readonly update?: string;
}
export declare function bigqueryReservationTimeoutsToTerraform(struct?: BigqueryReservationTimeoutsOutputReference | BigqueryReservationTimeouts | cdktf.IResolvable): any;
export declare class BigqueryReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryReservationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BigqueryReservationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation google_bigquery_reservation}
*/
export declare class BigqueryReservation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_reservation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_reservation google_bigquery_reservation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryReservationConfig
    */
    constructor(scope: Construct, id: string, config: BigqueryReservationConfig);
    private _concurrency?;
    get concurrency(): number;
    set concurrency(value: number);
    resetConcurrency(): void;
    get concurrencyInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreIdleSlots?;
    get ignoreIdleSlots(): boolean | cdktf.IResolvable;
    set ignoreIdleSlots(value: boolean | cdktf.IResolvable);
    resetIgnoreIdleSlots(): void;
    get ignoreIdleSlotsInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _multiRegionAuxiliary?;
    get multiRegionAuxiliary(): boolean | cdktf.IResolvable;
    set multiRegionAuxiliary(value: boolean | cdktf.IResolvable);
    resetMultiRegionAuxiliary(): void;
    get multiRegionAuxiliaryInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _slotCapacity?;
    get slotCapacity(): number;
    set slotCapacity(value: number);
    get slotCapacityInput(): number | undefined;
    private _timeouts;
    get timeouts(): BigqueryReservationTimeoutsOutputReference;
    putTimeouts(value: BigqueryReservationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BigqueryReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
