import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to 'true', the revision name (template.metadata.name) will be omitted and
  autogenerated by Cloud Run. This cannot be set to 'true' while 'template.metadata.name'
  is also set.
  (For legacy support, if 'template.metadata.name' is unset in state while
  this field is set to false, the revision name will still autogenerate.)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#autogenerate_revision_name CloudRunService#autogenerate_revision_name}
    */
    readonly autogenerateRevisionName?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#id CloudRunService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the cloud run instance. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#location CloudRunService#location}
    */
    readonly location: string;
    /**
    * Name must be unique within a namespace, within a Cloud Run region.
  Is required when creating resources. Name is primarily intended
  for creation idempotence and configuration definition. Cannot be updated.
  More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#project CloudRunService#project}
    */
    readonly project?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#metadata CloudRunService#metadata}
    */
    readonly metadata?: CloudRunServiceMetadata;
    /**
    * template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#template CloudRunService#template}
    */
    readonly template?: CloudRunServiceTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#timeouts CloudRunService#timeouts}
    */
    readonly timeouts?: CloudRunServiceTimeouts;
    /**
    * traffic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#traffic CloudRunService#traffic}
    */
    readonly traffic?: CloudRunServiceTraffic[] | cdktf.IResolvable;
}
export interface CloudRunServiceStatusConditions {
}
export declare function cloudRunServiceStatusConditionsToTerraform(struct?: CloudRunServiceStatusConditions): any;
export declare class CloudRunServiceStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceStatusConditions | undefined;
    set internalValue(value: CloudRunServiceStatusConditions | undefined);
    get message(): string;
    get reason(): string;
    get status(): string;
    get type(): string;
}
export declare class CloudRunServiceStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceStatusConditionsOutputReference;
}
export interface CloudRunServiceStatus {
}
export declare function cloudRunServiceStatusToTerraform(struct?: CloudRunServiceStatus): any;
export declare class CloudRunServiceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceStatus | undefined;
    set internalValue(value: CloudRunServiceStatus | undefined);
    private _conditions;
    get conditions(): CloudRunServiceStatusConditionsList;
    get latestCreatedRevisionName(): string;
    get latestReadyRevisionName(): string;
    get observedGeneration(): number;
    get url(): string;
}
export declare class CloudRunServiceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceStatusOutputReference;
}
export interface CloudRunServiceMetadata {
    /**
    * Annotations is a key value map stored with a resource that
  may be set by external tools to store and retrieve arbitrary metadata. More
  info: http://kubernetes.io/docs/user-guide/annotations
  
  **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
  If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
  or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
  
  Cloud Run (fully managed) uses the following annotation keys to configure features on a Service:
  
  - 'run.googleapis.com/ingress' sets the [ingress settings](https://cloud.google.com/sdk/gcloud/reference/run/deploy#--ingress)
    for the Service. For example, '"run.googleapis.com/ingress" = "all"'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#annotations CloudRunService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
  (scope and select) objects. May match selectors of replication controllers
  and routes.
  More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#labels CloudRunService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * In Cloud Run the namespace must be equal to either the
  project ID or project number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#namespace CloudRunService#namespace}
    */
    readonly namespace?: string;
}
export declare function cloudRunServiceMetadataToTerraform(struct?: CloudRunServiceMetadataOutputReference | CloudRunServiceMetadata): any;
export declare class CloudRunServiceMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceMetadata | undefined;
    set internalValue(value: CloudRunServiceMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export interface CloudRunServiceTemplateMetadata {
    /**
    * Annotations is a key value map stored with a resource that
  may be set by external tools to store and retrieve arbitrary metadata. More
  info: http://kubernetes.io/docs/user-guide/annotations
  
  **Note**: The Cloud Run API may add additional annotations that were not provided in your config.
  If terraform plan shows a diff where a server-side annotation is added, you can add it to your config
  or apply the lifecycle.ignore_changes rule to the metadata.0.annotations field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#annotations CloudRunService#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Map of string keys and values that can be used to organize and categorize
  (scope and select) objects. May match selectors of replication controllers
  and routes.
  More info: http://kubernetes.io/docs/user-guide/labels
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#labels CloudRunService#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name must be unique within a namespace, within a Cloud Run region.
  Is required when creating resources. Name is primarily intended
  for creation idempotence and configuration definition. Cannot be updated.
  More info: http://kubernetes.io/docs/user-guide/identifiers#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name?: string;
    /**
    * In Cloud Run the namespace must be equal to either the
  project ID or project number. It will default to the resource's project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#namespace CloudRunService#namespace}
    */
    readonly namespace?: string;
}
export declare function cloudRunServiceTemplateMetadataToTerraform(struct?: CloudRunServiceTemplateMetadataOutputReference | CloudRunServiceTemplateMetadata): any;
export declare class CloudRunServiceTemplateMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateMetadata | undefined;
    set internalValue(value: CloudRunServiceTemplateMetadata | undefined);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get generation(): number;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    get resourceVersion(): string;
    get selfLink(): string;
    get uid(): string;
}
export interface CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef {
    /**
    * A Cloud Secret Manager secret version. Must be 'latest' for the latest
  version or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#key CloudRunService#key}
    */
    readonly key: string;
    /**
    * The name of the secret in Cloud Secret Manager. By default, the secret is assumed to be in the same project.
  If the secret is in another project, you must define an alias.
  An alias definition has the form: :projects/{project-id|project-number}/secrets/.
  If multiple alias definitions are needed, they must be separated by commas.
  The alias definitions must be set on the run.googleapis.com/secrets annotation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
}
export declare function cloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference | CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): any;
export declare class CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvValueFrom {
    /**
    * secret_key_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#secret_key_ref CloudRunService#secret_key_ref}
    */
    readonly secretKeyRef: CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef;
}
export declare function cloudRunServiceTemplateSpecContainersEnvValueFromToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvValueFromOutputReference | CloudRunServiceTemplateSpecContainersEnvValueFrom): any;
export declare class CloudRunServiceTemplateSpecContainersEnvValueFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvValueFrom | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvValueFrom | undefined);
    private _secretKeyRef;
    get secretKeyRef(): CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRefOutputReference;
    putSecretKeyRef(value: CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef): void;
    get secretKeyRefInput(): CloudRunServiceTemplateSpecContainersEnvValueFromSecretKeyRef | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnv {
    /**
    * Name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name?: string;
    /**
    * Variable references $(VAR_NAME) are expanded
  using the previous defined environment variables in the container and
  any route environment variables. If a variable cannot be resolved,
  the reference in the input string will be unchanged. The $(VAR_NAME)
  syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped
  references will never be expanded, regardless of whether the variable
  exists or not.
  Defaults to "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#value CloudRunService#value}
    */
    readonly value?: string;
    /**
    * value_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#value_from CloudRunService#value_from}
    */
    readonly valueFrom?: CloudRunServiceTemplateSpecContainersEnvValueFrom;
}
export declare function cloudRunServiceTemplateSpecContainersEnvToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable): any;
export declare class CloudRunServiceTemplateSpecContainersEnvOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnv | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _valueFrom;
    get valueFrom(): CloudRunServiceTemplateSpecContainersEnvValueFromOutputReference;
    putValueFrom(value: CloudRunServiceTemplateSpecContainersEnvValueFrom): void;
    resetValueFrom(): void;
    get valueFromInput(): CloudRunServiceTemplateSpecContainersEnvValueFrom | undefined;
}
export declare class CloudRunServiceTemplateSpecContainersEnvList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTemplateSpecContainersEnv[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTemplateSpecContainersEnvOutputReference;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference {
    /**
    * Name of the referent.
  More info:
  https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference | CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef {
    /**
    * Specify whether the ConfigMap must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#optional CloudRunService#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * local_object_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#local_object_reference CloudRunService#local_object_reference}
    */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromConfigMapRefToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference | CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference;
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefLocalObjectReference | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference {
    /**
    * Name of the referent.
  More info:
  https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference | CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFromSecretRef {
    /**
    * Specify whether the Secret must be defined
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#optional CloudRunService#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
    /**
    * local_object_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#local_object_reference CloudRunService#local_object_reference}
    */
    readonly localObjectReference?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromSecretRefToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference | CloudRunServiceTemplateSpecContainersEnvFromSecretRef): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined);
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
    private _localObjectReference;
    get localObjectReference(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReferenceOutputReference;
    putLocalObjectReference(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference): void;
    resetLocalObjectReference(): void;
    get localObjectReferenceInput(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefLocalObjectReference | undefined;
}
export interface CloudRunServiceTemplateSpecContainersEnvFrom {
    /**
    * An optional identifier to prepend to each key in the ConfigMap.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#prefix CloudRunService#prefix}
    */
    readonly prefix?: string;
    /**
    * config_map_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#config_map_ref CloudRunService#config_map_ref}
    */
    readonly configMapRef?: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef;
    /**
    * secret_ref block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#secret_ref CloudRunService#secret_ref}
    */
    readonly secretRef?: CloudRunServiceTemplateSpecContainersEnvFromSecretRef;
}
export declare function cloudRunServiceTemplateSpecContainersEnvFromToTerraform(struct?: CloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable): any;
export declare class CloudRunServiceTemplateSpecContainersEnvFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersEnvFrom | cdktf.IResolvable | undefined);
    private _prefix?;
    get prefix(): string;
    set prefix(value: string);
    resetPrefix(): void;
    get prefixInput(): string | undefined;
    private _configMapRef;
    get configMapRef(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRefOutputReference;
    putConfigMapRef(value: CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef): void;
    resetConfigMapRef(): void;
    get configMapRefInput(): CloudRunServiceTemplateSpecContainersEnvFromConfigMapRef | undefined;
    private _secretRef;
    get secretRef(): CloudRunServiceTemplateSpecContainersEnvFromSecretRefOutputReference;
    putSecretRef(value: CloudRunServiceTemplateSpecContainersEnvFromSecretRef): void;
    resetSecretRef(): void;
    get secretRefInput(): CloudRunServiceTemplateSpecContainersEnvFromSecretRef | undefined;
}
export declare class CloudRunServiceTemplateSpecContainersEnvFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTemplateSpecContainersEnvFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTemplateSpecContainersEnvFromOutputReference;
}
export interface CloudRunServiceTemplateSpecContainersPorts {
    /**
    * Port number the container listens on. This must be a valid port number (between 1 and 65535). Defaults to "8080".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#container_port CloudRunService#container_port}
    */
    readonly containerPort?: number;
    /**
    * If specified, used to specify which protocol to use. Allowed values are "http1" (HTTP/1) and "h2c" (HTTP/2 end-to-end). Defaults to "http1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name?: string;
    /**
    * Protocol for port. Must be "TCP". Defaults to "TCP".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#protocol CloudRunService#protocol}
    */
    readonly protocol?: string;
}
export declare function cloudRunServiceTemplateSpecContainersPortsToTerraform(struct?: CloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable): any;
export declare class CloudRunServiceTemplateSpecContainersPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersPorts | cdktf.IResolvable | undefined);
    private _containerPort?;
    get containerPort(): number;
    set containerPort(value: number);
    resetContainerPort(): void;
    get containerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class CloudRunServiceTemplateSpecContainersPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTemplateSpecContainersPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTemplateSpecContainersPortsOutputReference;
}
export interface CloudRunServiceTemplateSpecContainersResources {
    /**
    * Limits describes the maximum amount of compute resources allowed.
  The values of the map is string form of the 'quantity' k8s type:
  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#limits CloudRunService#limits}
    */
    readonly limits?: {
        [key: string]: string;
    };
    /**
    * Requests describes the minimum amount of compute resources required.
  If Requests is omitted for a container, it defaults to Limits if that is
  explicitly specified, otherwise to an implementation-defined value.
  The values of the map is string form of the 'quantity' k8s type:
  https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#requests CloudRunService#requests}
    */
    readonly requests?: {
        [key: string]: string;
    };
}
export declare function cloudRunServiceTemplateSpecContainersResourcesToTerraform(struct?: CloudRunServiceTemplateSpecContainersResourcesOutputReference | CloudRunServiceTemplateSpecContainersResources): any;
export declare class CloudRunServiceTemplateSpecContainersResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecContainersResources | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersResources | undefined);
    private _limits?;
    get limits(): {
        [key: string]: string;
    };
    set limits(value: {
        [key: string]: string;
    });
    resetLimits(): void;
    get limitsInput(): {
        [key: string]: string;
    } | undefined;
    private _requests?;
    get requests(): {
        [key: string]: string;
    };
    set requests(value: {
        [key: string]: string;
    });
    resetRequests(): void;
    get requestsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface CloudRunServiceTemplateSpecContainersVolumeMounts {
    /**
    * Path within the container at which the volume should be mounted.  Must
  not contain ':'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#mount_path CloudRunService#mount_path}
    */
    readonly mountPath: string;
    /**
    * This must match the Name of a Volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
}
export declare function cloudRunServiceTemplateSpecContainersVolumeMountsToTerraform(struct?: CloudRunServiceTemplateSpecContainersVolumeMounts | cdktf.IResolvable): any;
export declare class CloudRunServiceTemplateSpecContainersVolumeMountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainersVolumeMounts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainersVolumeMounts | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class CloudRunServiceTemplateSpecContainersVolumeMountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTemplateSpecContainersVolumeMounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTemplateSpecContainersVolumeMountsOutputReference;
}
export interface CloudRunServiceTemplateSpecContainers {
    /**
    * Arguments to the entrypoint.
  The docker image's CMD is used if this is not provided.
  Variable references $(VAR_NAME) are expanded using the container's
  environment. If a variable cannot be resolved, the reference in the input
  string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
  double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
  regardless of whether the variable exists or not.
  More info:
  https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#args CloudRunService#args}
    */
    readonly args?: string[];
    /**
    * Entrypoint array. Not executed within a shell.
  The docker image's ENTRYPOINT is used if this is not provided.
  Variable references $(VAR_NAME) are expanded using the container's
  environment. If a variable cannot be resolved, the reference in the input
  string will be unchanged. The $(VAR_NAME) syntax can be escaped with a
  double $$, ie: $$(VAR_NAME). Escaped references will never be expanded,
  regardless of whether the variable exists or not.
  More info:
  https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#command CloudRunService#command}
    */
    readonly command?: string[];
    /**
    * Docker image name. This is most often a reference to a container located
  in the container registry, such as gcr.io/cloudrun/hello
  More info: https://kubernetes.io/docs/concepts/containers/images
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#image CloudRunService#image}
    */
    readonly image: string;
    /**
    * Container's working directory.
  If not specified, the container runtime's default will be used, which
  might be configured in the container image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#working_dir CloudRunService#working_dir}
    */
    readonly workingDir?: string;
    /**
    * env block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#env CloudRunService#env}
    */
    readonly env?: CloudRunServiceTemplateSpecContainersEnv[] | cdktf.IResolvable;
    /**
    * env_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#env_from CloudRunService#env_from}
    */
    readonly envFrom?: CloudRunServiceTemplateSpecContainersEnvFrom[] | cdktf.IResolvable;
    /**
    * ports block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#ports CloudRunService#ports}
    */
    readonly ports?: CloudRunServiceTemplateSpecContainersPorts[] | cdktf.IResolvable;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#resources CloudRunService#resources}
    */
    readonly resources?: CloudRunServiceTemplateSpecContainersResources;
    /**
    * volume_mounts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#volume_mounts CloudRunService#volume_mounts}
    */
    readonly volumeMounts?: CloudRunServiceTemplateSpecContainersVolumeMounts[] | cdktf.IResolvable;
}
export declare function cloudRunServiceTemplateSpecContainersToTerraform(struct?: CloudRunServiceTemplateSpecContainers | cdktf.IResolvable): any;
export declare class CloudRunServiceTemplateSpecContainersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTemplateSpecContainers | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecContainers | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
    private _env;
    get env(): CloudRunServiceTemplateSpecContainersEnvList;
    putEnv(value: CloudRunServiceTemplateSpecContainersEnv[] | cdktf.IResolvable): void;
    resetEnv(): void;
    get envInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecContainersEnv[] | undefined;
    private _envFrom;
    get envFrom(): CloudRunServiceTemplateSpecContainersEnvFromList;
    putEnvFrom(value: CloudRunServiceTemplateSpecContainersEnvFrom[] | cdktf.IResolvable): void;
    resetEnvFrom(): void;
    get envFromInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecContainersEnvFrom[] | undefined;
    private _ports;
    get ports(): CloudRunServiceTemplateSpecContainersPortsList;
    putPorts(value: CloudRunServiceTemplateSpecContainersPorts[] | cdktf.IResolvable): void;
    resetPorts(): void;
    get portsInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecContainersPorts[] | undefined;
    private _resources;
    get resources(): CloudRunServiceTemplateSpecContainersResourcesOutputReference;
    putResources(value: CloudRunServiceTemplateSpecContainersResources): void;
    resetResources(): void;
    get resourcesInput(): CloudRunServiceTemplateSpecContainersResources | undefined;
    private _volumeMounts;
    get volumeMounts(): CloudRunServiceTemplateSpecContainersVolumeMountsList;
    putVolumeMounts(value: CloudRunServiceTemplateSpecContainersVolumeMounts[] | cdktf.IResolvable): void;
    resetVolumeMounts(): void;
    get volumeMountsInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecContainersVolumeMounts[] | undefined;
}
export declare class CloudRunServiceTemplateSpecContainersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTemplateSpecContainersOutputReference;
}
export interface CloudRunServiceTemplateSpecVolumesSecretItems {
    /**
    * The Cloud Secret Manager secret version.
  Can be 'latest' for the latest value or an integer for a specific version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#key CloudRunService#key}
    */
    readonly key: string;
    /**
    * Mode bits to use on this file, must be a value between 0000 and 0777. If
  not specified, the volume defaultMode will be used. This might be in
  conflict with other options that affect the file mode, like fsGroup, and
  the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#mode CloudRunService#mode}
    */
    readonly mode?: number;
    /**
    * The relative path of the file to map the key to.
  May not be an absolute path.
  May not contain the path element '..'.
  May not start with the string '..'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#path CloudRunService#path}
    */
    readonly path: string;
}
export declare function cloudRunServiceTemplateSpecVolumesSecretItemsToTerraform(struct?: CloudRunServiceTemplateSpecVolumesSecretItems | cdktf.IResolvable): any;
export declare class CloudRunServiceTemplateSpecVolumesSecretItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTemplateSpecVolumesSecretItems | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecVolumesSecretItems | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _mode?;
    get mode(): number;
    set mode(value: number);
    resetMode(): void;
    get modeInput(): number | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class CloudRunServiceTemplateSpecVolumesSecretItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTemplateSpecVolumesSecretItems[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTemplateSpecVolumesSecretItemsOutputReference;
}
export interface CloudRunServiceTemplateSpecVolumesSecret {
    /**
    * Mode bits to use on created files by default. Must be a value between 0000
  and 0777. Defaults to 0644. Directories within the path are not affected by
  this setting. This might be in conflict with other options that affect the
  file mode, like fsGroup, and the result can be other mode bits set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#default_mode CloudRunService#default_mode}
    */
    readonly defaultMode?: number;
    /**
    * The name of the secret in Cloud Secret Manager. By default, the secret
  is assumed to be in the same project.
  If the secret is in another project, you must define an alias.
  An alias definition has the form:
  {alias}:projects/{project-id|project-number}/secrets/{secret-name}.
  If multiple alias definitions are needed, they must be separated by
  commas.
  The alias definitions must be set on the run.googleapis.com/secrets
  annotation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#secret_name CloudRunService#secret_name}
    */
    readonly secretName: string;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#items CloudRunService#items}
    */
    readonly items?: CloudRunServiceTemplateSpecVolumesSecretItems[] | cdktf.IResolvable;
}
export declare function cloudRunServiceTemplateSpecVolumesSecretToTerraform(struct?: CloudRunServiceTemplateSpecVolumesSecretOutputReference | CloudRunServiceTemplateSpecVolumesSecret): any;
export declare class CloudRunServiceTemplateSpecVolumesSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpecVolumesSecret | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecVolumesSecret | undefined);
    private _defaultMode?;
    get defaultMode(): number;
    set defaultMode(value: number);
    resetDefaultMode(): void;
    get defaultModeInput(): number | undefined;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _items;
    get items(): CloudRunServiceTemplateSpecVolumesSecretItemsList;
    putItems(value: CloudRunServiceTemplateSpecVolumesSecretItems[] | cdktf.IResolvable): void;
    resetItems(): void;
    get itemsInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecVolumesSecretItems[] | undefined;
}
export interface CloudRunServiceTemplateSpecVolumes {
    /**
    * Volume's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#name CloudRunService#name}
    */
    readonly name: string;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#secret CloudRunService#secret}
    */
    readonly secret: CloudRunServiceTemplateSpecVolumesSecret;
}
export declare function cloudRunServiceTemplateSpecVolumesToTerraform(struct?: CloudRunServiceTemplateSpecVolumes | cdktf.IResolvable): any;
export declare class CloudRunServiceTemplateSpecVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTemplateSpecVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTemplateSpecVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secret;
    get secret(): CloudRunServiceTemplateSpecVolumesSecretOutputReference;
    putSecret(value: CloudRunServiceTemplateSpecVolumesSecret): void;
    get secretInput(): CloudRunServiceTemplateSpecVolumesSecret | undefined;
}
export declare class CloudRunServiceTemplateSpecVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTemplateSpecVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTemplateSpecVolumesOutputReference;
}
export interface CloudRunServiceTemplateSpec {
    /**
    * ContainerConcurrency specifies the maximum allowed in-flight (concurrent)
  requests per container of the Revision. Values are:
  - '0' thread-safe, the system should manage the max concurrency. This is
      the default value.
  - '1' not-thread-safe. Single concurrency
  - '2-N' thread-safe, max concurrency of N
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#container_concurrency CloudRunService#container_concurrency}
    */
    readonly containerConcurrency?: number;
    /**
    * Email address of the IAM service account associated with the revision of the
  service. The service account represents the identity of the running revision,
  and determines what permissions the revision has. If not provided, the revision
  will use the project's default service account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#service_account_name CloudRunService#service_account_name}
    */
    readonly serviceAccountName?: string;
    /**
    * TimeoutSeconds holds the max duration the instance is allowed for responding to a request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#timeout_seconds CloudRunService#timeout_seconds}
    */
    readonly timeoutSeconds?: number;
    /**
    * containers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#containers CloudRunService#containers}
    */
    readonly containers?: CloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#volumes CloudRunService#volumes}
    */
    readonly volumes?: CloudRunServiceTemplateSpecVolumes[] | cdktf.IResolvable;
}
export declare function cloudRunServiceTemplateSpecToTerraform(struct?: CloudRunServiceTemplateSpecOutputReference | CloudRunServiceTemplateSpec): any;
export declare class CloudRunServiceTemplateSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplateSpec | undefined;
    set internalValue(value: CloudRunServiceTemplateSpec | undefined);
    private _containerConcurrency?;
    get containerConcurrency(): number;
    set containerConcurrency(value: number);
    resetContainerConcurrency(): void;
    get containerConcurrencyInput(): number | undefined;
    private _serviceAccountName?;
    get serviceAccountName(): string;
    set serviceAccountName(value: string);
    resetServiceAccountName(): void;
    get serviceAccountNameInput(): string | undefined;
    get servingState(): string;
    private _timeoutSeconds?;
    get timeoutSeconds(): number;
    set timeoutSeconds(value: number);
    resetTimeoutSeconds(): void;
    get timeoutSecondsInput(): number | undefined;
    private _containers;
    get containers(): CloudRunServiceTemplateSpecContainersList;
    putContainers(value: CloudRunServiceTemplateSpecContainers[] | cdktf.IResolvable): void;
    resetContainers(): void;
    get containersInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecContainers[] | undefined;
    private _volumes;
    get volumes(): CloudRunServiceTemplateSpecVolumesList;
    putVolumes(value: CloudRunServiceTemplateSpecVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | CloudRunServiceTemplateSpecVolumes[] | undefined;
}
export interface CloudRunServiceTemplate {
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#metadata CloudRunService#metadata}
    */
    readonly metadata?: CloudRunServiceTemplateMetadata;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#spec CloudRunService#spec}
    */
    readonly spec?: CloudRunServiceTemplateSpec;
}
export declare function cloudRunServiceTemplateToTerraform(struct?: CloudRunServiceTemplateOutputReference | CloudRunServiceTemplate): any;
export declare class CloudRunServiceTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTemplate | undefined;
    set internalValue(value: CloudRunServiceTemplate | undefined);
    private _metadata;
    get metadata(): CloudRunServiceTemplateMetadataOutputReference;
    putMetadata(value: CloudRunServiceTemplateMetadata): void;
    resetMetadata(): void;
    get metadataInput(): CloudRunServiceTemplateMetadata | undefined;
    private _spec;
    get spec(): CloudRunServiceTemplateSpecOutputReference;
    putSpec(value: CloudRunServiceTemplateSpec): void;
    resetSpec(): void;
    get specInput(): CloudRunServiceTemplateSpec | undefined;
}
export interface CloudRunServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#create CloudRunService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#delete CloudRunService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#update CloudRunService#update}
    */
    readonly update?: string;
}
export declare function cloudRunServiceTimeoutsToTerraform(struct?: CloudRunServiceTimeoutsOutputReference | CloudRunServiceTimeouts | cdktf.IResolvable): any;
export declare class CloudRunServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CloudRunServiceTraffic {
    /**
    * LatestRevision may be optionally provided to indicate that the latest ready
  Revision of the Configuration should be used for this traffic target. When
  provided LatestRevision must be true if RevisionName is empty; it must be
  false when RevisionName is non-empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#latest_revision CloudRunService#latest_revision}
    */
    readonly latestRevision?: boolean | cdktf.IResolvable;
    /**
    * Percent specifies percent of the traffic to this Revision or Configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#percent CloudRunService#percent}
    */
    readonly percent: number;
    /**
    * RevisionName of a specific revision to which to send this portion of traffic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#revision_name CloudRunService#revision_name}
    */
    readonly revisionName?: string;
    /**
    * Tag is optionally used to expose a dedicated url for referencing this target exclusively.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service#tag CloudRunService#tag}
    */
    readonly tag?: string;
}
export declare function cloudRunServiceTrafficToTerraform(struct?: CloudRunServiceTraffic | cdktf.IResolvable): any;
export declare class CloudRunServiceTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudRunServiceTraffic | cdktf.IResolvable | undefined;
    set internalValue(value: CloudRunServiceTraffic | cdktf.IResolvable | undefined);
    private _latestRevision?;
    get latestRevision(): boolean | cdktf.IResolvable;
    set latestRevision(value: boolean | cdktf.IResolvable);
    resetLatestRevision(): void;
    get latestRevisionInput(): boolean | cdktf.IResolvable | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    get percentInput(): number | undefined;
    private _revisionName?;
    get revisionName(): string;
    set revisionName(value: string);
    resetRevisionName(): void;
    get revisionNameInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    get url(): string;
}
export declare class CloudRunServiceTrafficList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudRunServiceTraffic[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudRunServiceTrafficOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service google_cloud_run_service}
*/
export declare class CloudRunService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service google_cloud_run_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudRunServiceConfig
    */
    constructor(scope: Construct, id: string, config: CloudRunServiceConfig);
    private _autogenerateRevisionName?;
    get autogenerateRevisionName(): boolean | cdktf.IResolvable;
    set autogenerateRevisionName(value: boolean | cdktf.IResolvable);
    resetAutogenerateRevisionName(): void;
    get autogenerateRevisionNameInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status;
    get status(): CloudRunServiceStatusList;
    private _metadata;
    get metadata(): CloudRunServiceMetadataOutputReference;
    putMetadata(value: CloudRunServiceMetadata): void;
    resetMetadata(): void;
    get metadataInput(): CloudRunServiceMetadata | undefined;
    private _template;
    get template(): CloudRunServiceTemplateOutputReference;
    putTemplate(value: CloudRunServiceTemplate): void;
    resetTemplate(): void;
    get templateInput(): CloudRunServiceTemplate | undefined;
    private _timeouts;
    get timeouts(): CloudRunServiceTimeoutsOutputReference;
    putTimeouts(value: CloudRunServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CloudRunServiceTimeouts | undefined;
    private _traffic;
    get traffic(): CloudRunServiceTrafficList;
    putTraffic(value: CloudRunServiceTraffic[] | cdktf.IResolvable): void;
    resetTraffic(): void;
    get trafficInput(): cdktf.IResolvable | CloudRunServiceTraffic[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
