import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunV2ServiceIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#id CloudRunV2ServiceIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#location CloudRunV2ServiceIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#members CloudRunV2ServiceIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#name CloudRunV2ServiceIamBinding#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#project CloudRunV2ServiceIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#role CloudRunV2ServiceIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#condition CloudRunV2ServiceIamBinding#condition}
    */
    readonly condition?: CloudRunV2ServiceIamBindingCondition;
}
export interface CloudRunV2ServiceIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#description CloudRunV2ServiceIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#expression CloudRunV2ServiceIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding#title CloudRunV2ServiceIamBinding#title}
    */
    readonly title: string;
}
export declare function cloudRunV2ServiceIamBindingConditionToTerraform(struct?: CloudRunV2ServiceIamBindingConditionOutputReference | CloudRunV2ServiceIamBindingCondition): any;
export declare class CloudRunV2ServiceIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceIamBindingCondition | undefined;
    set internalValue(value: CloudRunV2ServiceIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding google_cloud_run_v2_service_iam_binding}
*/
export declare class CloudRunV2ServiceIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_v2_service_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_binding google_cloud_run_v2_service_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudRunV2ServiceIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: CloudRunV2ServiceIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): CloudRunV2ServiceIamBindingConditionOutputReference;
    putCondition(value: CloudRunV2ServiceIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): CloudRunV2ServiceIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
