import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudRunV2ServiceIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#id CloudRunV2ServiceIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#location CloudRunV2ServiceIamMember#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#member CloudRunV2ServiceIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#name CloudRunV2ServiceIamMember#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#project CloudRunV2ServiceIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#role CloudRunV2ServiceIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#condition CloudRunV2ServiceIamMember#condition}
    */
    readonly condition?: CloudRunV2ServiceIamMemberCondition;
}
export interface CloudRunV2ServiceIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#description CloudRunV2ServiceIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#expression CloudRunV2ServiceIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member#title CloudRunV2ServiceIamMember#title}
    */
    readonly title: string;
}
export declare function cloudRunV2ServiceIamMemberConditionToTerraform(struct?: CloudRunV2ServiceIamMemberConditionOutputReference | CloudRunV2ServiceIamMemberCondition): any;
export declare class CloudRunV2ServiceIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudRunV2ServiceIamMemberCondition | undefined;
    set internalValue(value: CloudRunV2ServiceIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member google_cloud_run_v2_service_iam_member}
*/
export declare class CloudRunV2ServiceIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_run_v2_service_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_v2_service_iam_member google_cloud_run_v2_service_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudRunV2ServiceIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: CloudRunV2ServiceIamMemberConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): CloudRunV2ServiceIamMemberConditionOutputReference;
    putCondition(value: CloudRunV2ServiceIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): CloudRunV2ServiceIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
