import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudTasksQueueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#id CloudTasksQueue#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the queue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#location CloudTasksQueue#location}
    */
    readonly location: string;
    /**
    * The queue name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#name CloudTasksQueue#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#project CloudTasksQueue#project}
    */
    readonly project?: string;
    /**
    * app_engine_routing_override block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#app_engine_routing_override CloudTasksQueue#app_engine_routing_override}
    */
    readonly appEngineRoutingOverride?: CloudTasksQueueAppEngineRoutingOverride;
    /**
    * rate_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#rate_limits CloudTasksQueue#rate_limits}
    */
    readonly rateLimits?: CloudTasksQueueRateLimits;
    /**
    * retry_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#retry_config CloudTasksQueue#retry_config}
    */
    readonly retryConfig?: CloudTasksQueueRetryConfig;
    /**
    * stackdriver_logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#stackdriver_logging_config CloudTasksQueue#stackdriver_logging_config}
    */
    readonly stackdriverLoggingConfig?: CloudTasksQueueStackdriverLoggingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#timeouts CloudTasksQueue#timeouts}
    */
    readonly timeouts?: CloudTasksQueueTimeouts;
}
export interface CloudTasksQueueAppEngineRoutingOverride {
    /**
    * App instance.
  
  By default, the task is sent to an instance which is available when the task is attempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#instance CloudTasksQueue#instance}
    */
    readonly instance?: string;
    /**
    * App service.
  
  By default, the task is sent to the service which is the default service when the task is attempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#service CloudTasksQueue#service}
    */
    readonly service?: string;
    /**
    * App version.
  
  By default, the task is sent to the version which is the default version when the task is attempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#version CloudTasksQueue#version}
    */
    readonly version?: string;
}
export declare function cloudTasksQueueAppEngineRoutingOverrideToTerraform(struct?: CloudTasksQueueAppEngineRoutingOverrideOutputReference | CloudTasksQueueAppEngineRoutingOverride): any;
export declare class CloudTasksQueueAppEngineRoutingOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudTasksQueueAppEngineRoutingOverride | undefined;
    set internalValue(value: CloudTasksQueueAppEngineRoutingOverride | undefined);
    get host(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface CloudTasksQueueRateLimits {
    /**
    * The maximum number of concurrent tasks that Cloud Tasks allows to
  be dispatched for this queue. After this threshold has been
  reached, Cloud Tasks stops dispatching tasks until the number of
  concurrent requests decreases.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_concurrent_dispatches CloudTasksQueue#max_concurrent_dispatches}
    */
    readonly maxConcurrentDispatches?: number;
    /**
    * The maximum rate at which tasks are dispatched from this queue.
  
  If unspecified when the queue is created, Cloud Tasks will pick the default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_dispatches_per_second CloudTasksQueue#max_dispatches_per_second}
    */
    readonly maxDispatchesPerSecond?: number;
}
export declare function cloudTasksQueueRateLimitsToTerraform(struct?: CloudTasksQueueRateLimitsOutputReference | CloudTasksQueueRateLimits): any;
export declare class CloudTasksQueueRateLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudTasksQueueRateLimits | undefined;
    set internalValue(value: CloudTasksQueueRateLimits | undefined);
    get maxBurstSize(): number;
    private _maxConcurrentDispatches?;
    get maxConcurrentDispatches(): number;
    set maxConcurrentDispatches(value: number);
    resetMaxConcurrentDispatches(): void;
    get maxConcurrentDispatchesInput(): number | undefined;
    private _maxDispatchesPerSecond?;
    get maxDispatchesPerSecond(): number;
    set maxDispatchesPerSecond(value: number);
    resetMaxDispatchesPerSecond(): void;
    get maxDispatchesPerSecondInput(): number | undefined;
}
export interface CloudTasksQueueRetryConfig {
    /**
    * Number of attempts per task.
  
  Cloud Tasks will attempt the task maxAttempts times (that is, if
  the first attempt fails, then there will be maxAttempts - 1
  retries). Must be >= -1.
  
  If unspecified when the queue is created, Cloud Tasks will pick
  the default.
  
  -1 indicates unlimited attempts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_attempts CloudTasksQueue#max_attempts}
    */
    readonly maxAttempts?: number;
    /**
    * A task will be scheduled for retry between minBackoff and
  maxBackoff duration after it fails, if the queue's RetryConfig
  specifies that the task should be retried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_backoff CloudTasksQueue#max_backoff}
    */
    readonly maxBackoff?: string;
    /**
    * The time between retries will double maxDoublings times.
  
  A task's retry interval starts at minBackoff, then doubles maxDoublings times,
  then increases linearly, and finally retries retries at intervals of maxBackoff
  up to maxAttempts times.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_doublings CloudTasksQueue#max_doublings}
    */
    readonly maxDoublings?: number;
    /**
    * If positive, maxRetryDuration specifies the time limit for
  retrying a failed task, measured from when the task was first
  attempted. Once maxRetryDuration time has passed and the task has
  been attempted maxAttempts times, no further attempts will be
  made and the task will be deleted.
  
  If zero, then the task age is unlimited.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#max_retry_duration CloudTasksQueue#max_retry_duration}
    */
    readonly maxRetryDuration?: string;
    /**
    * A task will be scheduled for retry between minBackoff and
  maxBackoff duration after it fails, if the queue's RetryConfig
  specifies that the task should be retried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#min_backoff CloudTasksQueue#min_backoff}
    */
    readonly minBackoff?: string;
}
export declare function cloudTasksQueueRetryConfigToTerraform(struct?: CloudTasksQueueRetryConfigOutputReference | CloudTasksQueueRetryConfig): any;
export declare class CloudTasksQueueRetryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudTasksQueueRetryConfig | undefined;
    set internalValue(value: CloudTasksQueueRetryConfig | undefined);
    private _maxAttempts?;
    get maxAttempts(): number;
    set maxAttempts(value: number);
    resetMaxAttempts(): void;
    get maxAttemptsInput(): number | undefined;
    private _maxBackoff?;
    get maxBackoff(): string;
    set maxBackoff(value: string);
    resetMaxBackoff(): void;
    get maxBackoffInput(): string | undefined;
    private _maxDoublings?;
    get maxDoublings(): number;
    set maxDoublings(value: number);
    resetMaxDoublings(): void;
    get maxDoublingsInput(): number | undefined;
    private _maxRetryDuration?;
    get maxRetryDuration(): string;
    set maxRetryDuration(value: string);
    resetMaxRetryDuration(): void;
    get maxRetryDurationInput(): string | undefined;
    private _minBackoff?;
    get minBackoff(): string;
    set minBackoff(value: string);
    resetMinBackoff(): void;
    get minBackoffInput(): string | undefined;
}
export interface CloudTasksQueueStackdriverLoggingConfig {
    /**
    * Specifies the fraction of operations to write to Stackdriver Logging.
  This field may contain any value between 0.0 and 1.0, inclusive. 0.0 is the
  default and means that no operations are logged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#sampling_ratio CloudTasksQueue#sampling_ratio}
    */
    readonly samplingRatio: number;
}
export declare function cloudTasksQueueStackdriverLoggingConfigToTerraform(struct?: CloudTasksQueueStackdriverLoggingConfigOutputReference | CloudTasksQueueStackdriverLoggingConfig): any;
export declare class CloudTasksQueueStackdriverLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudTasksQueueStackdriverLoggingConfig | undefined;
    set internalValue(value: CloudTasksQueueStackdriverLoggingConfig | undefined);
    private _samplingRatio?;
    get samplingRatio(): number;
    set samplingRatio(value: number);
    get samplingRatioInput(): number | undefined;
}
export interface CloudTasksQueueTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#create CloudTasksQueue#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#delete CloudTasksQueue#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue#update CloudTasksQueue#update}
    */
    readonly update?: string;
}
export declare function cloudTasksQueueTimeoutsToTerraform(struct?: CloudTasksQueueTimeoutsOutputReference | CloudTasksQueueTimeouts | cdktf.IResolvable): any;
export declare class CloudTasksQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudTasksQueueTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudTasksQueueTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue google_cloud_tasks_queue}
*/
export declare class CloudTasksQueue extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_tasks_queue";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_tasks_queue google_cloud_tasks_queue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudTasksQueueConfig
    */
    constructor(scope: Construct, id: string, config: CloudTasksQueueConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _appEngineRoutingOverride;
    get appEngineRoutingOverride(): CloudTasksQueueAppEngineRoutingOverrideOutputReference;
    putAppEngineRoutingOverride(value: CloudTasksQueueAppEngineRoutingOverride): void;
    resetAppEngineRoutingOverride(): void;
    get appEngineRoutingOverrideInput(): CloudTasksQueueAppEngineRoutingOverride | undefined;
    private _rateLimits;
    get rateLimits(): CloudTasksQueueRateLimitsOutputReference;
    putRateLimits(value: CloudTasksQueueRateLimits): void;
    resetRateLimits(): void;
    get rateLimitsInput(): CloudTasksQueueRateLimits | undefined;
    private _retryConfig;
    get retryConfig(): CloudTasksQueueRetryConfigOutputReference;
    putRetryConfig(value: CloudTasksQueueRetryConfig): void;
    resetRetryConfig(): void;
    get retryConfigInput(): CloudTasksQueueRetryConfig | undefined;
    private _stackdriverLoggingConfig;
    get stackdriverLoggingConfig(): CloudTasksQueueStackdriverLoggingConfigOutputReference;
    putStackdriverLoggingConfig(value: CloudTasksQueueStackdriverLoggingConfig): void;
    resetStackdriverLoggingConfig(): void;
    get stackdriverLoggingConfigInput(): CloudTasksQueueStackdriverLoggingConfig | undefined;
    private _timeouts;
    get timeouts(): CloudTasksQueueTimeoutsOutputReference;
    putTimeouts(value: CloudTasksQueueTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CloudTasksQueueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
