import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudfunctionsFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Memory (in MB), available to the function. Default value is 256. Possible values include 128, 256, 512, 1024, etc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#available_memory_mb CloudfunctionsFunction#available_memory_mb}
    */
    readonly availableMemoryMb?: number;
    /**
    *  A set of key/value environment variable pairs available during build time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#build_environment_variables CloudfunctionsFunction#build_environment_variables}
    */
    readonly buildEnvironmentVariables?: {
        [key: string]: string;
    };
    /**
    * Name of the Cloud Build Custom Worker Pool that should be used to build the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#build_worker_pool CloudfunctionsFunction#build_worker_pool}
    */
    readonly buildWorkerPool?: string;
    /**
    * Description of the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#description CloudfunctionsFunction#description}
    */
    readonly description?: string;
    /**
    * Docker Registry to use for storing the function's Docker images. Allowed values are CONTAINER_REGISTRY (default) and ARTIFACT_REGISTRY.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#docker_registry CloudfunctionsFunction#docker_registry}
    */
    readonly dockerRegistry?: string;
    /**
    * User managed repository created in Artifact Registry optionally with a customer managed encryption key. If specified, deployments will use Artifact Registry for storing images built with Cloud Build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#docker_repository CloudfunctionsFunction#docker_repository}
    */
    readonly dockerRepository?: string;
    /**
    * Name of the function that will be executed when the Google Cloud Function is triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#entry_point CloudfunctionsFunction#entry_point}
    */
    readonly entryPoint?: string;
    /**
    * A set of key/value environment variable pairs to assign to the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#environment_variables CloudfunctionsFunction#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * The security level for the function. Defaults to SECURE_OPTIONAL. Valid only if trigger_http is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#https_trigger_security_level CloudfunctionsFunction#https_trigger_security_level}
    */
    readonly httpsTriggerSecurityLevel?: string;
    /**
    * URL which triggers function execution. Returned only if trigger_http is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#https_trigger_url CloudfunctionsFunction#https_trigger_url}
    */
    readonly httpsTriggerUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#id CloudfunctionsFunction#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String value that controls what traffic can reach the function. Allowed values are ALLOW_ALL and ALLOW_INTERNAL_ONLY. Changes to this field will recreate the cloud function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#ingress_settings CloudfunctionsFunction#ingress_settings}
    */
    readonly ingressSettings?: string;
    /**
    * Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt function resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#kms_key_name CloudfunctionsFunction#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#labels CloudfunctionsFunction#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The limit on the maximum number of function instances that may coexist at a given time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#max_instances CloudfunctionsFunction#max_instances}
    */
    readonly maxInstances?: number;
    /**
    * The limit on the minimum number of function instances that may coexist at a given time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#min_instances CloudfunctionsFunction#min_instances}
    */
    readonly minInstances?: number;
    /**
    * A user-defined name of the function. Function names must be unique globally.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#name CloudfunctionsFunction#name}
    */
    readonly name: string;
    /**
    * Project of the function. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#project CloudfunctionsFunction#project}
    */
    readonly project?: string;
    /**
    * Region of function. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#region CloudfunctionsFunction#region}
    */
    readonly region?: string;
    /**
    * The runtime in which the function is going to run. Eg. "nodejs8", "nodejs10", "python37", "go111".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#runtime CloudfunctionsFunction#runtime}
    */
    readonly runtime: string;
    /**
    *  If provided, the self-provided service account to run the function with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#service_account_email CloudfunctionsFunction#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * The GCS bucket containing the zip archive which contains the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#source_archive_bucket CloudfunctionsFunction#source_archive_bucket}
    */
    readonly sourceArchiveBucket?: string;
    /**
    * The source archive object (file) in archive bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#source_archive_object CloudfunctionsFunction#source_archive_object}
    */
    readonly sourceArchiveObject?: string;
    /**
    * Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#timeout CloudfunctionsFunction#timeout}
    */
    readonly timeout?: number;
    /**
    * Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as https_trigger_url. Cannot be used with trigger_bucket and trigger_topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#trigger_http CloudfunctionsFunction#trigger_http}
    */
    readonly triggerHttp?: boolean | cdktf.IResolvable;
    /**
    * The VPC Network Connector that this cloud function can connect to. It can be either the fully-qualified URI, or the short name of the network connector resource. The format of this field is projects/*\/locations/*\/connectors/*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#vpc_connector CloudfunctionsFunction#vpc_connector}
    */
    readonly vpcConnector?: string;
    /**
    * The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are ALL_TRAFFIC and PRIVATE_RANGES_ONLY. Defaults to PRIVATE_RANGES_ONLY. If unset, this field preserves the previously set value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#vpc_connector_egress_settings CloudfunctionsFunction#vpc_connector_egress_settings}
    */
    readonly vpcConnectorEgressSettings?: string;
    /**
    * event_trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#event_trigger CloudfunctionsFunction#event_trigger}
    */
    readonly eventTrigger?: CloudfunctionsFunctionEventTrigger;
    /**
    * secret_environment_variables block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#secret_environment_variables CloudfunctionsFunction#secret_environment_variables}
    */
    readonly secretEnvironmentVariables?: CloudfunctionsFunctionSecretEnvironmentVariables[] | cdktf.IResolvable;
    /**
    * secret_volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#secret_volumes CloudfunctionsFunction#secret_volumes}
    */
    readonly secretVolumes?: CloudfunctionsFunctionSecretVolumes[] | cdktf.IResolvable;
    /**
    * source_repository block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#source_repository CloudfunctionsFunction#source_repository}
    */
    readonly sourceRepository?: CloudfunctionsFunctionSourceRepository;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#timeouts CloudfunctionsFunction#timeouts}
    */
    readonly timeouts?: CloudfunctionsFunctionTimeouts;
}
export interface CloudfunctionsFunctionEventTriggerFailurePolicy {
    /**
    * Whether the function should be retried on failure. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#retry CloudfunctionsFunction#retry}
    */
    readonly retry: boolean | cdktf.IResolvable;
}
export declare function cloudfunctionsFunctionEventTriggerFailurePolicyToTerraform(struct?: CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference | CloudfunctionsFunctionEventTriggerFailurePolicy): any;
export declare class CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudfunctionsFunctionEventTriggerFailurePolicy | undefined;
    set internalValue(value: CloudfunctionsFunctionEventTriggerFailurePolicy | undefined);
    private _retry?;
    get retry(): boolean | cdktf.IResolvable;
    set retry(value: boolean | cdktf.IResolvable);
    get retryInput(): boolean | cdktf.IResolvable | undefined;
}
export interface CloudfunctionsFunctionEventTrigger {
    /**
    * The type of event to observe. For example: "google.storage.object.finalize". See the documentation on calling Cloud Functions for a full reference of accepted triggers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#event_type CloudfunctionsFunction#event_type}
    */
    readonly eventType: string;
    /**
    * The name or partial URI of the resource from which to observe events. For example, "myBucket" or "projects/my-project/topics/my-topic"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#resource CloudfunctionsFunction#resource}
    */
    readonly resource: string;
    /**
    * failure_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#failure_policy CloudfunctionsFunction#failure_policy}
    */
    readonly failurePolicy?: CloudfunctionsFunctionEventTriggerFailurePolicy;
}
export declare function cloudfunctionsFunctionEventTriggerToTerraform(struct?: CloudfunctionsFunctionEventTriggerOutputReference | CloudfunctionsFunctionEventTrigger): any;
export declare class CloudfunctionsFunctionEventTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudfunctionsFunctionEventTrigger | undefined;
    set internalValue(value: CloudfunctionsFunctionEventTrigger | undefined);
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    get eventTypeInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _failurePolicy;
    get failurePolicy(): CloudfunctionsFunctionEventTriggerFailurePolicyOutputReference;
    putFailurePolicy(value: CloudfunctionsFunctionEventTriggerFailurePolicy): void;
    resetFailurePolicy(): void;
    get failurePolicyInput(): CloudfunctionsFunctionEventTriggerFailurePolicy | undefined;
}
export interface CloudfunctionsFunctionSecretEnvironmentVariables {
    /**
    * Name of the environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#key CloudfunctionsFunction#key}
    */
    readonly key: string;
    /**
    * Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#project_id CloudfunctionsFunction#project_id}
    */
    readonly projectId?: string;
    /**
    * ID of the secret in secret manager (not the full resource name).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#secret CloudfunctionsFunction#secret}
    */
    readonly secret: string;
    /**
    * Version of the secret (version number or the string "latest"). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new clones start.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#version CloudfunctionsFunction#version}
    */
    readonly version: string;
}
export declare function cloudfunctionsFunctionSecretEnvironmentVariablesToTerraform(struct?: CloudfunctionsFunctionSecretEnvironmentVariables | cdktf.IResolvable): any;
export declare class CloudfunctionsFunctionSecretEnvironmentVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudfunctionsFunctionSecretEnvironmentVariables | cdktf.IResolvable | undefined;
    set internalValue(value: CloudfunctionsFunctionSecretEnvironmentVariables | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class CloudfunctionsFunctionSecretEnvironmentVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudfunctionsFunctionSecretEnvironmentVariables[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudfunctionsFunctionSecretEnvironmentVariablesOutputReference;
}
export interface CloudfunctionsFunctionSecretVolumesVersions {
    /**
    * Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mount_path as "/etc/secrets" and path as "/secret_foo" would mount the secret value file at "/etc/secrets/secret_foo".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#path CloudfunctionsFunction#path}
    */
    readonly path: string;
    /**
    * Version of the secret (version number or the string "latest"). It is preferable to use "latest" version with secret volumes as secret value changes are reflected immediately.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#version CloudfunctionsFunction#version}
    */
    readonly version: string;
}
export declare function cloudfunctionsFunctionSecretVolumesVersionsToTerraform(struct?: CloudfunctionsFunctionSecretVolumesVersions | cdktf.IResolvable): any;
export declare class CloudfunctionsFunctionSecretVolumesVersionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudfunctionsFunctionSecretVolumesVersions | cdktf.IResolvable | undefined;
    set internalValue(value: CloudfunctionsFunctionSecretVolumesVersions | cdktf.IResolvable | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export declare class CloudfunctionsFunctionSecretVolumesVersionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudfunctionsFunctionSecretVolumesVersions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudfunctionsFunctionSecretVolumesVersionsOutputReference;
}
export interface CloudfunctionsFunctionSecretVolumes {
    /**
    * The path within the container to mount the secret volume. For example, setting the mount_path as "/etc/secrets" would mount the secret value files under the "/etc/secrets" directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount paths: "/etc/secrets" Restricted mount paths: "/cloudsql", "/dev/log", "/pod", "/proc", "/var/log".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#mount_path CloudfunctionsFunction#mount_path}
    */
    readonly mountPath: string;
    /**
    * Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#project_id CloudfunctionsFunction#project_id}
    */
    readonly projectId?: string;
    /**
    * ID of the secret in secret manager (not the full resource name).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#secret CloudfunctionsFunction#secret}
    */
    readonly secret: string;
    /**
    * versions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#versions CloudfunctionsFunction#versions}
    */
    readonly versions?: CloudfunctionsFunctionSecretVolumesVersions[] | cdktf.IResolvable;
}
export declare function cloudfunctionsFunctionSecretVolumesToTerraform(struct?: CloudfunctionsFunctionSecretVolumes | cdktf.IResolvable): any;
export declare class CloudfunctionsFunctionSecretVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CloudfunctionsFunctionSecretVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: CloudfunctionsFunctionSecretVolumes | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    get mountPathInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _versions;
    get versions(): CloudfunctionsFunctionSecretVolumesVersionsList;
    putVersions(value: CloudfunctionsFunctionSecretVolumesVersions[] | cdktf.IResolvable): void;
    resetVersions(): void;
    get versionsInput(): cdktf.IResolvable | CloudfunctionsFunctionSecretVolumesVersions[] | undefined;
}
export declare class CloudfunctionsFunctionSecretVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CloudfunctionsFunctionSecretVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CloudfunctionsFunctionSecretVolumesOutputReference;
}
export interface CloudfunctionsFunctionSourceRepository {
    /**
    * The URL pointing to the hosted repository where the function is defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#url CloudfunctionsFunction#url}
    */
    readonly url: string;
}
export declare function cloudfunctionsFunctionSourceRepositoryToTerraform(struct?: CloudfunctionsFunctionSourceRepositoryOutputReference | CloudfunctionsFunctionSourceRepository): any;
export declare class CloudfunctionsFunctionSourceRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudfunctionsFunctionSourceRepository | undefined;
    set internalValue(value: CloudfunctionsFunctionSourceRepository | undefined);
    get deployedUrl(): string;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface CloudfunctionsFunctionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#create CloudfunctionsFunction#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#delete CloudfunctionsFunction#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#read CloudfunctionsFunction#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function#update CloudfunctionsFunction#update}
    */
    readonly update?: string;
}
export declare function cloudfunctionsFunctionTimeoutsToTerraform(struct?: CloudfunctionsFunctionTimeoutsOutputReference | CloudfunctionsFunctionTimeouts | cdktf.IResolvable): any;
export declare class CloudfunctionsFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudfunctionsFunctionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CloudfunctionsFunctionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function google_cloudfunctions_function}
*/
export declare class CloudfunctionsFunction extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudfunctions_function";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudfunctions_function google_cloudfunctions_function} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudfunctionsFunctionConfig
    */
    constructor(scope: Construct, id: string, config: CloudfunctionsFunctionConfig);
    private _availableMemoryMb?;
    get availableMemoryMb(): number;
    set availableMemoryMb(value: number);
    resetAvailableMemoryMb(): void;
    get availableMemoryMbInput(): number | undefined;
    private _buildEnvironmentVariables?;
    get buildEnvironmentVariables(): {
        [key: string]: string;
    };
    set buildEnvironmentVariables(value: {
        [key: string]: string;
    });
    resetBuildEnvironmentVariables(): void;
    get buildEnvironmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _buildWorkerPool?;
    get buildWorkerPool(): string;
    set buildWorkerPool(value: string);
    resetBuildWorkerPool(): void;
    get buildWorkerPoolInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dockerRegistry?;
    get dockerRegistry(): string;
    set dockerRegistry(value: string);
    resetDockerRegistry(): void;
    get dockerRegistryInput(): string | undefined;
    private _dockerRepository?;
    get dockerRepository(): string;
    set dockerRepository(value: string);
    resetDockerRepository(): void;
    get dockerRepositoryInput(): string | undefined;
    private _entryPoint?;
    get entryPoint(): string;
    set entryPoint(value: string);
    resetEntryPoint(): void;
    get entryPointInput(): string | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _httpsTriggerSecurityLevel?;
    get httpsTriggerSecurityLevel(): string;
    set httpsTriggerSecurityLevel(value: string);
    resetHttpsTriggerSecurityLevel(): void;
    get httpsTriggerSecurityLevelInput(): string | undefined;
    private _httpsTriggerUrl?;
    get httpsTriggerUrl(): string;
    set httpsTriggerUrl(value: string);
    resetHttpsTriggerUrl(): void;
    get httpsTriggerUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingressSettings?;
    get ingressSettings(): string;
    set ingressSettings(value: string);
    resetIngressSettings(): void;
    get ingressSettingsInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    get runtimeInput(): string | undefined;
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    private _sourceArchiveBucket?;
    get sourceArchiveBucket(): string;
    set sourceArchiveBucket(value: string);
    resetSourceArchiveBucket(): void;
    get sourceArchiveBucketInput(): string | undefined;
    private _sourceArchiveObject?;
    get sourceArchiveObject(): string;
    set sourceArchiveObject(value: string);
    resetSourceArchiveObject(): void;
    get sourceArchiveObjectInput(): string | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _triggerHttp?;
    get triggerHttp(): boolean | cdktf.IResolvable;
    set triggerHttp(value: boolean | cdktf.IResolvable);
    resetTriggerHttp(): void;
    get triggerHttpInput(): boolean | cdktf.IResolvable | undefined;
    private _vpcConnector?;
    get vpcConnector(): string;
    set vpcConnector(value: string);
    resetVpcConnector(): void;
    get vpcConnectorInput(): string | undefined;
    private _vpcConnectorEgressSettings?;
    get vpcConnectorEgressSettings(): string;
    set vpcConnectorEgressSettings(value: string);
    resetVpcConnectorEgressSettings(): void;
    get vpcConnectorEgressSettingsInput(): string | undefined;
    private _eventTrigger;
    get eventTrigger(): CloudfunctionsFunctionEventTriggerOutputReference;
    putEventTrigger(value: CloudfunctionsFunctionEventTrigger): void;
    resetEventTrigger(): void;
    get eventTriggerInput(): CloudfunctionsFunctionEventTrigger | undefined;
    private _secretEnvironmentVariables;
    get secretEnvironmentVariables(): CloudfunctionsFunctionSecretEnvironmentVariablesList;
    putSecretEnvironmentVariables(value: CloudfunctionsFunctionSecretEnvironmentVariables[] | cdktf.IResolvable): void;
    resetSecretEnvironmentVariables(): void;
    get secretEnvironmentVariablesInput(): cdktf.IResolvable | CloudfunctionsFunctionSecretEnvironmentVariables[] | undefined;
    private _secretVolumes;
    get secretVolumes(): CloudfunctionsFunctionSecretVolumesList;
    putSecretVolumes(value: CloudfunctionsFunctionSecretVolumes[] | cdktf.IResolvable): void;
    resetSecretVolumes(): void;
    get secretVolumesInput(): cdktf.IResolvable | CloudfunctionsFunctionSecretVolumes[] | undefined;
    private _sourceRepository;
    get sourceRepository(): CloudfunctionsFunctionSourceRepositoryOutputReference;
    putSourceRepository(value: CloudfunctionsFunctionSourceRepository): void;
    resetSourceRepository(): void;
    get sourceRepositoryInput(): CloudfunctionsFunctionSourceRepository | undefined;
    private _timeouts;
    get timeouts(): CloudfunctionsFunctionTimeoutsOutputReference;
    putTimeouts(value: CloudfunctionsFunctionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CloudfunctionsFunctionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
