import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * When set to 'true', the network is created in "auto subnet mode" and
  it will create a subnet for each region automatically across the
  '10.128.0.0/9' address range.
  
  When set to 'false', the network is created in "custom subnet mode" so
  the user can explicitly connect subnetwork resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#auto_create_subnetworks ComputeNetwork#auto_create_subnetworks}
    */
    readonly autoCreateSubnetworks?: boolean | cdktf.IResolvable;
    /**
    * If set to 'true', default routes ('0.0.0.0/0') will be deleted
  immediately after network creation. Defaults to 'false'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#delete_default_routes_on_create ComputeNetwork#delete_default_routes_on_create}
    */
    readonly deleteDefaultRoutesOnCreate?: boolean | cdktf.IResolvable;
    /**
    * An optional description of this resource. The resource must be
  recreated to modify this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#description ComputeNetwork#description}
    */
    readonly description?: string;
    /**
    * Enable ULA internal ipv6 on this network. Enabling this feature will assign
  a /48 from google defined ULA prefix fd20::/20.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#enable_ula_internal_ipv6 ComputeNetwork#enable_ula_internal_ipv6}
    */
    readonly enableUlaInternalIpv6?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#id ComputeNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * When enabling ula internal ipv6, caller optionally can specify the /48 range
  they want from the google defined ULA prefix fd20::/20. The input must be a
  valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
  fail if the speficied /48 is already in used by another resource.
  If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#internal_ipv6_range ComputeNetwork#internal_ipv6_range}
    */
    readonly internalIpv6Range?: string;
    /**
    * Maximum Transmission Unit in bytes. The default value is 1460 bytes.
  The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
  Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
  with an ICMP 'Fragmentation-Needed' message if the packets are routed to the Internet or other VPCs
  with varying MTUs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#mtu ComputeNetwork#mtu}
    */
    readonly mtu?: number;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#name ComputeNetwork#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#project ComputeNetwork#project}
    */
    readonly project?: string;
    /**
    * The network-wide routing mode to use. If set to 'REGIONAL', this
  network's cloud routers will only advertise routes with subnetworks
  of this network in the same region as the router. If set to 'GLOBAL',
  this network's cloud routers will advertise routes with all
  subnetworks of this network, across regions. Possible values: ["REGIONAL", "GLOBAL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#routing_mode ComputeNetwork#routing_mode}
    */
    readonly routingMode?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#timeouts ComputeNetwork#timeouts}
    */
    readonly timeouts?: ComputeNetworkTimeouts;
}
export interface ComputeNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#create ComputeNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#delete ComputeNetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network#update ComputeNetwork#update}
    */
    readonly update?: string;
}
export declare function computeNetworkTimeoutsToTerraform(struct?: ComputeNetworkTimeoutsOutputReference | ComputeNetworkTimeouts | cdktf.IResolvable): any;
export declare class ComputeNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeNetworkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network google_compute_network}
*/
export declare class ComputeNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network google_compute_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeNetworkConfig
    */
    constructor(scope: Construct, id: string, config: ComputeNetworkConfig);
    private _autoCreateSubnetworks?;
    get autoCreateSubnetworks(): boolean | cdktf.IResolvable;
    set autoCreateSubnetworks(value: boolean | cdktf.IResolvable);
    resetAutoCreateSubnetworks(): void;
    get autoCreateSubnetworksInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteDefaultRoutesOnCreate?;
    get deleteDefaultRoutesOnCreate(): boolean | cdktf.IResolvable;
    set deleteDefaultRoutesOnCreate(value: boolean | cdktf.IResolvable);
    resetDeleteDefaultRoutesOnCreate(): void;
    get deleteDefaultRoutesOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableUlaInternalIpv6?;
    get enableUlaInternalIpv6(): boolean | cdktf.IResolvable;
    set enableUlaInternalIpv6(value: boolean | cdktf.IResolvable);
    resetEnableUlaInternalIpv6(): void;
    get enableUlaInternalIpv6Input(): boolean | cdktf.IResolvable | undefined;
    get gatewayIpv4(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internalIpv6Range?;
    get internalIpv6Range(): string;
    set internalIpv6Range(value: string);
    resetInternalIpv6Range(): void;
    get internalIpv6RangeInput(): string | undefined;
    private _mtu?;
    get mtu(): number;
    set mtu(value: number);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _routingMode?;
    get routingMode(): string;
    set routingMode(value: string);
    resetRoutingMode(): void;
    get routingModeInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): ComputeNetworkTimeoutsOutputReference;
    putTimeouts(value: ComputeNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
