import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionTargetTcpProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A reference to the BackendService resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#backend_service ComputeRegionTargetTcpProxy#backend_service}
    */
    readonly backendService: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#description ComputeRegionTargetTcpProxy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#id ComputeRegionTargetTcpProxy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#name ComputeRegionTargetTcpProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#project ComputeRegionTargetTcpProxy#project}
    */
    readonly project?: string;
    /**
    * This field only applies when the forwarding rule that references
  this target proxy has a loadBalancingScheme set to INTERNAL_SELF_MANAGED.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#proxy_bind ComputeRegionTargetTcpProxy#proxy_bind}
    */
    readonly proxyBind?: boolean | cdktf.IResolvable;
    /**
    * Specifies the type of proxy header to append before sending data to
  the backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#proxy_header ComputeRegionTargetTcpProxy#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The Region in which the created target TCP proxy should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#region ComputeRegionTargetTcpProxy#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#timeouts ComputeRegionTargetTcpProxy#timeouts}
    */
    readonly timeouts?: ComputeRegionTargetTcpProxyTimeouts;
}
export interface ComputeRegionTargetTcpProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#create ComputeRegionTargetTcpProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy#delete ComputeRegionTargetTcpProxy#delete}
    */
    readonly delete?: string;
}
export declare function computeRegionTargetTcpProxyTimeoutsToTerraform(struct?: ComputeRegionTargetTcpProxyTimeoutsOutputReference | ComputeRegionTargetTcpProxyTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionTargetTcpProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionTargetTcpProxyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionTargetTcpProxyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy google_compute_region_target_tcp_proxy}
*/
export declare class ComputeRegionTargetTcpProxy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_target_tcp_proxy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_tcp_proxy google_compute_region_target_tcp_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionTargetTcpProxyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionTargetTcpProxyConfig);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _proxyBind?;
    get proxyBind(): boolean | cdktf.IResolvable;
    set proxyBind(value: boolean | cdktf.IResolvable);
    resetProxyBind(): void;
    get proxyBindInput(): boolean | cdktf.IResolvable | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    get proxyId(): number;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): ComputeRegionTargetTcpProxyTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionTargetTcpProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeRegionTargetTcpProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
