import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Creates the new snapshot in the snapshot chain labeled with the
  specified name. The chain name must be 1-63 characters long and
  comply with RFC1035. This is an uncommon option only for advanced
  service owners who needs to create separate snapshot chains, for
  example, for chargeback tracking.  When you describe your snapshot
  resource, this field is visible only if it has a non-empty value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#chain_name ComputeSnapshot#chain_name}
    */
    readonly chainName?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#description ComputeSnapshot#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#id ComputeSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels to apply to this Snapshot.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#labels ComputeSnapshot#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the resource; provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#name ComputeSnapshot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#project ComputeSnapshot#project}
    */
    readonly project?: string;
    /**
    * A reference to the disk used to create this snapshot.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#source_disk ComputeSnapshot#source_disk}
    */
    readonly sourceDisk: string;
    /**
    * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#storage_locations ComputeSnapshot#storage_locations}
    */
    readonly storageLocations?: string[];
    /**
    * A reference to the zone where the disk is hosted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#zone ComputeSnapshot#zone}
    */
    readonly zone?: string;
    /**
    * snapshot_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#snapshot_encryption_key ComputeSnapshot#snapshot_encryption_key}
    */
    readonly snapshotEncryptionKey?: ComputeSnapshotSnapshotEncryptionKey;
    /**
    * source_disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#source_disk_encryption_key ComputeSnapshot#source_disk_encryption_key}
    */
    readonly sourceDiskEncryptionKey?: ComputeSnapshotSourceDiskEncryptionKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#timeouts ComputeSnapshot#timeouts}
    */
    readonly timeouts?: ComputeSnapshotTimeouts;
}
export interface ComputeSnapshotSnapshotEncryptionKey {
    /**
    * The name of the encryption key that is stored in Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#kms_key_self_link ComputeSnapshot#kms_key_self_link}
    */
    readonly kmsKeySelfLink?: string;
    /**
    * The service account used for the encryption request for the given KMS key.
  If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#kms_key_service_account ComputeSnapshot#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
  RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#raw_key ComputeSnapshot#raw_key}
    */
    readonly rawKey?: string;
}
export declare function computeSnapshotSnapshotEncryptionKeyToTerraform(struct?: ComputeSnapshotSnapshotEncryptionKeyOutputReference | ComputeSnapshotSnapshotEncryptionKey): any;
export declare class ComputeSnapshotSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSnapshotSnapshotEncryptionKey | undefined;
    set internalValue(value: ComputeSnapshotSnapshotEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    get kmsKeySelfLink(): string;
    set kmsKeySelfLink(value: string);
    resetKmsKeySelfLink(): void;
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface ComputeSnapshotSourceDiskEncryptionKey {
    /**
    * The service account used for the encryption request for the given KMS key.
  If absent, the Compute Engine Service Agent service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#kms_key_service_account ComputeSnapshot#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
  RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#raw_key ComputeSnapshot#raw_key}
    */
    readonly rawKey?: string;
}
export declare function computeSnapshotSourceDiskEncryptionKeyToTerraform(struct?: ComputeSnapshotSourceDiskEncryptionKeyOutputReference | ComputeSnapshotSourceDiskEncryptionKey): any;
export declare class ComputeSnapshotSourceDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSnapshotSourceDiskEncryptionKey | undefined;
    set internalValue(value: ComputeSnapshotSourceDiskEncryptionKey | undefined);
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    resetKmsKeyServiceAccount(): void;
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
}
export interface ComputeSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#create ComputeSnapshot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#delete ComputeSnapshot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot#update ComputeSnapshot#update}
    */
    readonly update?: string;
}
export declare function computeSnapshotTimeoutsToTerraform(struct?: ComputeSnapshotTimeoutsOutputReference | ComputeSnapshotTimeouts | cdktf.IResolvable): any;
export declare class ComputeSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSnapshotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeSnapshotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot google_compute_snapshot}
*/
export declare class ComputeSnapshot extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot google_compute_snapshot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSnapshotConfig);
    private _chainName?;
    get chainName(): string;
    set chainName(value: string);
    resetChainName(): void;
    get chainNameInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get diskSizeGb(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get licenses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get snapshotId(): number;
    private _sourceDisk?;
    get sourceDisk(): string;
    set sourceDisk(value: string);
    get sourceDiskInput(): string | undefined;
    get storageBytes(): number;
    private _storageLocations?;
    get storageLocations(): string[];
    set storageLocations(value: string[]);
    resetStorageLocations(): void;
    get storageLocationsInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _snapshotEncryptionKey;
    get snapshotEncryptionKey(): ComputeSnapshotSnapshotEncryptionKeyOutputReference;
    putSnapshotEncryptionKey(value: ComputeSnapshotSnapshotEncryptionKey): void;
    resetSnapshotEncryptionKey(): void;
    get snapshotEncryptionKeyInput(): ComputeSnapshotSnapshotEncryptionKey | undefined;
    private _sourceDiskEncryptionKey;
    get sourceDiskEncryptionKey(): ComputeSnapshotSourceDiskEncryptionKeyOutputReference;
    putSourceDiskEncryptionKey(value: ComputeSnapshotSourceDiskEncryptionKey): void;
    resetSourceDiskEncryptionKey(): void;
    get sourceDiskEncryptionKeyInput(): ComputeSnapshotSourceDiskEncryptionKey | undefined;
    private _timeouts;
    get timeouts(): ComputeSnapshotTimeoutsOutputReference;
    putTimeouts(value: ComputeSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
