import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeTargetSslProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A reference to the BackendService resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#backend_service ComputeTargetSslProxy#backend_service}
    */
    readonly backendService: string;
    /**
    * A reference to the CertificateMap resource uri that identifies a certificate map
  associated with the given target proxy. This field can only be set for global target proxies.
  Accepted format is '//certificatemanager.googleapis.com/projects/{project}/locations/{location}/certificateMaps/{resourceName}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#certificate_map ComputeTargetSslProxy#certificate_map}
    */
    readonly certificateMap?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#description ComputeTargetSslProxy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#id ComputeTargetSslProxy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#name ComputeTargetSslProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#project ComputeTargetSslProxy#project}
    */
    readonly project?: string;
    /**
    * Specifies the type of proxy header to append before sending data to
  the backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#proxy_header ComputeTargetSslProxy#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * A list of SslCertificate resources that are used to authenticate
  connections between users and the load balancer. At least one
  SSL certificate must be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#ssl_certificates ComputeTargetSslProxy#ssl_certificates}
    */
    readonly sslCertificates?: string[];
    /**
    * A reference to the SslPolicy resource that will be associated with
  the TargetSslProxy resource. If not set, the TargetSslProxy
  resource will not have any SSL policy configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#ssl_policy ComputeTargetSslProxy#ssl_policy}
    */
    readonly sslPolicy?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#timeouts ComputeTargetSslProxy#timeouts}
    */
    readonly timeouts?: ComputeTargetSslProxyTimeouts;
}
export interface ComputeTargetSslProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#create ComputeTargetSslProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#delete ComputeTargetSslProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy#update ComputeTargetSslProxy#update}
    */
    readonly update?: string;
}
export declare function computeTargetSslProxyTimeoutsToTerraform(struct?: ComputeTargetSslProxyTimeoutsOutputReference | ComputeTargetSslProxyTimeouts | cdktf.IResolvable): any;
export declare class ComputeTargetSslProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeTargetSslProxyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeTargetSslProxyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy google_compute_target_ssl_proxy}
*/
export declare class ComputeTargetSslProxy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_target_ssl_proxy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_ssl_proxy google_compute_target_ssl_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeTargetSslProxyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeTargetSslProxyConfig);
    private _backendService?;
    get backendService(): string;
    set backendService(value: string);
    get backendServiceInput(): string | undefined;
    private _certificateMap?;
    get certificateMap(): string;
    set certificateMap(value: string);
    resetCertificateMap(): void;
    get certificateMapInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    get proxyId(): number;
    get selfLink(): string;
    private _sslCertificates?;
    get sslCertificates(): string[];
    set sslCertificates(value: string[]);
    resetSslCertificates(): void;
    get sslCertificatesInput(): string[] | undefined;
    private _sslPolicy?;
    get sslPolicy(): string;
    set sslPolicy(value: string);
    resetSslPolicy(): void;
    get sslPolicyInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeTargetSslProxyTimeoutsOutputReference;
    putTimeouts(value: ComputeTargetSslProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeTargetSslProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
