import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAwsNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#annotations ContainerAwsNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The awsCluster for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#cluster ContainerAwsNodePool#cluster}
    */
    readonly cluster: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#id ContainerAwsNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#location ContainerAwsNodePool#location}
    */
    readonly location: string;
    /**
    * The name of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#name ContainerAwsNodePool#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#project ContainerAwsNodePool#project}
    */
    readonly project?: string;
    /**
    * The subnet where the node pool node run.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#subnet_id ContainerAwsNodePool#subnet_id}
    */
    readonly subnetId: string;
    /**
    * The Kubernetes version to run on this node pool (e.g. `1.19.10-gke.1000`). You can list all supported versions on a given Google Cloud region by calling GetAwsServerConfig.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#version ContainerAwsNodePool#version}
    */
    readonly version: string;
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#autoscaling ContainerAwsNodePool#autoscaling}
    */
    readonly autoscaling: ContainerAwsNodePoolAutoscaling;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#config ContainerAwsNodePool#config}
    */
    readonly config: ContainerAwsNodePoolConfigA;
    /**
    * max_pods_constraint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#max_pods_constraint ContainerAwsNodePool#max_pods_constraint}
    */
    readonly maxPodsConstraint: ContainerAwsNodePoolMaxPodsConstraint;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#timeouts ContainerAwsNodePool#timeouts}
    */
    readonly timeouts?: ContainerAwsNodePoolTimeouts;
}
export interface ContainerAwsNodePoolAutoscaling {
    /**
    * Maximum number of nodes in the NodePool. Must be >= min_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#max_node_count ContainerAwsNodePool#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * Minimum number of nodes in the NodePool. Must be >= 1 and <= max_node_count.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#min_node_count ContainerAwsNodePool#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function containerAwsNodePoolAutoscalingToTerraform(struct?: ContainerAwsNodePoolAutoscalingOutputReference | ContainerAwsNodePoolAutoscaling): any;
export declare class ContainerAwsNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolAutoscaling | undefined;
    set internalValue(value: ContainerAwsNodePoolAutoscaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface ContainerAwsNodePoolConfigAutoscalingMetricsCollection {
    /**
    * The frequency at which EC2 Auto Scaling sends aggregated data to AWS CloudWatch. The only valid value is "1Minute".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#granularity ContainerAwsNodePool#granularity}
    */
    readonly granularity: string;
    /**
    * The metrics to enable. For a list of valid metrics, see https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_EnableMetricsCollection.html. If you specify granularity and don't specify any metrics, all metrics are enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#metrics ContainerAwsNodePool#metrics}
    */
    readonly metrics?: string[];
}
export declare function containerAwsNodePoolConfigAutoscalingMetricsCollectionToTerraform(struct?: ContainerAwsNodePoolConfigAutoscalingMetricsCollectionOutputReference | ContainerAwsNodePoolConfigAutoscalingMetricsCollection): any;
export declare class ContainerAwsNodePoolConfigAutoscalingMetricsCollectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolConfigAutoscalingMetricsCollection | undefined;
    set internalValue(value: ContainerAwsNodePoolConfigAutoscalingMetricsCollection | undefined);
    private _granularity?;
    get granularity(): string;
    set granularity(value: string);
    get granularityInput(): string | undefined;
    private _metrics?;
    get metrics(): string[];
    set metrics(value: string[]);
    resetMetrics(): void;
    get metricsInput(): string[] | undefined;
}
export interface ContainerAwsNodePoolConfigConfigEncryption {
    /**
    * The ARN of the AWS KMS key used to encrypt node pool configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#kms_key_arn ContainerAwsNodePool#kms_key_arn}
    */
    readonly kmsKeyArn: string;
}
export declare function containerAwsNodePoolConfigConfigEncryptionToTerraform(struct?: ContainerAwsNodePoolConfigConfigEncryptionOutputReference | ContainerAwsNodePoolConfigConfigEncryption): any;
export declare class ContainerAwsNodePoolConfigConfigEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolConfigConfigEncryption | undefined;
    set internalValue(value: ContainerAwsNodePoolConfigConfigEncryption | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    get kmsKeyArnInput(): string | undefined;
}
export interface ContainerAwsNodePoolConfigProxyConfig {
    /**
    * The ARN of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#secret_arn ContainerAwsNodePool#secret_arn}
    */
    readonly secretArn: string;
    /**
    * The version string of the AWS Secret Manager secret that contains the HTTP(S) proxy configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#secret_version ContainerAwsNodePool#secret_version}
    */
    readonly secretVersion: string;
}
export declare function containerAwsNodePoolConfigProxyConfigToTerraform(struct?: ContainerAwsNodePoolConfigProxyConfigOutputReference | ContainerAwsNodePoolConfigProxyConfig): any;
export declare class ContainerAwsNodePoolConfigProxyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolConfigProxyConfig | undefined;
    set internalValue(value: ContainerAwsNodePoolConfigProxyConfig | undefined);
    private _secretArn?;
    get secretArn(): string;
    set secretArn(value: string);
    get secretArnInput(): string | undefined;
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface ContainerAwsNodePoolConfigRootVolume {
    /**
    * Optional. The number of I/O operations per second (IOPS) to provision for GP3 volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#iops ContainerAwsNodePool#iops}
    */
    readonly iops?: number;
    /**
    * Optional. The Amazon Resource Name (ARN) of the Customer Managed Key (CMK) used to encrypt AWS EBS volumes. If not specified, the default Amazon managed key associated to the AWS region where this cluster runs will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#kms_key_arn ContainerAwsNodePool#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Optional. The size of the volume, in GiBs. When unspecified, a default value is provided. See the specific reference in the parent resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#size_gib ContainerAwsNodePool#size_gib}
    */
    readonly sizeGib?: number;
    /**
    * Optional. Type of the EBS volume. When unspecified, it defaults to GP2 volume. Possible values: VOLUME_TYPE_UNSPECIFIED, GP2, GP3
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#volume_type ContainerAwsNodePool#volume_type}
    */
    readonly volumeType?: string;
}
export declare function containerAwsNodePoolConfigRootVolumeToTerraform(struct?: ContainerAwsNodePoolConfigRootVolumeOutputReference | ContainerAwsNodePoolConfigRootVolume): any;
export declare class ContainerAwsNodePoolConfigRootVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolConfigRootVolume | undefined;
    set internalValue(value: ContainerAwsNodePoolConfigRootVolume | undefined);
    private _iops?;
    get iops(): number;
    set iops(value: number);
    resetIops(): void;
    get iopsInput(): number | undefined;
    private _kmsKeyArn?;
    get kmsKeyArn(): string;
    set kmsKeyArn(value: string);
    resetKmsKeyArn(): void;
    get kmsKeyArnInput(): string | undefined;
    private _sizeGib?;
    get sizeGib(): number;
    set sizeGib(value: number);
    resetSizeGib(): void;
    get sizeGibInput(): number | undefined;
    private _volumeType?;
    get volumeType(): string;
    set volumeType(value: string);
    resetVolumeType(): void;
    get volumeTypeInput(): string | undefined;
}
export interface ContainerAwsNodePoolConfigSshConfig {
    /**
    * The name of the EC2 key pair used to login into cluster machines.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#ec2_key_pair ContainerAwsNodePool#ec2_key_pair}
    */
    readonly ec2KeyPair: string;
}
export declare function containerAwsNodePoolConfigSshConfigToTerraform(struct?: ContainerAwsNodePoolConfigSshConfigOutputReference | ContainerAwsNodePoolConfigSshConfig): any;
export declare class ContainerAwsNodePoolConfigSshConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolConfigSshConfig | undefined;
    set internalValue(value: ContainerAwsNodePoolConfigSshConfig | undefined);
    private _ec2KeyPair?;
    get ec2KeyPair(): string;
    set ec2KeyPair(value: string);
    get ec2KeyPairInput(): string | undefined;
}
export interface ContainerAwsNodePoolConfigTaints {
    /**
    * The taint effect. Possible values: EFFECT_UNSPECIFIED, NO_SCHEDULE, PREFER_NO_SCHEDULE, NO_EXECUTE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#effect ContainerAwsNodePool#effect}
    */
    readonly effect: string;
    /**
    * Key for the taint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#key ContainerAwsNodePool#key}
    */
    readonly key: string;
    /**
    * Value for the taint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#value ContainerAwsNodePool#value}
    */
    readonly value: string;
}
export declare function containerAwsNodePoolConfigTaintsToTerraform(struct?: ContainerAwsNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class ContainerAwsNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerAwsNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAwsNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ContainerAwsNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerAwsNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerAwsNodePoolConfigTaintsOutputReference;
}
export interface ContainerAwsNodePoolConfigA {
    /**
    * The name of the AWS IAM role assigned to nodes in the pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#iam_instance_profile ContainerAwsNodePool#iam_instance_profile}
    */
    readonly iamInstanceProfile: string;
    /**
    * Optional. The AWS instance type. When unspecified, it defaults to `m5.large`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#instance_type ContainerAwsNodePool#instance_type}
    */
    readonly instanceType?: string;
    /**
    * Optional. The initial labels assigned to nodes of this node pool. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#labels ContainerAwsNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Optional. The IDs of additional security groups to add to nodes in this pool. The manager will automatically create security groups with minimum rules needed for a functioning cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#security_group_ids ContainerAwsNodePool#security_group_ids}
    */
    readonly securityGroupIds?: string[];
    /**
    * Optional. Key/value metadata to assign to each underlying AWS resource. Specify at most 50 pairs containing alphanumerics, spaces, and symbols (.+-=_:@/). Keys can be up to 127 Unicode characters. Values can be up to 255 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#tags ContainerAwsNodePool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * autoscaling_metrics_collection block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#autoscaling_metrics_collection ContainerAwsNodePool#autoscaling_metrics_collection}
    */
    readonly autoscalingMetricsCollection?: ContainerAwsNodePoolConfigAutoscalingMetricsCollection;
    /**
    * config_encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#config_encryption ContainerAwsNodePool#config_encryption}
    */
    readonly configEncryption: ContainerAwsNodePoolConfigConfigEncryption;
    /**
    * proxy_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#proxy_config ContainerAwsNodePool#proxy_config}
    */
    readonly proxyConfig?: ContainerAwsNodePoolConfigProxyConfig;
    /**
    * root_volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#root_volume ContainerAwsNodePool#root_volume}
    */
    readonly rootVolume?: ContainerAwsNodePoolConfigRootVolume;
    /**
    * ssh_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#ssh_config ContainerAwsNodePool#ssh_config}
    */
    readonly sshConfig?: ContainerAwsNodePoolConfigSshConfig;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#taints ContainerAwsNodePool#taints}
    */
    readonly taints?: ContainerAwsNodePoolConfigTaints[] | cdktf.IResolvable;
}
export declare function containerAwsNodePoolConfigAToTerraform(struct?: ContainerAwsNodePoolConfigAOutputReference | ContainerAwsNodePoolConfigA): any;
export declare class ContainerAwsNodePoolConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolConfigA | undefined;
    set internalValue(value: ContainerAwsNodePoolConfigA | undefined);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string;
    set iamInstanceProfile(value: string);
    get iamInstanceProfileInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    resetInstanceType(): void;
    get instanceTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _securityGroupIds?;
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    resetSecurityGroupIds(): void;
    get securityGroupIdsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _autoscalingMetricsCollection;
    get autoscalingMetricsCollection(): ContainerAwsNodePoolConfigAutoscalingMetricsCollectionOutputReference;
    putAutoscalingMetricsCollection(value: ContainerAwsNodePoolConfigAutoscalingMetricsCollection): void;
    resetAutoscalingMetricsCollection(): void;
    get autoscalingMetricsCollectionInput(): ContainerAwsNodePoolConfigAutoscalingMetricsCollection | undefined;
    private _configEncryption;
    get configEncryption(): ContainerAwsNodePoolConfigConfigEncryptionOutputReference;
    putConfigEncryption(value: ContainerAwsNodePoolConfigConfigEncryption): void;
    get configEncryptionInput(): ContainerAwsNodePoolConfigConfigEncryption | undefined;
    private _proxyConfig;
    get proxyConfig(): ContainerAwsNodePoolConfigProxyConfigOutputReference;
    putProxyConfig(value: ContainerAwsNodePoolConfigProxyConfig): void;
    resetProxyConfig(): void;
    get proxyConfigInput(): ContainerAwsNodePoolConfigProxyConfig | undefined;
    private _rootVolume;
    get rootVolume(): ContainerAwsNodePoolConfigRootVolumeOutputReference;
    putRootVolume(value: ContainerAwsNodePoolConfigRootVolume): void;
    resetRootVolume(): void;
    get rootVolumeInput(): ContainerAwsNodePoolConfigRootVolume | undefined;
    private _sshConfig;
    get sshConfig(): ContainerAwsNodePoolConfigSshConfigOutputReference;
    putSshConfig(value: ContainerAwsNodePoolConfigSshConfig): void;
    resetSshConfig(): void;
    get sshConfigInput(): ContainerAwsNodePoolConfigSshConfig | undefined;
    private _taints;
    get taints(): ContainerAwsNodePoolConfigTaintsList;
    putTaints(value: ContainerAwsNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | ContainerAwsNodePoolConfigTaints[] | undefined;
}
export interface ContainerAwsNodePoolMaxPodsConstraint {
    /**
    * The maximum number of pods to schedule on a single node.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#max_pods_per_node ContainerAwsNodePool#max_pods_per_node}
    */
    readonly maxPodsPerNode: number;
}
export declare function containerAwsNodePoolMaxPodsConstraintToTerraform(struct?: ContainerAwsNodePoolMaxPodsConstraintOutputReference | ContainerAwsNodePoolMaxPodsConstraint): any;
export declare class ContainerAwsNodePoolMaxPodsConstraintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolMaxPodsConstraint | undefined;
    set internalValue(value: ContainerAwsNodePoolMaxPodsConstraint | undefined);
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    get maxPodsPerNodeInput(): number | undefined;
}
export interface ContainerAwsNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#create ContainerAwsNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#delete ContainerAwsNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool#update ContainerAwsNodePool#update}
    */
    readonly update?: string;
}
export declare function containerAwsNodePoolTimeoutsToTerraform(struct?: ContainerAwsNodePoolTimeoutsOutputReference | ContainerAwsNodePoolTimeouts | cdktf.IResolvable): any;
export declare class ContainerAwsNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAwsNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAwsNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool google_container_aws_node_pool}
*/
export declare class ContainerAwsNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_container_aws_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_aws_node_pool google_container_aws_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAwsNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAwsNodePoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _autoscaling;
    get autoscaling(): ContainerAwsNodePoolAutoscalingOutputReference;
    putAutoscaling(value: ContainerAwsNodePoolAutoscaling): void;
    get autoscalingInput(): ContainerAwsNodePoolAutoscaling | undefined;
    private _config;
    get config(): ContainerAwsNodePoolConfigAOutputReference;
    putConfig(value: ContainerAwsNodePoolConfigA): void;
    get configInput(): ContainerAwsNodePoolConfigA | undefined;
    private _maxPodsConstraint;
    get maxPodsConstraint(): ContainerAwsNodePoolMaxPodsConstraintOutputReference;
    putMaxPodsConstraint(value: ContainerAwsNodePoolMaxPodsConstraint): void;
    get maxPodsConstraintInput(): ContainerAwsNodePoolMaxPodsConstraint | undefined;
    private _timeouts;
    get timeouts(): ContainerAwsNodePoolTimeoutsOutputReference;
    putTimeouts(value: ContainerAwsNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAwsNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
