import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
  individual column based on that schema.
  
  For attaching a tag to a nested column, use '.' to separate the column names. Example:
  'outer_column.inner_column'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#column DataCatalogTag#column}
    */
    readonly column?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#id DataCatalogTag#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
  all entries in that group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#parent DataCatalogTag#parent}
    */
    readonly parent?: string;
    /**
    * The resource name of the tag template that this tag uses. Example:
  projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
  This field cannot be modified after creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#template DataCatalogTag#template}
    */
    readonly template: string;
    /**
    * fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#fields DataCatalogTag#fields}
    */
    readonly fields: DataCatalogTagFields[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#timeouts DataCatalogTag#timeouts}
    */
    readonly timeouts?: DataCatalogTagTimeouts;
}
export interface DataCatalogTagFields {
    /**
    * Holds the value for a tag field with boolean type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#bool_value DataCatalogTag#bool_value}
    */
    readonly boolValue?: boolean | cdktf.IResolvable;
    /**
    * Holds the value for a tag field with double type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#double_value DataCatalogTag#double_value}
    */
    readonly doubleValue?: number;
    /**
    * The display name of the enum value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#enum_value DataCatalogTag#enum_value}
    */
    readonly enumValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#field_name DataCatalogTag#field_name}
    */
    readonly fieldName: string;
    /**
    * Holds the value for a tag field with string type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#string_value DataCatalogTag#string_value}
    */
    readonly stringValue?: string;
    /**
    * Holds the value for a tag field with timestamp type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#timestamp_value DataCatalogTag#timestamp_value}
    */
    readonly timestampValue?: string;
}
export declare function dataCatalogTagFieldsToTerraform(struct?: DataCatalogTagFields | cdktf.IResolvable): any;
export declare class DataCatalogTagFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataCatalogTagFields | cdktf.IResolvable | undefined;
    set internalValue(value: DataCatalogTagFields | cdktf.IResolvable | undefined);
    private _boolValue?;
    get boolValue(): boolean | cdktf.IResolvable;
    set boolValue(value: boolean | cdktf.IResolvable);
    resetBoolValue(): void;
    get boolValueInput(): boolean | cdktf.IResolvable | undefined;
    get displayName(): string;
    private _doubleValue?;
    get doubleValue(): number;
    set doubleValue(value: number);
    resetDoubleValue(): void;
    get doubleValueInput(): number | undefined;
    private _enumValue?;
    get enumValue(): string;
    set enumValue(value: string);
    resetEnumValue(): void;
    get enumValueInput(): string | undefined;
    private _fieldName?;
    get fieldName(): string;
    set fieldName(value: string);
    get fieldNameInput(): string | undefined;
    get order(): number;
    private _stringValue?;
    get stringValue(): string;
    set stringValue(value: string);
    resetStringValue(): void;
    get stringValueInput(): string | undefined;
    private _timestampValue?;
    get timestampValue(): string;
    set timestampValue(value: string);
    resetTimestampValue(): void;
    get timestampValueInput(): string | undefined;
}
export declare class DataCatalogTagFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataCatalogTagFields[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataCatalogTagFieldsOutputReference;
}
export interface DataCatalogTagTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#create DataCatalogTag#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#delete DataCatalogTag#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag#update DataCatalogTag#update}
    */
    readonly update?: string;
}
export declare function dataCatalogTagTimeoutsToTerraform(struct?: DataCatalogTagTimeoutsOutputReference | DataCatalogTagTimeouts | cdktf.IResolvable): any;
export declare class DataCatalogTagTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogTagTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataCatalogTagTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag google_data_catalog_tag}
*/
export declare class DataCatalogTag extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_tag";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag google_data_catalog_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogTagConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogTagConfig);
    private _column?;
    get column(): string;
    set column(value: string);
    resetColumn(): void;
    get columnInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _template?;
    get template(): string;
    set template(value: string);
    get templateInput(): string | undefined;
    get templateDisplayname(): string;
    private _fields;
    get fields(): DataCatalogTagFieldsList;
    putFields(value: DataCatalogTagFields[] | cdktf.IResolvable): void;
    get fieldsInput(): cdktf.IResolvable | DataCatalogTagFields[] | undefined;
    private _timeouts;
    get timeouts(): DataCatalogTagTimeoutsOutputReference;
    putTimeouts(value: DataCatalogTagTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataCatalogTagTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
