import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFusionInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#dataproc_service_account DataFusionInstance#dataproc_service_account}
    */
    readonly dataprocServiceAccount?: string;
    /**
    * An optional description of the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#description DataFusionInstance#description}
    */
    readonly description?: string;
    /**
    * Display name for an instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#display_name DataFusionInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Option to enable granular role-based access control.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#enable_rbac DataFusionInstance#enable_rbac}
    */
    readonly enableRbac?: boolean | cdktf.IResolvable;
    /**
    * Option to enable Stackdriver Logging.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#enable_stackdriver_logging DataFusionInstance#enable_stackdriver_logging}
    */
    readonly enableStackdriverLogging?: boolean | cdktf.IResolvable;
    /**
    * Option to enable Stackdriver Monitoring.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#enable_stackdriver_monitoring DataFusionInstance#enable_stackdriver_monitoring}
    */
    readonly enableStackdriverMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#id DataFusionInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource labels for instance to use to annotate any related underlying resources,
  such as Compute Engine VMs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#labels DataFusionInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The ID of the instance or a fully qualified identifier for the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#name DataFusionInstance#name}
    */
    readonly name: string;
    /**
    * Map of additional options used to configure the behavior of Data Fusion instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#options DataFusionInstance#options}
    */
    readonly options?: {
        [key: string]: string;
    };
    /**
    * Specifies whether the Data Fusion instance should be private. If set to
  true, all Data Fusion nodes will have private IP addresses and will not be
  able to access the public internet.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#private_instance DataFusionInstance#private_instance}
    */
    readonly privateInstance?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#project DataFusionInstance#project}
    */
    readonly project?: string;
    /**
    * The region of the Data Fusion instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#region DataFusionInstance#region}
    */
    readonly region?: string;
    /**
    * Represents the type of Data Fusion instance. Each type is configured with
  the default settings for processing and memory.
  - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
  using point and click UI. However, there are certain limitations, such as fewer number
  of concurrent pipelines, no support for streaming pipelines, etc.
  - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
  available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
  - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
  with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
  pipelines at low cost. Possible values: ["BASIC", "ENTERPRISE", "DEVELOPER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#type DataFusionInstance#type}
    */
    readonly type: string;
    /**
    * Current version of the Data Fusion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#version DataFusionInstance#version}
    */
    readonly version?: string;
    /**
    * Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#zone DataFusionInstance#zone}
    */
    readonly zone?: string;
    /**
    * crypto_key_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#crypto_key_config DataFusionInstance#crypto_key_config}
    */
    readonly cryptoKeyConfig?: DataFusionInstanceCryptoKeyConfig;
    /**
    * event_publish_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#event_publish_config DataFusionInstance#event_publish_config}
    */
    readonly eventPublishConfig?: DataFusionInstanceEventPublishConfig;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#network_config DataFusionInstance#network_config}
    */
    readonly networkConfig?: DataFusionInstanceNetworkConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#timeouts DataFusionInstance#timeouts}
    */
    readonly timeouts?: DataFusionInstanceTimeouts;
}
export interface DataFusionInstanceCryptoKeyConfig {
    /**
    * The name of the key which is used to encrypt/decrypt customer data. For key in Cloud KMS, the key should be in the format of projects/*\/locations/*\/keyRings/*\/cryptoKeys/*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#key_reference DataFusionInstance#key_reference}
    */
    readonly keyReference: string;
}
export declare function dataFusionInstanceCryptoKeyConfigToTerraform(struct?: DataFusionInstanceCryptoKeyConfigOutputReference | DataFusionInstanceCryptoKeyConfig): any;
export declare class DataFusionInstanceCryptoKeyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFusionInstanceCryptoKeyConfig | undefined;
    set internalValue(value: DataFusionInstanceCryptoKeyConfig | undefined);
    private _keyReference?;
    get keyReference(): string;
    set keyReference(value: string);
    get keyReferenceInput(): string | undefined;
}
export interface DataFusionInstanceEventPublishConfig {
    /**
    * Option to enable Event Publishing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#enabled DataFusionInstance#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The resource name of the Pub/Sub topic. Format: projects/{projectId}/topics/{topic_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#topic DataFusionInstance#topic}
    */
    readonly topic: string;
}
export declare function dataFusionInstanceEventPublishConfigToTerraform(struct?: DataFusionInstanceEventPublishConfigOutputReference | DataFusionInstanceEventPublishConfig): any;
export declare class DataFusionInstanceEventPublishConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFusionInstanceEventPublishConfig | undefined;
    set internalValue(value: DataFusionInstanceEventPublishConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface DataFusionInstanceNetworkConfig {
    /**
    * The IP range in CIDR notation to use for the managed Data Fusion instance
  nodes. This range must not overlap with any other ranges used in the Data Fusion instance network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#ip_allocation DataFusionInstance#ip_allocation}
    */
    readonly ipAllocation: string;
    /**
    * Name of the network in the project with which the tenant project
  will be peered for executing pipelines. In case of shared VPC where the network resides in another host
  project the network should specified in the form of projects/{host-project-id}/global/networks/{network}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#network DataFusionInstance#network}
    */
    readonly network: string;
}
export declare function dataFusionInstanceNetworkConfigToTerraform(struct?: DataFusionInstanceNetworkConfigOutputReference | DataFusionInstanceNetworkConfig): any;
export declare class DataFusionInstanceNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFusionInstanceNetworkConfig | undefined;
    set internalValue(value: DataFusionInstanceNetworkConfig | undefined);
    private _ipAllocation?;
    get ipAllocation(): string;
    set ipAllocation(value: string);
    get ipAllocationInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
}
export interface DataFusionInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#create DataFusionInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#delete DataFusionInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance#update DataFusionInstance#update}
    */
    readonly update?: string;
}
export declare function dataFusionInstanceTimeoutsToTerraform(struct?: DataFusionInstanceTimeoutsOutputReference | DataFusionInstanceTimeouts | cdktf.IResolvable): any;
export declare class DataFusionInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFusionInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFusionInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance google_data_fusion_instance}
*/
export declare class DataFusionInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_fusion_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_fusion_instance google_data_fusion_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFusionInstanceConfig
    */
    constructor(scope: Construct, id: string, config: DataFusionInstanceConfig);
    get apiEndpoint(): string;
    get createTime(): string;
    private _dataprocServiceAccount?;
    get dataprocServiceAccount(): string;
    set dataprocServiceAccount(value: string);
    resetDataprocServiceAccount(): void;
    get dataprocServiceAccountInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _enableRbac?;
    get enableRbac(): boolean | cdktf.IResolvable;
    set enableRbac(value: boolean | cdktf.IResolvable);
    resetEnableRbac(): void;
    get enableRbacInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverLogging?;
    get enableStackdriverLogging(): boolean | cdktf.IResolvable;
    set enableStackdriverLogging(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverLogging(): void;
    get enableStackdriverLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableStackdriverMonitoring?;
    get enableStackdriverMonitoring(): boolean | cdktf.IResolvable;
    set enableStackdriverMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableStackdriverMonitoring(): void;
    get enableStackdriverMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    get gcsBucket(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _options?;
    get options(): {
        [key: string]: string;
    };
    set options(value: {
        [key: string]: string;
    });
    resetOptions(): void;
    get optionsInput(): {
        [key: string]: string;
    } | undefined;
    get p4ServiceAccount(): string;
    private _privateInstance?;
    get privateInstance(): boolean | cdktf.IResolvable;
    set privateInstance(value: boolean | cdktf.IResolvable);
    resetPrivateInstance(): void;
    get privateInstanceInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get serviceEndpoint(): string;
    get state(): string;
    get stateMessage(): string;
    get tenantProjectId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _cryptoKeyConfig;
    get cryptoKeyConfig(): DataFusionInstanceCryptoKeyConfigOutputReference;
    putCryptoKeyConfig(value: DataFusionInstanceCryptoKeyConfig): void;
    resetCryptoKeyConfig(): void;
    get cryptoKeyConfigInput(): DataFusionInstanceCryptoKeyConfig | undefined;
    private _eventPublishConfig;
    get eventPublishConfig(): DataFusionInstanceEventPublishConfigOutputReference;
    putEventPublishConfig(value: DataFusionInstanceEventPublishConfig): void;
    resetEventPublishConfig(): void;
    get eventPublishConfigInput(): DataFusionInstanceEventPublishConfig | undefined;
    private _networkConfig;
    get networkConfig(): DataFusionInstanceNetworkConfigOutputReference;
    putNetworkConfig(value: DataFusionInstanceNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): DataFusionInstanceNetworkConfig | undefined;
    private _timeouts;
    get timeouts(): DataFusionInstanceTimeoutsOutputReference;
    putTimeouts(value: DataFusionInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFusionInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
