import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleArtifactRegistryRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/artifact_registry_repository#id DataGoogleArtifactRegistryRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the location this repository is located in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/artifact_registry_repository#location DataGoogleArtifactRegistryRepository#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/artifact_registry_repository#project DataGoogleArtifactRegistryRepository#project}
    */
    readonly project?: string;
    /**
    * The last part of the repository name, for example:
  "repo1"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/artifact_registry_repository#repository_id DataGoogleArtifactRegistryRepository#repository_id}
    */
    readonly repositoryId: string;
}
export interface DataGoogleArtifactRegistryRepositoryMavenConfig {
}
export declare function dataGoogleArtifactRegistryRepositoryMavenConfigToTerraform(struct?: DataGoogleArtifactRegistryRepositoryMavenConfig): any;
export declare class DataGoogleArtifactRegistryRepositoryMavenConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleArtifactRegistryRepositoryMavenConfig | undefined;
    set internalValue(value: DataGoogleArtifactRegistryRepositoryMavenConfig | undefined);
    get allowSnapshotOverwrites(): cdktf.IResolvable;
    get versionPolicy(): string;
}
export declare class DataGoogleArtifactRegistryRepositoryMavenConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleArtifactRegistryRepositoryMavenConfigOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/artifact_registry_repository google_artifact_registry_repository}
*/
export declare class DataGoogleArtifactRegistryRepository extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_artifact_registry_repository";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/artifact_registry_repository google_artifact_registry_repository} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleArtifactRegistryRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleArtifactRegistryRepositoryConfig);
    get createTime(): string;
    get description(): string;
    get format(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kmsKeyName(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mavenConfig;
    get mavenConfig(): DataGoogleArtifactRegistryRepositoryMavenConfigList;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repositoryId?;
    get repositoryId(): string;
    set repositoryId(value: string);
    get repositoryIdInput(): string | undefined;
    get updateTime(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
