import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance#id DataGoogleComputeInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the instance. One of name or self_link must be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance#name DataGoogleComputeInstance#name}
    */
    readonly name?: string;
    /**
    * The ID of the project in which the resource belongs. If self_link is provided, this value is ignored. If neither self_link nor project are provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance#project DataGoogleComputeInstance#project}
    */
    readonly project?: string;
    /**
    * The URI of the created resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance#self_link DataGoogleComputeInstance#self_link}
    */
    readonly selfLink?: string;
    /**
    * The zone of the instance. If self_link is provided, this value is ignored. If neither self_link nor zone are provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_instance#zone DataGoogleComputeInstance#zone}
    */
    readonly zone?: string;
}
export interface DataGoogleComputeInstanceAdvancedMachineFeatures {
}
export declare function dataGoogleComputeInstanceAdvancedMachineFeaturesToTerraform(struct?: DataGoogleComputeInstanceAdvancedMachineFeatures): any;
export declare class DataGoogleComputeInstanceAdvancedMachineFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceAdvancedMachineFeatures | undefined;
    set internalValue(value: DataGoogleComputeInstanceAdvancedMachineFeatures | undefined);
    get enableNestedVirtualization(): cdktf.IResolvable;
    get threadsPerCore(): number;
    get visibleCoreCount(): number;
}
export declare class DataGoogleComputeInstanceAdvancedMachineFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceAdvancedMachineFeaturesOutputReference;
}
export interface DataGoogleComputeInstanceAttachedDisk {
}
export declare function dataGoogleComputeInstanceAttachedDiskToTerraform(struct?: DataGoogleComputeInstanceAttachedDisk): any;
export declare class DataGoogleComputeInstanceAttachedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceAttachedDisk | undefined;
    set internalValue(value: DataGoogleComputeInstanceAttachedDisk | undefined);
    get deviceName(): string;
    get diskEncryptionKeyRaw(): string;
    get diskEncryptionKeySha256(): string;
    get kmsKeySelfLink(): string;
    get mode(): string;
    get source(): string;
}
export declare class DataGoogleComputeInstanceAttachedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceAttachedDiskOutputReference;
}
export interface DataGoogleComputeInstanceBootDiskInitializeParams {
}
export declare function dataGoogleComputeInstanceBootDiskInitializeParamsToTerraform(struct?: DataGoogleComputeInstanceBootDiskInitializeParams): any;
export declare class DataGoogleComputeInstanceBootDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceBootDiskInitializeParams | undefined;
    set internalValue(value: DataGoogleComputeInstanceBootDiskInitializeParams | undefined);
    get image(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get size(): number;
    get type(): string;
}
export declare class DataGoogleComputeInstanceBootDiskInitializeParamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceBootDiskInitializeParamsOutputReference;
}
export interface DataGoogleComputeInstanceBootDisk {
}
export declare function dataGoogleComputeInstanceBootDiskToTerraform(struct?: DataGoogleComputeInstanceBootDisk): any;
export declare class DataGoogleComputeInstanceBootDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceBootDisk | undefined;
    set internalValue(value: DataGoogleComputeInstanceBootDisk | undefined);
    get autoDelete(): cdktf.IResolvable;
    get deviceName(): string;
    get diskEncryptionKeyRaw(): string;
    get diskEncryptionKeySha256(): string;
    private _initializeParams;
    get initializeParams(): DataGoogleComputeInstanceBootDiskInitializeParamsList;
    get kmsKeySelfLink(): string;
    get mode(): string;
    get source(): string;
}
export declare class DataGoogleComputeInstanceBootDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceBootDiskOutputReference;
}
export interface DataGoogleComputeInstanceConfidentialInstanceConfig {
}
export declare function dataGoogleComputeInstanceConfidentialInstanceConfigToTerraform(struct?: DataGoogleComputeInstanceConfidentialInstanceConfig): any;
export declare class DataGoogleComputeInstanceConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceConfidentialInstanceConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceConfidentialInstanceConfig | undefined);
    get enableConfidentialCompute(): cdktf.IResolvable;
}
export declare class DataGoogleComputeInstanceConfidentialInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceConfidentialInstanceConfigOutputReference;
}
export interface DataGoogleComputeInstanceGuestAccelerator {
}
export declare function dataGoogleComputeInstanceGuestAcceleratorToTerraform(struct?: DataGoogleComputeInstanceGuestAccelerator): any;
export declare class DataGoogleComputeInstanceGuestAcceleratorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceGuestAccelerator | undefined;
    set internalValue(value: DataGoogleComputeInstanceGuestAccelerator | undefined);
    get count(): number;
    get type(): string;
}
export declare class DataGoogleComputeInstanceGuestAcceleratorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceGuestAcceleratorOutputReference;
}
export interface DataGoogleComputeInstanceNetworkInterfaceAccessConfig {
}
export declare function dataGoogleComputeInstanceNetworkInterfaceAccessConfigToTerraform(struct?: DataGoogleComputeInstanceNetworkInterfaceAccessConfig): any;
export declare class DataGoogleComputeInstanceNetworkInterfaceAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceNetworkInterfaceAccessConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceNetworkInterfaceAccessConfig | undefined);
    get natIp(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterfaceAccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceNetworkInterfaceAccessConfigOutputReference;
}
export interface DataGoogleComputeInstanceNetworkInterfaceAliasIpRange {
}
export declare function dataGoogleComputeInstanceNetworkInterfaceAliasIpRangeToTerraform(struct?: DataGoogleComputeInstanceNetworkInterfaceAliasIpRange): any;
export declare class DataGoogleComputeInstanceNetworkInterfaceAliasIpRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceNetworkInterfaceAliasIpRange | undefined;
    set internalValue(value: DataGoogleComputeInstanceNetworkInterfaceAliasIpRange | undefined);
    get ipCidrRange(): string;
    get subnetworkRangeName(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterfaceAliasIpRangeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceNetworkInterfaceAliasIpRangeOutputReference;
}
export interface DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfig {
}
export declare function dataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfigToTerraform(struct?: DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfig): any;
export declare class DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfig | undefined);
    get externalIpv6(): string;
    get externalIpv6PrefixLength(): string;
    get networkTier(): string;
    get publicPtrDomainName(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfigOutputReference;
}
export interface DataGoogleComputeInstanceNetworkInterface {
}
export declare function dataGoogleComputeInstanceNetworkInterfaceToTerraform(struct?: DataGoogleComputeInstanceNetworkInterface): any;
export declare class DataGoogleComputeInstanceNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceNetworkInterface | undefined;
    set internalValue(value: DataGoogleComputeInstanceNetworkInterface | undefined);
    private _accessConfig;
    get accessConfig(): DataGoogleComputeInstanceNetworkInterfaceAccessConfigList;
    private _aliasIpRange;
    get aliasIpRange(): DataGoogleComputeInstanceNetworkInterfaceAliasIpRangeList;
    private _ipv6AccessConfig;
    get ipv6AccessConfig(): DataGoogleComputeInstanceNetworkInterfaceIpv6AccessConfigList;
    get ipv6AccessType(): string;
    get name(): string;
    get network(): string;
    get networkIp(): string;
    get nicType(): string;
    get queueCount(): number;
    get stackType(): string;
    get subnetwork(): string;
    get subnetworkProject(): string;
}
export declare class DataGoogleComputeInstanceNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceNetworkInterfaceOutputReference;
}
export interface DataGoogleComputeInstanceReservationAffinitySpecificReservation {
}
export declare function dataGoogleComputeInstanceReservationAffinitySpecificReservationToTerraform(struct?: DataGoogleComputeInstanceReservationAffinitySpecificReservation): any;
export declare class DataGoogleComputeInstanceReservationAffinitySpecificReservationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceReservationAffinitySpecificReservation | undefined;
    set internalValue(value: DataGoogleComputeInstanceReservationAffinitySpecificReservation | undefined);
    get key(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceReservationAffinitySpecificReservationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceReservationAffinitySpecificReservationOutputReference;
}
export interface DataGoogleComputeInstanceReservationAffinity {
}
export declare function dataGoogleComputeInstanceReservationAffinityToTerraform(struct?: DataGoogleComputeInstanceReservationAffinity): any;
export declare class DataGoogleComputeInstanceReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceReservationAffinity | undefined;
    set internalValue(value: DataGoogleComputeInstanceReservationAffinity | undefined);
    private _specificReservation;
    get specificReservation(): DataGoogleComputeInstanceReservationAffinitySpecificReservationList;
    get type(): string;
}
export declare class DataGoogleComputeInstanceReservationAffinityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceReservationAffinityOutputReference;
}
export interface DataGoogleComputeInstanceSchedulingNodeAffinities {
}
export declare function dataGoogleComputeInstanceSchedulingNodeAffinitiesToTerraform(struct?: DataGoogleComputeInstanceSchedulingNodeAffinities): any;
export declare class DataGoogleComputeInstanceSchedulingNodeAffinitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceSchedulingNodeAffinities | undefined;
    set internalValue(value: DataGoogleComputeInstanceSchedulingNodeAffinities | undefined);
    get key(): string;
    get operator(): string;
    get values(): string[];
}
export declare class DataGoogleComputeInstanceSchedulingNodeAffinitiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceSchedulingNodeAffinitiesOutputReference;
}
export interface DataGoogleComputeInstanceScheduling {
}
export declare function dataGoogleComputeInstanceSchedulingToTerraform(struct?: DataGoogleComputeInstanceScheduling): any;
export declare class DataGoogleComputeInstanceSchedulingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceScheduling | undefined;
    set internalValue(value: DataGoogleComputeInstanceScheduling | undefined);
    get automaticRestart(): cdktf.IResolvable;
    get instanceTerminationAction(): string;
    get minNodeCpus(): number;
    private _nodeAffinities;
    get nodeAffinities(): DataGoogleComputeInstanceSchedulingNodeAffinitiesList;
    get onHostMaintenance(): string;
    get preemptible(): cdktf.IResolvable;
    get provisioningModel(): string;
}
export declare class DataGoogleComputeInstanceSchedulingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceSchedulingOutputReference;
}
export interface DataGoogleComputeInstanceScratchDisk {
}
export declare function dataGoogleComputeInstanceScratchDiskToTerraform(struct?: DataGoogleComputeInstanceScratchDisk): any;
export declare class DataGoogleComputeInstanceScratchDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceScratchDisk | undefined;
    set internalValue(value: DataGoogleComputeInstanceScratchDisk | undefined);
    get interface(): string;
}
export declare class DataGoogleComputeInstanceScratchDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceScratchDiskOutputReference;
}
export interface DataGoogleComputeInstanceServiceAccount {
}
export declare function dataGoogleComputeInstanceServiceAccountToTerraform(struct?: DataGoogleComputeInstanceServiceAccount): any;
export declare class DataGoogleComputeInstanceServiceAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceServiceAccount | undefined;
    set internalValue(value: DataGoogleComputeInstanceServiceAccount | undefined);
    get email(): string;
    get scopes(): string[];
}
export declare class DataGoogleComputeInstanceServiceAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceServiceAccountOutputReference;
}
export interface DataGoogleComputeInstanceShieldedInstanceConfig {
}
export declare function dataGoogleComputeInstanceShieldedInstanceConfigToTerraform(struct?: DataGoogleComputeInstanceShieldedInstanceConfig): any;
export declare class DataGoogleComputeInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeInstanceShieldedInstanceConfig | undefined;
    set internalValue(value: DataGoogleComputeInstanceShieldedInstanceConfig | undefined);
    get enableIntegrityMonitoring(): cdktf.IResolvable;
    get enableSecureBoot(): cdktf.IResolvable;
    get enableVtpm(): cdktf.IResolvable;
}
export declare class DataGoogleComputeInstanceShieldedInstanceConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeInstanceShieldedInstanceConfigOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_instance google_compute_instance}
*/
export declare class DataGoogleComputeInstance extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_instance google_compute_instance} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeInstanceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeInstanceConfig);
    private _advancedMachineFeatures;
    get advancedMachineFeatures(): DataGoogleComputeInstanceAdvancedMachineFeaturesList;
    get allowStoppingForUpdate(): cdktf.IResolvable;
    private _attachedDisk;
    get attachedDisk(): DataGoogleComputeInstanceAttachedDiskList;
    private _bootDisk;
    get bootDisk(): DataGoogleComputeInstanceBootDiskList;
    get canIpForward(): cdktf.IResolvable;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): DataGoogleComputeInstanceConfidentialInstanceConfigList;
    get cpuPlatform(): string;
    get currentStatus(): string;
    get deletionProtection(): cdktf.IResolvable;
    get description(): string;
    get desiredStatus(): string;
    get enableDisplay(): cdktf.IResolvable;
    private _guestAccelerator;
    get guestAccelerator(): DataGoogleComputeInstanceGuestAcceleratorList;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceId(): string;
    get labelFingerprint(): string;
    private _labels;
    get labels(): cdktf.StringMap;
    get machineType(): string;
    private _metadata;
    get metadata(): cdktf.StringMap;
    get metadataFingerprint(): string;
    get metadataStartupScript(): string;
    get minCpuPlatform(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _networkInterface;
    get networkInterface(): DataGoogleComputeInstanceNetworkInterfaceList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _reservationAffinity;
    get reservationAffinity(): DataGoogleComputeInstanceReservationAffinityList;
    get resourcePolicies(): string[];
    private _scheduling;
    get scheduling(): DataGoogleComputeInstanceSchedulingList;
    private _scratchDisk;
    get scratchDisk(): DataGoogleComputeInstanceScratchDiskList;
    private _selfLink?;
    get selfLink(): string;
    set selfLink(value: string);
    resetSelfLink(): void;
    get selfLinkInput(): string | undefined;
    private _serviceAccount;
    get serviceAccount(): DataGoogleComputeInstanceServiceAccountList;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): DataGoogleComputeInstanceShieldedInstanceConfigList;
    get tags(): string[];
    get tagsFingerprint(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
