import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeNodeTypesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_node_types#id DataGoogleComputeNodeTypes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_node_types#project DataGoogleComputeNodeTypes#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_node_types#zone DataGoogleComputeNodeTypes#zone}
    */
    readonly zone?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_node_types google_compute_node_types}
*/
export declare class DataGoogleComputeNodeTypes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_node_types";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_node_types google_compute_node_types} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeNodeTypesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleComputeNodeTypesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get names(): string[];
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
