import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleContainerAttachedVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_attached_versions#id DataGoogleContainerAttachedVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_attached_versions#location DataGoogleContainerAttachedVersions#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_attached_versions#project DataGoogleContainerAttachedVersions#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/container_attached_versions google_container_attached_versions}
*/
export declare class DataGoogleContainerAttachedVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_container_attached_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_attached_versions google_container_attached_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleContainerAttachedVersionsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleContainerAttachedVersionsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get validVersions(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
