import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleLoggingProjectCmekSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/logging_project_cmek_settings#id DataGoogleLoggingProjectCmekSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name for the configured Cloud KMS key.
                  KMS key name format:
                  "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
                  To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
                  The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
                  See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/logging_project_cmek_settings#kms_key_name DataGoogleLoggingProjectCmekSettings#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/logging_project_cmek_settings#project DataGoogleLoggingProjectCmekSettings#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/logging_project_cmek_settings google_logging_project_cmek_settings}
*/
export declare class DataGoogleLoggingProjectCmekSettings extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_logging_project_cmek_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/logging_project_cmek_settings google_logging_project_cmek_settings} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleLoggingProjectCmekSettingsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleLoggingProjectCmekSettingsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    get kmsKeyVersionName(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get serviceAccountId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
