import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlDatabaseInstancesConfig extends cdktf.TerraformMetaArguments {
    /**
    * To filter out the database instances which are of the specified database version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances#database_version DataGoogleSqlDatabaseInstances#database_version}
    */
    readonly databaseVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances#id DataGoogleSqlDatabaseInstances#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Project ID of the project that contains the instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances#project DataGoogleSqlDatabaseInstances#project}
    */
    readonly project?: string;
    /**
    * To filter out the database instances which are located in this specified region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances#region DataGoogleSqlDatabaseInstances#region}
    */
    readonly region?: string;
    /**
    * To filter out the database instances based on the current state of the database instance, valid values include : "SQL_INSTANCE_STATE_UNSPECIFIED", "RUNNABLE", "SUSPENDED", "PENDING_DELETE", "PENDING_CREATE", "MAINTENANCE" and "FAILED".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances#state DataGoogleSqlDatabaseInstances#state}
    */
    readonly state?: string;
    /**
    * To filter out the database instances based on the machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances#tier DataGoogleSqlDatabaseInstances#tier}
    */
    readonly tier?: string;
    /**
    * To filter out the database instances which are located in this specified zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances#zone DataGoogleSqlDatabaseInstances#zone}
    */
    readonly zone?: string;
}
export interface DataGoogleSqlDatabaseInstancesInstancesClone {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesCloneToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesClone): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesCloneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesClone | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesClone | undefined);
    get allocatedIpRange(): string;
    get pointInTime(): string;
    get sourceInstanceName(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesCloneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesCloneOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesIpAddress {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesIpAddressToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesIpAddress): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesIpAddress | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesIpAddress | undefined);
    get ipAddress(): string;
    get timeToRetire(): string;
    get type(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesIpAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesIpAddressOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesReplicaConfiguration {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesReplicaConfigurationToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesReplicaConfiguration): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesReplicaConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesReplicaConfiguration | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesReplicaConfiguration | undefined);
    get caCertificate(): string;
    get clientCertificate(): string;
    get clientKey(): string;
    get connectRetryInterval(): number;
    get dumpFilePath(): string;
    get failoverTarget(): cdktf.IResolvable;
    get masterHeartbeatPeriod(): number;
    get password(): string;
    get sslCipher(): string;
    get username(): string;
    get verifyServerCertificate(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesReplicaConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesReplicaConfigurationOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContext {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesRestoreBackupContextToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContext): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContext | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContext | undefined);
    get backupRunId(): number;
    get instanceId(): string;
    get project(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContextList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContextOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesServerCaCert {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesServerCaCertToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesServerCaCert): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesServerCaCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesServerCaCert | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesServerCaCert | undefined);
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesServerCaCertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesServerCaCertOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfig {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfigToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfig): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfig | undefined);
    get domain(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettings {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettingsToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettings): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettings | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettings | undefined);
    get retainedBackups(): number;
    get retentionUnit(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettingsOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfiguration {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfiguration): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfiguration | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfiguration | undefined);
    private _backupRetentionSettings;
    get backupRetentionSettings(): DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationBackupRetentionSettingsList;
    get binaryLogEnabled(): cdktf.IResolvable;
    get enabled(): cdktf.IResolvable;
    get location(): string;
    get pointInTimeRecoveryEnabled(): cdktf.IResolvable;
    get startTime(): string;
    get transactionLogRetentionDays(): number;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlags {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlagsToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlags): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlags | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlags | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlagsOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriod {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriodToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriod): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriod | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriod | undefined);
    get endDate(): string;
    get startDate(): string;
    get time(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriodOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfig {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfigToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfig): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfig | undefined);
    get queryInsightsEnabled(): cdktf.IResolvable;
    get queryPlansPerMinute(): number;
    get queryStringLength(): number;
    get recordApplicationTags(): cdktf.IResolvable;
    get recordClientAddress(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworks {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworksToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworks): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworks | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworks | undefined);
    get expirationTime(): string;
    get name(): string;
    get value(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworksOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfiguration {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfiguration): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfiguration | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfiguration | undefined);
    get allocatedIpRange(): string;
    private _authorizedNetworks;
    get authorizedNetworks(): DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationAuthorizedNetworksList;
    get enablePrivatePathForGoogleCloudServices(): cdktf.IResolvable;
    get ipv4Enabled(): cdktf.IResolvable;
    get privateNetwork(): string;
    get requireSsl(): cdktf.IResolvable;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreference {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreferenceToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreference): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreference | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreference | undefined);
    get followGaeApplication(): string;
    get secondaryZone(): string;
    get zone(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreferenceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreferenceOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindow {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindowToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindow): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindow | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindow | undefined);
    get day(): number;
    get hour(): number;
    get updateTrack(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindowOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicy {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicyToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicy): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicy | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicy | undefined);
    get complexity(): string;
    get disallowUsernameSubstring(): cdktf.IResolvable;
    get enablePasswordPolicy(): cdktf.IResolvable;
    get minLength(): number;
    get passwordChangeInterval(): string;
    get reuseInterval(): number;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicyOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfig {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfigToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfig): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfig | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfig | undefined);
    get bucket(): string;
    get retentionInterval(): string;
    get uploadInterval(): string;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfigOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstancesSettings {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesSettingsToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstancesSettings): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstancesSettings | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstancesSettings | undefined);
    get activationPolicy(): string;
    private _activeDirectoryConfig;
    get activeDirectoryConfig(): DataGoogleSqlDatabaseInstancesInstancesSettingsActiveDirectoryConfigList;
    get availabilityType(): string;
    private _backupConfiguration;
    get backupConfiguration(): DataGoogleSqlDatabaseInstancesInstancesSettingsBackupConfigurationList;
    get collation(): string;
    get connectorEnforcement(): string;
    private _databaseFlags;
    get databaseFlags(): DataGoogleSqlDatabaseInstancesInstancesSettingsDatabaseFlagsList;
    get deletionProtectionEnabled(): cdktf.IResolvable;
    private _denyMaintenancePeriod;
    get denyMaintenancePeriod(): DataGoogleSqlDatabaseInstancesInstancesSettingsDenyMaintenancePeriodList;
    get diskAutoresize(): cdktf.IResolvable;
    get diskAutoresizeLimit(): number;
    get diskSize(): number;
    get diskType(): string;
    private _insightsConfig;
    get insightsConfig(): DataGoogleSqlDatabaseInstancesInstancesSettingsInsightsConfigList;
    private _ipConfiguration;
    get ipConfiguration(): DataGoogleSqlDatabaseInstancesInstancesSettingsIpConfigurationList;
    private _locationPreference;
    get locationPreference(): DataGoogleSqlDatabaseInstancesInstancesSettingsLocationPreferenceList;
    private _maintenanceWindow;
    get maintenanceWindow(): DataGoogleSqlDatabaseInstancesInstancesSettingsMaintenanceWindowList;
    private _passwordValidationPolicy;
    get passwordValidationPolicy(): DataGoogleSqlDatabaseInstancesInstancesSettingsPasswordValidationPolicyList;
    get pricingPlan(): string;
    private _sqlServerAuditConfig;
    get sqlServerAuditConfig(): DataGoogleSqlDatabaseInstancesInstancesSettingsSqlServerAuditConfigList;
    get tier(): string;
    get timeZone(): string;
    private _userLabels;
    get userLabels(): cdktf.StringMap;
    get version(): number;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesSettingsOutputReference;
}
export interface DataGoogleSqlDatabaseInstancesInstances {
}
export declare function dataGoogleSqlDatabaseInstancesInstancesToTerraform(struct?: DataGoogleSqlDatabaseInstancesInstances): any;
export declare class DataGoogleSqlDatabaseInstancesInstancesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlDatabaseInstancesInstances | undefined;
    set internalValue(value: DataGoogleSqlDatabaseInstancesInstances | undefined);
    get availableMaintenanceVersions(): string[];
    private _clone;
    get clone(): DataGoogleSqlDatabaseInstancesInstancesCloneList;
    get connectionName(): string;
    get databaseVersion(): string;
    get deletionProtection(): cdktf.IResolvable;
    get encryptionKeyName(): string;
    get firstIpAddress(): string;
    get instanceType(): string;
    private _ipAddress;
    get ipAddress(): DataGoogleSqlDatabaseInstancesInstancesIpAddressList;
    get maintenanceVersion(): string;
    get masterInstanceName(): string;
    get name(): string;
    get privateIpAddress(): string;
    get project(): string;
    get publicIpAddress(): string;
    get region(): string;
    private _replicaConfiguration;
    get replicaConfiguration(): DataGoogleSqlDatabaseInstancesInstancesReplicaConfigurationList;
    private _restoreBackupContext;
    get restoreBackupContext(): DataGoogleSqlDatabaseInstancesInstancesRestoreBackupContextList;
    get rootPassword(): string;
    get selfLink(): string;
    private _serverCaCert;
    get serverCaCert(): DataGoogleSqlDatabaseInstancesInstancesServerCaCertList;
    get serviceAccountEmailAddress(): string;
    private _settings;
    get settings(): DataGoogleSqlDatabaseInstancesInstancesSettingsList;
}
export declare class DataGoogleSqlDatabaseInstancesInstancesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlDatabaseInstancesInstancesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances google_sql_database_instances}
*/
export declare class DataGoogleSqlDatabaseInstances extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sql_database_instances";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/sql_database_instances google_sql_database_instances} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSqlDatabaseInstancesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleSqlDatabaseInstancesConfig);
    private _databaseVersion?;
    get databaseVersion(): string;
    set databaseVersion(value: string);
    resetDatabaseVersion(): void;
    get databaseVersionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instances;
    get instances(): DataGoogleSqlDatabaseInstancesInstancesList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    resetTier(): void;
    get tierInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
