import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageProjectServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account#id DataGoogleStorageProjectServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account#project DataGoogleStorageProjectServiceAccount#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account#user_project DataGoogleStorageProjectServiceAccount#user_project}
    */
    readonly userProject?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account google_storage_project_service_account}
*/
export declare class DataGoogleStorageProjectServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_storage_project_service_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_project_service_account google_storage_project_service_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleStorageProjectServiceAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleStorageProjectServiceAccountConfig);
    get emailAddress(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get member(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _userProject?;
    get userProject(): string;
    set userProject(value: string);
    resetUserProject(): void;
    get userProjectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
