import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageTransferProjectServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_transfer_project_service_account#id DataGoogleStorageTransferProjectServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_transfer_project_service_account#project DataGoogleStorageTransferProjectServiceAccount#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_transfer_project_service_account google_storage_transfer_project_service_account}
*/
export declare class DataGoogleStorageTransferProjectServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_storage_transfer_project_service_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_transfer_project_service_account google_storage_transfer_project_service_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleStorageTransferProjectServiceAccountConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleStorageTransferProjectServiceAccountConfig);
    get email(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get member(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get subjectId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
