import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataplexAssetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The zone for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#dataplex_zone DataplexAsset#dataplex_zone}
    */
    readonly dataplexZone: string;
    /**
    * Optional. Description of the asset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#description DataplexAsset#description}
    */
    readonly description?: string;
    /**
    * Optional. User friendly display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#display_name DataplexAsset#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#id DataplexAsset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. User defined labels for the asset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#labels DataplexAsset#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The lake for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#lake DataplexAsset#lake}
    */
    readonly lake: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#location DataplexAsset#location}
    */
    readonly location: string;
    /**
    * The name of the asset.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#name DataplexAsset#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#project DataplexAsset#project}
    */
    readonly project?: string;
    /**
    * discovery_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#discovery_spec DataplexAsset#discovery_spec}
    */
    readonly discoverySpec: DataplexAssetDiscoverySpec;
    /**
    * resource_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#resource_spec DataplexAsset#resource_spec}
    */
    readonly resourceSpec: DataplexAssetResourceSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#timeouts DataplexAsset#timeouts}
    */
    readonly timeouts?: DataplexAssetTimeouts;
}
export interface DataplexAssetDiscoveryStatusStats {
}
export declare function dataplexAssetDiscoveryStatusStatsToTerraform(struct?: DataplexAssetDiscoveryStatusStats): any;
export declare class DataplexAssetDiscoveryStatusStatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataplexAssetDiscoveryStatusStats | undefined;
    set internalValue(value: DataplexAssetDiscoveryStatusStats | undefined);
    get dataItems(): number;
    get dataSize(): number;
    get filesets(): number;
    get tables(): number;
}
export declare class DataplexAssetDiscoveryStatusStatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataplexAssetDiscoveryStatusStatsOutputReference;
}
export interface DataplexAssetDiscoveryStatus {
}
export declare function dataplexAssetDiscoveryStatusToTerraform(struct?: DataplexAssetDiscoveryStatus): any;
export declare class DataplexAssetDiscoveryStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataplexAssetDiscoveryStatus | undefined;
    set internalValue(value: DataplexAssetDiscoveryStatus | undefined);
    get lastRunDuration(): string;
    get lastRunTime(): string;
    get message(): string;
    get state(): string;
    private _stats;
    get stats(): DataplexAssetDiscoveryStatusStatsList;
    get updateTime(): string;
}
export declare class DataplexAssetDiscoveryStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataplexAssetDiscoveryStatusOutputReference;
}
export interface DataplexAssetResourceStatus {
}
export declare function dataplexAssetResourceStatusToTerraform(struct?: DataplexAssetResourceStatus): any;
export declare class DataplexAssetResourceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataplexAssetResourceStatus | undefined;
    set internalValue(value: DataplexAssetResourceStatus | undefined);
    get message(): string;
    get state(): string;
    get updateTime(): string;
}
export declare class DataplexAssetResourceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataplexAssetResourceStatusOutputReference;
}
export interface DataplexAssetSecurityStatus {
}
export declare function dataplexAssetSecurityStatusToTerraform(struct?: DataplexAssetSecurityStatus): any;
export declare class DataplexAssetSecurityStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataplexAssetSecurityStatus | undefined;
    set internalValue(value: DataplexAssetSecurityStatus | undefined);
    get message(): string;
    get state(): string;
    get updateTime(): string;
}
export declare class DataplexAssetSecurityStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataplexAssetSecurityStatusOutputReference;
}
export interface DataplexAssetDiscoverySpecCsvOptions {
    /**
    * Optional. The delimiter being used to separate values. This defaults to ','.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#delimiter DataplexAsset#delimiter}
    */
    readonly delimiter?: string;
    /**
    * Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#disable_type_inference DataplexAsset#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#encoding DataplexAsset#encoding}
    */
    readonly encoding?: string;
    /**
    * Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#header_rows DataplexAsset#header_rows}
    */
    readonly headerRows?: number;
}
export declare function dataplexAssetDiscoverySpecCsvOptionsToTerraform(struct?: DataplexAssetDiscoverySpecCsvOptionsOutputReference | DataplexAssetDiscoverySpecCsvOptions): any;
export declare class DataplexAssetDiscoverySpecCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexAssetDiscoverySpecCsvOptions | undefined;
    set internalValue(value: DataplexAssetDiscoverySpecCsvOptions | undefined);
    private _delimiter?;
    get delimiter(): string;
    set delimiter(value: string);
    resetDelimiter(): void;
    get delimiterInput(): string | undefined;
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _headerRows?;
    get headerRows(): number;
    set headerRows(value: number);
    resetHeaderRows(): void;
    get headerRowsInput(): number | undefined;
}
export interface DataplexAssetDiscoverySpecJsonOptions {
    /**
    * Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#disable_type_inference DataplexAsset#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#encoding DataplexAsset#encoding}
    */
    readonly encoding?: string;
}
export declare function dataplexAssetDiscoverySpecJsonOptionsToTerraform(struct?: DataplexAssetDiscoverySpecJsonOptionsOutputReference | DataplexAssetDiscoverySpecJsonOptions): any;
export declare class DataplexAssetDiscoverySpecJsonOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexAssetDiscoverySpecJsonOptions | undefined;
    set internalValue(value: DataplexAssetDiscoverySpecJsonOptions | undefined);
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
}
export interface DataplexAssetDiscoverySpec {
    /**
    * Required. Whether discovery is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#enabled DataplexAsset#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#exclude_patterns DataplexAsset#exclude_patterns}
    */
    readonly excludePatterns?: string[];
    /**
    * Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#include_patterns DataplexAsset#include_patterns}
    */
    readonly includePatterns?: string[];
    /**
    * Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#schedule DataplexAsset#schedule}
    */
    readonly schedule?: string;
    /**
    * csv_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#csv_options DataplexAsset#csv_options}
    */
    readonly csvOptions?: DataplexAssetDiscoverySpecCsvOptions;
    /**
    * json_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#json_options DataplexAsset#json_options}
    */
    readonly jsonOptions?: DataplexAssetDiscoverySpecJsonOptions;
}
export declare function dataplexAssetDiscoverySpecToTerraform(struct?: DataplexAssetDiscoverySpecOutputReference | DataplexAssetDiscoverySpec): any;
export declare class DataplexAssetDiscoverySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexAssetDiscoverySpec | undefined;
    set internalValue(value: DataplexAssetDiscoverySpec | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _excludePatterns?;
    get excludePatterns(): string[];
    set excludePatterns(value: string[]);
    resetExcludePatterns(): void;
    get excludePatternsInput(): string[] | undefined;
    private _includePatterns?;
    get includePatterns(): string[];
    set includePatterns(value: string[]);
    resetIncludePatterns(): void;
    get includePatternsInput(): string[] | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _csvOptions;
    get csvOptions(): DataplexAssetDiscoverySpecCsvOptionsOutputReference;
    putCsvOptions(value: DataplexAssetDiscoverySpecCsvOptions): void;
    resetCsvOptions(): void;
    get csvOptionsInput(): DataplexAssetDiscoverySpecCsvOptions | undefined;
    private _jsonOptions;
    get jsonOptions(): DataplexAssetDiscoverySpecJsonOptionsOutputReference;
    putJsonOptions(value: DataplexAssetDiscoverySpecJsonOptions): void;
    resetJsonOptions(): void;
    get jsonOptionsInput(): DataplexAssetDiscoverySpecJsonOptions | undefined;
}
export interface DataplexAssetResourceSpec {
    /**
    * Immutable. Relative name of the cloud resource that contains the data that is being managed within a lake. For example: `projects/{project_number}/buckets/{bucket_id}` `projects/{project_number}/datasets/{dataset_id}`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#name DataplexAsset#name}
    */
    readonly name?: string;
    /**
    * Required. Immutable. Type of resource. Possible values: STORAGE_BUCKET, BIGQUERY_DATASET
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#type DataplexAsset#type}
    */
    readonly type: string;
}
export declare function dataplexAssetResourceSpecToTerraform(struct?: DataplexAssetResourceSpecOutputReference | DataplexAssetResourceSpec): any;
export declare class DataplexAssetResourceSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexAssetResourceSpec | undefined;
    set internalValue(value: DataplexAssetResourceSpec | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DataplexAssetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#create DataplexAsset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#delete DataplexAsset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset#update DataplexAsset#update}
    */
    readonly update?: string;
}
export declare function dataplexAssetTimeoutsToTerraform(struct?: DataplexAssetTimeoutsOutputReference | DataplexAssetTimeouts | cdktf.IResolvable): any;
export declare class DataplexAssetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexAssetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataplexAssetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset google_dataplex_asset}
*/
export declare class DataplexAsset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_asset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataplex_asset google_dataplex_asset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataplexAssetConfig
    */
    constructor(scope: Construct, id: string, config: DataplexAssetConfig);
    get createTime(): string;
    private _dataplexZone?;
    get dataplexZone(): string;
    set dataplexZone(value: string);
    get dataplexZoneInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _discoveryStatus;
    get discoveryStatus(): DataplexAssetDiscoveryStatusList;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lake?;
    get lake(): string;
    set lake(value: string);
    get lakeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourceStatus;
    get resourceStatus(): DataplexAssetResourceStatusList;
    private _securityStatus;
    get securityStatus(): DataplexAssetSecurityStatusList;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _discoverySpec;
    get discoverySpec(): DataplexAssetDiscoverySpecOutputReference;
    putDiscoverySpec(value: DataplexAssetDiscoverySpec): void;
    get discoverySpecInput(): DataplexAssetDiscoverySpec | undefined;
    private _resourceSpec;
    get resourceSpec(): DataplexAssetResourceSpecOutputReference;
    putResourceSpec(value: DataplexAssetResourceSpec): void;
    get resourceSpecInput(): DataplexAssetResourceSpec | undefined;
    private _timeouts;
    get timeouts(): DataplexAssetTimeoutsOutputReference;
    putTimeouts(value: DataplexAssetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataplexAssetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
