import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataplexZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Description of the zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#description DataplexZone#description}
    */
    readonly description?: string;
    /**
    * Optional. User friendly display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#display_name DataplexZone#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#id DataplexZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. User defined labels for the zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#labels DataplexZone#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The lake for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#lake DataplexZone#lake}
    */
    readonly lake: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#location DataplexZone#location}
    */
    readonly location: string;
    /**
    * The name of the zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#name DataplexZone#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#project DataplexZone#project}
    */
    readonly project?: string;
    /**
    * Required. Immutable. The type of the zone. Possible values: TYPE_UNSPECIFIED, RAW, CURATED
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#type DataplexZone#type}
    */
    readonly type: string;
    /**
    * discovery_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#discovery_spec DataplexZone#discovery_spec}
    */
    readonly discoverySpec: DataplexZoneDiscoverySpec;
    /**
    * resource_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#resource_spec DataplexZone#resource_spec}
    */
    readonly resourceSpec: DataplexZoneResourceSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#timeouts DataplexZone#timeouts}
    */
    readonly timeouts?: DataplexZoneTimeouts;
}
export interface DataplexZoneAssetStatus {
}
export declare function dataplexZoneAssetStatusToTerraform(struct?: DataplexZoneAssetStatus): any;
export declare class DataplexZoneAssetStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataplexZoneAssetStatus | undefined;
    set internalValue(value: DataplexZoneAssetStatus | undefined);
    get activeAssets(): number;
    get securityPolicyApplyingAssets(): number;
    get updateTime(): string;
}
export declare class DataplexZoneAssetStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataplexZoneAssetStatusOutputReference;
}
export interface DataplexZoneDiscoverySpecCsvOptions {
    /**
    * Optional. The delimiter being used to separate values. This defaults to ','.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#delimiter DataplexZone#delimiter}
    */
    readonly delimiter?: string;
    /**
    * Optional. Whether to disable the inference of data type for CSV data. If true, all columns will be registered as strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#disable_type_inference DataplexZone#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#encoding DataplexZone#encoding}
    */
    readonly encoding?: string;
    /**
    * Optional. The number of rows to interpret as header rows that should be skipped when reading data rows.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#header_rows DataplexZone#header_rows}
    */
    readonly headerRows?: number;
}
export declare function dataplexZoneDiscoverySpecCsvOptionsToTerraform(struct?: DataplexZoneDiscoverySpecCsvOptionsOutputReference | DataplexZoneDiscoverySpecCsvOptions): any;
export declare class DataplexZoneDiscoverySpecCsvOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexZoneDiscoverySpecCsvOptions | undefined;
    set internalValue(value: DataplexZoneDiscoverySpecCsvOptions | undefined);
    private _delimiter?;
    get delimiter(): string;
    set delimiter(value: string);
    resetDelimiter(): void;
    get delimiterInput(): string | undefined;
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
    private _headerRows?;
    get headerRows(): number;
    set headerRows(value: number);
    resetHeaderRows(): void;
    get headerRowsInput(): number | undefined;
}
export interface DataplexZoneDiscoverySpecJsonOptions {
    /**
    * Optional. Whether to disable the inference of data type for Json data. If true, all columns will be registered as their primitive types (strings, number or boolean).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#disable_type_inference DataplexZone#disable_type_inference}
    */
    readonly disableTypeInference?: boolean | cdktf.IResolvable;
    /**
    * Optional. The character encoding of the data. The default is UTF-8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#encoding DataplexZone#encoding}
    */
    readonly encoding?: string;
}
export declare function dataplexZoneDiscoverySpecJsonOptionsToTerraform(struct?: DataplexZoneDiscoverySpecJsonOptionsOutputReference | DataplexZoneDiscoverySpecJsonOptions): any;
export declare class DataplexZoneDiscoverySpecJsonOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexZoneDiscoverySpecJsonOptions | undefined;
    set internalValue(value: DataplexZoneDiscoverySpecJsonOptions | undefined);
    private _disableTypeInference?;
    get disableTypeInference(): boolean | cdktf.IResolvable;
    set disableTypeInference(value: boolean | cdktf.IResolvable);
    resetDisableTypeInference(): void;
    get disableTypeInferenceInput(): boolean | cdktf.IResolvable | undefined;
    private _encoding?;
    get encoding(): string;
    set encoding(value: string);
    resetEncoding(): void;
    get encodingInput(): string | undefined;
}
export interface DataplexZoneDiscoverySpec {
    /**
    * Required. Whether discovery is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#enabled DataplexZone#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Optional. The list of patterns to apply for selecting data to exclude during discovery. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#exclude_patterns DataplexZone#exclude_patterns}
    */
    readonly excludePatterns?: string[];
    /**
    * Optional. The list of patterns to apply for selecting data to include during discovery if only a subset of the data should considered. For Cloud Storage bucket assets, these are interpreted as glob patterns used to match object names. For BigQuery dataset assets, these are interpreted as patterns to match table names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#include_patterns DataplexZone#include_patterns}
    */
    readonly includePatterns?: string[];
    /**
    * Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running discovery periodically. Successive discovery runs must be scheduled at least 60 minutes apart. The default value is to run discovery every 60 minutes. To explicitly set a timezone to the cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone database. For example, "CRON_TZ=America/New_York 1 * * * *", or "TZ=America/New_York 1 * * * *".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#schedule DataplexZone#schedule}
    */
    readonly schedule?: string;
    /**
    * csv_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#csv_options DataplexZone#csv_options}
    */
    readonly csvOptions?: DataplexZoneDiscoverySpecCsvOptions;
    /**
    * json_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#json_options DataplexZone#json_options}
    */
    readonly jsonOptions?: DataplexZoneDiscoverySpecJsonOptions;
}
export declare function dataplexZoneDiscoverySpecToTerraform(struct?: DataplexZoneDiscoverySpecOutputReference | DataplexZoneDiscoverySpec): any;
export declare class DataplexZoneDiscoverySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexZoneDiscoverySpec | undefined;
    set internalValue(value: DataplexZoneDiscoverySpec | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _excludePatterns?;
    get excludePatterns(): string[];
    set excludePatterns(value: string[]);
    resetExcludePatterns(): void;
    get excludePatternsInput(): string[] | undefined;
    private _includePatterns?;
    get includePatterns(): string[];
    set includePatterns(value: string[]);
    resetIncludePatterns(): void;
    get includePatternsInput(): string[] | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    resetSchedule(): void;
    get scheduleInput(): string | undefined;
    private _csvOptions;
    get csvOptions(): DataplexZoneDiscoverySpecCsvOptionsOutputReference;
    putCsvOptions(value: DataplexZoneDiscoverySpecCsvOptions): void;
    resetCsvOptions(): void;
    get csvOptionsInput(): DataplexZoneDiscoverySpecCsvOptions | undefined;
    private _jsonOptions;
    get jsonOptions(): DataplexZoneDiscoverySpecJsonOptionsOutputReference;
    putJsonOptions(value: DataplexZoneDiscoverySpecJsonOptions): void;
    resetJsonOptions(): void;
    get jsonOptionsInput(): DataplexZoneDiscoverySpecJsonOptions | undefined;
}
export interface DataplexZoneResourceSpec {
    /**
    * Required. Immutable. The location type of the resources that are allowed to be attached to the assets within this zone. Possible values: LOCATION_TYPE_UNSPECIFIED, SINGLE_REGION, MULTI_REGION
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#location_type DataplexZone#location_type}
    */
    readonly locationType: string;
}
export declare function dataplexZoneResourceSpecToTerraform(struct?: DataplexZoneResourceSpecOutputReference | DataplexZoneResourceSpec): any;
export declare class DataplexZoneResourceSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexZoneResourceSpec | undefined;
    set internalValue(value: DataplexZoneResourceSpec | undefined);
    private _locationType?;
    get locationType(): string;
    set locationType(value: string);
    get locationTypeInput(): string | undefined;
}
export interface DataplexZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#create DataplexZone#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#delete DataplexZone#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone#update DataplexZone#update}
    */
    readonly update?: string;
}
export declare function dataplexZoneTimeoutsToTerraform(struct?: DataplexZoneTimeoutsOutputReference | DataplexZoneTimeouts | cdktf.IResolvable): any;
export declare class DataplexZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataplexZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataplexZoneTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone google_dataplex_zone}
*/
export declare class DataplexZone extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataplex_zone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataplex_zone google_dataplex_zone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataplexZoneConfig
    */
    constructor(scope: Construct, id: string, config: DataplexZoneConfig);
    private _assetStatus;
    get assetStatus(): DataplexZoneAssetStatusList;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lake?;
    get lake(): string;
    set lake(value: string);
    get lakeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _discoverySpec;
    get discoverySpec(): DataplexZoneDiscoverySpecOutputReference;
    putDiscoverySpec(value: DataplexZoneDiscoverySpec): void;
    get discoverySpecInput(): DataplexZoneDiscoverySpec | undefined;
    private _resourceSpec;
    get resourceSpec(): DataplexZoneResourceSpecOutputReference;
    putResourceSpec(value: DataplexZoneResourceSpec): void;
    get resourceSpecInput(): DataplexZoneResourceSpec | undefined;
    private _timeouts;
    get timeouts(): DataplexZoneTimeoutsOutputReference;
    putTimeouts(value: DataplexZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataplexZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
