import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatastreamConnectionProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * The connection profile identifier.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#connection_profile_id DatastreamConnectionProfile#connection_profile_id}
    */
    readonly connectionProfileId: string;
    /**
    * Display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#display_name DatastreamConnectionProfile#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#id DatastreamConnectionProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#labels DatastreamConnectionProfile#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this connection profile is located in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#location DatastreamConnectionProfile#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#project DatastreamConnectionProfile#project}
    */
    readonly project?: string;
    /**
    * bigquery_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#bigquery_profile DatastreamConnectionProfile#bigquery_profile}
    */
    readonly bigqueryProfile?: DatastreamConnectionProfileBigqueryProfile;
    /**
    * forward_ssh_connectivity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#forward_ssh_connectivity DatastreamConnectionProfile#forward_ssh_connectivity}
    */
    readonly forwardSshConnectivity?: DatastreamConnectionProfileForwardSshConnectivity;
    /**
    * gcs_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#gcs_profile DatastreamConnectionProfile#gcs_profile}
    */
    readonly gcsProfile?: DatastreamConnectionProfileGcsProfile;
    /**
    * mysql_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#mysql_profile DatastreamConnectionProfile#mysql_profile}
    */
    readonly mysqlProfile?: DatastreamConnectionProfileMysqlProfile;
    /**
    * oracle_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#oracle_profile DatastreamConnectionProfile#oracle_profile}
    */
    readonly oracleProfile?: DatastreamConnectionProfileOracleProfile;
    /**
    * postgresql_profile block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#postgresql_profile DatastreamConnectionProfile#postgresql_profile}
    */
    readonly postgresqlProfile?: DatastreamConnectionProfilePostgresqlProfile;
    /**
    * private_connectivity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#private_connectivity DatastreamConnectionProfile#private_connectivity}
    */
    readonly privateConnectivity?: DatastreamConnectionProfilePrivateConnectivity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#timeouts DatastreamConnectionProfile#timeouts}
    */
    readonly timeouts?: DatastreamConnectionProfileTimeouts;
}
export interface DatastreamConnectionProfileBigqueryProfile {
}
export declare function datastreamConnectionProfileBigqueryProfileToTerraform(struct?: DatastreamConnectionProfileBigqueryProfileOutputReference | DatastreamConnectionProfileBigqueryProfile): any;
export declare class DatastreamConnectionProfileBigqueryProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfileBigqueryProfile | undefined;
    set internalValue(value: DatastreamConnectionProfileBigqueryProfile | undefined);
}
export interface DatastreamConnectionProfileForwardSshConnectivity {
    /**
    * Hostname for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#hostname DatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * SSH password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#password DatastreamConnectionProfile#password}
    */
    readonly password?: string;
    /**
    * Port for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#port DatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * SSH private key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#private_key DatastreamConnectionProfile#private_key}
    */
    readonly privateKey?: string;
    /**
    * Username for the SSH tunnel.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#username DatastreamConnectionProfile#username}
    */
    readonly username: string;
}
export declare function datastreamConnectionProfileForwardSshConnectivityToTerraform(struct?: DatastreamConnectionProfileForwardSshConnectivityOutputReference | DatastreamConnectionProfileForwardSshConnectivity): any;
export declare class DatastreamConnectionProfileForwardSshConnectivityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfileForwardSshConnectivity | undefined;
    set internalValue(value: DatastreamConnectionProfileForwardSshConnectivity | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _privateKey?;
    get privateKey(): string;
    set privateKey(value: string);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DatastreamConnectionProfileGcsProfile {
    /**
    * The Cloud Storage bucket name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#bucket DatastreamConnectionProfile#bucket}
    */
    readonly bucket: string;
    /**
    * The root path inside the Cloud Storage bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#root_path DatastreamConnectionProfile#root_path}
    */
    readonly rootPath?: string;
}
export declare function datastreamConnectionProfileGcsProfileToTerraform(struct?: DatastreamConnectionProfileGcsProfileOutputReference | DatastreamConnectionProfileGcsProfile): any;
export declare class DatastreamConnectionProfileGcsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfileGcsProfile | undefined;
    set internalValue(value: DatastreamConnectionProfileGcsProfile | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _rootPath?;
    get rootPath(): string;
    set rootPath(value: string);
    resetRootPath(): void;
    get rootPathInput(): string | undefined;
}
export interface DatastreamConnectionProfileMysqlProfileSslConfig {
    /**
    * PEM-encoded certificate of the CA that signed the source database
  server's certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#ca_certificate DatastreamConnectionProfile#ca_certificate}
    */
    readonly caCertificate?: string;
    /**
    * PEM-encoded certificate that will be used by the replica to
  authenticate against the source database server. If this field
  is used then the 'clientKey' and the 'caCertificate' fields are
  mandatory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#client_certificate DatastreamConnectionProfile#client_certificate}
    */
    readonly clientCertificate?: string;
    /**
    * PEM-encoded private key associated with the Client Certificate.
  If this field is used then the 'client_certificate' and the
  'ca_certificate' fields are mandatory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#client_key DatastreamConnectionProfile#client_key}
    */
    readonly clientKey?: string;
}
export declare function datastreamConnectionProfileMysqlProfileSslConfigToTerraform(struct?: DatastreamConnectionProfileMysqlProfileSslConfigOutputReference | DatastreamConnectionProfileMysqlProfileSslConfig): any;
export declare class DatastreamConnectionProfileMysqlProfileSslConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfileMysqlProfileSslConfig | undefined;
    set internalValue(value: DatastreamConnectionProfileMysqlProfileSslConfig | undefined);
    private _caCertificate?;
    get caCertificate(): string;
    set caCertificate(value: string);
    resetCaCertificate(): void;
    get caCertificateInput(): string | undefined;
    get caCertificateSet(): cdktf.IResolvable;
    private _clientCertificate?;
    get clientCertificate(): string;
    set clientCertificate(value: string);
    resetClientCertificate(): void;
    get clientCertificateInput(): string | undefined;
    get clientCertificateSet(): cdktf.IResolvable;
    private _clientKey?;
    get clientKey(): string;
    set clientKey(value: string);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    get clientKeySet(): cdktf.IResolvable;
}
export interface DatastreamConnectionProfileMysqlProfile {
    /**
    * Hostname for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#hostname DatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * Password for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#password DatastreamConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Port for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#port DatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * Username for the MySQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#username DatastreamConnectionProfile#username}
    */
    readonly username: string;
    /**
    * ssl_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#ssl_config DatastreamConnectionProfile#ssl_config}
    */
    readonly sslConfig?: DatastreamConnectionProfileMysqlProfileSslConfig;
}
export declare function datastreamConnectionProfileMysqlProfileToTerraform(struct?: DatastreamConnectionProfileMysqlProfileOutputReference | DatastreamConnectionProfileMysqlProfile): any;
export declare class DatastreamConnectionProfileMysqlProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfileMysqlProfile | undefined;
    set internalValue(value: DatastreamConnectionProfileMysqlProfile | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _sslConfig;
    get sslConfig(): DatastreamConnectionProfileMysqlProfileSslConfigOutputReference;
    putSslConfig(value: DatastreamConnectionProfileMysqlProfileSslConfig): void;
    resetSslConfig(): void;
    get sslConfigInput(): DatastreamConnectionProfileMysqlProfileSslConfig | undefined;
}
export interface DatastreamConnectionProfileOracleProfile {
    /**
    * Connection string attributes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#connection_attributes DatastreamConnectionProfile#connection_attributes}
    */
    readonly connectionAttributes?: {
        [key: string]: string;
    };
    /**
    * Database for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#database_service DatastreamConnectionProfile#database_service}
    */
    readonly databaseService: string;
    /**
    * Hostname for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#hostname DatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * Password for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#password DatastreamConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Port for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#port DatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * Username for the Oracle connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#username DatastreamConnectionProfile#username}
    */
    readonly username: string;
}
export declare function datastreamConnectionProfileOracleProfileToTerraform(struct?: DatastreamConnectionProfileOracleProfileOutputReference | DatastreamConnectionProfileOracleProfile): any;
export declare class DatastreamConnectionProfileOracleProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfileOracleProfile | undefined;
    set internalValue(value: DatastreamConnectionProfileOracleProfile | undefined);
    private _connectionAttributes?;
    get connectionAttributes(): {
        [key: string]: string;
    };
    set connectionAttributes(value: {
        [key: string]: string;
    });
    resetConnectionAttributes(): void;
    get connectionAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _databaseService?;
    get databaseService(): string;
    set databaseService(value: string);
    get databaseServiceInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DatastreamConnectionProfilePostgresqlProfile {
    /**
    * Database for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#database DatastreamConnectionProfile#database}
    */
    readonly database: string;
    /**
    * Hostname for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#hostname DatastreamConnectionProfile#hostname}
    */
    readonly hostname: string;
    /**
    * Password for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#password DatastreamConnectionProfile#password}
    */
    readonly password: string;
    /**
    * Port for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#port DatastreamConnectionProfile#port}
    */
    readonly port?: number;
    /**
    * Username for the PostgreSQL connection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#username DatastreamConnectionProfile#username}
    */
    readonly username: string;
}
export declare function datastreamConnectionProfilePostgresqlProfileToTerraform(struct?: DatastreamConnectionProfilePostgresqlProfileOutputReference | DatastreamConnectionProfilePostgresqlProfile): any;
export declare class DatastreamConnectionProfilePostgresqlProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfilePostgresqlProfile | undefined;
    set internalValue(value: DatastreamConnectionProfilePostgresqlProfile | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface DatastreamConnectionProfilePrivateConnectivity {
    /**
    * A reference to a private connection resource. Format: 'projects/{project}/locations/{location}/privateConnections/{name}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#private_connection DatastreamConnectionProfile#private_connection}
    */
    readonly privateConnection: string;
}
export declare function datastreamConnectionProfilePrivateConnectivityToTerraform(struct?: DatastreamConnectionProfilePrivateConnectivityOutputReference | DatastreamConnectionProfilePrivateConnectivity): any;
export declare class DatastreamConnectionProfilePrivateConnectivityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfilePrivateConnectivity | undefined;
    set internalValue(value: DatastreamConnectionProfilePrivateConnectivity | undefined);
    private _privateConnection?;
    get privateConnection(): string;
    set privateConnection(value: string);
    get privateConnectionInput(): string | undefined;
}
export interface DatastreamConnectionProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#create DatastreamConnectionProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#delete DatastreamConnectionProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile#update DatastreamConnectionProfile#update}
    */
    readonly update?: string;
}
export declare function datastreamConnectionProfileTimeoutsToTerraform(struct?: DatastreamConnectionProfileTimeoutsOutputReference | DatastreamConnectionProfileTimeouts | cdktf.IResolvable): any;
export declare class DatastreamConnectionProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastreamConnectionProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatastreamConnectionProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile google_datastream_connection_profile}
*/
export declare class DatastreamConnectionProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_datastream_connection_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/datastream_connection_profile google_datastream_connection_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatastreamConnectionProfileConfig
    */
    constructor(scope: Construct, id: string, config: DatastreamConnectionProfileConfig);
    private _connectionProfileId?;
    get connectionProfileId(): string;
    set connectionProfileId(value: string);
    get connectionProfileIdInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _bigqueryProfile;
    get bigqueryProfile(): DatastreamConnectionProfileBigqueryProfileOutputReference;
    putBigqueryProfile(value: DatastreamConnectionProfileBigqueryProfile): void;
    resetBigqueryProfile(): void;
    get bigqueryProfileInput(): DatastreamConnectionProfileBigqueryProfile | undefined;
    private _forwardSshConnectivity;
    get forwardSshConnectivity(): DatastreamConnectionProfileForwardSshConnectivityOutputReference;
    putForwardSshConnectivity(value: DatastreamConnectionProfileForwardSshConnectivity): void;
    resetForwardSshConnectivity(): void;
    get forwardSshConnectivityInput(): DatastreamConnectionProfileForwardSshConnectivity | undefined;
    private _gcsProfile;
    get gcsProfile(): DatastreamConnectionProfileGcsProfileOutputReference;
    putGcsProfile(value: DatastreamConnectionProfileGcsProfile): void;
    resetGcsProfile(): void;
    get gcsProfileInput(): DatastreamConnectionProfileGcsProfile | undefined;
    private _mysqlProfile;
    get mysqlProfile(): DatastreamConnectionProfileMysqlProfileOutputReference;
    putMysqlProfile(value: DatastreamConnectionProfileMysqlProfile): void;
    resetMysqlProfile(): void;
    get mysqlProfileInput(): DatastreamConnectionProfileMysqlProfile | undefined;
    private _oracleProfile;
    get oracleProfile(): DatastreamConnectionProfileOracleProfileOutputReference;
    putOracleProfile(value: DatastreamConnectionProfileOracleProfile): void;
    resetOracleProfile(): void;
    get oracleProfileInput(): DatastreamConnectionProfileOracleProfile | undefined;
    private _postgresqlProfile;
    get postgresqlProfile(): DatastreamConnectionProfilePostgresqlProfileOutputReference;
    putPostgresqlProfile(value: DatastreamConnectionProfilePostgresqlProfile): void;
    resetPostgresqlProfile(): void;
    get postgresqlProfileInput(): DatastreamConnectionProfilePostgresqlProfile | undefined;
    private _privateConnectivity;
    get privateConnectivity(): DatastreamConnectionProfilePrivateConnectivityOutputReference;
    putPrivateConnectivity(value: DatastreamConnectionProfilePrivateConnectivity): void;
    resetPrivateConnectivity(): void;
    get privateConnectivityInput(): DatastreamConnectionProfilePrivateConnectivity | undefined;
    private _timeouts;
    get timeouts(): DatastreamConnectionProfileTimeoutsOutputReference;
    putTimeouts(value: DatastreamConnectionProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatastreamConnectionProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
