import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * A textual description field. Defaults to 'Managed by Terraform'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#description DnsPolicy#description}
    */
    readonly description?: string;
    /**
    * Allows networks bound to this policy to receive DNS queries sent
  by VMs or applications over VPN connections. When enabled, a
  virtual IP address will be allocated from each of the sub-networks
  that are bound to this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#enable_inbound_forwarding DnsPolicy#enable_inbound_forwarding}
    */
    readonly enableInboundForwarding?: boolean | cdktf.IResolvable;
    /**
    * Controls whether logging is enabled for the networks bound to this policy.
  Defaults to no logging if not set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#enable_logging DnsPolicy#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#id DnsPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User assigned name for this policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#name DnsPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#project DnsPolicy#project}
    */
    readonly project?: string;
    /**
    * alternative_name_server_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#alternative_name_server_config DnsPolicy#alternative_name_server_config}
    */
    readonly alternativeNameServerConfig?: DnsPolicyAlternativeNameServerConfig;
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#networks DnsPolicy#networks}
    */
    readonly networks?: DnsPolicyNetworks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#timeouts DnsPolicy#timeouts}
    */
    readonly timeouts?: DnsPolicyTimeouts;
}
export interface DnsPolicyAlternativeNameServerConfigTargetNameServers {
    /**
    * Forwarding path for this TargetNameServer. If unset or 'default' Cloud DNS will make forwarding
  decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
  to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#forwarding_path DnsPolicy#forwarding_path}
    */
    readonly forwardingPath?: string;
    /**
    * IPv4 address to forward to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#ipv4_address DnsPolicy#ipv4_address}
    */
    readonly ipv4Address: string;
}
export declare function dnsPolicyAlternativeNameServerConfigTargetNameServersToTerraform(struct?: DnsPolicyAlternativeNameServerConfigTargetNameServers | cdktf.IResolvable): any;
export declare class DnsPolicyAlternativeNameServerConfigTargetNameServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsPolicyAlternativeNameServerConfigTargetNameServers | cdktf.IResolvable | undefined;
    set internalValue(value: DnsPolicyAlternativeNameServerConfigTargetNameServers | cdktf.IResolvable | undefined);
    private _forwardingPath?;
    get forwardingPath(): string;
    set forwardingPath(value: string);
    resetForwardingPath(): void;
    get forwardingPathInput(): string | undefined;
    private _ipv4Address?;
    get ipv4Address(): string;
    set ipv4Address(value: string);
    get ipv4AddressInput(): string | undefined;
}
export declare class DnsPolicyAlternativeNameServerConfigTargetNameServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsPolicyAlternativeNameServerConfigTargetNameServers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsPolicyAlternativeNameServerConfigTargetNameServersOutputReference;
}
export interface DnsPolicyAlternativeNameServerConfig {
    /**
    * target_name_servers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#target_name_servers DnsPolicy#target_name_servers}
    */
    readonly targetNameServers: DnsPolicyAlternativeNameServerConfigTargetNameServers[] | cdktf.IResolvable;
}
export declare function dnsPolicyAlternativeNameServerConfigToTerraform(struct?: DnsPolicyAlternativeNameServerConfigOutputReference | DnsPolicyAlternativeNameServerConfig): any;
export declare class DnsPolicyAlternativeNameServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsPolicyAlternativeNameServerConfig | undefined;
    set internalValue(value: DnsPolicyAlternativeNameServerConfig | undefined);
    private _targetNameServers;
    get targetNameServers(): DnsPolicyAlternativeNameServerConfigTargetNameServersList;
    putTargetNameServers(value: DnsPolicyAlternativeNameServerConfigTargetNameServers[] | cdktf.IResolvable): void;
    get targetNameServersInput(): cdktf.IResolvable | DnsPolicyAlternativeNameServerConfigTargetNameServers[] | undefined;
}
export interface DnsPolicyNetworks {
    /**
    * The id or fully qualified URL of the VPC network to forward queries to.
  This should be formatted like 'projects/{project}/global/networks/{network}' or
  'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#network_url DnsPolicy#network_url}
    */
    readonly networkUrl: string;
}
export declare function dnsPolicyNetworksToTerraform(struct?: DnsPolicyNetworks | cdktf.IResolvable): any;
export declare class DnsPolicyNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsPolicyNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: DnsPolicyNetworks | cdktf.IResolvable | undefined);
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
}
export declare class DnsPolicyNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsPolicyNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsPolicyNetworksOutputReference;
}
export interface DnsPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#create DnsPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#delete DnsPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_policy#update DnsPolicy#update}
    */
    readonly update?: string;
}
export declare function dnsPolicyTimeoutsToTerraform(struct?: DnsPolicyTimeoutsOutputReference | DnsPolicyTimeouts | cdktf.IResolvable): any;
export declare class DnsPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DnsPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_policy google_dns_policy}
*/
export declare class DnsPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_policy google_dns_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DnsPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enableInboundForwarding?;
    get enableInboundForwarding(): boolean | cdktf.IResolvable;
    set enableInboundForwarding(value: boolean | cdktf.IResolvable);
    resetEnableInboundForwarding(): void;
    get enableInboundForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _alternativeNameServerConfig;
    get alternativeNameServerConfig(): DnsPolicyAlternativeNameServerConfigOutputReference;
    putAlternativeNameServerConfig(value: DnsPolicyAlternativeNameServerConfig): void;
    resetAlternativeNameServerConfig(): void;
    get alternativeNameServerConfigInput(): DnsPolicyAlternativeNameServerConfig | undefined;
    private _networks;
    get networks(): DnsPolicyNetworksList;
    putNetworks(value: DnsPolicyNetworks[] | cdktf.IResolvable): void;
    resetNetworks(): void;
    get networksInput(): cdktf.IResolvable | DnsPolicyNetworks[] | undefined;
    private _timeouts;
    get timeouts(): DnsPolicyTimeoutsOutputReference;
    putTimeouts(value: DnsPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DnsPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
