import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventarcChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/*\/locations/*\/keyRings/*\/cryptoKeys/*`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#crypto_key_name EventarcChannel#crypto_key_name}
    */
    readonly cryptoKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#id EventarcChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#location EventarcChannel#location}
    */
    readonly location: string;
    /**
    * Required. The resource name of the channel. Must be unique within the location on the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#name EventarcChannel#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#project EventarcChannel#project}
    */
    readonly project?: string;
    /**
    * The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#third_party_provider EventarcChannel#third_party_provider}
    */
    readonly thirdPartyProvider?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#timeouts EventarcChannel#timeouts}
    */
    readonly timeouts?: EventarcChannelTimeouts;
}
export interface EventarcChannelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#create EventarcChannel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#delete EventarcChannel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel#update EventarcChannel#update}
    */
    readonly update?: string;
}
export declare function eventarcChannelTimeoutsToTerraform(struct?: EventarcChannelTimeoutsOutputReference | EventarcChannelTimeouts | cdktf.IResolvable): any;
export declare class EventarcChannelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventarcChannelTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventarcChannelTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel google_eventarc_channel}
*/
export declare class EventarcChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_eventarc_channel";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/eventarc_channel google_eventarc_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventarcChannelConfig
    */
    constructor(scope: Construct, id: string, config: EventarcChannelConfig);
    get activationToken(): string;
    get createTime(): string;
    private _cryptoKeyName?;
    get cryptoKeyName(): string;
    set cryptoKeyName(value: string);
    resetCryptoKeyName(): void;
    get cryptoKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pubsubTopic(): string;
    get state(): string;
    private _thirdPartyProvider?;
    get thirdPartyProvider(): string;
    set thirdPartyProvider(value: string);
    resetThirdPartyProvider(): void;
    get thirdPartyProviderInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): EventarcChannelTimeoutsOutputReference;
    putTimeouts(value: EventarcChannelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventarcChannelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
