import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FilestoreSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of the snapshot with 2048 characters or less. Requests with longer descriptions will be rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#description FilestoreSnapshot#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#id FilestoreSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the filestore instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#instance FilestoreSnapshot#instance}
    */
    readonly instance: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#labels FilestoreSnapshot#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location of the instance. This can be a region for ENTERPRISE tier instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#location FilestoreSnapshot#location}
    */
    readonly location: string;
    /**
    * The resource name of the snapshot. The name must be unique within the specified instance.
  
  The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#name FilestoreSnapshot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#project FilestoreSnapshot#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#timeouts FilestoreSnapshot#timeouts}
    */
    readonly timeouts?: FilestoreSnapshotTimeouts;
}
export interface FilestoreSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#create FilestoreSnapshot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#delete FilestoreSnapshot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot#update FilestoreSnapshot#update}
    */
    readonly update?: string;
}
export declare function filestoreSnapshotTimeoutsToTerraform(struct?: FilestoreSnapshotTimeoutsOutputReference | FilestoreSnapshotTimeouts | cdktf.IResolvable): any;
export declare class FilestoreSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FilestoreSnapshotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FilestoreSnapshotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot google_filestore_snapshot}
*/
export declare class FilestoreSnapshot extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_filestore_snapshot";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/filestore_snapshot google_filestore_snapshot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FilestoreSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: FilestoreSnapshotConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get filesystemUsedBytes(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _timeouts;
    get timeouts(): FilestoreSnapshotTimeoutsOutputReference;
    putTimeouts(value: FilestoreSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FilestoreSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
