import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FolderOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#constraint FolderOrganizationPolicy#constraint}
    */
    readonly constraint: string;
    /**
    * The resource name of the folder to set the policy for. Its format is folders/{folder_id}.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#folder FolderOrganizationPolicy#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#id FolderOrganizationPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Version of the Policy. Default version is 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#version FolderOrganizationPolicy#version}
    */
    readonly version?: number;
    /**
    * boolean_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#boolean_policy FolderOrganizationPolicy#boolean_policy}
    */
    readonly booleanPolicy?: FolderOrganizationPolicyBooleanPolicy;
    /**
    * list_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#list_policy FolderOrganizationPolicy#list_policy}
    */
    readonly listPolicy?: FolderOrganizationPolicyListPolicy;
    /**
    * restore_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#restore_policy FolderOrganizationPolicy#restore_policy}
    */
    readonly restorePolicy?: FolderOrganizationPolicyRestorePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#timeouts FolderOrganizationPolicy#timeouts}
    */
    readonly timeouts?: FolderOrganizationPolicyTimeouts;
}
export interface FolderOrganizationPolicyBooleanPolicy {
    /**
    * If true, then the Policy is enforced. If false, then any configuration is acceptable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#enforced FolderOrganizationPolicy#enforced}
    */
    readonly enforced: boolean | cdktf.IResolvable;
}
export declare function folderOrganizationPolicyBooleanPolicyToTerraform(struct?: FolderOrganizationPolicyBooleanPolicyOutputReference | FolderOrganizationPolicyBooleanPolicy): any;
export declare class FolderOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderOrganizationPolicyBooleanPolicy | undefined;
    set internalValue(value: FolderOrganizationPolicyBooleanPolicy | undefined);
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface FolderOrganizationPolicyListPolicyAllow {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#all FolderOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#values FolderOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function folderOrganizationPolicyListPolicyAllowToTerraform(struct?: FolderOrganizationPolicyListPolicyAllowOutputReference | FolderOrganizationPolicyListPolicyAllow): any;
export declare class FolderOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderOrganizationPolicyListPolicyAllow | undefined;
    set internalValue(value: FolderOrganizationPolicyListPolicyAllow | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface FolderOrganizationPolicyListPolicyDeny {
    /**
    * The policy allows or denies all values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#all FolderOrganizationPolicy#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * The policy can define specific values that are allowed or denied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#values FolderOrganizationPolicy#values}
    */
    readonly values?: string[];
}
export declare function folderOrganizationPolicyListPolicyDenyToTerraform(struct?: FolderOrganizationPolicyListPolicyDenyOutputReference | FolderOrganizationPolicyListPolicyDeny): any;
export declare class FolderOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderOrganizationPolicyListPolicyDeny | undefined;
    set internalValue(value: FolderOrganizationPolicyListPolicyDeny | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface FolderOrganizationPolicyListPolicy {
    /**
    * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#inherit_from_parent FolderOrganizationPolicy#inherit_from_parent}
    */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
    * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#suggested_value FolderOrganizationPolicy#suggested_value}
    */
    readonly suggestedValue?: string;
    /**
    * allow block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#allow FolderOrganizationPolicy#allow}
    */
    readonly allow?: FolderOrganizationPolicyListPolicyAllow;
    /**
    * deny block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#deny FolderOrganizationPolicy#deny}
    */
    readonly deny?: FolderOrganizationPolicyListPolicyDeny;
}
export declare function folderOrganizationPolicyListPolicyToTerraform(struct?: FolderOrganizationPolicyListPolicyOutputReference | FolderOrganizationPolicyListPolicy): any;
export declare class FolderOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderOrganizationPolicyListPolicy | undefined;
    set internalValue(value: FolderOrganizationPolicyListPolicy | undefined);
    private _inheritFromParent?;
    get inheritFromParent(): boolean | cdktf.IResolvable;
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    resetInheritFromParent(): void;
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    get suggestedValue(): string;
    set suggestedValue(value: string);
    resetSuggestedValue(): void;
    get suggestedValueInput(): string | undefined;
    private _allow;
    get allow(): FolderOrganizationPolicyListPolicyAllowOutputReference;
    putAllow(value: FolderOrganizationPolicyListPolicyAllow): void;
    resetAllow(): void;
    get allowInput(): FolderOrganizationPolicyListPolicyAllow | undefined;
    private _deny;
    get deny(): FolderOrganizationPolicyListPolicyDenyOutputReference;
    putDeny(value: FolderOrganizationPolicyListPolicyDeny): void;
    resetDeny(): void;
    get denyInput(): FolderOrganizationPolicyListPolicyDeny | undefined;
}
export interface FolderOrganizationPolicyRestorePolicy {
    /**
    * May only be set to true. If set, then the default Policy is restored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#default FolderOrganizationPolicy#default}
    */
    readonly default: boolean | cdktf.IResolvable;
}
export declare function folderOrganizationPolicyRestorePolicyToTerraform(struct?: FolderOrganizationPolicyRestorePolicyOutputReference | FolderOrganizationPolicyRestorePolicy): any;
export declare class FolderOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderOrganizationPolicyRestorePolicy | undefined;
    set internalValue(value: FolderOrganizationPolicyRestorePolicy | undefined);
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
export interface FolderOrganizationPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#create FolderOrganizationPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#delete FolderOrganizationPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#read FolderOrganizationPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy#update FolderOrganizationPolicy#update}
    */
    readonly update?: string;
}
export declare function folderOrganizationPolicyTimeoutsToTerraform(struct?: FolderOrganizationPolicyTimeoutsOutputReference | FolderOrganizationPolicyTimeouts | cdktf.IResolvable): any;
export declare class FolderOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FolderOrganizationPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FolderOrganizationPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy google_folder_organization_policy}
*/
export declare class FolderOrganizationPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_folder_organization_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_organization_policy google_folder_organization_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FolderOrganizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: FolderOrganizationPolicyConfig);
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get updateTime(): string;
    private _version?;
    get version(): number;
    set version(value: number);
    resetVersion(): void;
    get versionInput(): number | undefined;
    private _booleanPolicy;
    get booleanPolicy(): FolderOrganizationPolicyBooleanPolicyOutputReference;
    putBooleanPolicy(value: FolderOrganizationPolicyBooleanPolicy): void;
    resetBooleanPolicy(): void;
    get booleanPolicyInput(): FolderOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy;
    get listPolicy(): FolderOrganizationPolicyListPolicyOutputReference;
    putListPolicy(value: FolderOrganizationPolicyListPolicy): void;
    resetListPolicy(): void;
    get listPolicyInput(): FolderOrganizationPolicyListPolicy | undefined;
    private _restorePolicy;
    get restorePolicy(): FolderOrganizationPolicyRestorePolicyOutputReference;
    putRestorePolicy(value: FolderOrganizationPolicyRestorePolicy): void;
    resetRestorePolicy(): void;
    get restorePolicyInput(): FolderOrganizationPolicyRestorePolicy | undefined;
    private _timeouts;
    get timeouts(): FolderOrganizationPolicyTimeoutsOutputReference;
    putTimeouts(value: FolderOrganizationPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FolderOrganizationPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
