"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IamWorkforcePoolProvider = exports.IamWorkforcePoolProviderTimeoutsOutputReference = exports.iamWorkforcePoolProviderTimeoutsToTerraform = exports.IamWorkforcePoolProviderSamlOutputReference = exports.iamWorkforcePoolProviderSamlToTerraform = exports.IamWorkforcePoolProviderOidcOutputReference = exports.iamWorkforcePoolProviderOidcToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function iamWorkforcePoolProviderOidcToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        client_id: cdktf.stringToTerraform(struct.clientId),
        issuer_uri: cdktf.stringToTerraform(struct.issuerUri),
    };
}
exports.iamWorkforcePoolProviderOidcToTerraform = iamWorkforcePoolProviderOidcToTerraform;
class IamWorkforcePoolProviderOidcOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._clientId !== undefined) {
            hasAnyValues = true;
            internalValueResult.clientId = this._clientId;
        }
        if (this._issuerUri !== undefined) {
            hasAnyValues = true;
            internalValueResult.issuerUri = this._issuerUri;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._clientId = undefined;
            this._issuerUri = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._clientId = value.clientId;
            this._issuerUri = value.issuerUri;
        }
    }
    get clientId() {
        return this.getStringAttribute('client_id');
    }
    set clientId(value) {
        this._clientId = value;
    }
    // Temporarily expose input value. Use with caution.
    get clientIdInput() {
        return this._clientId;
    }
    get issuerUri() {
        return this.getStringAttribute('issuer_uri');
    }
    set issuerUri(value) {
        this._issuerUri = value;
    }
    // Temporarily expose input value. Use with caution.
    get issuerUriInput() {
        return this._issuerUri;
    }
}
exports.IamWorkforcePoolProviderOidcOutputReference = IamWorkforcePoolProviderOidcOutputReference;
_a = JSII_RTTI_SYMBOL_1;
IamWorkforcePoolProviderOidcOutputReference[_a] = { fqn: "@cdktf/provider-google.iamWorkforcePoolProvider.IamWorkforcePoolProviderOidcOutputReference", version: "5.0.7" };
function iamWorkforcePoolProviderSamlToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        idp_metadata_xml: cdktf.stringToTerraform(struct.idpMetadataXml),
    };
}
exports.iamWorkforcePoolProviderSamlToTerraform = iamWorkforcePoolProviderSamlToTerraform;
class IamWorkforcePoolProviderSamlOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._idpMetadataXml !== undefined) {
            hasAnyValues = true;
            internalValueResult.idpMetadataXml = this._idpMetadataXml;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._idpMetadataXml = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._idpMetadataXml = value.idpMetadataXml;
        }
    }
    get idpMetadataXml() {
        return this.getStringAttribute('idp_metadata_xml');
    }
    set idpMetadataXml(value) {
        this._idpMetadataXml = value;
    }
    // Temporarily expose input value. Use with caution.
    get idpMetadataXmlInput() {
        return this._idpMetadataXml;
    }
}
exports.IamWorkforcePoolProviderSamlOutputReference = IamWorkforcePoolProviderSamlOutputReference;
_b = JSII_RTTI_SYMBOL_1;
IamWorkforcePoolProviderSamlOutputReference[_b] = { fqn: "@cdktf/provider-google.iamWorkforcePoolProvider.IamWorkforcePoolProviderSamlOutputReference", version: "5.0.7" };
function iamWorkforcePoolProviderTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.iamWorkforcePoolProviderTimeoutsToTerraform = iamWorkforcePoolProviderTimeoutsToTerraform;
class IamWorkforcePoolProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.IamWorkforcePoolProviderTimeoutsOutputReference = IamWorkforcePoolProviderTimeoutsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
IamWorkforcePoolProviderTimeoutsOutputReference[_c] = { fqn: "@cdktf/provider-google.iamWorkforcePoolProvider.IamWorkforcePoolProviderTimeoutsOutputReference", version: "5.0.7" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider google_iam_workforce_pool_provider}
*/
class IamWorkforcePoolProvider extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool_provider google_iam_workforce_pool_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IamWorkforcePoolProviderConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_iam_workforce_pool_provider',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.55.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // oidc - computed: false, optional: true, required: false
        this._oidc = new IamWorkforcePoolProviderOidcOutputReference(this, "oidc");
        // saml - computed: false, optional: true, required: false
        this._saml = new IamWorkforcePoolProviderSamlOutputReference(this, "saml");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new IamWorkforcePoolProviderTimeoutsOutputReference(this, "timeouts");
        this._attributeCondition = config.attributeCondition;
        this._attributeMapping = config.attributeMapping;
        this._description = config.description;
        this._disabled = config.disabled;
        this._displayName = config.displayName;
        this._id = config.id;
        this._location = config.location;
        this._providerId = config.providerId;
        this._workforcePoolId = config.workforcePoolId;
        this._oidc.internalValue = config.oidc;
        this._saml.internalValue = config.saml;
        this._timeouts.internalValue = config.timeouts;
    }
    get attributeCondition() {
        return this.getStringAttribute('attribute_condition');
    }
    set attributeCondition(value) {
        this._attributeCondition = value;
    }
    resetAttributeCondition() {
        this._attributeCondition = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get attributeConditionInput() {
        return this._attributeCondition;
    }
    get attributeMapping() {
        return this.getStringMapAttribute('attribute_mapping');
    }
    set attributeMapping(value) {
        this._attributeMapping = value;
    }
    resetAttributeMapping() {
        this._attributeMapping = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get attributeMappingInput() {
        return this._attributeMapping;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get disabled() {
        return this.getBooleanAttribute('disabled');
    }
    set disabled(value) {
        this._disabled = value;
    }
    resetDisabled() {
        this._disabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disabledInput() {
        return this._disabled;
    }
    get displayName() {
        return this.getStringAttribute('display_name');
    }
    set displayName(value) {
        this._displayName = value;
    }
    resetDisplayName() {
        this._displayName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get displayNameInput() {
        return this._displayName;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get location() {
        return this.getStringAttribute('location');
    }
    set location(value) {
        this._location = value;
    }
    // Temporarily expose input value. Use with caution.
    get locationInput() {
        return this._location;
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    get providerId() {
        return this.getStringAttribute('provider_id');
    }
    set providerId(value) {
        this._providerId = value;
    }
    // Temporarily expose input value. Use with caution.
    get providerIdInput() {
        return this._providerId;
    }
    // state - computed: true, optional: false, required: false
    get state() {
        return this.getStringAttribute('state');
    }
    get workforcePoolId() {
        return this.getStringAttribute('workforce_pool_id');
    }
    set workforcePoolId(value) {
        this._workforcePoolId = value;
    }
    // Temporarily expose input value. Use with caution.
    get workforcePoolIdInput() {
        return this._workforcePoolId;
    }
    get oidc() {
        return this._oidc;
    }
    putOidc(value) {
        this._oidc.internalValue = value;
    }
    resetOidc() {
        this._oidc.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcInput() {
        return this._oidc.internalValue;
    }
    get saml() {
        return this._saml;
    }
    putSaml(value) {
        this._saml.internalValue = value;
    }
    resetSaml() {
        this._saml.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get samlInput() {
        return this._saml.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            attribute_condition: cdktf.stringToTerraform(this._attributeCondition),
            attribute_mapping: cdktf.hashMapper(cdktf.stringToTerraform)(this._attributeMapping),
            description: cdktf.stringToTerraform(this._description),
            disabled: cdktf.booleanToTerraform(this._disabled),
            display_name: cdktf.stringToTerraform(this._displayName),
            id: cdktf.stringToTerraform(this._id),
            location: cdktf.stringToTerraform(this._location),
            provider_id: cdktf.stringToTerraform(this._providerId),
            workforce_pool_id: cdktf.stringToTerraform(this._workforcePoolId),
            oidc: iamWorkforcePoolProviderOidcToTerraform(this._oidc.internalValue),
            saml: iamWorkforcePoolProviderSamlToTerraform(this._saml.internalValue),
            timeouts: iamWorkforcePoolProviderTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.IamWorkforcePoolProvider = IamWorkforcePoolProvider;
_d = JSII_RTTI_SYMBOL_1;
IamWorkforcePoolProvider[_d] = { fqn: "@cdktf/provider-google.iamWorkforcePoolProvider.IamWorkforcePoolProvider", version: "5.0.7" };
// =================
// STATIC PROPERTIES
// =================
IamWorkforcePoolProvider.tfResourceType = "google_iam_workforce_pool_provider";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaWFtLXdvcmtmb3JjZS1wb29sLXByb3ZpZGVyL2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBd0svQixTQUFnQix1Q0FBdUMsQ0FBQyxNQUFtRjtJQUN6SSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFFBQVEsQ0FBQztRQUNwRCxVQUFVLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxTQUFTLENBQUM7S0FDdkQsQ0FBQTtBQUNILENBQUM7QUFURCwwRkFTQztBQUVELE1BQWEsMkNBQTRDLFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHbEY7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztTQUMvQztRQUNELElBQUksSUFBSSxDQUFDLFVBQVUsS0FBSyxTQUFTLEVBQUU7WUFDakMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQztTQUNqRDtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUErQztRQUN0RSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDM0IsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7U0FDN0I7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztZQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7U0FDbkM7SUFDSCxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUFhO1FBQ2hDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO0lBQzFCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDOztBQTlESCxrR0ErREM7OztBQXdCRCxTQUFnQix1Q0FBdUMsQ0FBQyxNQUFtRjtJQUN6SSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsY0FBYyxDQUFDO0tBQ2xFLENBQUE7QUFDSCxDQUFDO0FBUkQsMEZBUUM7QUFFRCxNQUFhLDJDQUE0QyxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR2xGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxlQUFlLEtBQUssU0FBUyxFQUFFO1lBQ3RDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDM0Q7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBK0M7UUFDdEUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsU0FBUyxDQUFDO1NBQ2xDO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7U0FDN0M7SUFDSCxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQzs7QUEzQ0gsa0dBNENDOzs7QUFnQkQsU0FBZ0IsMkNBQTJDLENBQUMsTUFBK0c7SUFDekssSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxNQUFNLENBQUM7UUFDL0MsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztLQUNoRCxDQUFBO0FBQ0gsQ0FBQztBQVZELGtHQVVDO0FBRUQsTUFBYSwrQ0FBZ0QsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUl0Rjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVJqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVM5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUN4QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7U0FDN0I7UUFDRCxJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sS0FBSyxTQUFTLEVBQUU7WUFDOUIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUF1RTtRQUM5RixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLGVBQWUsR0FBRyxTQUFTLENBQUM7WUFDakMsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7WUFDekIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7U0FDMUI7YUFDSSxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO1NBQzlCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztZQUNqQyxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztTQUM3QjtJQUNILENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBcEdILDBHQXFHQzs7O0FBRUQ7O0VBRUU7QUFDRixNQUFhLHdCQUF5QixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPbkUsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQ7Ozs7OztNQU1FO0lBQ0YsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBc0M7UUFDckYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSxvQ0FBb0M7WUFDM0QsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxRQUFRO2dCQUN0QixlQUFlLEVBQUUsUUFBUTtnQkFDekIseUJBQXlCLEVBQUUsUUFBUTthQUNwQztZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixZQUFZLEVBQUUsTUFBTSxDQUFDLFlBQVk7WUFDakMsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO1lBQzdCLE9BQU8sRUFBRSxNQUFNLENBQUMsT0FBTztTQUN4QixDQUFDLENBQUM7UUFvS0wsMERBQTBEO1FBQ2xELFVBQUssR0FBRyxJQUFJLDJDQUEyQyxDQUFDLElBQUksRUFBRSxNQUFNLENBQUMsQ0FBQztRQWU5RSwwREFBMEQ7UUFDbEQsVUFBSyxHQUFHLElBQUksMkNBQTJDLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBZTlFLDhEQUE4RDtRQUN0RCxjQUFTLEdBQUcsSUFBSSwrQ0FBK0MsQ0FBQyxJQUFJLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFwTXhGLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsR0FBRyxHQUFHLE1BQU0sQ0FBQyxFQUFFLENBQUM7UUFDckIsSUFBSSxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDdkMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztJQUNqRCxDQUFDO0lBUUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUFhO1FBQ3pDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUNNLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsbUJBQW1CLEdBQUcsU0FBUyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx1QkFBdUI7UUFDaEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDekQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBZ0M7UUFDMUQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxTQUFTLENBQUM7SUFDckMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFhO1FBQ2xDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBa0M7UUFDcEQsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUM7SUFDekIsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7SUFDN0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUVELDBEQUEwRDtJQUMxRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBRUQsMkRBQTJEO0lBQzNELElBQVcsS0FBSztRQUNkLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ00sT0FBTyxDQUFDLEtBQW1DO1FBQ2hELElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNNLE9BQU8sQ0FBQyxLQUFtQztRQUNoRCxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDdkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ00sV0FBVyxDQUFDLEtBQXVDO1FBQ3hELElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxtQkFBbUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1lBQ3RFLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ3BGLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN2RCxRQUFRLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDbEQsWUFBWSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO1lBQ3hELEVBQUUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztZQUNyQyxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDakQsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7WUFDakUsSUFBSSxFQUFFLHVDQUF1QyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDO1lBQ3ZFLElBQUksRUFBRSx1Q0FBdUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQztZQUN2RSxRQUFRLEVBQUUsMkNBQTJDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUM7U0FDcEYsQ0FBQztJQUNKLENBQUM7O0FBeFFILDREQXlRQzs7O0FBdlFDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csdUNBQWMsR0FBRyxvQ0FBb0MsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXJcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgLyoqXG4gICogQSBbQ29tbW9uIEV4cHJlc3Npb24gTGFuZ3VhZ2VdKGh0dHBzOi8vb3BlbnNvdXJjZS5nb29nbGUvcHJvamVjdHMvY2VsKSBleHByZXNzaW9uLCBpblxucGxhaW4gdGV4dCwgdG8gcmVzdHJpY3Qgd2hhdCBvdGhlcndpc2UgdmFsaWQgYXV0aGVudGljYXRpb24gY3JlZGVudGlhbHMgaXNzdWVkIGJ5IHRoZVxucHJvdmlkZXIgc2hvdWxkIG5vdCBiZSBhY2NlcHRlZC5cblxuVGhlIGV4cHJlc3Npb24gbXVzdCBvdXRwdXQgYSBib29sZWFuIHJlcHJlc2VudGluZyB3aGV0aGVyIHRvIGFsbG93IHRoZSBmZWRlcmF0aW9uLlxuXG5UaGUgZm9sbG93aW5nIGtleXdvcmRzIG1heSBiZSByZWZlcmVuY2VkIGluIHRoZSBleHByZXNzaW9uczpcbiAgKiAnYXNzZXJ0aW9uJzogSlNPTiByZXByZXNlbnRpbmcgdGhlIGF1dGhlbnRpY2F0aW9uIGNyZWRlbnRpYWwgaXNzdWVkIGJ5IHRoZSBwcm92aWRlci5cbiAgKiAnZ29vZ2xlJzogVGhlIEdvb2dsZSBhdHRyaWJ1dGVzIG1hcHBlZCBmcm9tIHRoZSBhc3NlcnRpb24gaW4gdGhlICdhdHRyaWJ1dGVfbWFwcGluZ3MnLlxuICAgICdnb29nbGUucHJvZmlsZV9waG90bycgYW5kICdnb29nbGUuZGlzcGxheV9uYW1lJyBhcmUgbm90IHN1cHBvcnRlZC5cbiAgKiAnYXR0cmlidXRlJzogVGhlIGN1c3RvbSBhdHRyaWJ1dGVzIG1hcHBlZCBmcm9tIHRoZSBhc3NlcnRpb24gaW4gdGhlICdhdHRyaWJ1dGVfbWFwcGluZ3MnLlxuXG5UaGUgbWF4aW11bSBsZW5ndGggb2YgdGhlIGF0dHJpYnV0ZSBjb25kaXRpb24gZXhwcmVzc2lvbiBpcyA0MDk2IGNoYXJhY3RlcnMuXG5JZiB1bnNwZWNpZmllZCwgYWxsIHZhbGlkIGF1dGhlbnRpY2F0aW9uIGNyZWRlbnRpYWxzIHdpbGwgYmUgYWNjZXB0ZWQuXG5cblRoZSBmb2xsb3dpbmcgZXhhbXBsZSBzaG93cyBob3cgdG8gb25seSBhbGxvdyBjcmVkZW50aWFscyB3aXRoIGEgbWFwcGVkICdnb29nbGUuZ3JvdXBzJyB2YWx1ZSBvZiAnYWRtaW5zJzpcbmBgYFxuXCInYWRtaW5zJyBpbiBnb29nbGUuZ3JvdXBzXCJcbmBgYFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2lhbV93b3JrZm9yY2VfcG9vbF9wcm92aWRlciNhdHRyaWJ1dGVfY29uZGl0aW9uIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNhdHRyaWJ1dGVfY29uZGl0aW9ufVxuICAqL1xuICByZWFkb25seSBhdHRyaWJ1dGVDb25kaXRpb24/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE1hcHMgYXR0cmlidXRlcyBmcm9tIHRoZSBhdXRoZW50aWNhdGlvbiBjcmVkZW50aWFscyBpc3N1ZWQgYnkgYW4gZXh0ZXJuYWwgaWRlbnRpdHkgcHJvdmlkZXJcbnRvIEdvb2dsZSBDbG91ZCBhdHRyaWJ1dGVzLCBzdWNoIGFzICdzdWJqZWN0JyBhbmQgJ3NlZ21lbnQnLlxuXG5FYWNoIGtleSBtdXN0IGJlIGEgc3RyaW5nIHNwZWNpZnlpbmcgdGhlIEdvb2dsZSBDbG91ZCBJQU0gYXR0cmlidXRlIHRvIG1hcCB0by5cblxuVGhlIGZvbGxvd2luZyBrZXlzIGFyZSBzdXBwb3J0ZWQ6XG4gICogJ2dvb2dsZS5zdWJqZWN0JzogVGhlIHByaW5jaXBhbCBJQU0gaXMgYXV0aGVudGljYXRpbmcuIFlvdSBjYW4gcmVmZXJlbmNlIHRoaXMgdmFsdWUgaW4gSUFNIGJpbmRpbmdzLlxuICAgIFRoaXMgaXMgYWxzbyB0aGUgc3ViamVjdCB0aGF0IGFwcGVhcnMgaW4gQ2xvdWQgTG9nZ2luZyBsb2dzLiBUaGlzIGlzIGEgcmVxdWlyZWQgZmllbGQgYW5kXG4gICAgdGhlIG1hcHBlZCBzdWJqZWN0IGNhbm5vdCBleGNlZWQgMTI3IGJ5dGVzLlxuICAqICdnb29nbGUuZ3JvdXBzJzogR3JvdXBzIHRoZSBhdXRoZW50aWNhdGluZyB1c2VyIGJlbG9uZ3MgdG8uIFlvdSBjYW4gZ3JhbnQgZ3JvdXBzIGFjY2VzcyB0b1xuICAgIHJlc291cmNlcyB1c2luZyBhbiBJQU0gJ3ByaW5jaXBhbFNldCcgYmluZGluZzsgYWNjZXNzIGFwcGxpZXMgdG8gYWxsIG1lbWJlcnMgb2YgdGhlIGdyb3VwLlxuICAqICdnb29nbGUuZGlzcGxheV9uYW1lJzogVGhlIG5hbWUgb2YgdGhlIGF1dGhlbnRpY2F0ZWQgdXNlci4gVGhpcyBpcyBhbiBvcHRpb25hbCBmaWVsZCBhbmRcbiAgICB0aGUgbWFwcGVkIGRpc3BsYXkgbmFtZSBjYW5ub3QgZXhjZWVkIDEwMCBieXRlcy4gSWYgbm90IHNldCwgJ2dvb2dsZS5zdWJqZWN0JyB3aWxsIGJlIGRpc3BsYXllZCBpbnN0ZWFkLlxuICAgIFRoaXMgYXR0cmlidXRlIGNhbm5vdCBiZSByZWZlcmVuY2VkIGluIElBTSBiaW5kaW5ncy5cbiAgKiAnZ29vZ2xlLnByb2ZpbGVfcGhvdG8nOiBUaGUgVVJMIHRoYXQgc3BlY2lmaWVzIHRoZSBhdXRoZW50aWNhdGVkIHVzZXIncyB0aHVtYm5haWwgcGhvdG8uXG4gICAgVGhpcyBpcyBhbiBvcHRpb25hbCBmaWVsZC4gV2hlbiBzZXQsIHRoZSBpbWFnZSB3aWxsIGJlIHZpc2libGUgYXMgdGhlIHVzZXIncyBwcm9maWxlIHBpY3R1cmUuXG4gICAgSWYgbm90IHNldCwgYSBnZW5lcmljIHVzZXIgaWNvbiB3aWxsIGJlIGRpc3BsYXllZCBpbnN0ZWFkLlxuICAgIFRoaXMgYXR0cmlidXRlIGNhbm5vdCBiZSByZWZlcmVuY2VkIGluIElBTSBiaW5kaW5ncy5cblxuWW91IGNhbiBhbHNvIHByb3ZpZGUgY3VzdG9tIGF0dHJpYnV0ZXMgYnkgc3BlY2lmeWluZyAnYXR0cmlidXRlLntjdXN0b21fYXR0cmlidXRlfScsIHdoZXJlIHtjdXN0b21fYXR0cmlidXRlfVxuaXMgdGhlIG5hbWUgb2YgdGhlIGN1c3RvbSBhdHRyaWJ1dGUgdG8gYmUgbWFwcGVkLiBZb3UgY2FuIGRlZmluZSBhIG1heGltdW0gb2YgNTAgY3VzdG9tIGF0dHJpYnV0ZXMuXG5UaGUgbWF4aW11bSBsZW5ndGggb2YgYSBtYXBwZWQgYXR0cmlidXRlIGtleSBpcyAxMDAgY2hhcmFjdGVycywgYW5kIHRoZSBrZXkgbWF5IG9ubHkgY29udGFpbiB0aGUgY2hhcmFjdGVycyBbYS16MC05X10uXG5cbllvdSBjYW4gcmVmZXJlbmNlIHRoZXNlIGF0dHJpYnV0ZXMgaW4gSUFNIHBvbGljaWVzIHRvIGRlZmluZSBmaW5lLWdyYWluZWQgYWNjZXNzIGZvciBhIHdvcmtmb3JjZSBwb29sXG50byBHb29nbGUgQ2xvdWQgcmVzb3VyY2VzLiBGb3IgZXhhbXBsZTpcbiAgKiAnZ29vZ2xlLnN1YmplY3QnOlxuICAgICdwcmluY2lwYWw6Ly9pYW0uZ29vZ2xlYXBpcy5jb20vbG9jYXRpb25zL3tsb2NhdGlvbn0vd29ya2ZvcmNlUG9vbHMve3Bvb2x9L3N1YmplY3Qve3ZhbHVlfSdcbiAgKiAnZ29vZ2xlLmdyb3Vwcyc6XG4gICAgJ3ByaW5jaXBhbFNldDovL2lhbS5nb29nbGVhcGlzLmNvbS9sb2NhdGlvbnMve2xvY2F0aW9ufS93b3JrZm9yY2VQb29scy97cG9vbH0vZ3JvdXAve3ZhbHVlfSdcbiAgKiAnYXR0cmlidXRlLntjdXN0b21fYXR0cmlidXRlfSc6XG4gICAgJ3ByaW5jaXBhbFNldDovL2lhbS5nb29nbGVhcGlzLmNvbS9sb2NhdGlvbnMve2xvY2F0aW9ufS93b3JrZm9yY2VQb29scy97cG9vbH0vYXR0cmlidXRlLntjdXN0b21fYXR0cmlidXRlfS97dmFsdWV9J1xuXG5FYWNoIHZhbHVlIG11c3QgYmUgYSBbQ29tbW9uIEV4cHJlc3Npb24gTGFuZ3VhZ2VdKGh0dHBzOi8vb3BlbnNvdXJjZS5nb29nbGUvcHJvamVjdHMvY2VsKVxuZnVuY3Rpb24gdGhhdCBtYXBzIGFuIGlkZW50aXR5IHByb3ZpZGVyIGNyZWRlbnRpYWwgdG8gdGhlIG5vcm1hbGl6ZWQgYXR0cmlidXRlIHNwZWNpZmllZFxuYnkgdGhlIGNvcnJlc3BvbmRpbmcgbWFwIGtleS5cblxuWW91IGNhbiB1c2UgdGhlICdhc3NlcnRpb24nIGtleXdvcmQgaW4gdGhlIGV4cHJlc3Npb24gdG8gYWNjZXNzIGEgSlNPTiByZXByZXNlbnRhdGlvbiBvZlxudGhlIGF1dGhlbnRpY2F0aW9uIGNyZWRlbnRpYWwgaXNzdWVkIGJ5IHRoZSBwcm92aWRlci5cblxuVGhlIG1heGltdW0gbGVuZ3RoIG9mIGFuIGF0dHJpYnV0ZSBtYXBwaW5nIGV4cHJlc3Npb24gaXMgMjA0OCBjaGFyYWN0ZXJzLiBXaGVuIGV2YWx1YXRlZCxcbnRoZSB0b3RhbCBzaXplIG9mIGFsbCBtYXBwZWQgYXR0cmlidXRlcyBtdXN0IG5vdCBleGNlZWQgOEtCLlxuXG5Gb3IgT0lEQyBwcm92aWRlcnMsIHlvdSBtdXN0IHN1cHBseSBhIGN1c3RvbSBtYXBwaW5nIHRoYXQgaW5jbHVkZXMgdGhlICdnb29nbGUuc3ViamVjdCcgYXR0cmlidXRlLlxuRm9yIGV4YW1wbGUsIHRoZSBmb2xsb3dpbmcgbWFwcyB0aGUgc3ViIGNsYWltIG9mIHRoZSBpbmNvbWluZyBjcmVkZW50aWFsIHRvIHRoZSAnc3ViamVjdCcgYXR0cmlidXRlXG5vbiBhIEdvb2dsZSB0b2tlbjpcbmBgYFxue1wiZ29vZ2xlLnN1YmplY3RcIjogXCJhc3NlcnRpb24uc3ViXCJ9XG5gYGBcblxuQW4gb2JqZWN0IGNvbnRhaW5pbmcgYSBsaXN0IG9mICdcImtleVwiOiB2YWx1ZScgcGFpcnMuXG5FeGFtcGxlOiAneyBcIm5hbWVcIjogXCJ3cmVuY2hcIiwgXCJtYXNzXCI6IFwiMS4za2dcIiwgXCJjb3VudFwiOiBcIjNcIiB9Jy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjYXR0cmlidXRlX21hcHBpbmcgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyI2F0dHJpYnV0ZV9tYXBwaW5nfVxuICAqL1xuICByZWFkb25seSBhdHRyaWJ1dGVNYXBwaW5nPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbiAgLyoqXG4gICogQSB1c2VyLXNwZWNpZmllZCBkZXNjcmlwdGlvbiBvZiB0aGUgcHJvdmlkZXIuIENhbm5vdCBleGNlZWQgMjU2IGNoYXJhY3RlcnMuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyI2Rlc2NyaXB0aW9uIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNkZXNjcmlwdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFdoZXRoZXIgdGhlIHByb3ZpZGVyIGlzIGRpc2FibGVkLiBZb3UgY2Fubm90IHVzZSBhIGRpc2FibGVkIHByb3ZpZGVyIHRvIGV4Y2hhbmdlIHRva2Vucy5cbkhvd2V2ZXIsIGV4aXN0aW5nIHRva2VucyBzdGlsbCBncmFudCBhY2Nlc3MuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyI2Rpc2FibGVkIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNkaXNhYmxlZH1cbiAgKi9cbiAgcmVhZG9ubHkgZGlzYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIEEgdXNlci1zcGVjaWZpZWQgZGlzcGxheSBuYW1lIGZvciB0aGUgcHJvdmlkZXIuIENhbm5vdCBleGNlZWQgMzIgY2hhcmFjdGVycy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjZGlzcGxheV9uYW1lIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNkaXNwbGF5X25hbWV9XG4gICovXG4gIHJlYWRvbmx5IGRpc3BsYXlOYW1lPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjaWQgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyI2lkfVxuICAqXG4gICogUGxlYXNlIGJlIGF3YXJlIHRoYXQgdGhlIGlkIGZpZWxkIGlzIGF1dG9tYXRpY2FsbHkgYWRkZWQgdG8gYWxsIHJlc291cmNlcyBpbiBUZXJyYWZvcm0gcHJvdmlkZXJzIHVzaW5nIGEgVGVycmFmb3JtIHByb3ZpZGVyIFNESyB2ZXJzaW9uIGJlbG93IDIuXG4gICogSWYgeW91IGV4cGVyaWVuY2UgcHJvYmxlbXMgc2V0dGluZyB0aGlzIHZhbHVlIGl0IG1pZ2h0IG5vdCBiZSBzZXR0YWJsZS4gUGxlYXNlIHRha2UgYSBsb29rIGF0IHRoZSBwcm92aWRlciBkb2N1bWVudGF0aW9uIHRvIGVuc3VyZSBpdCBzaG91bGQgYmUgc2V0dGFibGUuXG4gICovXG4gIHJlYWRvbmx5IGlkPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgbG9jYXRpb24gZm9yIHRoZSByZXNvdXJjZS5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjbG9jYXRpb24gSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyI2xvY2F0aW9ufVxuICAqL1xuICByZWFkb25seSBsb2NhdGlvbjogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgSUQgZm9yIHRoZSBwcm92aWRlciwgd2hpY2ggYmVjb21lcyB0aGUgZmluYWwgY29tcG9uZW50IG9mIHRoZSByZXNvdXJjZSBuYW1lLlxuVGhpcyB2YWx1ZSBtdXN0IGJlIDQtMzIgY2hhcmFjdGVycywgYW5kIG1heSBjb250YWluIHRoZSBjaGFyYWN0ZXJzIFthLXowLTktXS5cblRoZSBwcmVmaXggJ2djcC0nIGlzIHJlc2VydmVkIGZvciB1c2UgYnkgR29vZ2xlLCBhbmQgbWF5IG5vdCBiZSBzcGVjaWZpZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyI3Byb3ZpZGVyX2lkIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNwcm92aWRlcl9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgcHJvdmlkZXJJZDogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgSUQgdG8gdXNlIGZvciB0aGUgcG9vbCwgd2hpY2ggYmVjb21lcyB0aGUgZmluYWwgY29tcG9uZW50IG9mIHRoZSByZXNvdXJjZSBuYW1lLlxuVGhlIElEcyBtdXN0IGJlIGEgZ2xvYmFsbHkgdW5pcXVlIHN0cmluZyBvZiA2IHRvIDYzIGxvd2VyY2FzZSBsZXR0ZXJzLCBkaWdpdHMsIG9yIGh5cGhlbnMuXG5JdCBtdXN0IHN0YXJ0IHdpdGggYSBsZXR0ZXIsIGFuZCBjYW5ub3QgaGF2ZSBhIHRyYWlsaW5nIGh5cGhlbi5cblRoZSBwcmVmaXggJ2djcC0nIGlzIHJlc2VydmVkIGZvciB1c2UgYnkgR29vZ2xlLCBhbmQgbWF5IG5vdCBiZSBzcGVjaWZpZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyI3dvcmtmb3JjZV9wb29sX2lkIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciN3b3JrZm9yY2VfcG9vbF9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgd29ya2ZvcmNlUG9vbElkOiBzdHJpbmc7XG4gIC8qKlxuICAqIG9pZGMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjb2lkYyBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXIjb2lkY31cbiAgKi9cbiAgcmVhZG9ubHkgb2lkYz86IElhbVdvcmtmb3JjZVBvb2xQcm92aWRlck9pZGM7XG4gIC8qKlxuICAqIHNhbWwgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjc2FtbCBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXIjc2FtbH1cbiAgKi9cbiAgcmVhZG9ubHkgc2FtbD86IElhbVdvcmtmb3JjZVBvb2xQcm92aWRlclNhbWw7XG4gIC8qKlxuICAqIHRpbWVvdXRzIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyI3RpbWVvdXRzIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciN0aW1lb3V0c31cbiAgKi9cbiAgcmVhZG9ubHkgdGltZW91dHM/OiBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJUaW1lb3V0cztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyT2lkYyB7XG4gIC8qKlxuICAqIFRoZSBjbGllbnQgSUQuIE11c3QgbWF0Y2ggdGhlIGF1ZGllbmNlIGNsYWltIG9mIHRoZSBKV1QgaXNzdWVkIGJ5IHRoZSBpZGVudGl0eSBwcm92aWRlci5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjY2xpZW50X2lkIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNjbGllbnRfaWR9XG4gICovXG4gIHJlYWRvbmx5IGNsaWVudElkOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBPSURDIGlzc3VlciBVUkkuIE11c3QgYmUgYSB2YWxpZCBVUkkgdXNpbmcgdGhlICdodHRwcycgc2NoZW1lLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2lhbV93b3JrZm9yY2VfcG9vbF9wcm92aWRlciNpc3N1ZXJfdXJpIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNpc3N1ZXJfdXJpfVxuICAqL1xuICByZWFkb25seSBpc3N1ZXJVcmk6IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlhbVdvcmtmb3JjZVBvb2xQcm92aWRlck9pZGNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJPaWRjT3V0cHV0UmVmZXJlbmNlIHwgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyT2lkYyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjbGllbnRfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuY2xpZW50SWQpLFxuICAgIGlzc3Vlcl91cmk6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuaXNzdWVyVXJpKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyT2lkY091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyT2lkYyB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY2xpZW50SWQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2xpZW50SWQgPSB0aGlzLl9jbGllbnRJZDtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2lzc3VlclVyaSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pc3N1ZXJVcmkgPSB0aGlzLl9pc3N1ZXJVcmk7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJPaWRjIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fY2xpZW50SWQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9pc3N1ZXJVcmkgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2NsaWVudElkID0gdmFsdWUuY2xpZW50SWQ7XG4gICAgICB0aGlzLl9pc3N1ZXJVcmkgPSB2YWx1ZS5pc3N1ZXJVcmk7XG4gICAgfVxuICB9XG5cbiAgLy8gY2xpZW50X2lkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX2NsaWVudElkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjbGllbnRJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NsaWVudF9pZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2xpZW50SWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NsaWVudElkID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNsaWVudElkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NsaWVudElkO1xuICB9XG5cbiAgLy8gaXNzdWVyX3VyaSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9pc3N1ZXJVcmk/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGlzc3VlclVyaSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lzc3Vlcl91cmknKTtcbiAgfVxuICBwdWJsaWMgc2V0IGlzc3VlclVyaSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faXNzdWVyVXJpID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlzc3VlclVyaUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9pc3N1ZXJVcmk7XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyU2FtbCB7XG4gIC8qKlxuICAqIFNBTUwgSWRlbnRpdHkgcHJvdmlkZXIgY29uZmlndXJhdGlvbiBtZXRhZGF0YSB4bWwgZG9jLlxuVGhlIHhtbCBkb2N1bWVudCBzaG91bGQgY29tcGx5IHdpdGggW1NBTUwgMi4wIHNwZWNpZmljYXRpb25dKGh0dHBzOi8vZG9jcy5vYXNpcy1vcGVuLm9yZy9zZWN1cml0eS9zYW1sL3YyLjAvc2FtbC1tZXRhZGF0YS0yLjAtb3MucGRmKS5cblRoZSBtYXggc2l6ZSBvZiB0aGUgYWNjZXB0YWJsZSB4bWwgZG9jdW1lbnQgd2lsbCBiZSBib3VuZGVkIHRvIDEyOGsgY2hhcmFjdGVycy5cblxuVGhlIG1ldGFkYXRhIHhtbCBkb2N1bWVudCBzaG91bGQgc2F0aXNmeSB0aGUgZm9sbG93aW5nIGNvbnN0cmFpbnRzOlxuMSkgTXVzdCBjb250YWluIGFuIElkZW50aXR5IFByb3ZpZGVyIEVudGl0eSBJRC5cbjIpIE11c3QgY29udGFpbiBhdCBsZWFzdCBvbmUgbm9uLWV4cGlyZWQgc2lnbmluZyBrZXkgY2VydGlmaWNhdGUuXG4zKSBGb3IgZWFjaCBzaWduaW5nIGtleTogXG4gIGEpIFZhbGlkIGZyb20gc2hvdWxkIGJlIG5vIG1vcmUgdGhhbiA3IGRheXMgZnJvbSBub3cuIFxuICBiKSBWYWxpZCB0byBzaG91bGQgYmUgbm8gbW9yZSB0aGFuIDEwIHllYXJzIGluIHRoZSBmdXR1cmUuIFxuNCkgVXAgdG8gMyBJZFAgc2lnbmluZyBrZXlzIGFyZSBhbGxvd2VkIGluIHRoZSBtZXRhZGF0YSB4bWwuXG5cbldoZW4gdXBkYXRpbmcgdGhlIHByb3ZpZGVyJ3MgbWV0YWRhdGEgeG1sLCBhdCBsZWFzdCBvbmUgbm9uLWV4cGlyZWQgc2lnbmluZyBrZXlcbm11c3Qgb3ZlcmxhcCB3aXRoIHRoZSBleGlzdGluZyBtZXRhZGF0YS4gVGhpcyByZXF1aXJlbWVudCBpcyBza2lwcGVkIGlmIHRoZXJlIGFyZVxubm8gbm9uLWV4cGlyZWQgc2lnbmluZyBrZXlzIHByZXNlbnQgaW4gdGhlIGV4aXN0aW5nIG1ldGFkYXRhLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2lhbV93b3JrZm9yY2VfcG9vbF9wcm92aWRlciNpZHBfbWV0YWRhdGFfeG1sIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciNpZHBfbWV0YWRhdGFfeG1sfVxuICAqL1xuICByZWFkb25seSBpZHBNZXRhZGF0YVhtbDogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyU2FtbFRvVGVycmFmb3JtKHN0cnVjdD86IElhbVdvcmtmb3JjZVBvb2xQcm92aWRlclNhbWxPdXRwdXRSZWZlcmVuY2UgfCBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJTYW1sKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGlkcF9tZXRhZGF0YV94bWw6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuaWRwTWV0YWRhdGFYbWwpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJTYW1sT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJTYW1sIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9pZHBNZXRhZGF0YVhtbCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5pZHBNZXRhZGF0YVhtbCA9IHRoaXMuX2lkcE1ldGFkYXRhWG1sO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyU2FtbCB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2lkcE1ldGFkYXRhWG1sID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9pZHBNZXRhZGF0YVhtbCA9IHZhbHVlLmlkcE1ldGFkYXRhWG1sO1xuICAgIH1cbiAgfVxuXG4gIC8vIGlkcF9tZXRhZGF0YV94bWwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfaWRwTWV0YWRhdGFYbWw/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGlkcE1ldGFkYXRhWG1sKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWRwX21ldGFkYXRhX3htbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWRwTWV0YWRhdGFYbWwodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2lkcE1ldGFkYXRhWG1sID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlkcE1ldGFkYXRhWG1sSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkcE1ldGFkYXRhWG1sO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlclRpbWVvdXRzIHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvZ29vZ2xlL3IvaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyI2NyZWF0ZSBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXIjY3JlYXRlfVxuICAqL1xuICByZWFkb25seSBjcmVhdGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2lhbV93b3JrZm9yY2VfcG9vbF9wcm92aWRlciNkZWxldGUgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyI2RlbGV0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgZGVsZXRlPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIjdXBkYXRlIElhbVdvcmtmb3JjZVBvb2xQcm92aWRlciN1cGRhdGV9XG4gICovXG4gIHJlYWRvbmx5IHVwZGF0ZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlhbVdvcmtmb3JjZVBvb2xQcm92aWRlclRpbWVvdXRzVG9UZXJyYWZvcm0oc3RydWN0PzogSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyVGltZW91dHNPdXRwdXRSZWZlcmVuY2UgfCBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJUaW1lb3V0cyB8IGNka3RmLklSZXNvbHZhYmxlKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGNyZWF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5jcmVhdGUpLFxuICAgIGRlbGV0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5kZWxldGUpLFxuICAgIHVwZGF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS51cGRhdGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJUaW1lb3V0c091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgcHJpdmF0ZSByZXNvbHZhYmxlVmFsdWU/OiBjZGt0Zi5JUmVzb2x2YWJsZTtcblxuICAvKipcbiAgKiBAcGFyYW0gdGVycmFmb3JtUmVzb3VyY2UgVGhlIHBhcmVudCByZXNvdXJjZVxuICAqIEBwYXJhbSB0ZXJyYWZvcm1BdHRyaWJ1dGUgVGhlIGF0dHJpYnV0ZSBvbiB0aGUgcGFyZW50IHJlc291cmNlIHRoaXMgY2xhc3MgaXMgcmVmZXJlbmNpbmdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JSW50ZXJwb2xhdGluZ1BhcmVudCwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcpIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBmYWxzZSwgMCk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyVGltZW91dHMgfCBjZGt0Zi5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKHRoaXMucmVzb2x2YWJsZVZhbHVlKSB7XG4gICAgICByZXR1cm4gdGhpcy5yZXNvbHZhYmxlVmFsdWU7XG4gICAgfVxuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2NyZWF0ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5jcmVhdGUgPSB0aGlzLl9jcmVhdGU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9kZWxldGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVsZXRlID0gdGhpcy5fZGVsZXRlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdXBkYXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnVwZGF0ZSA9IHRoaXMuX3VwZGF0ZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IElhbVdvcmtmb3JjZVBvb2xQcm92aWRlclRpbWVvdXRzIHwgY2RrdGYuSVJlc29sdmFibGUgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLnJlc29sdmFibGVWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2NyZWF0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2RlbGV0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3VwZGF0ZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSBpZiAoY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZSh2YWx1ZSkpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB2YWx1ZTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5yZXNvbHZhYmxlVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZS5jcmVhdGU7XG4gICAgICB0aGlzLl9kZWxldGUgPSB2YWx1ZS5kZWxldGU7XG4gICAgICB0aGlzLl91cGRhdGUgPSB2YWx1ZS51cGRhdGU7XG4gICAgfVxuICB9XG5cbiAgLy8gY3JlYXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NyZWF0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY3JlYXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY3JlYXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCBjcmVhdGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NyZWF0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENyZWF0ZSgpIHtcbiAgICB0aGlzLl9jcmVhdGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNyZWF0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jcmVhdGU7XG4gIH1cblxuICAvLyBkZWxldGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVsZXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBkZWxldGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkZWxldGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGV0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGVsZXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVsZXRlKCkge1xuICAgIHRoaXMuX2RlbGV0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVsZXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlbGV0ZTtcbiAgfVxuXG4gIC8vIHVwZGF0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF91cGRhdGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHVwZGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VwZGF0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgdXBkYXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91cGRhdGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRVcGRhdGUoKSB7XG4gICAgdGhpcy5fdXBkYXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1cGRhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdXBkYXRlO1xuICB9XG59XG5cbi8qKlxuKiBSZXByZXNlbnRzIGEge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9nb29nbGUvci9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXIgZ29vZ2xlX2lhbV93b3JrZm9yY2VfcG9vbF9wcm92aWRlcn1cbiovXG5leHBvcnQgY2xhc3MgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtUmVzb3VyY2Uge1xuXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBQUk9QRVJUSUVTXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgdGZSZXNvdXJjZVR5cGUgPSBcImdvb2dsZV9pYW1fd29ya2ZvcmNlX3Bvb2xfcHJvdmlkZXJcIjtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIC8qKlxuICAqIENyZWF0ZSBhIG5ldyB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2dvb2dsZS9yL2lhbV93b3JrZm9yY2VfcG9vbF9wcm92aWRlciBnb29nbGVfaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyfSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBJYW1Xb3JrZm9yY2VQb29sUHJvdmlkZXJDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdnb29nbGVfaWFtX3dvcmtmb3JjZV9wb29sX3Byb3ZpZGVyJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2dvb2dsZScsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbjogJzQuNTUuMCcsXG4gICAgICAgIHByb3ZpZGVyVmVyc2lvbkNvbnN0cmFpbnQ6ICd+PiA0LjAnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGUsXG4gICAgICBwcm92aXNpb25lcnM6IGNvbmZpZy5wcm92aXNpb25lcnMsXG4gICAgICBjb25uZWN0aW9uOiBjb25maWcuY29ubmVjdGlvbixcbiAgICAgIGZvckVhY2g6IGNvbmZpZy5mb3JFYWNoXG4gICAgfSk7XG4gICAgdGhpcy5fYXR0cmlidXRlQ29uZGl0aW9uID0gY29uZmlnLmF0dHJpYnV0ZUNvbmRpdGlvbjtcbiAgICB0aGlzLl9hdHRyaWJ1dGVNYXBwaW5nID0gY29uZmlnLmF0dHJpYnV0ZU1hcHBpbmc7XG4gICAgdGhpcy5fZGVzY3JpcHRpb24gPSBjb25maWcuZGVzY3JpcHRpb247XG4gICAgdGhpcy5fZGlzYWJsZWQgPSBjb25maWcuZGlzYWJsZWQ7XG4gICAgdGhpcy5fZGlzcGxheU5hbWUgPSBjb25maWcuZGlzcGxheU5hbWU7XG4gICAgdGhpcy5faWQgPSBjb25maWcuaWQ7XG4gICAgdGhpcy5fbG9jYXRpb24gPSBjb25maWcubG9jYXRpb247XG4gICAgdGhpcy5fcHJvdmlkZXJJZCA9IGNvbmZpZy5wcm92aWRlcklkO1xuICAgIHRoaXMuX3dvcmtmb3JjZVBvb2xJZCA9IGNvbmZpZy53b3JrZm9yY2VQb29sSWQ7XG4gICAgdGhpcy5fb2lkYy5pbnRlcm5hbFZhbHVlID0gY29uZmlnLm9pZGM7XG4gICAgdGhpcy5fc2FtbC5pbnRlcm5hbFZhbHVlID0gY29uZmlnLnNhbWw7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy50aW1lb3V0cztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYXR0cmlidXRlX2NvbmRpdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdHRyaWJ1dGVDb25kaXRpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGF0dHJpYnV0ZUNvbmRpdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2F0dHJpYnV0ZV9jb25kaXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGF0dHJpYnV0ZUNvbmRpdGlvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fYXR0cmlidXRlQ29uZGl0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QXR0cmlidXRlQ29uZGl0aW9uKCkge1xuICAgIHRoaXMuX2F0dHJpYnV0ZUNvbmRpdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYXR0cmlidXRlQ29uZGl0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F0dHJpYnV0ZUNvbmRpdGlvbjtcbiAgfVxuXG4gIC8vIGF0dHJpYnV0ZV9tYXBwaW5nIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2F0dHJpYnV0ZU1hcHBpbmc/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9OyBcbiAgcHVibGljIGdldCBhdHRyaWJ1dGVNYXBwaW5nKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ01hcEF0dHJpYnV0ZSgnYXR0cmlidXRlX21hcHBpbmcnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGF0dHJpYnV0ZU1hcHBpbmcodmFsdWU6IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH0pIHtcbiAgICB0aGlzLl9hdHRyaWJ1dGVNYXBwaW5nID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QXR0cmlidXRlTWFwcGluZygpIHtcbiAgICB0aGlzLl9hdHRyaWJ1dGVNYXBwaW5nID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBhdHRyaWJ1dGVNYXBwaW5nSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F0dHJpYnV0ZU1hcHBpbmc7XG4gIH1cblxuICAvLyBkZXNjcmlwdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZXNjcmlwdGlvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGVzY3JpcHRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkZXNjcmlwdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVzY3JpcHRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVzY3JpcHRpb24oKSB7XG4gICAgdGhpcy5fZGVzY3JpcHRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlc2NyaXB0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rlc2NyaXB0aW9uO1xuICB9XG5cbiAgLy8gZGlzYWJsZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGlzYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGRpc2FibGVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2Rpc2FibGVkJyk7XG4gIH1cbiAgcHVibGljIHNldCBkaXNhYmxlZCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fZGlzYWJsZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREaXNhYmxlZCgpIHtcbiAgICB0aGlzLl9kaXNhYmxlZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGlzYWJsZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGlzYWJsZWQ7XG4gIH1cblxuICAvLyBkaXNwbGF5X25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGlzcGxheU5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRpc3BsYXlOYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGlzcGxheV9uYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBkaXNwbGF5TmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGlzcGxheU5hbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREaXNwbGF5TmFtZSgpIHtcbiAgICB0aGlzLl9kaXNwbGF5TmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGlzcGxheU5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGlzcGxheU5hbWU7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZCgpIHtcbiAgICB0aGlzLl9pZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQ7XG4gIH1cblxuICAvLyBsb2NhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9sb2NhdGlvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbG9jYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdsb2NhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgbG9jYXRpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2xvY2F0aW9uID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGxvY2F0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2xvY2F0aW9uO1xuICB9XG5cbiAgLy8gbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCduYW1lJyk7XG4gIH1cblxuICAvLyBwcm92aWRlcl9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9wcm92aWRlcklkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBwcm92aWRlcklkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncHJvdmlkZXJfaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHByb3ZpZGVySWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Byb3ZpZGVySWQgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJvdmlkZXJJZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcm92aWRlcklkO1xuICB9XG5cbiAgLy8gc3RhdGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBzdGF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3N0YXRlJyk7XG4gIH1cblxuICAvLyB3b3JrZm9yY2VfcG9vbF9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF93b3JrZm9yY2VQb29sSWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHdvcmtmb3JjZVBvb2xJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3dvcmtmb3JjZV9wb29sX2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCB3b3JrZm9yY2VQb29sSWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3dvcmtmb3JjZVBvb2xJZCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB3b3JrZm9yY2VQb29sSWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fd29ya2ZvcmNlUG9vbElkO1xuICB9XG5cbiAgLy8gb2lkYyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9vaWRjID0gbmV3IElhbVdvcmtmb3JjZVBvb2xQcm92aWRlck9pZGNPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJvaWRjXCIpO1xuICBwdWJsaWMgZ2V0IG9pZGMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX29pZGM7XG4gIH1cbiAgcHVibGljIHB1dE9pZGModmFsdWU6IElhbVdvcmtmb3JjZVBvb2xQcm92aWRlck9pZGMpIHtcbiAgICB0aGlzLl9vaWRjLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRPaWRjKCkge1xuICAgIHRoaXMuX29pZGMuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgb2lkY0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9vaWRjLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBzYW1sIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NhbWwgPSBuZXcgSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyU2FtbE91dHB1dFJlZmVyZW5jZSh0aGlzLCBcInNhbWxcIik7XG4gIHB1YmxpYyBnZXQgc2FtbCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2FtbDtcbiAgfVxuICBwdWJsaWMgcHV0U2FtbCh2YWx1ZTogSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyU2FtbCkge1xuICAgIHRoaXMuX3NhbWwuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNhbWwoKSB7XG4gICAgdGhpcy5fc2FtbC5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzYW1sSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NhbWwuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIHRpbWVvdXRzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RpbWVvdXRzID0gbmV3IElhbVdvcmtmb3JjZVBvb2xQcm92aWRlclRpbWVvdXRzT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwidGltZW91dHNcIik7XG4gIHB1YmxpYyBnZXQgdGltZW91dHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RpbWVvdXRzO1xuICB9XG4gIHB1YmxpYyBwdXRUaW1lb3V0cyh2YWx1ZTogSWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyVGltZW91dHMpIHtcbiAgICB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGltZW91dHMoKSB7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGltZW91dHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYXR0cmlidXRlX2NvbmRpdGlvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fYXR0cmlidXRlQ29uZGl0aW9uKSxcbiAgICAgIGF0dHJpYnV0ZV9tYXBwaW5nOiBjZGt0Zi5oYXNoTWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKSh0aGlzLl9hdHRyaWJ1dGVNYXBwaW5nKSxcbiAgICAgIGRlc2NyaXB0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9kZXNjcmlwdGlvbiksXG4gICAgICBkaXNhYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2Rpc2FibGVkKSxcbiAgICAgIGRpc3BsYXlfbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZGlzcGxheU5hbWUpLFxuICAgICAgaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2lkKSxcbiAgICAgIGxvY2F0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9sb2NhdGlvbiksXG4gICAgICBwcm92aWRlcl9pZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fcHJvdmlkZXJJZCksXG4gICAgICB3b3JrZm9yY2VfcG9vbF9pZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fd29ya2ZvcmNlUG9vbElkKSxcbiAgICAgIG9pZGM6IGlhbVdvcmtmb3JjZVBvb2xQcm92aWRlck9pZGNUb1RlcnJhZm9ybSh0aGlzLl9vaWRjLmludGVybmFsVmFsdWUpLFxuICAgICAgc2FtbDogaWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyU2FtbFRvVGVycmFmb3JtKHRoaXMuX3NhbWwuaW50ZXJuYWxWYWx1ZSksXG4gICAgICB0aW1lb3V0czogaWFtV29ya2ZvcmNlUG9vbFByb3ZpZGVyVGltZW91dHNUb1RlcnJhZm9ybSh0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlKSxcbiAgICB9O1xuICB9XG59XG4iXX0=