import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IamWorkforcePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * A user-specified description of the pool. Cannot exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#description IamWorkforcePool#description}
    */
    readonly description?: string;
    /**
    * Whether the pool is disabled. You cannot use a disabled pool to exchange tokens,
  or use existing tokens to access resources. If the pool is re-enabled, existing tokens grant access again.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#disabled IamWorkforcePool#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * A user-specified display name of the pool in Google Cloud Console. Cannot exceed 32 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#display_name IamWorkforcePool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#id IamWorkforcePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#location IamWorkforcePool#location}
    */
    readonly location: string;
    /**
    * Immutable. The resource name of the parent. Format: 'organizations/{org-id}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#parent IamWorkforcePool#parent}
    */
    readonly parent: string;
    /**
    * Duration that the Google Cloud access tokens, console sign-in sessions,
  and 'gcloud' sign-in sessions from this pool are valid.
  Must be greater than 15 minutes (900s) and less than 12 hours (43200s).
  If 'sessionDuration' is not configured, minted credentials have a default duration of one hour (3600s).
  A duration in seconds with up to nine fractional digits, ending with ''s''. Example: "'3.5s'".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#session_duration IamWorkforcePool#session_duration}
    */
    readonly sessionDuration?: string;
    /**
    * The name of the pool. The ID must be a globally unique string of 6 to 63 lowercase letters,
  digits, or hyphens. It must start with a letter, and cannot have a trailing hyphen.
  The prefix 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#workforce_pool_id IamWorkforcePool#workforce_pool_id}
    */
    readonly workforcePoolId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#timeouts IamWorkforcePool#timeouts}
    */
    readonly timeouts?: IamWorkforcePoolTimeouts;
}
export interface IamWorkforcePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#create IamWorkforcePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#delete IamWorkforcePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool#update IamWorkforcePool#update}
    */
    readonly update?: string;
}
export declare function iamWorkforcePoolTimeoutsToTerraform(struct?: IamWorkforcePoolTimeoutsOutputReference | IamWorkforcePoolTimeouts | cdktf.IResolvable): any;
export declare class IamWorkforcePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkforcePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IamWorkforcePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool google_iam_workforce_pool}
*/
export declare class IamWorkforcePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_workforce_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iam_workforce_pool google_iam_workforce_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IamWorkforcePoolConfig
    */
    constructor(scope: Construct, id: string, config: IamWorkforcePoolConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _sessionDuration?;
    get sessionDuration(): string;
    set sessionDuration(value: string);
    resetSessionDuration(): void;
    get sessionDurationInput(): string | undefined;
    get state(): string;
    private _workforcePoolId?;
    get workforcePoolId(): string;
    set workforcePoolId(value: string);
    get workforcePoolIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): IamWorkforcePoolTimeoutsOutputReference;
    putTimeouts(value: IamWorkforcePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IamWorkforcePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
