import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsCryptoKeyVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the cryptoKey associated with the CryptoKeyVersions.
  Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyring}}/cryptoKeys/{{cryptoKey}}''
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version#crypto_key KmsCryptoKeyVersion#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version#id KmsCryptoKeyVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The current state of the CryptoKeyVersion. Possible values: ["PENDING_GENERATION", "ENABLED", "DISABLED", "DESTROYED", "DESTROY_SCHEDULED", "PENDING_IMPORT", "IMPORT_FAILED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version#state KmsCryptoKeyVersion#state}
    */
    readonly state?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version#timeouts KmsCryptoKeyVersion#timeouts}
    */
    readonly timeouts?: KmsCryptoKeyVersionTimeouts;
}
export interface KmsCryptoKeyVersionAttestationCertChains {
}
export declare function kmsCryptoKeyVersionAttestationCertChainsToTerraform(struct?: KmsCryptoKeyVersionAttestationCertChains): any;
export declare class KmsCryptoKeyVersionAttestationCertChainsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KmsCryptoKeyVersionAttestationCertChains | undefined;
    set internalValue(value: KmsCryptoKeyVersionAttestationCertChains | undefined);
    get caviumCerts(): string;
    get googleCardCerts(): string;
    get googlePartitionCerts(): string;
}
export declare class KmsCryptoKeyVersionAttestationCertChainsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KmsCryptoKeyVersionAttestationCertChainsOutputReference;
}
export interface KmsCryptoKeyVersionAttestationExternalProtectionLevelOptions {
}
export declare function kmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsToTerraform(struct?: KmsCryptoKeyVersionAttestationExternalProtectionLevelOptions): any;
export declare class KmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KmsCryptoKeyVersionAttestationExternalProtectionLevelOptions | undefined;
    set internalValue(value: KmsCryptoKeyVersionAttestationExternalProtectionLevelOptions | undefined);
    get ekmConnectionKeyPath(): string;
    get externalKeyUri(): string;
}
export declare class KmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsOutputReference;
}
export interface KmsCryptoKeyVersionAttestation {
}
export declare function kmsCryptoKeyVersionAttestationToTerraform(struct?: KmsCryptoKeyVersionAttestation): any;
export declare class KmsCryptoKeyVersionAttestationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KmsCryptoKeyVersionAttestation | undefined;
    set internalValue(value: KmsCryptoKeyVersionAttestation | undefined);
    private _certChains;
    get certChains(): KmsCryptoKeyVersionAttestationCertChainsList;
    get content(): string;
    private _externalProtectionLevelOptions;
    get externalProtectionLevelOptions(): KmsCryptoKeyVersionAttestationExternalProtectionLevelOptionsList;
    get format(): string;
}
export declare class KmsCryptoKeyVersionAttestationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KmsCryptoKeyVersionAttestationOutputReference;
}
export interface KmsCryptoKeyVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version#create KmsCryptoKeyVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version#delete KmsCryptoKeyVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version#update KmsCryptoKeyVersion#update}
    */
    readonly update?: string;
}
export declare function kmsCryptoKeyVersionTimeoutsToTerraform(struct?: KmsCryptoKeyVersionTimeoutsOutputReference | KmsCryptoKeyVersionTimeouts | cdktf.IResolvable): any;
export declare class KmsCryptoKeyVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KmsCryptoKeyVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KmsCryptoKeyVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version google_kms_crypto_key_version}
*/
export declare class KmsCryptoKeyVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_crypto_key_version";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_version google_kms_crypto_key_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsCryptoKeyVersionConfig
    */
    constructor(scope: Construct, id: string, config: KmsCryptoKeyVersionConfig);
    get algorithm(): string;
    private _attestation;
    get attestation(): KmsCryptoKeyVersionAttestationList;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    get generateTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get protectionLevel(): string;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _timeouts;
    get timeouts(): KmsCryptoKeyVersionTimeoutsOutputReference;
    putTimeouts(value: KmsCryptoKeyVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KmsCryptoKeyVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
