import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringSloConfig extends cdktf.TerraformMetaArguments {
    /**
    * A calendar period, semantically "since the start of the current
  <calendarPeriod>". Possible values: ["DAY", "WEEK", "FORTNIGHT", "MONTH"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#calendar_period MonitoringSlo#calendar_period}
    */
    readonly calendarPeriod?: string;
    /**
    * Name used for UI elements listing this SLO.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#display_name MonitoringSlo#display_name}
    */
    readonly displayName?: string;
    /**
    * The fraction of service that must be good in order for this objective
  to be met. 0 < goal <= 0.999
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#goal MonitoringSlo#goal}
    */
    readonly goal: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#id MonitoringSlo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#project MonitoringSlo#project}
    */
    readonly project?: string;
    /**
    * A rolling time period, semantically "in the past X days".
  Must be between 1 to 30 days, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#rolling_period_days MonitoringSlo#rolling_period_days}
    */
    readonly rollingPeriodDays?: number;
    /**
    * ID of the service to which this SLO belongs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#service MonitoringSlo#service}
    */
    readonly service: string;
    /**
    * The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#slo_id MonitoringSlo#slo_id}
    */
    readonly sloId?: string;
    /**
    * This field is intended to be used for organizing and identifying the AlertPolicy
  objects.The field can contain up to 64 entries. Each key and value is limited
  to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
  can contain only lowercase letters, numerals, underscores, and dashes. Keys
  must begin with a letter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#user_labels MonitoringSlo#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * basic_sli block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#basic_sli MonitoringSlo#basic_sli}
    */
    readonly basicSli?: MonitoringSloBasicSli;
    /**
    * request_based_sli block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#request_based_sli MonitoringSlo#request_based_sli}
    */
    readonly requestBasedSli?: MonitoringSloRequestBasedSli;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#timeouts MonitoringSlo#timeouts}
    */
    readonly timeouts?: MonitoringSloTimeouts;
    /**
    * windows_based_sli block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#windows_based_sli MonitoringSlo#windows_based_sli}
    */
    readonly windowsBasedSli?: MonitoringSloWindowsBasedSli;
}
export interface MonitoringSloBasicSliAvailability {
    /**
    * Whether an availability SLI is enabled or not. Must be set to true. Defaults to 'true'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#enabled MonitoringSlo#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function monitoringSloBasicSliAvailabilityToTerraform(struct?: MonitoringSloBasicSliAvailabilityOutputReference | MonitoringSloBasicSliAvailability): any;
export declare class MonitoringSloBasicSliAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloBasicSliAvailability | undefined;
    set internalValue(value: MonitoringSloBasicSliAvailability | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitoringSloBasicSliLatency {
    /**
    * A duration string, e.g. 10s.
  Good service is defined to be the count of requests made to
  this service that return in no more than threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#threshold MonitoringSlo#threshold}
    */
    readonly threshold: string;
}
export declare function monitoringSloBasicSliLatencyToTerraform(struct?: MonitoringSloBasicSliLatencyOutputReference | MonitoringSloBasicSliLatency): any;
export declare class MonitoringSloBasicSliLatencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloBasicSliLatency | undefined;
    set internalValue(value: MonitoringSloBasicSliLatency | undefined);
    private _threshold?;
    get threshold(): string;
    set threshold(value: string);
    get thresholdInput(): string | undefined;
}
export interface MonitoringSloBasicSli {
    /**
    * An optional set of locations to which this SLI is relevant.
  Telemetry from other locations will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  locations in which the Service has activity. For service types
  that don't support breaking down by location, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#location MonitoringSlo#location}
    */
    readonly location?: string[];
    /**
    * An optional set of RPCs to which this SLI is relevant.
  Telemetry from other methods will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  the Service's methods. For service types that don't support
  breaking down by method, setting this field will result in an
  error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#method MonitoringSlo#method}
    */
    readonly method?: string[];
    /**
    * The set of API versions to which this SLI is relevant.
  Telemetry from other API versions will not be used to
  calculate performance for this SLI. If omitted,
  this SLI applies to all API versions. For service types
  that don't support breaking down by version, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#version MonitoringSlo#version}
    */
    readonly version?: string[];
    /**
    * availability block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#availability MonitoringSlo#availability}
    */
    readonly availability?: MonitoringSloBasicSliAvailability;
    /**
    * latency block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#latency MonitoringSlo#latency}
    */
    readonly latency?: MonitoringSloBasicSliLatency;
}
export declare function monitoringSloBasicSliToTerraform(struct?: MonitoringSloBasicSliOutputReference | MonitoringSloBasicSli): any;
export declare class MonitoringSloBasicSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloBasicSli | undefined;
    set internalValue(value: MonitoringSloBasicSli | undefined);
    private _location?;
    get location(): string[];
    set location(value: string[]);
    resetLocation(): void;
    get locationInput(): string[] | undefined;
    private _method?;
    get method(): string[];
    set method(value: string[]);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _version?;
    get version(): string[];
    set version(value: string[]);
    resetVersion(): void;
    get versionInput(): string[] | undefined;
    private _availability;
    get availability(): MonitoringSloBasicSliAvailabilityOutputReference;
    putAvailability(value: MonitoringSloBasicSliAvailability): void;
    resetAvailability(): void;
    get availabilityInput(): MonitoringSloBasicSliAvailability | undefined;
    private _latency;
    get latency(): MonitoringSloBasicSliLatencyOutputReference;
    putLatency(value: MonitoringSloBasicSliLatency): void;
    resetLatency(): void;
    get latencyInput(): MonitoringSloBasicSliLatency | undefined;
}
export interface MonitoringSloRequestBasedSliDistributionCutRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to "infinity", defining an open range
  ">= range.min"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to "-infinity", defining an open range
  "< range.max"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function monitoringSloRequestBasedSliDistributionCutRangeToTerraform(struct?: MonitoringSloRequestBasedSliDistributionCutRangeOutputReference | MonitoringSloRequestBasedSliDistributionCutRange): any;
export declare class MonitoringSloRequestBasedSliDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloRequestBasedSliDistributionCutRange | undefined;
    set internalValue(value: MonitoringSloRequestBasedSliDistributionCutRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloRequestBasedSliDistributionCut {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  aggregating values to quantify the good service provided.
  
  Must have ValueType = DISTRIBUTION and
  MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_filter MonitoringSlo#distribution_filter}
    */
    readonly distributionFilter: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
    */
    readonly range: MonitoringSloRequestBasedSliDistributionCutRange;
}
export declare function monitoringSloRequestBasedSliDistributionCutToTerraform(struct?: MonitoringSloRequestBasedSliDistributionCutOutputReference | MonitoringSloRequestBasedSliDistributionCut): any;
export declare class MonitoringSloRequestBasedSliDistributionCutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloRequestBasedSliDistributionCut | undefined;
    set internalValue(value: MonitoringSloRequestBasedSliDistributionCut | undefined);
    private _distributionFilter?;
    get distributionFilter(): string;
    set distributionFilter(value: string);
    get distributionFilterInput(): string | undefined;
    private _range;
    get range(): MonitoringSloRequestBasedSliDistributionCutRangeOutputReference;
    putRange(value: MonitoringSloRequestBasedSliDistributionCutRange): void;
    get rangeInput(): MonitoringSloRequestBasedSliDistributionCutRange | undefined;
}
export interface MonitoringSloRequestBasedSliGoodTotalRatio {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying bad service provided, either demanded service that
  was not provided or demanded service that was of inadequate
  quality.
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
  
  Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
  must be set (good + bad = total is assumed).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#bad_service_filter MonitoringSlo#bad_service_filter}
    */
    readonly badServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying good service provided.
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
  
  Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
  must be set (good + bad = total is assumed).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_service_filter MonitoringSlo#good_service_filter}
    */
    readonly goodServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying total demanded service.
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
  
  Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
  must be set (good + bad = total is assumed).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#total_service_filter MonitoringSlo#total_service_filter}
    */
    readonly totalServiceFilter?: string;
}
export declare function monitoringSloRequestBasedSliGoodTotalRatioToTerraform(struct?: MonitoringSloRequestBasedSliGoodTotalRatioOutputReference | MonitoringSloRequestBasedSliGoodTotalRatio): any;
export declare class MonitoringSloRequestBasedSliGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloRequestBasedSliGoodTotalRatio | undefined;
    set internalValue(value: MonitoringSloRequestBasedSliGoodTotalRatio | undefined);
    private _badServiceFilter?;
    get badServiceFilter(): string;
    set badServiceFilter(value: string);
    resetBadServiceFilter(): void;
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    get goodServiceFilter(): string;
    set goodServiceFilter(value: string);
    resetGoodServiceFilter(): void;
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    get totalServiceFilter(): string;
    set totalServiceFilter(value: string);
    resetTotalServiceFilter(): void;
    get totalServiceFilterInput(): string | undefined;
}
export interface MonitoringSloRequestBasedSli {
    /**
    * distribution_cut block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_cut MonitoringSlo#distribution_cut}
    */
    readonly distributionCut?: MonitoringSloRequestBasedSliDistributionCut;
    /**
    * good_total_ratio block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_total_ratio MonitoringSlo#good_total_ratio}
    */
    readonly goodTotalRatio?: MonitoringSloRequestBasedSliGoodTotalRatio;
}
export declare function monitoringSloRequestBasedSliToTerraform(struct?: MonitoringSloRequestBasedSliOutputReference | MonitoringSloRequestBasedSli): any;
export declare class MonitoringSloRequestBasedSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloRequestBasedSli | undefined;
    set internalValue(value: MonitoringSloRequestBasedSli | undefined);
    private _distributionCut;
    get distributionCut(): MonitoringSloRequestBasedSliDistributionCutOutputReference;
    putDistributionCut(value: MonitoringSloRequestBasedSliDistributionCut): void;
    resetDistributionCut(): void;
    get distributionCutInput(): MonitoringSloRequestBasedSliDistributionCut | undefined;
    private _goodTotalRatio;
    get goodTotalRatio(): MonitoringSloRequestBasedSliGoodTotalRatioOutputReference;
    putGoodTotalRatio(value: MonitoringSloRequestBasedSliGoodTotalRatio): void;
    resetGoodTotalRatio(): void;
    get goodTotalRatioInput(): MonitoringSloRequestBasedSliGoodTotalRatio | undefined;
}
export interface MonitoringSloTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#create MonitoringSlo#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#delete MonitoringSlo#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#update MonitoringSlo#update}
    */
    readonly update?: string;
}
export declare function monitoringSloTimeoutsToTerraform(struct?: MonitoringSloTimeoutsOutputReference | MonitoringSloTimeouts | cdktf.IResolvable): any;
export declare class MonitoringSloTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitoringSloTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability {
    /**
    * Whether an availability SLI is enabled or not. Must be set to 'true. Defaults to 'true'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#enabled MonitoringSlo#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency {
    /**
    * A duration string, e.g. 10s.
  Good service is defined to be the count of requests made to
  this service that return in no more than threshold.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#threshold MonitoringSlo#threshold}
    */
    readonly threshold: string;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined);
    private _threshold?;
    get threshold(): string;
    set threshold(value: string);
    get thresholdInput(): string | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance {
    /**
    * An optional set of locations to which this SLI is relevant.
  Telemetry from other locations will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  locations in which the Service has activity. For service types
  that don't support breaking down by location, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#location MonitoringSlo#location}
    */
    readonly location?: string[];
    /**
    * An optional set of RPCs to which this SLI is relevant.
  Telemetry from other methods will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  the Service's methods. For service types that don't support
  breaking down by method, setting this field will result in an
  error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#method MonitoringSlo#method}
    */
    readonly method?: string[];
    /**
    * The set of API versions to which this SLI is relevant.
  Telemetry from other API versions will not be used to
  calculate performance for this SLI. If omitted,
  this SLI applies to all API versions. For service types
  that don't support breaking down by version, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#version MonitoringSlo#version}
    */
    readonly version?: string[];
    /**
    * availability block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#availability MonitoringSlo#availability}
    */
    readonly availability?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability;
    /**
    * latency block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#latency MonitoringSlo#latency}
    */
    readonly latency?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined);
    private _location?;
    get location(): string[];
    set location(value: string[]);
    resetLocation(): void;
    get locationInput(): string[] | undefined;
    private _method?;
    get method(): string[];
    set method(value: string[]);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _version?;
    get version(): string[];
    set version(value: string[]);
    resetVersion(): void;
    get versionInput(): string[] | undefined;
    private _availability;
    get availability(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference;
    putAvailability(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability): void;
    resetAvailability(): void;
    get availabilityInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined;
    private _latency;
    get latency(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference;
    putLatency(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency): void;
    resetLatency(): void;
    get latencyInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to "infinity", defining an open range
  ">= range.min"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to "-infinity", defining an open range
  "< range.max"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  aggregating values to quantify the good service provided.
  
  Must have ValueType = DISTRIBUTION and
  MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_filter MonitoringSlo#distribution_filter}
    */
    readonly distributionFilter: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
    */
    readonly range: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined);
    private _distributionFilter?;
    get distributionFilter(): string;
    set distributionFilter(value: string);
    get distributionFilterInput(): string | undefined;
    private _range;
    get range(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference;
    putRange(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange): void;
    get rangeInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying bad service provided, either demanded service that
  was not provided or demanded service that was of inadequate
  quality. Exactly two of
  good, bad, or total service filter must be defined (where
  good + bad = total is assumed)
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#bad_service_filter MonitoringSlo#bad_service_filter}
    */
    readonly badServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying good service provided. Exactly two of
  good, bad, or total service filter must be defined (where
  good + bad = total is assumed)
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_service_filter MonitoringSlo#good_service_filter}
    */
    readonly goodServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying total demanded service. Exactly two of
  good, bad, or total service filter must be defined (where
  good + bad = total is assumed)
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#total_service_filter MonitoringSlo#total_service_filter}
    */
    readonly totalServiceFilter?: string;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined);
    private _badServiceFilter?;
    get badServiceFilter(): string;
    set badServiceFilter(value: string);
    resetBadServiceFilter(): void;
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    get goodServiceFilter(): string;
    set goodServiceFilter(value: string);
    resetGoodServiceFilter(): void;
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    get totalServiceFilter(): string;
    set totalServiceFilter(value: string);
    resetTotalServiceFilter(): void;
    get totalServiceFilterInput(): string | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance {
    /**
    * distribution_cut block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#distribution_cut MonitoringSlo#distribution_cut}
    */
    readonly distributionCut?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut;
    /**
    * good_total_ratio block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_total_ratio MonitoringSlo#good_total_ratio}
    */
    readonly goodTotalRatio?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined);
    private _distributionCut;
    get distributionCut(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference;
    putDistributionCut(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut): void;
    resetDistributionCut(): void;
    get distributionCutInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined;
    private _goodTotalRatio;
    get goodTotalRatio(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference;
    putGoodTotalRatio(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio): void;
    resetGoodTotalRatio(): void;
    get goodTotalRatioInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined;
}
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThreshold {
    /**
    * If window performance >= threshold, the window is counted
  as good.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#threshold MonitoringSlo#threshold}
    */
    readonly threshold?: number;
    /**
    * basic_sli_performance block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#basic_sli_performance MonitoringSlo#basic_sli_performance}
    */
    readonly basicSliPerformance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance;
    /**
    * performance block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#performance MonitoringSlo#performance}
    */
    readonly performance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance;
}
export declare function monitoringSloWindowsBasedSliGoodTotalRatioThresholdToTerraform(struct?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference | MonitoringSloWindowsBasedSliGoodTotalRatioThreshold): any;
export declare class MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined);
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    resetThreshold(): void;
    get thresholdInput(): number | undefined;
    private _basicSliPerformance;
    get basicSliPerformance(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference;
    putBasicSliPerformance(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance): void;
    resetBasicSliPerformance(): void;
    get basicSliPerformanceInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined;
    private _performance;
    get performance(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference;
    putPerformance(value: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance): void;
    resetPerformance(): void;
    get performanceInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricMeanInRangeRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to "infinity", defining an open range
  ">= range.min"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to "-infinity", defining an open range
  "< range.max"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function monitoringSloWindowsBasedSliMetricMeanInRangeRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference | MonitoringSloWindowsBasedSliMetricMeanInRangeRange): any;
export declare class MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricMeanInRange {
    /**
    * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  specifying the TimeSeries to use for evaluating window
  The provided TimeSeries must have ValueType = INT64 or
  ValueType = DOUBLE and MetricKind = GAUGE. Mean value 'X'
  should satisfy 'range.min <= X <= range.max'
  under good service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#time_series MonitoringSlo#time_series}
    */
    readonly timeSeries: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
    */
    readonly range: MonitoringSloWindowsBasedSliMetricMeanInRangeRange;
}
export declare function monitoringSloWindowsBasedSliMetricMeanInRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference | MonitoringSloWindowsBasedSliMetricMeanInRange): any;
export declare class MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliMetricMeanInRange | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliMetricMeanInRange | undefined);
    private _timeSeries?;
    get timeSeries(): string;
    set timeSeries(value: string);
    get timeSeriesInput(): string | undefined;
    private _range;
    get range(): MonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference;
    putRange(value: MonitoringSloWindowsBasedSliMetricMeanInRangeRange): void;
    get rangeInput(): MonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricSumInRangeRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to "infinity", defining an open range
  ">= range.min"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#max MonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to "-infinity", defining an open range
  "< range.max"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#min MonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function monitoringSloWindowsBasedSliMetricSumInRangeRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference | MonitoringSloWindowsBasedSliMetricSumInRangeRange): any;
export declare class MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface MonitoringSloWindowsBasedSliMetricSumInRange {
    /**
    * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  specifying the TimeSeries to use for evaluating window
  quality. The provided TimeSeries must have
  ValueType = INT64 or ValueType = DOUBLE and
  MetricKind = GAUGE.
  
  Summed value 'X' should satisfy
  'range.min <= X <= range.max' for a good window.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#time_series MonitoringSlo#time_series}
    */
    readonly timeSeries: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#range MonitoringSlo#range}
    */
    readonly range: MonitoringSloWindowsBasedSliMetricSumInRangeRange;
}
export declare function monitoringSloWindowsBasedSliMetricSumInRangeToTerraform(struct?: MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference | MonitoringSloWindowsBasedSliMetricSumInRange): any;
export declare class MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSliMetricSumInRange | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSliMetricSumInRange | undefined);
    private _timeSeries?;
    get timeSeries(): string;
    set timeSeries(value: string);
    get timeSeriesInput(): string | undefined;
    private _range;
    get range(): MonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference;
    putRange(value: MonitoringSloWindowsBasedSliMetricSumInRangeRange): void;
    get rangeInput(): MonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined;
}
export interface MonitoringSloWindowsBasedSli {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  with ValueType = BOOL. The window is good if any true values
  appear in the window. One of 'good_bad_metric_filter',
  'good_total_ratio_threshold', 'metric_mean_in_range',
  'metric_sum_in_range' must be set for 'windows_based_sli'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_bad_metric_filter MonitoringSlo#good_bad_metric_filter}
    */
    readonly goodBadMetricFilter?: string;
    /**
    * Duration over which window quality is evaluated, given as a
  duration string "{X}s" representing X seconds. Must be an
  integer fraction of a day and at least 60s.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#window_period MonitoringSlo#window_period}
    */
    readonly windowPeriod?: string;
    /**
    * good_total_ratio_threshold block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#good_total_ratio_threshold MonitoringSlo#good_total_ratio_threshold}
    */
    readonly goodTotalRatioThreshold?: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold;
    /**
    * metric_mean_in_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#metric_mean_in_range MonitoringSlo#metric_mean_in_range}
    */
    readonly metricMeanInRange?: MonitoringSloWindowsBasedSliMetricMeanInRange;
    /**
    * metric_sum_in_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo#metric_sum_in_range MonitoringSlo#metric_sum_in_range}
    */
    readonly metricSumInRange?: MonitoringSloWindowsBasedSliMetricSumInRange;
}
export declare function monitoringSloWindowsBasedSliToTerraform(struct?: MonitoringSloWindowsBasedSliOutputReference | MonitoringSloWindowsBasedSli): any;
export declare class MonitoringSloWindowsBasedSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringSloWindowsBasedSli | undefined;
    set internalValue(value: MonitoringSloWindowsBasedSli | undefined);
    private _goodBadMetricFilter?;
    get goodBadMetricFilter(): string;
    set goodBadMetricFilter(value: string);
    resetGoodBadMetricFilter(): void;
    get goodBadMetricFilterInput(): string | undefined;
    private _windowPeriod?;
    get windowPeriod(): string;
    set windowPeriod(value: string);
    resetWindowPeriod(): void;
    get windowPeriodInput(): string | undefined;
    private _goodTotalRatioThreshold;
    get goodTotalRatioThreshold(): MonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference;
    putGoodTotalRatioThreshold(value: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold): void;
    resetGoodTotalRatioThreshold(): void;
    get goodTotalRatioThresholdInput(): MonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined;
    private _metricMeanInRange;
    get metricMeanInRange(): MonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference;
    putMetricMeanInRange(value: MonitoringSloWindowsBasedSliMetricMeanInRange): void;
    resetMetricMeanInRange(): void;
    get metricMeanInRangeInput(): MonitoringSloWindowsBasedSliMetricMeanInRange | undefined;
    private _metricSumInRange;
    get metricSumInRange(): MonitoringSloWindowsBasedSliMetricSumInRangeOutputReference;
    putMetricSumInRange(value: MonitoringSloWindowsBasedSliMetricSumInRange): void;
    resetMetricSumInRange(): void;
    get metricSumInRangeInput(): MonitoringSloWindowsBasedSliMetricSumInRange | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo google_monitoring_slo}
*/
export declare class MonitoringSlo extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_slo";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo google_monitoring_slo} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringSloConfig
    */
    constructor(scope: Construct, id: string, config: MonitoringSloConfig);
    private _calendarPeriod?;
    get calendarPeriod(): string;
    set calendarPeriod(value: string);
    resetCalendarPeriod(): void;
    get calendarPeriodInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _goal?;
    get goal(): number;
    set goal(value: number);
    get goalInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rollingPeriodDays?;
    get rollingPeriodDays(): number;
    set rollingPeriodDays(value: number);
    resetRollingPeriodDays(): void;
    get rollingPeriodDaysInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _sloId?;
    get sloId(): string;
    set sloId(value: string);
    resetSloId(): void;
    get sloIdInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _basicSli;
    get basicSli(): MonitoringSloBasicSliOutputReference;
    putBasicSli(value: MonitoringSloBasicSli): void;
    resetBasicSli(): void;
    get basicSliInput(): MonitoringSloBasicSli | undefined;
    private _requestBasedSli;
    get requestBasedSli(): MonitoringSloRequestBasedSliOutputReference;
    putRequestBasedSli(value: MonitoringSloRequestBasedSli): void;
    resetRequestBasedSli(): void;
    get requestBasedSliInput(): MonitoringSloRequestBasedSli | undefined;
    private _timeouts;
    get timeouts(): MonitoringSloTimeoutsOutputReference;
    putTimeouts(value: MonitoringSloTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitoringSloTimeouts | undefined;
    private _windowsBasedSli;
    get windowsBasedSli(): MonitoringSloWindowsBasedSliOutputReference;
    putWindowsBasedSli(value: MonitoringSloWindowsBasedSli): void;
    resetWindowsBasedSli(): void;
    get windowsBasedSliInput(): MonitoringSloWindowsBasedSli | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
