import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkServicesEdgeCacheOriginConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#description NetworkServicesEdgeCacheOrigin#description}
    */
    readonly description?: string;
    /**
    * The Origin resource to try when the current origin cannot be reached.
  After maxAttempts is reached, the configured failoverOrigin will be used to fulfil the request.
  
  The value of timeout.maxAttemptsTimeout dictates the timeout across all origins.
  A reference to a Topic resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#failover_origin NetworkServicesEdgeCacheOrigin#failover_origin}
    */
    readonly failoverOrigin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#id NetworkServicesEdgeCacheOrigin#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the EdgeCache resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#labels NetworkServicesEdgeCacheOrigin#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The maximum number of attempts to cache fill from this origin. Another attempt is made when a cache fill fails with one of the retryConditions.
  
  Once maxAttempts to this origin have failed the failoverOrigin will be used, if one is specified. That failoverOrigin may specify its own maxAttempts,
  retryConditions and failoverOrigin to control its own cache fill failures.
  
  The total number of allowed attempts to cache fill across this and failover origins is limited to four.
  The total time allowed for cache fill attempts across this and failover origins can be controlled with maxAttemptsTimeout.
  
  The last valid, non-retried response from all origins will be returned to the client.
  If no origin returns a valid response, an HTTP 502 will be returned to the client.
  
  Defaults to 1. Must be a value greater than 0 and less than 4.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#max_attempts NetworkServicesEdgeCacheOrigin#max_attempts}
    */
    readonly maxAttempts?: number;
    /**
    * Name of the resource; provided by the client when the resource is created.
  The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
  and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#name NetworkServicesEdgeCacheOrigin#name}
    */
    readonly name: string;
    /**
    * A fully qualified domain name (FQDN) or IP address reachable over the public Internet, or the address of a Google Cloud Storage bucket.
  
  This address will be used as the origin for cache requests - e.g. FQDN: media-backend.example.com, IPv4: 35.218.1.1, IPv6: 2607:f8b0:4012:809::200e, Cloud Storage: gs://bucketname
  
  When providing an FQDN (hostname), it must be publicly resolvable (e.g. via Google public DNS) and IP addresses must be publicly routable.  It must not contain a protocol (e.g., https://) and it must not contain any slashes.
  If a Cloud Storage bucket is provided, it must be in the canonical "gs://bucketname" format. Other forms, such as "storage.googleapis.com", will be rejected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#origin_address NetworkServicesEdgeCacheOrigin#origin_address}
    */
    readonly originAddress: string;
    /**
    * The port to connect to the origin on.
  Defaults to port 443 for HTTP2 and HTTPS protocols, and port 80 for HTTP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#port NetworkServicesEdgeCacheOrigin#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#project NetworkServicesEdgeCacheOrigin#project}
    */
    readonly project?: string;
    /**
    * The protocol to use to connect to the configured origin. Defaults to HTTP2, and it is strongly recommended that users use HTTP2 for both security & performance.
  
  When using HTTP2 or HTTPS as the protocol, a valid, publicly-signed, unexpired TLS (SSL) certificate must be presented by the origin server. Possible values: ["HTTP2", "HTTPS", "HTTP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#protocol NetworkServicesEdgeCacheOrigin#protocol}
    */
    readonly protocol?: string;
    /**
    * Specifies one or more retry conditions for the configured origin.
  
  If the failure mode during a connection attempt to the origin matches the configured retryCondition(s),
  the origin request will be retried up to maxAttempts times. The failoverOrigin, if configured, will then be used to satisfy the request.
  
  The default retryCondition is "CONNECT_FAILURE".
  
  retryConditions apply to this origin, and not subsequent failoverOrigin(s),
  which may specify their own retryConditions and maxAttempts.
  
  Valid values are:
  
  - CONNECT_FAILURE: Retry on failures connecting to origins, for example due to connection timeouts.
  - HTTP_5XX: Retry if the origin responds with any 5xx response code, or if the origin does not respond at all, example: disconnects, reset, read timeout, connection failure, and refused streams.
  - GATEWAY_ERROR: Similar to 5xx, but only applies to response codes 502, 503 or 504.
  - RETRIABLE_4XX: Retry for retriable 4xx response codes, which include HTTP 409 (Conflict) and HTTP 429 (Too Many Requests)
  - NOT_FOUND: Retry if the origin returns a HTTP 404 (Not Found). This can be useful when generating video content, and the segment is not available yet.
  - FORBIDDEN: Retry if the origin returns a HTTP 403 (Forbidden). Possible values: ["CONNECT_FAILURE", "HTTP_5XX", "GATEWAY_ERROR", "RETRIABLE_4XX", "NOT_FOUND", "FORBIDDEN"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#retry_conditions NetworkServicesEdgeCacheOrigin#retry_conditions}
    */
    readonly retryConditions?: string[];
    /**
    * aws_v4_authentication block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#aws_v4_authentication NetworkServicesEdgeCacheOrigin#aws_v4_authentication}
    */
    readonly awsV4Authentication?: NetworkServicesEdgeCacheOriginAwsV4Authentication;
    /**
    * origin_override_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#origin_override_action NetworkServicesEdgeCacheOrigin#origin_override_action}
    */
    readonly originOverrideAction?: NetworkServicesEdgeCacheOriginOriginOverrideAction;
    /**
    * origin_redirect block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#origin_redirect NetworkServicesEdgeCacheOrigin#origin_redirect}
    */
    readonly originRedirect?: NetworkServicesEdgeCacheOriginOriginRedirect;
    /**
    * timeout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#timeout NetworkServicesEdgeCacheOrigin#timeout}
    */
    readonly timeout?: NetworkServicesEdgeCacheOriginTimeout;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#timeouts NetworkServicesEdgeCacheOrigin#timeouts}
    */
    readonly timeouts?: NetworkServicesEdgeCacheOriginTimeouts;
}
export interface NetworkServicesEdgeCacheOriginAwsV4Authentication {
    /**
    * The access key ID your origin uses to identify the key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#access_key_id NetworkServicesEdgeCacheOrigin#access_key_id}
    */
    readonly accessKeyId: string;
    /**
    * The name of the AWS region that your origin is in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#origin_region NetworkServicesEdgeCacheOrigin#origin_region}
    */
    readonly originRegion: string;
    /**
    * The Secret Manager secret version of the secret access key used by your origin.
  
  This is the resource name of the secret version in the format 'projects/*\/secrets/*\/versions/*' where the '*' values are replaced by the project, secret, and version you require.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#secret_access_key_version NetworkServicesEdgeCacheOrigin#secret_access_key_version}
    */
    readonly secretAccessKeyVersion: string;
}
export declare function networkServicesEdgeCacheOriginAwsV4AuthenticationToTerraform(struct?: NetworkServicesEdgeCacheOriginAwsV4AuthenticationOutputReference | NetworkServicesEdgeCacheOriginAwsV4Authentication): any;
export declare class NetworkServicesEdgeCacheOriginAwsV4AuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginAwsV4Authentication | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginAwsV4Authentication | undefined);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    get accessKeyIdInput(): string | undefined;
    private _originRegion?;
    get originRegion(): string;
    set originRegion(value: string);
    get originRegionInput(): string | undefined;
    private _secretAccessKeyVersion?;
    get secretAccessKeyVersion(): string;
    set secretAccessKeyVersion(value: string);
    get secretAccessKeyVersionInput(): string | undefined;
}
export interface NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd {
    /**
    * The name of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#header_name NetworkServicesEdgeCacheOrigin#header_name}
    */
    readonly headerName: string;
    /**
    * The value of the header to add.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#header_value NetworkServicesEdgeCacheOrigin#header_value}
    */
    readonly headerValue: string;
    /**
    * Whether to replace all existing headers with the same name.
  
  By default, added header values are appended
  to the response or request headers with the
  same field names. The added values are
  separated by commas.
  
  To overwrite existing values, set 'replace' to 'true'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#replace NetworkServicesEdgeCacheOrigin#replace}
    */
    readonly replace?: boolean | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddToTerraform(struct?: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd | cdktf.IResolvable): any;
export declare class NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    get headerNameInput(): string | undefined;
    private _headerValue?;
    get headerValue(): string;
    set headerValue(value: string);
    get headerValueInput(): string | undefined;
    private _replace?;
    get replace(): boolean | cdktf.IResolvable;
    set replace(value: boolean | cdktf.IResolvable);
    resetReplace(): void;
    get replaceInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddOutputReference;
}
export interface NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderAction {
    /**
    * request_headers_to_add block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#request_headers_to_add NetworkServicesEdgeCacheOrigin#request_headers_to_add}
    */
    readonly requestHeadersToAdd?: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable;
}
export declare function networkServicesEdgeCacheOriginOriginOverrideActionHeaderActionToTerraform(struct?: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionOutputReference | NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderAction): any;
export declare class NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderAction | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderAction | undefined);
    private _requestHeadersToAdd;
    get requestHeadersToAdd(): NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAddList;
    putRequestHeadersToAdd(value: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd[] | cdktf.IResolvable): void;
    resetRequestHeadersToAdd(): void;
    get requestHeadersToAddInput(): cdktf.IResolvable | NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionRequestHeadersToAdd[] | undefined;
}
export interface NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewrite {
    /**
    * Prior to forwarding the request to the selected
  origin, the request's host header is replaced with
  contents of the hostRewrite.
  
  This value must be between 1 and 255 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#host_rewrite NetworkServicesEdgeCacheOrigin#host_rewrite}
    */
    readonly hostRewrite?: string;
}
export declare function networkServicesEdgeCacheOriginOriginOverrideActionUrlRewriteToTerraform(struct?: NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewriteOutputReference | NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewrite): any;
export declare class NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewriteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewrite | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewrite | undefined);
    private _hostRewrite?;
    get hostRewrite(): string;
    set hostRewrite(value: string);
    resetHostRewrite(): void;
    get hostRewriteInput(): string | undefined;
}
export interface NetworkServicesEdgeCacheOriginOriginOverrideAction {
    /**
    * header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#header_action NetworkServicesEdgeCacheOrigin#header_action}
    */
    readonly headerAction?: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderAction;
    /**
    * url_rewrite block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#url_rewrite NetworkServicesEdgeCacheOrigin#url_rewrite}
    */
    readonly urlRewrite?: NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewrite;
}
export declare function networkServicesEdgeCacheOriginOriginOverrideActionToTerraform(struct?: NetworkServicesEdgeCacheOriginOriginOverrideActionOutputReference | NetworkServicesEdgeCacheOriginOriginOverrideAction): any;
export declare class NetworkServicesEdgeCacheOriginOriginOverrideActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginOriginOverrideAction | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginOriginOverrideAction | undefined);
    private _headerAction;
    get headerAction(): NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderActionOutputReference;
    putHeaderAction(value: NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderAction): void;
    resetHeaderAction(): void;
    get headerActionInput(): NetworkServicesEdgeCacheOriginOriginOverrideActionHeaderAction | undefined;
    private _urlRewrite;
    get urlRewrite(): NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewriteOutputReference;
    putUrlRewrite(value: NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewrite): void;
    resetUrlRewrite(): void;
    get urlRewriteInput(): NetworkServicesEdgeCacheOriginOriginOverrideActionUrlRewrite | undefined;
}
export interface NetworkServicesEdgeCacheOriginOriginRedirect {
    /**
    * The set of redirect response codes that the CDN
  follows. Values of
  [RedirectConditions](https://cloud.google.com/media-cdn/docs/reference/rest/v1/projects.locations.edgeCacheOrigins#redirectconditions)
  are accepted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#redirect_conditions NetworkServicesEdgeCacheOrigin#redirect_conditions}
    */
    readonly redirectConditions?: string[];
}
export declare function networkServicesEdgeCacheOriginOriginRedirectToTerraform(struct?: NetworkServicesEdgeCacheOriginOriginRedirectOutputReference | NetworkServicesEdgeCacheOriginOriginRedirect): any;
export declare class NetworkServicesEdgeCacheOriginOriginRedirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginOriginRedirect | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginOriginRedirect | undefined);
    private _redirectConditions?;
    get redirectConditions(): string[];
    set redirectConditions(value: string[]);
    resetRedirectConditions(): void;
    get redirectConditionsInput(): string[] | undefined;
}
export interface NetworkServicesEdgeCacheOriginTimeout {
    /**
    * The maximum duration to wait for a single origin connection to be established, including DNS lookup, TLS handshake and TCP/QUIC connection establishment.
  
  Defaults to 5 seconds. The timeout must be a value between 1s and 15s.
  
  The connectTimeout capped by the deadline set by the request's maxAttemptsTimeout.  The last connection attempt may have a smaller connectTimeout in order to adhere to the overall maxAttemptsTimeout.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#connect_timeout NetworkServicesEdgeCacheOrigin#connect_timeout}
    */
    readonly connectTimeout?: string;
    /**
    * The maximum time across all connection attempts to the origin, including failover origins, before returning an error to the client. A HTTP 504 will be returned if the timeout is reached before a response is returned.
  
  Defaults to 15 seconds. The timeout must be a value between 1s and 30s.
  
  If a failoverOrigin is specified, the maxAttemptsTimeout of the first configured origin sets the deadline for all connection attempts across all failoverOrigins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#max_attempts_timeout NetworkServicesEdgeCacheOrigin#max_attempts_timeout}
    */
    readonly maxAttemptsTimeout?: string;
    /**
    * The maximum duration to wait between reads of a single HTTP connection/stream.
  
  Defaults to 15 seconds.  The timeout must be a value between 1s and 30s.
  
  The readTimeout is capped by the responseTimeout.  All reads of the HTTP connection/stream must be completed by the deadline set by the responseTimeout.
  
  If the response headers have already been written to the connection, the response will be truncated and logged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#read_timeout NetworkServicesEdgeCacheOrigin#read_timeout}
    */
    readonly readTimeout?: string;
    /**
    * The maximum duration to wait for the last byte of a response to arrive when reading from the HTTP connection/stream.
  
  Defaults to 30 seconds. The timeout must be a value between 1s and 120s.
  
  The responseTimeout starts after the connection has been established.
  
  This also applies to HTTP Chunked Transfer Encoding responses, and/or when an open-ended Range request is made to the origin. Origins that take longer to write additional bytes to the response than the configured responseTimeout will result in an error being returned to the client.
  
  If the response headers have already been written to the connection, the response will be truncated and logged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#response_timeout NetworkServicesEdgeCacheOrigin#response_timeout}
    */
    readonly responseTimeout?: string;
}
export declare function networkServicesEdgeCacheOriginTimeoutToTerraform(struct?: NetworkServicesEdgeCacheOriginTimeoutOutputReference | NetworkServicesEdgeCacheOriginTimeout): any;
export declare class NetworkServicesEdgeCacheOriginTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginTimeout | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginTimeout | undefined);
    private _connectTimeout?;
    get connectTimeout(): string;
    set connectTimeout(value: string);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): string | undefined;
    private _maxAttemptsTimeout?;
    get maxAttemptsTimeout(): string;
    set maxAttemptsTimeout(value: string);
    resetMaxAttemptsTimeout(): void;
    get maxAttemptsTimeoutInput(): string | undefined;
    private _readTimeout?;
    get readTimeout(): string;
    set readTimeout(value: string);
    resetReadTimeout(): void;
    get readTimeoutInput(): string | undefined;
    private _responseTimeout?;
    get responseTimeout(): string;
    set responseTimeout(value: string);
    resetResponseTimeout(): void;
    get responseTimeoutInput(): string | undefined;
}
export interface NetworkServicesEdgeCacheOriginTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#create NetworkServicesEdgeCacheOrigin#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#delete NetworkServicesEdgeCacheOrigin#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin#update NetworkServicesEdgeCacheOrigin#update}
    */
    readonly update?: string;
}
export declare function networkServicesEdgeCacheOriginTimeoutsToTerraform(struct?: NetworkServicesEdgeCacheOriginTimeoutsOutputReference | NetworkServicesEdgeCacheOriginTimeouts | cdktf.IResolvable): any;
export declare class NetworkServicesEdgeCacheOriginTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkServicesEdgeCacheOriginTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkServicesEdgeCacheOriginTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin google_network_services_edge_cache_origin}
*/
export declare class NetworkServicesEdgeCacheOrigin extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_edge_cache_origin";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_origin google_network_services_edge_cache_origin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkServicesEdgeCacheOriginConfig
    */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheOriginConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _failoverOrigin?;
    get failoverOrigin(): string;
    set failoverOrigin(value: string);
    resetFailoverOrigin(): void;
    get failoverOriginInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maxAttempts?;
    get maxAttempts(): number;
    set maxAttempts(value: number);
    resetMaxAttempts(): void;
    get maxAttemptsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _originAddress?;
    get originAddress(): string;
    set originAddress(value: string);
    get originAddressInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _retryConditions?;
    get retryConditions(): string[];
    set retryConditions(value: string[]);
    resetRetryConditions(): void;
    get retryConditionsInput(): string[] | undefined;
    private _awsV4Authentication;
    get awsV4Authentication(): NetworkServicesEdgeCacheOriginAwsV4AuthenticationOutputReference;
    putAwsV4Authentication(value: NetworkServicesEdgeCacheOriginAwsV4Authentication): void;
    resetAwsV4Authentication(): void;
    get awsV4AuthenticationInput(): NetworkServicesEdgeCacheOriginAwsV4Authentication | undefined;
    private _originOverrideAction;
    get originOverrideAction(): NetworkServicesEdgeCacheOriginOriginOverrideActionOutputReference;
    putOriginOverrideAction(value: NetworkServicesEdgeCacheOriginOriginOverrideAction): void;
    resetOriginOverrideAction(): void;
    get originOverrideActionInput(): NetworkServicesEdgeCacheOriginOriginOverrideAction | undefined;
    private _originRedirect;
    get originRedirect(): NetworkServicesEdgeCacheOriginOriginRedirectOutputReference;
    putOriginRedirect(value: NetworkServicesEdgeCacheOriginOriginRedirect): void;
    resetOriginRedirect(): void;
    get originRedirectInput(): NetworkServicesEdgeCacheOriginOriginRedirect | undefined;
    private _timeout;
    get timeout(): NetworkServicesEdgeCacheOriginTimeoutOutputReference;
    putTimeout(value: NetworkServicesEdgeCacheOriginTimeout): void;
    resetTimeout(): void;
    get timeoutInput(): NetworkServicesEdgeCacheOriginTimeout | undefined;
    private _timeouts;
    get timeouts(): NetworkServicesEdgeCacheOriginTimeoutsOutputReference;
    putTimeouts(value: NetworkServicesEdgeCacheOriginTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkServicesEdgeCacheOriginTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
