import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotebooksInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The size of the boot disk in GB attached to this instance,
  up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB.
  If not specified, this defaults to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#boot_disk_size_gb NotebooksInstance#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Possible disk types for notebook instances. Possible values: ["DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED", "PD_EXTREME"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#boot_disk_type NotebooksInstance#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * Instance creation time
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#create_time NotebooksInstance#create_time}
    */
    readonly createTime?: string;
    /**
    * Specify a custom Cloud Storage path where the GPU driver is stored.
  If not specified, we'll automatically choose from official GPU drivers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#custom_gpu_driver_path NotebooksInstance#custom_gpu_driver_path}
    */
    readonly customGpuDriverPath?: string;
    /**
    * The size of the data disk in GB attached to this instance,
  up to a maximum of 64000 GB (64 TB).
  You can choose the size of the data disk based on how big your notebooks and data are.
  If not specified, this defaults to 100.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#data_disk_size_gb NotebooksInstance#data_disk_size_gb}
    */
    readonly dataDiskSizeGb?: number;
    /**
    * Possible disk types for notebook instances. Possible values: ["DISK_TYPE_UNSPECIFIED", "PD_STANDARD", "PD_SSD", "PD_BALANCED", "PD_EXTREME"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#data_disk_type NotebooksInstance#data_disk_type}
    */
    readonly dataDiskType?: string;
    /**
    * Disk encryption method used on the boot and data disks, defaults to GMEK. Possible values: ["DISK_ENCRYPTION_UNSPECIFIED", "GMEK", "CMEK"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#disk_encryption NotebooksInstance#disk_encryption}
    */
    readonly diskEncryption?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#id NotebooksInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the end user authorizes Google Cloud to install GPU driver
  on this instance. If this field is empty or set to false, the GPU driver
  won't be installed. Only applicable to instances with GPUs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#install_gpu_driver NotebooksInstance#install_gpu_driver}
    */
    readonly installGpuDriver?: boolean | cdktf.IResolvable;
    /**
    * The list of owners of this instance after creation.
  Format: alias@example.com.
  Currently supports one owner only.
  If not specified, all of the service account users of
  your VM instance's service account can use the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#instance_owners NotebooksInstance#instance_owners}
    */
    readonly instanceOwners?: string[];
    /**
    * The KMS key used to encrypt the disks, only applicable if diskEncryption is CMEK.
  Format: projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#kms_key NotebooksInstance#kms_key}
    */
    readonly kmsKey?: string;
    /**
    * Labels to apply to this instance. These can be later modified by the setLabels method.
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#labels NotebooksInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A reference to the zone where the machine resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#location NotebooksInstance#location}
    */
    readonly location: string;
    /**
    * A reference to a machine type which defines VM kind.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#machine_type NotebooksInstance#machine_type}
    */
    readonly machineType: string;
    /**
    * Custom metadata to apply to this instance.
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#metadata NotebooksInstance#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The name specified for the Notebook instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#name NotebooksInstance#name}
    */
    readonly name: string;
    /**
    * The name of the VPC that this instance is in.
  Format: projects/{project_id}/global/networks/{network_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#network NotebooksInstance#network}
    */
    readonly network?: string;
    /**
    * The type of vNIC driver. Possible values: ["UNSPECIFIED_NIC_TYPE", "VIRTIO_NET", "GVNIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#nic_type NotebooksInstance#nic_type}
    */
    readonly nicType?: string;
    /**
    * The notebook instance will not register with the proxy..
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#no_proxy_access NotebooksInstance#no_proxy_access}
    */
    readonly noProxyAccess?: boolean | cdktf.IResolvable;
    /**
    * No public IP will be assigned to this instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#no_public_ip NotebooksInstance#no_public_ip}
    */
    readonly noPublicIp?: boolean | cdktf.IResolvable;
    /**
    * If true, the data disk will not be auto deleted when deleting the instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#no_remove_data_disk NotebooksInstance#no_remove_data_disk}
    */
    readonly noRemoveDataDisk?: boolean | cdktf.IResolvable;
    /**
    * Path to a Bash script that automatically runs after a
  notebook instance fully boots up. The path must be a URL
  or Cloud Storage path (gs://path-to-file/file-name).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#post_startup_script NotebooksInstance#post_startup_script}
    */
    readonly postStartupScript?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#project NotebooksInstance#project}
    */
    readonly project?: string;
    /**
    * The service account on this instance, giving access to other
  Google Cloud services. You can use any service account within
  the same project, but you must have the service account user
  permission to use the instance. If not specified,
  the Compute Engine default service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#service_account NotebooksInstance#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Optional. The URIs of service account scopes to be included in Compute Engine instances.
  If not specified, the following scopes are defined:
  - https://www.googleapis.com/auth/cloud-platform
  - https://www.googleapis.com/auth/userinfo.email
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#service_account_scopes NotebooksInstance#service_account_scopes}
    */
    readonly serviceAccountScopes?: string[];
    /**
    * The name of the subnet that this instance is in.
  Format: projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#subnet NotebooksInstance#subnet}
    */
    readonly subnet?: string;
    /**
    * The Compute Engine tags to add to instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#tags NotebooksInstance#tags}
    */
    readonly tags?: string[];
    /**
    * Instance update time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#update_time NotebooksInstance#update_time}
    */
    readonly updateTime?: string;
    /**
    * accelerator_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#accelerator_config NotebooksInstance#accelerator_config}
    */
    readonly acceleratorConfig?: NotebooksInstanceAcceleratorConfig;
    /**
    * container_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#container_image NotebooksInstance#container_image}
    */
    readonly containerImage?: NotebooksInstanceContainerImage;
    /**
    * reservation_affinity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#reservation_affinity NotebooksInstance#reservation_affinity}
    */
    readonly reservationAffinity?: NotebooksInstanceReservationAffinity;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#shielded_instance_config NotebooksInstance#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: NotebooksInstanceShieldedInstanceConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#timeouts NotebooksInstance#timeouts}
    */
    readonly timeouts?: NotebooksInstanceTimeouts;
    /**
    * vm_image block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#vm_image NotebooksInstance#vm_image}
    */
    readonly vmImage?: NotebooksInstanceVmImage;
}
export interface NotebooksInstanceAcceleratorConfig {
    /**
    * Count of cores of this accelerator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#core_count NotebooksInstance#core_count}
    */
    readonly coreCount: number;
    /**
    * Type of this accelerator. Possible values: ["ACCELERATOR_TYPE_UNSPECIFIED", "NVIDIA_TESLA_K80", "NVIDIA_TESLA_P100", "NVIDIA_TESLA_V100", "NVIDIA_TESLA_P4", "NVIDIA_TESLA_T4", "NVIDIA_TESLA_T4_VWS", "NVIDIA_TESLA_P100_VWS", "NVIDIA_TESLA_P4_VWS", "NVIDIA_TESLA_A100", "TPU_V2", "TPU_V3"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#type NotebooksInstance#type}
    */
    readonly type: string;
}
export declare function notebooksInstanceAcceleratorConfigToTerraform(struct?: NotebooksInstanceAcceleratorConfigOutputReference | NotebooksInstanceAcceleratorConfig): any;
export declare class NotebooksInstanceAcceleratorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksInstanceAcceleratorConfig | undefined;
    set internalValue(value: NotebooksInstanceAcceleratorConfig | undefined);
    private _coreCount?;
    get coreCount(): number;
    set coreCount(value: number);
    get coreCountInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface NotebooksInstanceContainerImage {
    /**
    * The path to the container image repository.
  For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#repository NotebooksInstance#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#tag NotebooksInstance#tag}
    */
    readonly tag?: string;
}
export declare function notebooksInstanceContainerImageToTerraform(struct?: NotebooksInstanceContainerImageOutputReference | NotebooksInstanceContainerImage): any;
export declare class NotebooksInstanceContainerImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksInstanceContainerImage | undefined;
    set internalValue(value: NotebooksInstanceContainerImage | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface NotebooksInstanceReservationAffinity {
    /**
    * The type of Compute Reservation. Possible values: ["NO_RESERVATION", "ANY_RESERVATION", "SPECIFIC_RESERVATION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#consume_reservation_type NotebooksInstance#consume_reservation_type}
    */
    readonly consumeReservationType: string;
    /**
    * Corresponds to the label key of reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#key NotebooksInstance#key}
    */
    readonly key?: string;
    /**
    * Corresponds to the label values of reservation resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#values NotebooksInstance#values}
    */
    readonly values?: string[];
}
export declare function notebooksInstanceReservationAffinityToTerraform(struct?: NotebooksInstanceReservationAffinityOutputReference | NotebooksInstanceReservationAffinity): any;
export declare class NotebooksInstanceReservationAffinityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksInstanceReservationAffinity | undefined;
    set internalValue(value: NotebooksInstanceReservationAffinity | undefined);
    private _consumeReservationType?;
    get consumeReservationType(): string;
    set consumeReservationType(value: string);
    get consumeReservationTypeInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    resetValues(): void;
    get valuesInput(): string[] | undefined;
}
export interface NotebooksInstanceShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the
  boot integrity of the instance. The attestation is performed against the integrity policy baseline.
  This baseline is initially derived from the implicitly trusted boot image when the instance is created.
  Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#enable_integrity_monitoring NotebooksInstance#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs
  authentic software by verifying the digital signature of all boot components, and halting the boot process
  if signature verification fails.
  Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#enable_secure_boot NotebooksInstance#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has the vTPM enabled.
  Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#enable_vtpm NotebooksInstance#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function notebooksInstanceShieldedInstanceConfigToTerraform(struct?: NotebooksInstanceShieldedInstanceConfigOutputReference | NotebooksInstanceShieldedInstanceConfig): any;
export declare class NotebooksInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksInstanceShieldedInstanceConfig | undefined;
    set internalValue(value: NotebooksInstanceShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NotebooksInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#create NotebooksInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#delete NotebooksInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#update NotebooksInstance#update}
    */
    readonly update?: string;
}
export declare function notebooksInstanceTimeoutsToTerraform(struct?: NotebooksInstanceTimeoutsOutputReference | NotebooksInstanceTimeouts | cdktf.IResolvable): any;
export declare class NotebooksInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NotebooksInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NotebooksInstanceVmImage {
    /**
    * Use this VM image family to find the image; the newest image in this family will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#image_family NotebooksInstance#image_family}
    */
    readonly imageFamily?: string;
    /**
    * Use VM image name to find the image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#image_name NotebooksInstance#image_name}
    */
    readonly imageName?: string;
    /**
    * The name of the Google Cloud project that this VM image belongs to.
  Format: projects/{project_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance#project NotebooksInstance#project}
    */
    readonly project: string;
}
export declare function notebooksInstanceVmImageToTerraform(struct?: NotebooksInstanceVmImageOutputReference | NotebooksInstanceVmImage): any;
export declare class NotebooksInstanceVmImageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksInstanceVmImage | undefined;
    set internalValue(value: NotebooksInstanceVmImage | undefined);
    private _imageFamily?;
    get imageFamily(): string;
    set imageFamily(value: string);
    resetImageFamily(): void;
    get imageFamilyInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance google_notebooks_instance}
*/
export declare class NotebooksInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_instance google_notebooks_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotebooksInstanceConfig
    */
    constructor(scope: Construct, id: string, config: NotebooksInstanceConfig);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _createTime?;
    get createTime(): string;
    set createTime(value: string);
    resetCreateTime(): void;
    get createTimeInput(): string | undefined;
    private _customGpuDriverPath?;
    get customGpuDriverPath(): string;
    set customGpuDriverPath(value: string);
    resetCustomGpuDriverPath(): void;
    get customGpuDriverPathInput(): string | undefined;
    private _dataDiskSizeGb?;
    get dataDiskSizeGb(): number;
    set dataDiskSizeGb(value: number);
    resetDataDiskSizeGb(): void;
    get dataDiskSizeGbInput(): number | undefined;
    private _dataDiskType?;
    get dataDiskType(): string;
    set dataDiskType(value: string);
    resetDataDiskType(): void;
    get dataDiskTypeInput(): string | undefined;
    private _diskEncryption?;
    get diskEncryption(): string;
    set diskEncryption(value: string);
    resetDiskEncryption(): void;
    get diskEncryptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _installGpuDriver?;
    get installGpuDriver(): boolean | cdktf.IResolvable;
    set installGpuDriver(value: boolean | cdktf.IResolvable);
    resetInstallGpuDriver(): void;
    get installGpuDriverInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceOwners?;
    get instanceOwners(): string[];
    set instanceOwners(value: string[]);
    resetInstanceOwners(): void;
    get instanceOwnersInput(): string[] | undefined;
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _noProxyAccess?;
    get noProxyAccess(): boolean | cdktf.IResolvable;
    set noProxyAccess(value: boolean | cdktf.IResolvable);
    resetNoProxyAccess(): void;
    get noProxyAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _noPublicIp?;
    get noPublicIp(): boolean | cdktf.IResolvable;
    set noPublicIp(value: boolean | cdktf.IResolvable);
    resetNoPublicIp(): void;
    get noPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _noRemoveDataDisk?;
    get noRemoveDataDisk(): boolean | cdktf.IResolvable;
    set noRemoveDataDisk(value: boolean | cdktf.IResolvable);
    resetNoRemoveDataDisk(): void;
    get noRemoveDataDiskInput(): boolean | cdktf.IResolvable | undefined;
    private _postStartupScript?;
    get postStartupScript(): string;
    set postStartupScript(value: string);
    resetPostStartupScript(): void;
    get postStartupScriptInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get proxyUri(): string;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[];
    set serviceAccountScopes(value: string[]);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    get state(): string;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _updateTime?;
    get updateTime(): string;
    set updateTime(value: string);
    resetUpdateTime(): void;
    get updateTimeInput(): string | undefined;
    private _acceleratorConfig;
    get acceleratorConfig(): NotebooksInstanceAcceleratorConfigOutputReference;
    putAcceleratorConfig(value: NotebooksInstanceAcceleratorConfig): void;
    resetAcceleratorConfig(): void;
    get acceleratorConfigInput(): NotebooksInstanceAcceleratorConfig | undefined;
    private _containerImage;
    get containerImage(): NotebooksInstanceContainerImageOutputReference;
    putContainerImage(value: NotebooksInstanceContainerImage): void;
    resetContainerImage(): void;
    get containerImageInput(): NotebooksInstanceContainerImage | undefined;
    private _reservationAffinity;
    get reservationAffinity(): NotebooksInstanceReservationAffinityOutputReference;
    putReservationAffinity(value: NotebooksInstanceReservationAffinity): void;
    resetReservationAffinity(): void;
    get reservationAffinityInput(): NotebooksInstanceReservationAffinity | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): NotebooksInstanceShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: NotebooksInstanceShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): NotebooksInstanceShieldedInstanceConfig | undefined;
    private _timeouts;
    get timeouts(): NotebooksInstanceTimeoutsOutputReference;
    putTimeouts(value: NotebooksInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NotebooksInstanceTimeouts | undefined;
    private _vmImage;
    get vmImage(): NotebooksInstanceVmImageOutputReference;
    putVmImage(value: NotebooksInstanceVmImage): void;
    resetVmImage(): void;
    get vmImageInput(): NotebooksInstanceVmImage | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
