import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotebooksRuntimeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#id NotebooksRuntime#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A reference to the zone where the machine resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#location NotebooksRuntime#location}
    */
    readonly location: string;
    /**
    * The name specified for the Notebook runtime.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#name NotebooksRuntime#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#project NotebooksRuntime#project}
    */
    readonly project?: string;
    /**
    * access_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#access_config NotebooksRuntime#access_config}
    */
    readonly accessConfig?: NotebooksRuntimeAccessConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#software_config NotebooksRuntime#software_config}
    */
    readonly softwareConfig?: NotebooksRuntimeSoftwareConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#timeouts NotebooksRuntime#timeouts}
    */
    readonly timeouts?: NotebooksRuntimeTimeouts;
    /**
    * virtual_machine block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#virtual_machine NotebooksRuntime#virtual_machine}
    */
    readonly virtualMachine?: NotebooksRuntimeVirtualMachine;
}
export interface NotebooksRuntimeMetrics {
}
export declare function notebooksRuntimeMetricsToTerraform(struct?: NotebooksRuntimeMetrics): any;
export declare class NotebooksRuntimeMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NotebooksRuntimeMetrics | undefined;
    set internalValue(value: NotebooksRuntimeMetrics | undefined);
    private _systemMetrics;
    get systemMetrics(): cdktf.StringMap;
}
export declare class NotebooksRuntimeMetricsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NotebooksRuntimeMetricsOutputReference;
}
export interface NotebooksRuntimeAccessConfig {
    /**
    * The type of access mode this instance. For valid values, see
  'https://cloud.google.com/vertex-ai/docs/workbench/reference/
  rest/v1/projects.locations.runtimes#RuntimeAccessType'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#access_type NotebooksRuntime#access_type}
    */
    readonly accessType?: string;
    /**
    * The owner of this runtime after creation. Format: 'alias@example.com'.
  Currently supports one owner only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#runtime_owner NotebooksRuntime#runtime_owner}
    */
    readonly runtimeOwner?: string;
}
export declare function notebooksRuntimeAccessConfigToTerraform(struct?: NotebooksRuntimeAccessConfigOutputReference | NotebooksRuntimeAccessConfig): any;
export declare class NotebooksRuntimeAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeAccessConfig | undefined;
    set internalValue(value: NotebooksRuntimeAccessConfig | undefined);
    private _accessType?;
    get accessType(): string;
    set accessType(value: string);
    resetAccessType(): void;
    get accessTypeInput(): string | undefined;
    get proxyUri(): string;
    private _runtimeOwner?;
    get runtimeOwner(): string;
    set runtimeOwner(value: string);
    resetRuntimeOwner(): void;
    get runtimeOwnerInput(): string | undefined;
}
export interface NotebooksRuntimeSoftwareConfigKernels {
    /**
    * The path to the container image repository.
  For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#repository NotebooksRuntime#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#tag NotebooksRuntime#tag}
    */
    readonly tag?: string;
}
export declare function notebooksRuntimeSoftwareConfigKernelsToTerraform(struct?: NotebooksRuntimeSoftwareConfigKernels | cdktf.IResolvable): any;
export declare class NotebooksRuntimeSoftwareConfigKernelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NotebooksRuntimeSoftwareConfigKernels | cdktf.IResolvable | undefined;
    set internalValue(value: NotebooksRuntimeSoftwareConfigKernels | cdktf.IResolvable | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export declare class NotebooksRuntimeSoftwareConfigKernelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NotebooksRuntimeSoftwareConfigKernels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NotebooksRuntimeSoftwareConfigKernelsOutputReference;
}
export interface NotebooksRuntimeSoftwareConfig {
    /**
    * Specify a custom Cloud Storage path where the GPU driver is stored.
  If not specified, we'll automatically choose from official GPU drivers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#custom_gpu_driver_path NotebooksRuntime#custom_gpu_driver_path}
    */
    readonly customGpuDriverPath?: string;
    /**
    * Verifies core internal services are running. Default: True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#enable_health_monitoring NotebooksRuntime#enable_health_monitoring}
    */
    readonly enableHealthMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Runtime will automatically shutdown after idle_shutdown_time.
  Default: True
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#idle_shutdown NotebooksRuntime#idle_shutdown}
    */
    readonly idleShutdown?: boolean | cdktf.IResolvable;
    /**
    * Time in minutes to wait before shuting down runtime.
  Default: 180 minutes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#idle_shutdown_timeout NotebooksRuntime#idle_shutdown_timeout}
    */
    readonly idleShutdownTimeout?: number;
    /**
    * Install Nvidia Driver automatically.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#install_gpu_driver NotebooksRuntime#install_gpu_driver}
    */
    readonly installGpuDriver?: boolean | cdktf.IResolvable;
    /**
    * Cron expression in UTC timezone for schedule instance auto upgrade.
  Please follow the [cron format](https://en.wikipedia.org/wiki/Cron).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#notebook_upgrade_schedule NotebooksRuntime#notebook_upgrade_schedule}
    */
    readonly notebookUpgradeSchedule?: string;
    /**
    * Path to a Bash script that automatically runs after a notebook instance
  fully boots up. The path must be a URL or
  Cloud Storage path (gs://path-to-file/file-name).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#post_startup_script NotebooksRuntime#post_startup_script}
    */
    readonly postStartupScript?: string;
    /**
    * Behavior for the post startup script. Possible values: ["POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED", "RUN_EVERY_START", "DOWNLOAD_AND_RUN_EVERY_START"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#post_startup_script_behavior NotebooksRuntime#post_startup_script_behavior}
    */
    readonly postStartupScriptBehavior?: string;
    /**
    * kernels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#kernels NotebooksRuntime#kernels}
    */
    readonly kernels?: NotebooksRuntimeSoftwareConfigKernels[] | cdktf.IResolvable;
}
export declare function notebooksRuntimeSoftwareConfigToTerraform(struct?: NotebooksRuntimeSoftwareConfigOutputReference | NotebooksRuntimeSoftwareConfig): any;
export declare class NotebooksRuntimeSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeSoftwareConfig | undefined;
    set internalValue(value: NotebooksRuntimeSoftwareConfig | undefined);
    private _customGpuDriverPath?;
    get customGpuDriverPath(): string;
    set customGpuDriverPath(value: string);
    resetCustomGpuDriverPath(): void;
    get customGpuDriverPathInput(): string | undefined;
    private _enableHealthMonitoring?;
    get enableHealthMonitoring(): boolean | cdktf.IResolvable;
    set enableHealthMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableHealthMonitoring(): void;
    get enableHealthMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _idleShutdown?;
    get idleShutdown(): boolean | cdktf.IResolvable;
    set idleShutdown(value: boolean | cdktf.IResolvable);
    resetIdleShutdown(): void;
    get idleShutdownInput(): boolean | cdktf.IResolvable | undefined;
    private _idleShutdownTimeout?;
    get idleShutdownTimeout(): number;
    set idleShutdownTimeout(value: number);
    resetIdleShutdownTimeout(): void;
    get idleShutdownTimeoutInput(): number | undefined;
    private _installGpuDriver?;
    get installGpuDriver(): boolean | cdktf.IResolvable;
    set installGpuDriver(value: boolean | cdktf.IResolvable);
    resetInstallGpuDriver(): void;
    get installGpuDriverInput(): boolean | cdktf.IResolvable | undefined;
    private _notebookUpgradeSchedule?;
    get notebookUpgradeSchedule(): string;
    set notebookUpgradeSchedule(value: string);
    resetNotebookUpgradeSchedule(): void;
    get notebookUpgradeScheduleInput(): string | undefined;
    private _postStartupScript?;
    get postStartupScript(): string;
    set postStartupScript(value: string);
    resetPostStartupScript(): void;
    get postStartupScriptInput(): string | undefined;
    private _postStartupScriptBehavior?;
    get postStartupScriptBehavior(): string;
    set postStartupScriptBehavior(value: string);
    resetPostStartupScriptBehavior(): void;
    get postStartupScriptBehaviorInput(): string | undefined;
    get upgradeable(): cdktf.IResolvable;
    private _kernels;
    get kernels(): NotebooksRuntimeSoftwareConfigKernelsList;
    putKernels(value: NotebooksRuntimeSoftwareConfigKernels[] | cdktf.IResolvable): void;
    resetKernels(): void;
    get kernelsInput(): cdktf.IResolvable | NotebooksRuntimeSoftwareConfigKernels[] | undefined;
}
export interface NotebooksRuntimeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#create NotebooksRuntime#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#delete NotebooksRuntime#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#update NotebooksRuntime#update}
    */
    readonly update?: string;
}
export declare function notebooksRuntimeTimeoutsToTerraform(struct?: NotebooksRuntimeTimeoutsOutputReference | NotebooksRuntimeTimeouts | cdktf.IResolvable): any;
export declare class NotebooksRuntimeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NotebooksRuntimeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig {
    /**
    * Count of cores of this accelerator.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#core_count NotebooksRuntime#core_count}
    */
    readonly coreCount?: number;
    /**
    * Accelerator model. For valid values, see
  'https://cloud.google.com/vertex-ai/docs/workbench/reference/
  rest/v1/projects.locations.runtimes#AcceleratorType'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#type NotebooksRuntime#type}
    */
    readonly type?: string;
}
export declare function notebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigToTerraform(struct?: NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigOutputReference | NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig): any;
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig | undefined);
    private _coreCount?;
    get coreCount(): number;
    set coreCount(value: number);
    resetCoreCount(): void;
    get coreCountInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages {
    /**
    * The path to the container image repository.
  For example: gcr.io/{project_id}/{imageName}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#repository NotebooksRuntime#repository}
    */
    readonly repository: string;
    /**
    * The tag of the container image. If not specified, this defaults to the latest tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#tag NotebooksRuntime#tag}
    */
    readonly tag?: string;
}
export declare function notebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesToTerraform(struct?: NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages | cdktf.IResolvable): any;
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages | cdktf.IResolvable | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages | cdktf.IResolvable | undefined);
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesOutputReference;
}
export interface NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams {
    /**
    * Provide this property when creating the disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#description NotebooksRuntime#description}
    */
    readonly description?: string;
    /**
    * Specifies the disk name. If not specified, the default is
  to use the name of the instance. If the disk with the
  instance name exists already in the given zone/region, a
  new name will be automatically generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#disk_name NotebooksRuntime#disk_name}
    */
    readonly diskName?: string;
    /**
    * Specifies the size of the disk in base-2 GB. If not
  specified, the disk will be the same size as the image
  (usually 10GB). If specified, the size must be equal to
  or larger than 10GB. Default 100 GB.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#disk_size_gb NotebooksRuntime#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * The type of the boot disk attached to this runtime,
  defaults to standard persistent disk. For valid values,
  see 'https://cloud.google.com/vertex-ai/docs/workbench/
  reference/rest/v1/projects.locations.runtimes#disktype'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#disk_type NotebooksRuntime#disk_type}
    */
    readonly diskType?: string;
    /**
    * Labels to apply to this disk. These can be later modified
  by the disks.setLabels method. This field is only
  applicable for persistent disks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#labels NotebooksRuntime#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function notebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsToTerraform(struct?: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsOutputReference | NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams): any;
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _diskName?;
    get diskName(): string;
    set diskName(value: string);
    resetDiskName(): void;
    get diskNameInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk {
    /**
    * "Specifies the disk interface to use for attaching this disk,
  which is either SCSI or NVME. The default is SCSI. Persistent
  disks must always use SCSI and the request will fail if you attempt
  to attach a persistent disk in any other format than SCSI. Local SSDs
  can use either NVME or SCSI. For performance characteristics of SCSI
  over NVMe, see Local SSD performance. Valid values: * NVME * SCSI".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#interface NotebooksRuntime#interface}
    */
    readonly interface?: string;
    /**
    * The mode in which to attach this disk, either READ_WRITE
  or READ_ONLY. If not specified, the default is to attach
  the disk in READ_WRITE mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#mode NotebooksRuntime#mode}
    */
    readonly mode?: string;
    /**
    * Specifies a valid partial or full URL to an existing
  Persistent Disk resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#source NotebooksRuntime#source}
    */
    readonly source?: string;
    /**
    * Specifies the type of the disk, either SCRATCH or PERSISTENT.
  If not specified, the default is PERSISTENT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#type NotebooksRuntime#type}
    */
    readonly type?: string;
    /**
    * initialize_params block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#initialize_params NotebooksRuntime#initialize_params}
    */
    readonly initializeParams?: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams;
}
export declare function notebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskToTerraform(struct?: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskOutputReference | NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk): any;
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk | undefined);
    get autoDelete(): cdktf.IResolvable;
    get boot(): cdktf.IResolvable;
    get deviceName(): string;
    get guestOsFeatures(): string[];
    get index(): number;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    resetInterface(): void;
    get interfaceInput(): string | undefined;
    get kind(): string;
    get licenses(): string[];
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _initializeParams;
    get initializeParams(): NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParamsOutputReference;
    putInitializeParams(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams): void;
    resetInitializeParams(): void;
    get initializeParamsInput(): NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskInitializeParams | undefined;
}
export interface NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig {
    /**
    * The Cloud KMS resource identifier of the customer-managed
  encryption key used to protect a resource, such as a disks.
  It has the following format:
  'projects/{PROJECT_ID}/locations/{REGION}/keyRings/
  {KEY_RING_NAME}/cryptoKeys/{KEY_NAME}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#kms_key NotebooksRuntime#kms_key}
    */
    readonly kmsKey?: string;
}
export declare function notebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigToTerraform(struct?: NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigOutputReference | NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig): any;
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
}
export interface NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig {
    /**
    * Defines whether the instance has integrity monitoring enabled.
  Enables monitoring and attestation of the boot integrity of
  the instance. The attestation is performed against the
  integrity policy baseline. This baseline is initially derived
  from the implicitly trusted boot image when the instance is
  created. Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#enable_integrity_monitoring NotebooksRuntime#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has Secure Boot enabled.Secure
  Boot helps ensure that the system only runs authentic software
  by verifying the digital signature of all boot components, and
  halting the boot process if signature verification fails.
  Disabled by default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#enable_secure_boot NotebooksRuntime#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Defines whether the instance has the vTPM enabled. Enabled by
  default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#enable_vtpm NotebooksRuntime#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function notebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigToTerraform(struct?: NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigOutputReference | NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig): any;
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NotebooksRuntimeVirtualMachineVirtualMachineConfig {
    /**
    * If true, runtime will only have internal IP addresses. By default,
  runtimes are not restricted to internal IP addresses, and will
  have ephemeral external IP addresses assigned to each vm. This
  'internal_ip_only' restriction can only be enabled for subnetwork
  enabled networks, and all dependencies must be configured to be
  accessible without external IP addresses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#internal_ip_only NotebooksRuntime#internal_ip_only}
    */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
    * The labels to associate with this runtime. Label **keys** must
  contain 1 to 63 characters, and must conform to [RFC 1035]
  (https://www.ietf.org/rfc/rfc1035.txt). Label **values** may be
  empty, but, if present, must contain 1 to 63 characters, and must
  conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt). No
  more than 32 labels can be associated with a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#labels NotebooksRuntime#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The Compute Engine machine type used for runtimes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#machine_type NotebooksRuntime#machine_type}
    */
    readonly machineType: string;
    /**
    * The Compute Engine metadata entries to add to virtual machine.
  (see [Project and instance metadata](https://cloud.google.com
  /compute/docs/storing-retrieving-metadata#project_and_instance
  _metadata)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#metadata NotebooksRuntime#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The Compute Engine network to be used for machine communications.
  Cannot be specified with subnetwork. If neither 'network' nor
  'subnet' is specified, the "default" network of the project is
  used, if it exists. A full URL or partial URI. Examples:
    * 'https://www.googleapis.com/compute/v1/projects/[project_id]/
    regions/global/default'
    * 'projects/[project_id]/regions/global/default'
  Runtimes are managed resources inside Google Infrastructure.
  Runtimes support the following network configurations:
    * Google Managed Network (Network & subnet are empty)
    * Consumer Project VPC (network & subnet are required). Requires
    configuring Private Service Access.
    * Shared VPC (network & subnet are required). Requires
    configuring Private Service Access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#network NotebooksRuntime#network}
    */
    readonly network?: string;
    /**
    * The type of vNIC to be used on this interface. This may be gVNIC
  or VirtioNet. Possible values: ["UNSPECIFIED_NIC_TYPE", "VIRTIO_NET", "GVNIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#nic_type NotebooksRuntime#nic_type}
    */
    readonly nicType?: string;
    /**
    * Reserved IP Range name is used for VPC Peering. The
  subnetwork allocation will use the range *name* if it's assigned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#reserved_ip_range NotebooksRuntime#reserved_ip_range}
    */
    readonly reservedIpRange?: string;
    /**
    * The Compute Engine subnetwork to be used for machine
  communications. Cannot be specified with network. A full URL or
  partial URI are valid. Examples:
    * 'https://www.googleapis.com/compute/v1/projects/[project_id]/
    regions/us-east1/subnetworks/sub0'
    * 'projects/[project_id]/regions/us-east1/subnetworks/sub0'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#subnet NotebooksRuntime#subnet}
    */
    readonly subnet?: string;
    /**
    * The Compute Engine tags to add to runtime (see [Tagging instances]
  (https://cloud.google.com/compute/docs/
  label-or-tag-resources#tags)).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#tags NotebooksRuntime#tags}
    */
    readonly tags?: string[];
    /**
    * accelerator_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#accelerator_config NotebooksRuntime#accelerator_config}
    */
    readonly acceleratorConfig?: NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig;
    /**
    * container_images block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#container_images NotebooksRuntime#container_images}
    */
    readonly containerImages?: NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | cdktf.IResolvable;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#data_disk NotebooksRuntime#data_disk}
    */
    readonly dataDisk: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#encryption_config NotebooksRuntime#encryption_config}
    */
    readonly encryptionConfig?: NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#shielded_instance_config NotebooksRuntime#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig;
}
export declare function notebooksRuntimeVirtualMachineVirtualMachineConfigToTerraform(struct?: NotebooksRuntimeVirtualMachineVirtualMachineConfigOutputReference | NotebooksRuntimeVirtualMachineVirtualMachineConfig): any;
export declare class NotebooksRuntimeVirtualMachineVirtualMachineConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeVirtualMachineVirtualMachineConfig | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachineVirtualMachineConfig | undefined);
    private _guestAttributes;
    get guestAttributes(): cdktf.StringMap;
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable;
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    get machineTypeInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _nicType?;
    get nicType(): string;
    set nicType(value: string);
    resetNicType(): void;
    get nicTypeInput(): string | undefined;
    private _reservedIpRange?;
    get reservedIpRange(): string;
    set reservedIpRange(value: string);
    resetReservedIpRange(): void;
    get reservedIpRangeInput(): string | undefined;
    private _subnet?;
    get subnet(): string;
    set subnet(value: string);
    resetSubnet(): void;
    get subnetInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get zone(): string;
    private _acceleratorConfig;
    get acceleratorConfig(): NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfigOutputReference;
    putAcceleratorConfig(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig): void;
    resetAcceleratorConfig(): void;
    get acceleratorConfigInput(): NotebooksRuntimeVirtualMachineVirtualMachineConfigAcceleratorConfig | undefined;
    private _containerImages;
    get containerImages(): NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImagesList;
    putContainerImages(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | cdktf.IResolvable): void;
    resetContainerImages(): void;
    get containerImagesInput(): cdktf.IResolvable | NotebooksRuntimeVirtualMachineVirtualMachineConfigContainerImages[] | undefined;
    private _dataDisk;
    get dataDisk(): NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDiskOutputReference;
    putDataDisk(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk): void;
    get dataDiskInput(): NotebooksRuntimeVirtualMachineVirtualMachineConfigDataDisk | undefined;
    private _encryptionConfig;
    get encryptionConfig(): NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): NotebooksRuntimeVirtualMachineVirtualMachineConfigEncryptionConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): NotebooksRuntimeVirtualMachineVirtualMachineConfigShieldedInstanceConfig | undefined;
}
export interface NotebooksRuntimeVirtualMachine {
    /**
    * virtual_machine_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime#virtual_machine_config NotebooksRuntime#virtual_machine_config}
    */
    readonly virtualMachineConfig?: NotebooksRuntimeVirtualMachineVirtualMachineConfig;
}
export declare function notebooksRuntimeVirtualMachineToTerraform(struct?: NotebooksRuntimeVirtualMachineOutputReference | NotebooksRuntimeVirtualMachine): any;
export declare class NotebooksRuntimeVirtualMachineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeVirtualMachine | undefined;
    set internalValue(value: NotebooksRuntimeVirtualMachine | undefined);
    get instanceId(): string;
    get instanceName(): string;
    private _virtualMachineConfig;
    get virtualMachineConfig(): NotebooksRuntimeVirtualMachineVirtualMachineConfigOutputReference;
    putVirtualMachineConfig(value: NotebooksRuntimeVirtualMachineVirtualMachineConfig): void;
    resetVirtualMachineConfig(): void;
    get virtualMachineConfigInput(): NotebooksRuntimeVirtualMachineVirtualMachineConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime google_notebooks_runtime}
*/
export declare class NotebooksRuntime extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_runtime";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime google_notebooks_runtime} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotebooksRuntimeConfig
    */
    constructor(scope: Construct, id: string, config: NotebooksRuntimeConfig);
    get healthState(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _metrics;
    get metrics(): NotebooksRuntimeMetricsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _accessConfig;
    get accessConfig(): NotebooksRuntimeAccessConfigOutputReference;
    putAccessConfig(value: NotebooksRuntimeAccessConfig): void;
    resetAccessConfig(): void;
    get accessConfigInput(): NotebooksRuntimeAccessConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): NotebooksRuntimeSoftwareConfigOutputReference;
    putSoftwareConfig(value: NotebooksRuntimeSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): NotebooksRuntimeSoftwareConfig | undefined;
    private _timeouts;
    get timeouts(): NotebooksRuntimeTimeoutsOutputReference;
    putTimeouts(value: NotebooksRuntimeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NotebooksRuntimeTimeouts | undefined;
    private _virtualMachine;
    get virtualMachine(): NotebooksRuntimeVirtualMachineOutputReference;
    putVirtualMachine(value: NotebooksRuntimeVirtualMachine): void;
    resetVirtualMachine(): void;
    get virtualMachineInput(): NotebooksRuntimeVirtualMachine | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
