import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrganizationIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy#id OrganizationIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The numeric ID of the organization in which you want to manage the audit logging config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy#org_id OrganizationIamPolicy#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy#policy_data OrganizationIamPolicy#policy_data}
    */
    readonly policyData: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy google_organization_iam_policy}
*/
export declare class OrganizationIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_organization_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_iam_policy google_organization_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: OrganizationIamPolicyConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
