"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleProvider = exports.googleProviderBatchingToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleProviderBatchingToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable_batching: cdktf.booleanToTerraform(struct.enableBatching),
        send_after: cdktf.stringToTerraform(struct.sendAfter),
    };
}
exports.googleProviderBatchingToTerraform = googleProviderBatchingToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google google}
*/
class GoogleProvider extends cdktf.TerraformProvider {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google google} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'google',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.55.0',
                providerVersionConstraint: '~> 4.0'
            },
            terraformProviderSource: 'google'
        });
        this._accessApprovalCustomEndpoint = config.accessApprovalCustomEndpoint;
        this._accessContextManagerCustomEndpoint = config.accessContextManagerCustomEndpoint;
        this._accessToken = config.accessToken;
        this._activeDirectoryCustomEndpoint = config.activeDirectoryCustomEndpoint;
        this._alloydbCustomEndpoint = config.alloydbCustomEndpoint;
        this._apigeeCustomEndpoint = config.apigeeCustomEndpoint;
        this._apikeysCustomEndpoint = config.apikeysCustomEndpoint;
        this._appEngineCustomEndpoint = config.appEngineCustomEndpoint;
        this._artifactRegistryCustomEndpoint = config.artifactRegistryCustomEndpoint;
        this._assuredWorkloadsCustomEndpoint = config.assuredWorkloadsCustomEndpoint;
        this._beyondcorpCustomEndpoint = config.beyondcorpCustomEndpoint;
        this._bigQueryCustomEndpoint = config.bigQueryCustomEndpoint;
        this._bigqueryAnalyticsHubCustomEndpoint = config.bigqueryAnalyticsHubCustomEndpoint;
        this._bigqueryConnectionCustomEndpoint = config.bigqueryConnectionCustomEndpoint;
        this._bigqueryDataTransferCustomEndpoint = config.bigqueryDataTransferCustomEndpoint;
        this._bigqueryReservationCustomEndpoint = config.bigqueryReservationCustomEndpoint;
        this._bigtableCustomEndpoint = config.bigtableCustomEndpoint;
        this._billingCustomEndpoint = config.billingCustomEndpoint;
        this._billingProject = config.billingProject;
        this._binaryAuthorizationCustomEndpoint = config.binaryAuthorizationCustomEndpoint;
        this._certificateManagerCustomEndpoint = config.certificateManagerCustomEndpoint;
        this._cloudAssetCustomEndpoint = config.cloudAssetCustomEndpoint;
        this._cloudBillingCustomEndpoint = config.cloudBillingCustomEndpoint;
        this._cloudBuildCustomEndpoint = config.cloudBuildCustomEndpoint;
        this._cloudBuildWorkerPoolCustomEndpoint = config.cloudBuildWorkerPoolCustomEndpoint;
        this._cloudFunctionsCustomEndpoint = config.cloudFunctionsCustomEndpoint;
        this._cloudIdentityCustomEndpoint = config.cloudIdentityCustomEndpoint;
        this._cloudIdsCustomEndpoint = config.cloudIdsCustomEndpoint;
        this._cloudIotCustomEndpoint = config.cloudIotCustomEndpoint;
        this._cloudResourceManagerCustomEndpoint = config.cloudResourceManagerCustomEndpoint;
        this._cloudRunCustomEndpoint = config.cloudRunCustomEndpoint;
        this._cloudRunV2CustomEndpoint = config.cloudRunV2CustomEndpoint;
        this._cloudSchedulerCustomEndpoint = config.cloudSchedulerCustomEndpoint;
        this._cloudTasksCustomEndpoint = config.cloudTasksCustomEndpoint;
        this._clouddeployCustomEndpoint = config.clouddeployCustomEndpoint;
        this._cloudfunctions2CustomEndpoint = config.cloudfunctions2CustomEndpoint;
        this._composerCustomEndpoint = config.composerCustomEndpoint;
        this._computeCustomEndpoint = config.computeCustomEndpoint;
        this._containerAnalysisCustomEndpoint = config.containerAnalysisCustomEndpoint;
        this._containerAttachedCustomEndpoint = config.containerAttachedCustomEndpoint;
        this._containerAwsCustomEndpoint = config.containerAwsCustomEndpoint;
        this._containerAzureCustomEndpoint = config.containerAzureCustomEndpoint;
        this._containerCustomEndpoint = config.containerCustomEndpoint;
        this._credentials = config.credentials;
        this._dataCatalogCustomEndpoint = config.dataCatalogCustomEndpoint;
        this._dataFusionCustomEndpoint = config.dataFusionCustomEndpoint;
        this._dataLossPreventionCustomEndpoint = config.dataLossPreventionCustomEndpoint;
        this._dataflowCustomEndpoint = config.dataflowCustomEndpoint;
        this._dataplexCustomEndpoint = config.dataplexCustomEndpoint;
        this._dataprocCustomEndpoint = config.dataprocCustomEndpoint;
        this._dataprocMetastoreCustomEndpoint = config.dataprocMetastoreCustomEndpoint;
        this._datastoreCustomEndpoint = config.datastoreCustomEndpoint;
        this._datastreamCustomEndpoint = config.datastreamCustomEndpoint;
        this._deploymentManagerCustomEndpoint = config.deploymentManagerCustomEndpoint;
        this._dialogflowCustomEndpoint = config.dialogflowCustomEndpoint;
        this._dialogflowCxCustomEndpoint = config.dialogflowCxCustomEndpoint;
        this._dnsCustomEndpoint = config.dnsCustomEndpoint;
        this._documentAiCustomEndpoint = config.documentAiCustomEndpoint;
        this._essentialContactsCustomEndpoint = config.essentialContactsCustomEndpoint;
        this._eventarcCustomEndpoint = config.eventarcCustomEndpoint;
        this._filestoreCustomEndpoint = config.filestoreCustomEndpoint;
        this._firebaserulesCustomEndpoint = config.firebaserulesCustomEndpoint;
        this._firestoreCustomEndpoint = config.firestoreCustomEndpoint;
        this._gameServicesCustomEndpoint = config.gameServicesCustomEndpoint;
        this._gkeBackupCustomEndpoint = config.gkeBackupCustomEndpoint;
        this._gkeHubCustomEndpoint = config.gkeHubCustomEndpoint;
        this._healthcareCustomEndpoint = config.healthcareCustomEndpoint;
        this._iam2CustomEndpoint = config.iam2CustomEndpoint;
        this._iamBetaCustomEndpoint = config.iamBetaCustomEndpoint;
        this._iamCredentialsCustomEndpoint = config.iamCredentialsCustomEndpoint;
        this._iamCustomEndpoint = config.iamCustomEndpoint;
        this._iamWorkforcePoolCustomEndpoint = config.iamWorkforcePoolCustomEndpoint;
        this._iapCustomEndpoint = config.iapCustomEndpoint;
        this._identityPlatformCustomEndpoint = config.identityPlatformCustomEndpoint;
        this._impersonateServiceAccount = config.impersonateServiceAccount;
        this._impersonateServiceAccountDelegates = config.impersonateServiceAccountDelegates;
        this._kmsCustomEndpoint = config.kmsCustomEndpoint;
        this._loggingCustomEndpoint = config.loggingCustomEndpoint;
        this._memcacheCustomEndpoint = config.memcacheCustomEndpoint;
        this._mlEngineCustomEndpoint = config.mlEngineCustomEndpoint;
        this._monitoringCustomEndpoint = config.monitoringCustomEndpoint;
        this._networkConnectivityCustomEndpoint = config.networkConnectivityCustomEndpoint;
        this._networkManagementCustomEndpoint = config.networkManagementCustomEndpoint;
        this._networkServicesCustomEndpoint = config.networkServicesCustomEndpoint;
        this._notebooksCustomEndpoint = config.notebooksCustomEndpoint;
        this._orgPolicyCustomEndpoint = config.orgPolicyCustomEndpoint;
        this._osConfigCustomEndpoint = config.osConfigCustomEndpoint;
        this._osLoginCustomEndpoint = config.osLoginCustomEndpoint;
        this._privatecaCustomEndpoint = config.privatecaCustomEndpoint;
        this._project = config.project;
        this._pubsubCustomEndpoint = config.pubsubCustomEndpoint;
        this._pubsubLiteCustomEndpoint = config.pubsubLiteCustomEndpoint;
        this._recaptchaEnterpriseCustomEndpoint = config.recaptchaEnterpriseCustomEndpoint;
        this._redisCustomEndpoint = config.redisCustomEndpoint;
        this._region = config.region;
        this._requestReason = config.requestReason;
        this._requestTimeout = config.requestTimeout;
        this._resourceManagerCustomEndpoint = config.resourceManagerCustomEndpoint;
        this._resourceManagerV3CustomEndpoint = config.resourceManagerV3CustomEndpoint;
        this._scopes = config.scopes;
        this._secretManagerCustomEndpoint = config.secretManagerCustomEndpoint;
        this._securityCenterCustomEndpoint = config.securityCenterCustomEndpoint;
        this._serviceManagementCustomEndpoint = config.serviceManagementCustomEndpoint;
        this._serviceNetworkingCustomEndpoint = config.serviceNetworkingCustomEndpoint;
        this._serviceUsageCustomEndpoint = config.serviceUsageCustomEndpoint;
        this._sourceRepoCustomEndpoint = config.sourceRepoCustomEndpoint;
        this._spannerCustomEndpoint = config.spannerCustomEndpoint;
        this._sqlCustomEndpoint = config.sqlCustomEndpoint;
        this._storageCustomEndpoint = config.storageCustomEndpoint;
        this._storageTransferCustomEndpoint = config.storageTransferCustomEndpoint;
        this._tagsCustomEndpoint = config.tagsCustomEndpoint;
        this._tagsLocationCustomEndpoint = config.tagsLocationCustomEndpoint;
        this._tpuCustomEndpoint = config.tpuCustomEndpoint;
        this._userProjectOverride = config.userProjectOverride;
        this._vertexAiCustomEndpoint = config.vertexAiCustomEndpoint;
        this._vpcAccessCustomEndpoint = config.vpcAccessCustomEndpoint;
        this._workflowsCustomEndpoint = config.workflowsCustomEndpoint;
        this._zone = config.zone;
        this._alias = config.alias;
        this._batching = config.batching;
    }
    get accessApprovalCustomEndpoint() {
        return this._accessApprovalCustomEndpoint;
    }
    set accessApprovalCustomEndpoint(value) {
        this._accessApprovalCustomEndpoint = value;
    }
    resetAccessApprovalCustomEndpoint() {
        this._accessApprovalCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessApprovalCustomEndpointInput() {
        return this._accessApprovalCustomEndpoint;
    }
    get accessContextManagerCustomEndpoint() {
        return this._accessContextManagerCustomEndpoint;
    }
    set accessContextManagerCustomEndpoint(value) {
        this._accessContextManagerCustomEndpoint = value;
    }
    resetAccessContextManagerCustomEndpoint() {
        this._accessContextManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessContextManagerCustomEndpointInput() {
        return this._accessContextManagerCustomEndpoint;
    }
    get accessToken() {
        return this._accessToken;
    }
    set accessToken(value) {
        this._accessToken = value;
    }
    resetAccessToken() {
        this._accessToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessTokenInput() {
        return this._accessToken;
    }
    get activeDirectoryCustomEndpoint() {
        return this._activeDirectoryCustomEndpoint;
    }
    set activeDirectoryCustomEndpoint(value) {
        this._activeDirectoryCustomEndpoint = value;
    }
    resetActiveDirectoryCustomEndpoint() {
        this._activeDirectoryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get activeDirectoryCustomEndpointInput() {
        return this._activeDirectoryCustomEndpoint;
    }
    get alloydbCustomEndpoint() {
        return this._alloydbCustomEndpoint;
    }
    set alloydbCustomEndpoint(value) {
        this._alloydbCustomEndpoint = value;
    }
    resetAlloydbCustomEndpoint() {
        this._alloydbCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get alloydbCustomEndpointInput() {
        return this._alloydbCustomEndpoint;
    }
    get apigeeCustomEndpoint() {
        return this._apigeeCustomEndpoint;
    }
    set apigeeCustomEndpoint(value) {
        this._apigeeCustomEndpoint = value;
    }
    resetApigeeCustomEndpoint() {
        this._apigeeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apigeeCustomEndpointInput() {
        return this._apigeeCustomEndpoint;
    }
    get apikeysCustomEndpoint() {
        return this._apikeysCustomEndpoint;
    }
    set apikeysCustomEndpoint(value) {
        this._apikeysCustomEndpoint = value;
    }
    resetApikeysCustomEndpoint() {
        this._apikeysCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get apikeysCustomEndpointInput() {
        return this._apikeysCustomEndpoint;
    }
    get appEngineCustomEndpoint() {
        return this._appEngineCustomEndpoint;
    }
    set appEngineCustomEndpoint(value) {
        this._appEngineCustomEndpoint = value;
    }
    resetAppEngineCustomEndpoint() {
        this._appEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get appEngineCustomEndpointInput() {
        return this._appEngineCustomEndpoint;
    }
    get artifactRegistryCustomEndpoint() {
        return this._artifactRegistryCustomEndpoint;
    }
    set artifactRegistryCustomEndpoint(value) {
        this._artifactRegistryCustomEndpoint = value;
    }
    resetArtifactRegistryCustomEndpoint() {
        this._artifactRegistryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get artifactRegistryCustomEndpointInput() {
        return this._artifactRegistryCustomEndpoint;
    }
    get assuredWorkloadsCustomEndpoint() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    set assuredWorkloadsCustomEndpoint(value) {
        this._assuredWorkloadsCustomEndpoint = value;
    }
    resetAssuredWorkloadsCustomEndpoint() {
        this._assuredWorkloadsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get assuredWorkloadsCustomEndpointInput() {
        return this._assuredWorkloadsCustomEndpoint;
    }
    get beyondcorpCustomEndpoint() {
        return this._beyondcorpCustomEndpoint;
    }
    set beyondcorpCustomEndpoint(value) {
        this._beyondcorpCustomEndpoint = value;
    }
    resetBeyondcorpCustomEndpoint() {
        this._beyondcorpCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get beyondcorpCustomEndpointInput() {
        return this._beyondcorpCustomEndpoint;
    }
    get bigQueryCustomEndpoint() {
        return this._bigQueryCustomEndpoint;
    }
    set bigQueryCustomEndpoint(value) {
        this._bigQueryCustomEndpoint = value;
    }
    resetBigQueryCustomEndpoint() {
        this._bigQueryCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigQueryCustomEndpointInput() {
        return this._bigQueryCustomEndpoint;
    }
    get bigqueryAnalyticsHubCustomEndpoint() {
        return this._bigqueryAnalyticsHubCustomEndpoint;
    }
    set bigqueryAnalyticsHubCustomEndpoint(value) {
        this._bigqueryAnalyticsHubCustomEndpoint = value;
    }
    resetBigqueryAnalyticsHubCustomEndpoint() {
        this._bigqueryAnalyticsHubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryAnalyticsHubCustomEndpointInput() {
        return this._bigqueryAnalyticsHubCustomEndpoint;
    }
    get bigqueryConnectionCustomEndpoint() {
        return this._bigqueryConnectionCustomEndpoint;
    }
    set bigqueryConnectionCustomEndpoint(value) {
        this._bigqueryConnectionCustomEndpoint = value;
    }
    resetBigqueryConnectionCustomEndpoint() {
        this._bigqueryConnectionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryConnectionCustomEndpointInput() {
        return this._bigqueryConnectionCustomEndpoint;
    }
    get bigqueryDataTransferCustomEndpoint() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    set bigqueryDataTransferCustomEndpoint(value) {
        this._bigqueryDataTransferCustomEndpoint = value;
    }
    resetBigqueryDataTransferCustomEndpoint() {
        this._bigqueryDataTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryDataTransferCustomEndpointInput() {
        return this._bigqueryDataTransferCustomEndpoint;
    }
    get bigqueryReservationCustomEndpoint() {
        return this._bigqueryReservationCustomEndpoint;
    }
    set bigqueryReservationCustomEndpoint(value) {
        this._bigqueryReservationCustomEndpoint = value;
    }
    resetBigqueryReservationCustomEndpoint() {
        this._bigqueryReservationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigqueryReservationCustomEndpointInput() {
        return this._bigqueryReservationCustomEndpoint;
    }
    get bigtableCustomEndpoint() {
        return this._bigtableCustomEndpoint;
    }
    set bigtableCustomEndpoint(value) {
        this._bigtableCustomEndpoint = value;
    }
    resetBigtableCustomEndpoint() {
        this._bigtableCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bigtableCustomEndpointInput() {
        return this._bigtableCustomEndpoint;
    }
    get billingCustomEndpoint() {
        return this._billingCustomEndpoint;
    }
    set billingCustomEndpoint(value) {
        this._billingCustomEndpoint = value;
    }
    resetBillingCustomEndpoint() {
        this._billingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get billingCustomEndpointInput() {
        return this._billingCustomEndpoint;
    }
    get billingProject() {
        return this._billingProject;
    }
    set billingProject(value) {
        this._billingProject = value;
    }
    resetBillingProject() {
        this._billingProject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get billingProjectInput() {
        return this._billingProject;
    }
    get binaryAuthorizationCustomEndpoint() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    set binaryAuthorizationCustomEndpoint(value) {
        this._binaryAuthorizationCustomEndpoint = value;
    }
    resetBinaryAuthorizationCustomEndpoint() {
        this._binaryAuthorizationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAuthorizationCustomEndpointInput() {
        return this._binaryAuthorizationCustomEndpoint;
    }
    get certificateManagerCustomEndpoint() {
        return this._certificateManagerCustomEndpoint;
    }
    set certificateManagerCustomEndpoint(value) {
        this._certificateManagerCustomEndpoint = value;
    }
    resetCertificateManagerCustomEndpoint() {
        this._certificateManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get certificateManagerCustomEndpointInput() {
        return this._certificateManagerCustomEndpoint;
    }
    get cloudAssetCustomEndpoint() {
        return this._cloudAssetCustomEndpoint;
    }
    set cloudAssetCustomEndpoint(value) {
        this._cloudAssetCustomEndpoint = value;
    }
    resetCloudAssetCustomEndpoint() {
        this._cloudAssetCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudAssetCustomEndpointInput() {
        return this._cloudAssetCustomEndpoint;
    }
    get cloudBillingCustomEndpoint() {
        return this._cloudBillingCustomEndpoint;
    }
    set cloudBillingCustomEndpoint(value) {
        this._cloudBillingCustomEndpoint = value;
    }
    resetCloudBillingCustomEndpoint() {
        this._cloudBillingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBillingCustomEndpointInput() {
        return this._cloudBillingCustomEndpoint;
    }
    get cloudBuildCustomEndpoint() {
        return this._cloudBuildCustomEndpoint;
    }
    set cloudBuildCustomEndpoint(value) {
        this._cloudBuildCustomEndpoint = value;
    }
    resetCloudBuildCustomEndpoint() {
        this._cloudBuildCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBuildCustomEndpointInput() {
        return this._cloudBuildCustomEndpoint;
    }
    get cloudBuildWorkerPoolCustomEndpoint() {
        return this._cloudBuildWorkerPoolCustomEndpoint;
    }
    set cloudBuildWorkerPoolCustomEndpoint(value) {
        this._cloudBuildWorkerPoolCustomEndpoint = value;
    }
    resetCloudBuildWorkerPoolCustomEndpoint() {
        this._cloudBuildWorkerPoolCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudBuildWorkerPoolCustomEndpointInput() {
        return this._cloudBuildWorkerPoolCustomEndpoint;
    }
    get cloudFunctionsCustomEndpoint() {
        return this._cloudFunctionsCustomEndpoint;
    }
    set cloudFunctionsCustomEndpoint(value) {
        this._cloudFunctionsCustomEndpoint = value;
    }
    resetCloudFunctionsCustomEndpoint() {
        this._cloudFunctionsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudFunctionsCustomEndpointInput() {
        return this._cloudFunctionsCustomEndpoint;
    }
    get cloudIdentityCustomEndpoint() {
        return this._cloudIdentityCustomEndpoint;
    }
    set cloudIdentityCustomEndpoint(value) {
        this._cloudIdentityCustomEndpoint = value;
    }
    resetCloudIdentityCustomEndpoint() {
        this._cloudIdentityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIdentityCustomEndpointInput() {
        return this._cloudIdentityCustomEndpoint;
    }
    get cloudIdsCustomEndpoint() {
        return this._cloudIdsCustomEndpoint;
    }
    set cloudIdsCustomEndpoint(value) {
        this._cloudIdsCustomEndpoint = value;
    }
    resetCloudIdsCustomEndpoint() {
        this._cloudIdsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIdsCustomEndpointInput() {
        return this._cloudIdsCustomEndpoint;
    }
    get cloudIotCustomEndpoint() {
        return this._cloudIotCustomEndpoint;
    }
    set cloudIotCustomEndpoint(value) {
        this._cloudIotCustomEndpoint = value;
    }
    resetCloudIotCustomEndpoint() {
        this._cloudIotCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudIotCustomEndpointInput() {
        return this._cloudIotCustomEndpoint;
    }
    get cloudResourceManagerCustomEndpoint() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    set cloudResourceManagerCustomEndpoint(value) {
        this._cloudResourceManagerCustomEndpoint = value;
    }
    resetCloudResourceManagerCustomEndpoint() {
        this._cloudResourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudResourceManagerCustomEndpointInput() {
        return this._cloudResourceManagerCustomEndpoint;
    }
    get cloudRunCustomEndpoint() {
        return this._cloudRunCustomEndpoint;
    }
    set cloudRunCustomEndpoint(value) {
        this._cloudRunCustomEndpoint = value;
    }
    resetCloudRunCustomEndpoint() {
        this._cloudRunCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudRunCustomEndpointInput() {
        return this._cloudRunCustomEndpoint;
    }
    get cloudRunV2CustomEndpoint() {
        return this._cloudRunV2CustomEndpoint;
    }
    set cloudRunV2CustomEndpoint(value) {
        this._cloudRunV2CustomEndpoint = value;
    }
    resetCloudRunV2CustomEndpoint() {
        this._cloudRunV2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudRunV2CustomEndpointInput() {
        return this._cloudRunV2CustomEndpoint;
    }
    get cloudSchedulerCustomEndpoint() {
        return this._cloudSchedulerCustomEndpoint;
    }
    set cloudSchedulerCustomEndpoint(value) {
        this._cloudSchedulerCustomEndpoint = value;
    }
    resetCloudSchedulerCustomEndpoint() {
        this._cloudSchedulerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudSchedulerCustomEndpointInput() {
        return this._cloudSchedulerCustomEndpoint;
    }
    get cloudTasksCustomEndpoint() {
        return this._cloudTasksCustomEndpoint;
    }
    set cloudTasksCustomEndpoint(value) {
        this._cloudTasksCustomEndpoint = value;
    }
    resetCloudTasksCustomEndpoint() {
        this._cloudTasksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudTasksCustomEndpointInput() {
        return this._cloudTasksCustomEndpoint;
    }
    get clouddeployCustomEndpoint() {
        return this._clouddeployCustomEndpoint;
    }
    set clouddeployCustomEndpoint(value) {
        this._clouddeployCustomEndpoint = value;
    }
    resetClouddeployCustomEndpoint() {
        this._clouddeployCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clouddeployCustomEndpointInput() {
        return this._clouddeployCustomEndpoint;
    }
    get cloudfunctions2CustomEndpoint() {
        return this._cloudfunctions2CustomEndpoint;
    }
    set cloudfunctions2CustomEndpoint(value) {
        this._cloudfunctions2CustomEndpoint = value;
    }
    resetCloudfunctions2CustomEndpoint() {
        this._cloudfunctions2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cloudfunctions2CustomEndpointInput() {
        return this._cloudfunctions2CustomEndpoint;
    }
    get composerCustomEndpoint() {
        return this._composerCustomEndpoint;
    }
    set composerCustomEndpoint(value) {
        this._composerCustomEndpoint = value;
    }
    resetComposerCustomEndpoint() {
        this._composerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get composerCustomEndpointInput() {
        return this._composerCustomEndpoint;
    }
    get computeCustomEndpoint() {
        return this._computeCustomEndpoint;
    }
    set computeCustomEndpoint(value) {
        this._computeCustomEndpoint = value;
    }
    resetComputeCustomEndpoint() {
        this._computeCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get computeCustomEndpointInput() {
        return this._computeCustomEndpoint;
    }
    get containerAnalysisCustomEndpoint() {
        return this._containerAnalysisCustomEndpoint;
    }
    set containerAnalysisCustomEndpoint(value) {
        this._containerAnalysisCustomEndpoint = value;
    }
    resetContainerAnalysisCustomEndpoint() {
        this._containerAnalysisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAnalysisCustomEndpointInput() {
        return this._containerAnalysisCustomEndpoint;
    }
    get containerAttachedCustomEndpoint() {
        return this._containerAttachedCustomEndpoint;
    }
    set containerAttachedCustomEndpoint(value) {
        this._containerAttachedCustomEndpoint = value;
    }
    resetContainerAttachedCustomEndpoint() {
        this._containerAttachedCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAttachedCustomEndpointInput() {
        return this._containerAttachedCustomEndpoint;
    }
    get containerAwsCustomEndpoint() {
        return this._containerAwsCustomEndpoint;
    }
    set containerAwsCustomEndpoint(value) {
        this._containerAwsCustomEndpoint = value;
    }
    resetContainerAwsCustomEndpoint() {
        this._containerAwsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAwsCustomEndpointInput() {
        return this._containerAwsCustomEndpoint;
    }
    get containerAzureCustomEndpoint() {
        return this._containerAzureCustomEndpoint;
    }
    set containerAzureCustomEndpoint(value) {
        this._containerAzureCustomEndpoint = value;
    }
    resetContainerAzureCustomEndpoint() {
        this._containerAzureCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerAzureCustomEndpointInput() {
        return this._containerAzureCustomEndpoint;
    }
    get containerCustomEndpoint() {
        return this._containerCustomEndpoint;
    }
    set containerCustomEndpoint(value) {
        this._containerCustomEndpoint = value;
    }
    resetContainerCustomEndpoint() {
        this._containerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get containerCustomEndpointInput() {
        return this._containerCustomEndpoint;
    }
    get credentials() {
        return this._credentials;
    }
    set credentials(value) {
        this._credentials = value;
    }
    resetCredentials() {
        this._credentials = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get credentialsInput() {
        return this._credentials;
    }
    get dataCatalogCustomEndpoint() {
        return this._dataCatalogCustomEndpoint;
    }
    set dataCatalogCustomEndpoint(value) {
        this._dataCatalogCustomEndpoint = value;
    }
    resetDataCatalogCustomEndpoint() {
        this._dataCatalogCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataCatalogCustomEndpointInput() {
        return this._dataCatalogCustomEndpoint;
    }
    get dataFusionCustomEndpoint() {
        return this._dataFusionCustomEndpoint;
    }
    set dataFusionCustomEndpoint(value) {
        this._dataFusionCustomEndpoint = value;
    }
    resetDataFusionCustomEndpoint() {
        this._dataFusionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataFusionCustomEndpointInput() {
        return this._dataFusionCustomEndpoint;
    }
    get dataLossPreventionCustomEndpoint() {
        return this._dataLossPreventionCustomEndpoint;
    }
    set dataLossPreventionCustomEndpoint(value) {
        this._dataLossPreventionCustomEndpoint = value;
    }
    resetDataLossPreventionCustomEndpoint() {
        this._dataLossPreventionCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataLossPreventionCustomEndpointInput() {
        return this._dataLossPreventionCustomEndpoint;
    }
    get dataflowCustomEndpoint() {
        return this._dataflowCustomEndpoint;
    }
    set dataflowCustomEndpoint(value) {
        this._dataflowCustomEndpoint = value;
    }
    resetDataflowCustomEndpoint() {
        this._dataflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataflowCustomEndpointInput() {
        return this._dataflowCustomEndpoint;
    }
    get dataplexCustomEndpoint() {
        return this._dataplexCustomEndpoint;
    }
    set dataplexCustomEndpoint(value) {
        this._dataplexCustomEndpoint = value;
    }
    resetDataplexCustomEndpoint() {
        this._dataplexCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataplexCustomEndpointInput() {
        return this._dataplexCustomEndpoint;
    }
    get dataprocCustomEndpoint() {
        return this._dataprocCustomEndpoint;
    }
    set dataprocCustomEndpoint(value) {
        this._dataprocCustomEndpoint = value;
    }
    resetDataprocCustomEndpoint() {
        this._dataprocCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataprocCustomEndpointInput() {
        return this._dataprocCustomEndpoint;
    }
    get dataprocMetastoreCustomEndpoint() {
        return this._dataprocMetastoreCustomEndpoint;
    }
    set dataprocMetastoreCustomEndpoint(value) {
        this._dataprocMetastoreCustomEndpoint = value;
    }
    resetDataprocMetastoreCustomEndpoint() {
        this._dataprocMetastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataprocMetastoreCustomEndpointInput() {
        return this._dataprocMetastoreCustomEndpoint;
    }
    get datastoreCustomEndpoint() {
        return this._datastoreCustomEndpoint;
    }
    set datastoreCustomEndpoint(value) {
        this._datastoreCustomEndpoint = value;
    }
    resetDatastoreCustomEndpoint() {
        this._datastoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datastoreCustomEndpointInput() {
        return this._datastoreCustomEndpoint;
    }
    get datastreamCustomEndpoint() {
        return this._datastreamCustomEndpoint;
    }
    set datastreamCustomEndpoint(value) {
        this._datastreamCustomEndpoint = value;
    }
    resetDatastreamCustomEndpoint() {
        this._datastreamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get datastreamCustomEndpointInput() {
        return this._datastreamCustomEndpoint;
    }
    get deploymentManagerCustomEndpoint() {
        return this._deploymentManagerCustomEndpoint;
    }
    set deploymentManagerCustomEndpoint(value) {
        this._deploymentManagerCustomEndpoint = value;
    }
    resetDeploymentManagerCustomEndpoint() {
        this._deploymentManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deploymentManagerCustomEndpointInput() {
        return this._deploymentManagerCustomEndpoint;
    }
    get dialogflowCustomEndpoint() {
        return this._dialogflowCustomEndpoint;
    }
    set dialogflowCustomEndpoint(value) {
        this._dialogflowCustomEndpoint = value;
    }
    resetDialogflowCustomEndpoint() {
        this._dialogflowCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dialogflowCustomEndpointInput() {
        return this._dialogflowCustomEndpoint;
    }
    get dialogflowCxCustomEndpoint() {
        return this._dialogflowCxCustomEndpoint;
    }
    set dialogflowCxCustomEndpoint(value) {
        this._dialogflowCxCustomEndpoint = value;
    }
    resetDialogflowCxCustomEndpoint() {
        this._dialogflowCxCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dialogflowCxCustomEndpointInput() {
        return this._dialogflowCxCustomEndpoint;
    }
    get dnsCustomEndpoint() {
        return this._dnsCustomEndpoint;
    }
    set dnsCustomEndpoint(value) {
        this._dnsCustomEndpoint = value;
    }
    resetDnsCustomEndpoint() {
        this._dnsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dnsCustomEndpointInput() {
        return this._dnsCustomEndpoint;
    }
    get documentAiCustomEndpoint() {
        return this._documentAiCustomEndpoint;
    }
    set documentAiCustomEndpoint(value) {
        this._documentAiCustomEndpoint = value;
    }
    resetDocumentAiCustomEndpoint() {
        this._documentAiCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get documentAiCustomEndpointInput() {
        return this._documentAiCustomEndpoint;
    }
    get essentialContactsCustomEndpoint() {
        return this._essentialContactsCustomEndpoint;
    }
    set essentialContactsCustomEndpoint(value) {
        this._essentialContactsCustomEndpoint = value;
    }
    resetEssentialContactsCustomEndpoint() {
        this._essentialContactsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get essentialContactsCustomEndpointInput() {
        return this._essentialContactsCustomEndpoint;
    }
    get eventarcCustomEndpoint() {
        return this._eventarcCustomEndpoint;
    }
    set eventarcCustomEndpoint(value) {
        this._eventarcCustomEndpoint = value;
    }
    resetEventarcCustomEndpoint() {
        this._eventarcCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventarcCustomEndpointInput() {
        return this._eventarcCustomEndpoint;
    }
    get filestoreCustomEndpoint() {
        return this._filestoreCustomEndpoint;
    }
    set filestoreCustomEndpoint(value) {
        this._filestoreCustomEndpoint = value;
    }
    resetFilestoreCustomEndpoint() {
        this._filestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get filestoreCustomEndpointInput() {
        return this._filestoreCustomEndpoint;
    }
    get firebaserulesCustomEndpoint() {
        return this._firebaserulesCustomEndpoint;
    }
    set firebaserulesCustomEndpoint(value) {
        this._firebaserulesCustomEndpoint = value;
    }
    resetFirebaserulesCustomEndpoint() {
        this._firebaserulesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firebaserulesCustomEndpointInput() {
        return this._firebaserulesCustomEndpoint;
    }
    get firestoreCustomEndpoint() {
        return this._firestoreCustomEndpoint;
    }
    set firestoreCustomEndpoint(value) {
        this._firestoreCustomEndpoint = value;
    }
    resetFirestoreCustomEndpoint() {
        this._firestoreCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firestoreCustomEndpointInput() {
        return this._firestoreCustomEndpoint;
    }
    get gameServicesCustomEndpoint() {
        return this._gameServicesCustomEndpoint;
    }
    set gameServicesCustomEndpoint(value) {
        this._gameServicesCustomEndpoint = value;
    }
    resetGameServicesCustomEndpoint() {
        this._gameServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gameServicesCustomEndpointInput() {
        return this._gameServicesCustomEndpoint;
    }
    get gkeBackupCustomEndpoint() {
        return this._gkeBackupCustomEndpoint;
    }
    set gkeBackupCustomEndpoint(value) {
        this._gkeBackupCustomEndpoint = value;
    }
    resetGkeBackupCustomEndpoint() {
        this._gkeBackupCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeBackupCustomEndpointInput() {
        return this._gkeBackupCustomEndpoint;
    }
    get gkeHubCustomEndpoint() {
        return this._gkeHubCustomEndpoint;
    }
    set gkeHubCustomEndpoint(value) {
        this._gkeHubCustomEndpoint = value;
    }
    resetGkeHubCustomEndpoint() {
        this._gkeHubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gkeHubCustomEndpointInput() {
        return this._gkeHubCustomEndpoint;
    }
    get healthcareCustomEndpoint() {
        return this._healthcareCustomEndpoint;
    }
    set healthcareCustomEndpoint(value) {
        this._healthcareCustomEndpoint = value;
    }
    resetHealthcareCustomEndpoint() {
        this._healthcareCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get healthcareCustomEndpointInput() {
        return this._healthcareCustomEndpoint;
    }
    get iam2CustomEndpoint() {
        return this._iam2CustomEndpoint;
    }
    set iam2CustomEndpoint(value) {
        this._iam2CustomEndpoint = value;
    }
    resetIam2CustomEndpoint() {
        this._iam2CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iam2CustomEndpointInput() {
        return this._iam2CustomEndpoint;
    }
    get iamBetaCustomEndpoint() {
        return this._iamBetaCustomEndpoint;
    }
    set iamBetaCustomEndpoint(value) {
        this._iamBetaCustomEndpoint = value;
    }
    resetIamBetaCustomEndpoint() {
        this._iamBetaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamBetaCustomEndpointInput() {
        return this._iamBetaCustomEndpoint;
    }
    get iamCredentialsCustomEndpoint() {
        return this._iamCredentialsCustomEndpoint;
    }
    set iamCredentialsCustomEndpoint(value) {
        this._iamCredentialsCustomEndpoint = value;
    }
    resetIamCredentialsCustomEndpoint() {
        this._iamCredentialsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamCredentialsCustomEndpointInput() {
        return this._iamCredentialsCustomEndpoint;
    }
    get iamCustomEndpoint() {
        return this._iamCustomEndpoint;
    }
    set iamCustomEndpoint(value) {
        this._iamCustomEndpoint = value;
    }
    resetIamCustomEndpoint() {
        this._iamCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamCustomEndpointInput() {
        return this._iamCustomEndpoint;
    }
    get iamWorkforcePoolCustomEndpoint() {
        return this._iamWorkforcePoolCustomEndpoint;
    }
    set iamWorkforcePoolCustomEndpoint(value) {
        this._iamWorkforcePoolCustomEndpoint = value;
    }
    resetIamWorkforcePoolCustomEndpoint() {
        this._iamWorkforcePoolCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iamWorkforcePoolCustomEndpointInput() {
        return this._iamWorkforcePoolCustomEndpoint;
    }
    get iapCustomEndpoint() {
        return this._iapCustomEndpoint;
    }
    set iapCustomEndpoint(value) {
        this._iapCustomEndpoint = value;
    }
    resetIapCustomEndpoint() {
        this._iapCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get iapCustomEndpointInput() {
        return this._iapCustomEndpoint;
    }
    get identityPlatformCustomEndpoint() {
        return this._identityPlatformCustomEndpoint;
    }
    set identityPlatformCustomEndpoint(value) {
        this._identityPlatformCustomEndpoint = value;
    }
    resetIdentityPlatformCustomEndpoint() {
        this._identityPlatformCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get identityPlatformCustomEndpointInput() {
        return this._identityPlatformCustomEndpoint;
    }
    get impersonateServiceAccount() {
        return this._impersonateServiceAccount;
    }
    set impersonateServiceAccount(value) {
        this._impersonateServiceAccount = value;
    }
    resetImpersonateServiceAccount() {
        this._impersonateServiceAccount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get impersonateServiceAccountInput() {
        return this._impersonateServiceAccount;
    }
    get impersonateServiceAccountDelegates() {
        return this._impersonateServiceAccountDelegates;
    }
    set impersonateServiceAccountDelegates(value) {
        this._impersonateServiceAccountDelegates = value;
    }
    resetImpersonateServiceAccountDelegates() {
        this._impersonateServiceAccountDelegates = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get impersonateServiceAccountDelegatesInput() {
        return this._impersonateServiceAccountDelegates;
    }
    get kmsCustomEndpoint() {
        return this._kmsCustomEndpoint;
    }
    set kmsCustomEndpoint(value) {
        this._kmsCustomEndpoint = value;
    }
    resetKmsCustomEndpoint() {
        this._kmsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get kmsCustomEndpointInput() {
        return this._kmsCustomEndpoint;
    }
    get loggingCustomEndpoint() {
        return this._loggingCustomEndpoint;
    }
    set loggingCustomEndpoint(value) {
        this._loggingCustomEndpoint = value;
    }
    resetLoggingCustomEndpoint() {
        this._loggingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loggingCustomEndpointInput() {
        return this._loggingCustomEndpoint;
    }
    get memcacheCustomEndpoint() {
        return this._memcacheCustomEndpoint;
    }
    set memcacheCustomEndpoint(value) {
        this._memcacheCustomEndpoint = value;
    }
    resetMemcacheCustomEndpoint() {
        this._memcacheCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get memcacheCustomEndpointInput() {
        return this._memcacheCustomEndpoint;
    }
    get mlEngineCustomEndpoint() {
        return this._mlEngineCustomEndpoint;
    }
    set mlEngineCustomEndpoint(value) {
        this._mlEngineCustomEndpoint = value;
    }
    resetMlEngineCustomEndpoint() {
        this._mlEngineCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mlEngineCustomEndpointInput() {
        return this._mlEngineCustomEndpoint;
    }
    get monitoringCustomEndpoint() {
        return this._monitoringCustomEndpoint;
    }
    set monitoringCustomEndpoint(value) {
        this._monitoringCustomEndpoint = value;
    }
    resetMonitoringCustomEndpoint() {
        this._monitoringCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monitoringCustomEndpointInput() {
        return this._monitoringCustomEndpoint;
    }
    get networkConnectivityCustomEndpoint() {
        return this._networkConnectivityCustomEndpoint;
    }
    set networkConnectivityCustomEndpoint(value) {
        this._networkConnectivityCustomEndpoint = value;
    }
    resetNetworkConnectivityCustomEndpoint() {
        this._networkConnectivityCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkConnectivityCustomEndpointInput() {
        return this._networkConnectivityCustomEndpoint;
    }
    get networkManagementCustomEndpoint() {
        return this._networkManagementCustomEndpoint;
    }
    set networkManagementCustomEndpoint(value) {
        this._networkManagementCustomEndpoint = value;
    }
    resetNetworkManagementCustomEndpoint() {
        this._networkManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkManagementCustomEndpointInput() {
        return this._networkManagementCustomEndpoint;
    }
    get networkServicesCustomEndpoint() {
        return this._networkServicesCustomEndpoint;
    }
    set networkServicesCustomEndpoint(value) {
        this._networkServicesCustomEndpoint = value;
    }
    resetNetworkServicesCustomEndpoint() {
        this._networkServicesCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get networkServicesCustomEndpointInput() {
        return this._networkServicesCustomEndpoint;
    }
    get notebooksCustomEndpoint() {
        return this._notebooksCustomEndpoint;
    }
    set notebooksCustomEndpoint(value) {
        this._notebooksCustomEndpoint = value;
    }
    resetNotebooksCustomEndpoint() {
        this._notebooksCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notebooksCustomEndpointInput() {
        return this._notebooksCustomEndpoint;
    }
    get orgPolicyCustomEndpoint() {
        return this._orgPolicyCustomEndpoint;
    }
    set orgPolicyCustomEndpoint(value) {
        this._orgPolicyCustomEndpoint = value;
    }
    resetOrgPolicyCustomEndpoint() {
        this._orgPolicyCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orgPolicyCustomEndpointInput() {
        return this._orgPolicyCustomEndpoint;
    }
    get osConfigCustomEndpoint() {
        return this._osConfigCustomEndpoint;
    }
    set osConfigCustomEndpoint(value) {
        this._osConfigCustomEndpoint = value;
    }
    resetOsConfigCustomEndpoint() {
        this._osConfigCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osConfigCustomEndpointInput() {
        return this._osConfigCustomEndpoint;
    }
    get osLoginCustomEndpoint() {
        return this._osLoginCustomEndpoint;
    }
    set osLoginCustomEndpoint(value) {
        this._osLoginCustomEndpoint = value;
    }
    resetOsLoginCustomEndpoint() {
        this._osLoginCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osLoginCustomEndpointInput() {
        return this._osLoginCustomEndpoint;
    }
    get privatecaCustomEndpoint() {
        return this._privatecaCustomEndpoint;
    }
    set privatecaCustomEndpoint(value) {
        this._privatecaCustomEndpoint = value;
    }
    resetPrivatecaCustomEndpoint() {
        this._privatecaCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privatecaCustomEndpointInput() {
        return this._privatecaCustomEndpoint;
    }
    get project() {
        return this._project;
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get pubsubCustomEndpoint() {
        return this._pubsubCustomEndpoint;
    }
    set pubsubCustomEndpoint(value) {
        this._pubsubCustomEndpoint = value;
    }
    resetPubsubCustomEndpoint() {
        this._pubsubCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubCustomEndpointInput() {
        return this._pubsubCustomEndpoint;
    }
    get pubsubLiteCustomEndpoint() {
        return this._pubsubLiteCustomEndpoint;
    }
    set pubsubLiteCustomEndpoint(value) {
        this._pubsubLiteCustomEndpoint = value;
    }
    resetPubsubLiteCustomEndpoint() {
        this._pubsubLiteCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubLiteCustomEndpointInput() {
        return this._pubsubLiteCustomEndpoint;
    }
    get recaptchaEnterpriseCustomEndpoint() {
        return this._recaptchaEnterpriseCustomEndpoint;
    }
    set recaptchaEnterpriseCustomEndpoint(value) {
        this._recaptchaEnterpriseCustomEndpoint = value;
    }
    resetRecaptchaEnterpriseCustomEndpoint() {
        this._recaptchaEnterpriseCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recaptchaEnterpriseCustomEndpointInput() {
        return this._recaptchaEnterpriseCustomEndpoint;
    }
    get redisCustomEndpoint() {
        return this._redisCustomEndpoint;
    }
    set redisCustomEndpoint(value) {
        this._redisCustomEndpoint = value;
    }
    resetRedisCustomEndpoint() {
        this._redisCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redisCustomEndpointInput() {
        return this._redisCustomEndpoint;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get requestReason() {
        return this._requestReason;
    }
    set requestReason(value) {
        this._requestReason = value;
    }
    resetRequestReason() {
        this._requestReason = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestReasonInput() {
        return this._requestReason;
    }
    get requestTimeout() {
        return this._requestTimeout;
    }
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    get resourceManagerCustomEndpoint() {
        return this._resourceManagerCustomEndpoint;
    }
    set resourceManagerCustomEndpoint(value) {
        this._resourceManagerCustomEndpoint = value;
    }
    resetResourceManagerCustomEndpoint() {
        this._resourceManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceManagerCustomEndpointInput() {
        return this._resourceManagerCustomEndpoint;
    }
    get resourceManagerV3CustomEndpoint() {
        return this._resourceManagerV3CustomEndpoint;
    }
    set resourceManagerV3CustomEndpoint(value) {
        this._resourceManagerV3CustomEndpoint = value;
    }
    resetResourceManagerV3CustomEndpoint() {
        this._resourceManagerV3CustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resourceManagerV3CustomEndpointInput() {
        return this._resourceManagerV3CustomEndpoint;
    }
    get scopes() {
        return this._scopes;
    }
    set scopes(value) {
        this._scopes = value;
    }
    resetScopes() {
        this._scopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scopesInput() {
        return this._scopes;
    }
    get secretManagerCustomEndpoint() {
        return this._secretManagerCustomEndpoint;
    }
    set secretManagerCustomEndpoint(value) {
        this._secretManagerCustomEndpoint = value;
    }
    resetSecretManagerCustomEndpoint() {
        this._secretManagerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretManagerCustomEndpointInput() {
        return this._secretManagerCustomEndpoint;
    }
    get securityCenterCustomEndpoint() {
        return this._securityCenterCustomEndpoint;
    }
    set securityCenterCustomEndpoint(value) {
        this._securityCenterCustomEndpoint = value;
    }
    resetSecurityCenterCustomEndpoint() {
        this._securityCenterCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get securityCenterCustomEndpointInput() {
        return this._securityCenterCustomEndpoint;
    }
    get serviceManagementCustomEndpoint() {
        return this._serviceManagementCustomEndpoint;
    }
    set serviceManagementCustomEndpoint(value) {
        this._serviceManagementCustomEndpoint = value;
    }
    resetServiceManagementCustomEndpoint() {
        this._serviceManagementCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceManagementCustomEndpointInput() {
        return this._serviceManagementCustomEndpoint;
    }
    get serviceNetworkingCustomEndpoint() {
        return this._serviceNetworkingCustomEndpoint;
    }
    set serviceNetworkingCustomEndpoint(value) {
        this._serviceNetworkingCustomEndpoint = value;
    }
    resetServiceNetworkingCustomEndpoint() {
        this._serviceNetworkingCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceNetworkingCustomEndpointInput() {
        return this._serviceNetworkingCustomEndpoint;
    }
    get serviceUsageCustomEndpoint() {
        return this._serviceUsageCustomEndpoint;
    }
    set serviceUsageCustomEndpoint(value) {
        this._serviceUsageCustomEndpoint = value;
    }
    resetServiceUsageCustomEndpoint() {
        this._serviceUsageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serviceUsageCustomEndpointInput() {
        return this._serviceUsageCustomEndpoint;
    }
    get sourceRepoCustomEndpoint() {
        return this._sourceRepoCustomEndpoint;
    }
    set sourceRepoCustomEndpoint(value) {
        this._sourceRepoCustomEndpoint = value;
    }
    resetSourceRepoCustomEndpoint() {
        this._sourceRepoCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sourceRepoCustomEndpointInput() {
        return this._sourceRepoCustomEndpoint;
    }
    get spannerCustomEndpoint() {
        return this._spannerCustomEndpoint;
    }
    set spannerCustomEndpoint(value) {
        this._spannerCustomEndpoint = value;
    }
    resetSpannerCustomEndpoint() {
        this._spannerCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get spannerCustomEndpointInput() {
        return this._spannerCustomEndpoint;
    }
    get sqlCustomEndpoint() {
        return this._sqlCustomEndpoint;
    }
    set sqlCustomEndpoint(value) {
        this._sqlCustomEndpoint = value;
    }
    resetSqlCustomEndpoint() {
        this._sqlCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sqlCustomEndpointInput() {
        return this._sqlCustomEndpoint;
    }
    get storageCustomEndpoint() {
        return this._storageCustomEndpoint;
    }
    set storageCustomEndpoint(value) {
        this._storageCustomEndpoint = value;
    }
    resetStorageCustomEndpoint() {
        this._storageCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageCustomEndpointInput() {
        return this._storageCustomEndpoint;
    }
    get storageTransferCustomEndpoint() {
        return this._storageTransferCustomEndpoint;
    }
    set storageTransferCustomEndpoint(value) {
        this._storageTransferCustomEndpoint = value;
    }
    resetStorageTransferCustomEndpoint() {
        this._storageTransferCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageTransferCustomEndpointInput() {
        return this._storageTransferCustomEndpoint;
    }
    get tagsCustomEndpoint() {
        return this._tagsCustomEndpoint;
    }
    set tagsCustomEndpoint(value) {
        this._tagsCustomEndpoint = value;
    }
    resetTagsCustomEndpoint() {
        this._tagsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsCustomEndpointInput() {
        return this._tagsCustomEndpoint;
    }
    get tagsLocationCustomEndpoint() {
        return this._tagsLocationCustomEndpoint;
    }
    set tagsLocationCustomEndpoint(value) {
        this._tagsLocationCustomEndpoint = value;
    }
    resetTagsLocationCustomEndpoint() {
        this._tagsLocationCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsLocationCustomEndpointInput() {
        return this._tagsLocationCustomEndpoint;
    }
    get tpuCustomEndpoint() {
        return this._tpuCustomEndpoint;
    }
    set tpuCustomEndpoint(value) {
        this._tpuCustomEndpoint = value;
    }
    resetTpuCustomEndpoint() {
        this._tpuCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tpuCustomEndpointInput() {
        return this._tpuCustomEndpoint;
    }
    get userProjectOverride() {
        return this._userProjectOverride;
    }
    set userProjectOverride(value) {
        this._userProjectOverride = value;
    }
    resetUserProjectOverride() {
        this._userProjectOverride = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userProjectOverrideInput() {
        return this._userProjectOverride;
    }
    get vertexAiCustomEndpoint() {
        return this._vertexAiCustomEndpoint;
    }
    set vertexAiCustomEndpoint(value) {
        this._vertexAiCustomEndpoint = value;
    }
    resetVertexAiCustomEndpoint() {
        this._vertexAiCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vertexAiCustomEndpointInput() {
        return this._vertexAiCustomEndpoint;
    }
    get vpcAccessCustomEndpoint() {
        return this._vpcAccessCustomEndpoint;
    }
    set vpcAccessCustomEndpoint(value) {
        this._vpcAccessCustomEndpoint = value;
    }
    resetVpcAccessCustomEndpoint() {
        this._vpcAccessCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vpcAccessCustomEndpointInput() {
        return this._vpcAccessCustomEndpoint;
    }
    get workflowsCustomEndpoint() {
        return this._workflowsCustomEndpoint;
    }
    set workflowsCustomEndpoint(value) {
        this._workflowsCustomEndpoint = value;
    }
    resetWorkflowsCustomEndpoint() {
        this._workflowsCustomEndpoint = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get workflowsCustomEndpointInput() {
        return this._workflowsCustomEndpoint;
    }
    get zone() {
        return this._zone;
    }
    set zone(value) {
        this._zone = value;
    }
    resetZone() {
        this._zone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get zoneInput() {
        return this._zone;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get batching() {
        return this._batching;
    }
    set batching(value) {
        this._batching = value;
    }
    resetBatching() {
        this._batching = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get batchingInput() {
        return this._batching;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_approval_custom_endpoint: cdktf.stringToTerraform(this._accessApprovalCustomEndpoint),
            access_context_manager_custom_endpoint: cdktf.stringToTerraform(this._accessContextManagerCustomEndpoint),
            access_token: cdktf.stringToTerraform(this._accessToken),
            active_directory_custom_endpoint: cdktf.stringToTerraform(this._activeDirectoryCustomEndpoint),
            alloydb_custom_endpoint: cdktf.stringToTerraform(this._alloydbCustomEndpoint),
            apigee_custom_endpoint: cdktf.stringToTerraform(this._apigeeCustomEndpoint),
            apikeys_custom_endpoint: cdktf.stringToTerraform(this._apikeysCustomEndpoint),
            app_engine_custom_endpoint: cdktf.stringToTerraform(this._appEngineCustomEndpoint),
            artifact_registry_custom_endpoint: cdktf.stringToTerraform(this._artifactRegistryCustomEndpoint),
            assured_workloads_custom_endpoint: cdktf.stringToTerraform(this._assuredWorkloadsCustomEndpoint),
            beyondcorp_custom_endpoint: cdktf.stringToTerraform(this._beyondcorpCustomEndpoint),
            big_query_custom_endpoint: cdktf.stringToTerraform(this._bigQueryCustomEndpoint),
            bigquery_analytics_hub_custom_endpoint: cdktf.stringToTerraform(this._bigqueryAnalyticsHubCustomEndpoint),
            bigquery_connection_custom_endpoint: cdktf.stringToTerraform(this._bigqueryConnectionCustomEndpoint),
            bigquery_data_transfer_custom_endpoint: cdktf.stringToTerraform(this._bigqueryDataTransferCustomEndpoint),
            bigquery_reservation_custom_endpoint: cdktf.stringToTerraform(this._bigqueryReservationCustomEndpoint),
            bigtable_custom_endpoint: cdktf.stringToTerraform(this._bigtableCustomEndpoint),
            billing_custom_endpoint: cdktf.stringToTerraform(this._billingCustomEndpoint),
            billing_project: cdktf.stringToTerraform(this._billingProject),
            binary_authorization_custom_endpoint: cdktf.stringToTerraform(this._binaryAuthorizationCustomEndpoint),
            certificate_manager_custom_endpoint: cdktf.stringToTerraform(this._certificateManagerCustomEndpoint),
            cloud_asset_custom_endpoint: cdktf.stringToTerraform(this._cloudAssetCustomEndpoint),
            cloud_billing_custom_endpoint: cdktf.stringToTerraform(this._cloudBillingCustomEndpoint),
            cloud_build_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildCustomEndpoint),
            cloud_build_worker_pool_custom_endpoint: cdktf.stringToTerraform(this._cloudBuildWorkerPoolCustomEndpoint),
            cloud_functions_custom_endpoint: cdktf.stringToTerraform(this._cloudFunctionsCustomEndpoint),
            cloud_identity_custom_endpoint: cdktf.stringToTerraform(this._cloudIdentityCustomEndpoint),
            cloud_ids_custom_endpoint: cdktf.stringToTerraform(this._cloudIdsCustomEndpoint),
            cloud_iot_custom_endpoint: cdktf.stringToTerraform(this._cloudIotCustomEndpoint),
            cloud_resource_manager_custom_endpoint: cdktf.stringToTerraform(this._cloudResourceManagerCustomEndpoint),
            cloud_run_custom_endpoint: cdktf.stringToTerraform(this._cloudRunCustomEndpoint),
            cloud_run_v2_custom_endpoint: cdktf.stringToTerraform(this._cloudRunV2CustomEndpoint),
            cloud_scheduler_custom_endpoint: cdktf.stringToTerraform(this._cloudSchedulerCustomEndpoint),
            cloud_tasks_custom_endpoint: cdktf.stringToTerraform(this._cloudTasksCustomEndpoint),
            clouddeploy_custom_endpoint: cdktf.stringToTerraform(this._clouddeployCustomEndpoint),
            cloudfunctions2_custom_endpoint: cdktf.stringToTerraform(this._cloudfunctions2CustomEndpoint),
            composer_custom_endpoint: cdktf.stringToTerraform(this._composerCustomEndpoint),
            compute_custom_endpoint: cdktf.stringToTerraform(this._computeCustomEndpoint),
            container_analysis_custom_endpoint: cdktf.stringToTerraform(this._containerAnalysisCustomEndpoint),
            container_attached_custom_endpoint: cdktf.stringToTerraform(this._containerAttachedCustomEndpoint),
            container_aws_custom_endpoint: cdktf.stringToTerraform(this._containerAwsCustomEndpoint),
            container_azure_custom_endpoint: cdktf.stringToTerraform(this._containerAzureCustomEndpoint),
            container_custom_endpoint: cdktf.stringToTerraform(this._containerCustomEndpoint),
            credentials: cdktf.stringToTerraform(this._credentials),
            data_catalog_custom_endpoint: cdktf.stringToTerraform(this._dataCatalogCustomEndpoint),
            data_fusion_custom_endpoint: cdktf.stringToTerraform(this._dataFusionCustomEndpoint),
            data_loss_prevention_custom_endpoint: cdktf.stringToTerraform(this._dataLossPreventionCustomEndpoint),
            dataflow_custom_endpoint: cdktf.stringToTerraform(this._dataflowCustomEndpoint),
            dataplex_custom_endpoint: cdktf.stringToTerraform(this._dataplexCustomEndpoint),
            dataproc_custom_endpoint: cdktf.stringToTerraform(this._dataprocCustomEndpoint),
            dataproc_metastore_custom_endpoint: cdktf.stringToTerraform(this._dataprocMetastoreCustomEndpoint),
            datastore_custom_endpoint: cdktf.stringToTerraform(this._datastoreCustomEndpoint),
            datastream_custom_endpoint: cdktf.stringToTerraform(this._datastreamCustomEndpoint),
            deployment_manager_custom_endpoint: cdktf.stringToTerraform(this._deploymentManagerCustomEndpoint),
            dialogflow_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCustomEndpoint),
            dialogflow_cx_custom_endpoint: cdktf.stringToTerraform(this._dialogflowCxCustomEndpoint),
            dns_custom_endpoint: cdktf.stringToTerraform(this._dnsCustomEndpoint),
            document_ai_custom_endpoint: cdktf.stringToTerraform(this._documentAiCustomEndpoint),
            essential_contacts_custom_endpoint: cdktf.stringToTerraform(this._essentialContactsCustomEndpoint),
            eventarc_custom_endpoint: cdktf.stringToTerraform(this._eventarcCustomEndpoint),
            filestore_custom_endpoint: cdktf.stringToTerraform(this._filestoreCustomEndpoint),
            firebaserules_custom_endpoint: cdktf.stringToTerraform(this._firebaserulesCustomEndpoint),
            firestore_custom_endpoint: cdktf.stringToTerraform(this._firestoreCustomEndpoint),
            game_services_custom_endpoint: cdktf.stringToTerraform(this._gameServicesCustomEndpoint),
            gke_backup_custom_endpoint: cdktf.stringToTerraform(this._gkeBackupCustomEndpoint),
            gke_hub_custom_endpoint: cdktf.stringToTerraform(this._gkeHubCustomEndpoint),
            healthcare_custom_endpoint: cdktf.stringToTerraform(this._healthcareCustomEndpoint),
            iam2_custom_endpoint: cdktf.stringToTerraform(this._iam2CustomEndpoint),
            iam_beta_custom_endpoint: cdktf.stringToTerraform(this._iamBetaCustomEndpoint),
            iam_credentials_custom_endpoint: cdktf.stringToTerraform(this._iamCredentialsCustomEndpoint),
            iam_custom_endpoint: cdktf.stringToTerraform(this._iamCustomEndpoint),
            iam_workforce_pool_custom_endpoint: cdktf.stringToTerraform(this._iamWorkforcePoolCustomEndpoint),
            iap_custom_endpoint: cdktf.stringToTerraform(this._iapCustomEndpoint),
            identity_platform_custom_endpoint: cdktf.stringToTerraform(this._identityPlatformCustomEndpoint),
            impersonate_service_account: cdktf.stringToTerraform(this._impersonateServiceAccount),
            impersonate_service_account_delegates: cdktf.listMapper(cdktf.stringToTerraform, false)(this._impersonateServiceAccountDelegates),
            kms_custom_endpoint: cdktf.stringToTerraform(this._kmsCustomEndpoint),
            logging_custom_endpoint: cdktf.stringToTerraform(this._loggingCustomEndpoint),
            memcache_custom_endpoint: cdktf.stringToTerraform(this._memcacheCustomEndpoint),
            ml_engine_custom_endpoint: cdktf.stringToTerraform(this._mlEngineCustomEndpoint),
            monitoring_custom_endpoint: cdktf.stringToTerraform(this._monitoringCustomEndpoint),
            network_connectivity_custom_endpoint: cdktf.stringToTerraform(this._networkConnectivityCustomEndpoint),
            network_management_custom_endpoint: cdktf.stringToTerraform(this._networkManagementCustomEndpoint),
            network_services_custom_endpoint: cdktf.stringToTerraform(this._networkServicesCustomEndpoint),
            notebooks_custom_endpoint: cdktf.stringToTerraform(this._notebooksCustomEndpoint),
            org_policy_custom_endpoint: cdktf.stringToTerraform(this._orgPolicyCustomEndpoint),
            os_config_custom_endpoint: cdktf.stringToTerraform(this._osConfigCustomEndpoint),
            os_login_custom_endpoint: cdktf.stringToTerraform(this._osLoginCustomEndpoint),
            privateca_custom_endpoint: cdktf.stringToTerraform(this._privatecaCustomEndpoint),
            project: cdktf.stringToTerraform(this._project),
            pubsub_custom_endpoint: cdktf.stringToTerraform(this._pubsubCustomEndpoint),
            pubsub_lite_custom_endpoint: cdktf.stringToTerraform(this._pubsubLiteCustomEndpoint),
            recaptcha_enterprise_custom_endpoint: cdktf.stringToTerraform(this._recaptchaEnterpriseCustomEndpoint),
            redis_custom_endpoint: cdktf.stringToTerraform(this._redisCustomEndpoint),
            region: cdktf.stringToTerraform(this._region),
            request_reason: cdktf.stringToTerraform(this._requestReason),
            request_timeout: cdktf.stringToTerraform(this._requestTimeout),
            resource_manager_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerCustomEndpoint),
            resource_manager_v3_custom_endpoint: cdktf.stringToTerraform(this._resourceManagerV3CustomEndpoint),
            scopes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._scopes),
            secret_manager_custom_endpoint: cdktf.stringToTerraform(this._secretManagerCustomEndpoint),
            security_center_custom_endpoint: cdktf.stringToTerraform(this._securityCenterCustomEndpoint),
            service_management_custom_endpoint: cdktf.stringToTerraform(this._serviceManagementCustomEndpoint),
            service_networking_custom_endpoint: cdktf.stringToTerraform(this._serviceNetworkingCustomEndpoint),
            service_usage_custom_endpoint: cdktf.stringToTerraform(this._serviceUsageCustomEndpoint),
            source_repo_custom_endpoint: cdktf.stringToTerraform(this._sourceRepoCustomEndpoint),
            spanner_custom_endpoint: cdktf.stringToTerraform(this._spannerCustomEndpoint),
            sql_custom_endpoint: cdktf.stringToTerraform(this._sqlCustomEndpoint),
            storage_custom_endpoint: cdktf.stringToTerraform(this._storageCustomEndpoint),
            storage_transfer_custom_endpoint: cdktf.stringToTerraform(this._storageTransferCustomEndpoint),
            tags_custom_endpoint: cdktf.stringToTerraform(this._tagsCustomEndpoint),
            tags_location_custom_endpoint: cdktf.stringToTerraform(this._tagsLocationCustomEndpoint),
            tpu_custom_endpoint: cdktf.stringToTerraform(this._tpuCustomEndpoint),
            user_project_override: cdktf.booleanToTerraform(this._userProjectOverride),
            vertex_ai_custom_endpoint: cdktf.stringToTerraform(this._vertexAiCustomEndpoint),
            vpc_access_custom_endpoint: cdktf.stringToTerraform(this._vpcAccessCustomEndpoint),
            workflows_custom_endpoint: cdktf.stringToTerraform(this._workflowsCustomEndpoint),
            zone: cdktf.stringToTerraform(this._zone),
            alias: cdktf.stringToTerraform(this._alias),
            batching: googleProviderBatchingToTerraform(this._batching),
        };
    }
}
exports.GoogleProvider = GoogleProvider;
_a = JSII_RTTI_SYMBOL_1;
GoogleProvider[_a] = { fqn: "@cdktf/provider-google.provider.GoogleProvider", version: "5.0.7" };
// =================
// STATIC PROPERTIES
// =================
GoogleProvider.tfResourceType = "google";
//# sourceMappingURL=data:application/json;base64,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