import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SccSourceIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#id SccSourceIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#members SccSourceIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#organization SccSourceIamBinding#organization}
    */
    readonly organization: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#role SccSourceIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#source SccSourceIamBinding#source}
    */
    readonly source: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#condition SccSourceIamBinding#condition}
    */
    readonly condition?: SccSourceIamBindingCondition;
}
export interface SccSourceIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#description SccSourceIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#expression SccSourceIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding#title SccSourceIamBinding#title}
    */
    readonly title: string;
}
export declare function sccSourceIamBindingConditionToTerraform(struct?: SccSourceIamBindingConditionOutputReference | SccSourceIamBindingCondition): any;
export declare class SccSourceIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SccSourceIamBindingCondition | undefined;
    set internalValue(value: SccSourceIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding google_scc_source_iam_binding}
*/
export declare class SccSourceIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_source_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/scc_source_iam_binding google_scc_source_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SccSourceIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: SccSourceIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
    private _condition;
    get condition(): SccSourceIamBindingConditionOutputReference;
    putCondition(value: SccSourceIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): SccSourceIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
